// chrome/services/printing/public/mojom/print_backend_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_DATA_VIEW_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/services/printing/public/mojom/print_backend_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "printing/backend/mojom/print_backend.mojom-shared.h"
#include "printing/mojom/print.mojom-shared.h"
#include "printing/mojom/printing_context.mojom-shared.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace printing::mojom {
class PrinterCapsAndInfoDataView;

class PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView;
class PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView;
class PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView;
class PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView;
class PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView;


}  // printing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PrinterCapsAndInfoDataView> {
  using Data = ::printing::mojom::internal::PrinterCapsAndInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView> {
  using Data = ::printing::mojom::internal::PrintBackendService_EnumeratePrinters_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView> {
  using Data = ::printing::mojom::internal::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView> {
  using Data = ::printing::mojom::internal::PrintBackendService_FetchCapabilities_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView> {
  using Data = ::printing::mojom::internal::PrintBackendService_UseDefaultSettings_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

template <>
struct MojomTypeTraits<::printing::mojom::PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView> {
  using Data = ::printing::mojom::internal::PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace printing::mojom {
// Interface base classes. They are used for type safety check.
class UnsandboxedPrintBackendHostInterfaceBase {};

using UnsandboxedPrintBackendHostPtrDataView =
    mojo::InterfacePtrDataView<UnsandboxedPrintBackendHostInterfaceBase>;
using UnsandboxedPrintBackendHostRequestDataView =
    mojo::InterfaceRequestDataView<UnsandboxedPrintBackendHostInterfaceBase>;
using UnsandboxedPrintBackendHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UnsandboxedPrintBackendHostInterfaceBase>;
using UnsandboxedPrintBackendHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UnsandboxedPrintBackendHostInterfaceBase>;
class SandboxedPrintBackendHostInterfaceBase {};

using SandboxedPrintBackendHostPtrDataView =
    mojo::InterfacePtrDataView<SandboxedPrintBackendHostInterfaceBase>;
using SandboxedPrintBackendHostRequestDataView =
    mojo::InterfaceRequestDataView<SandboxedPrintBackendHostInterfaceBase>;
using SandboxedPrintBackendHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<SandboxedPrintBackendHostInterfaceBase>;
using SandboxedPrintBackendHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<SandboxedPrintBackendHostInterfaceBase>;
class PrintBackendServiceInterfaceBase {};

using PrintBackendServicePtrDataView =
    mojo::InterfacePtrDataView<PrintBackendServiceInterfaceBase>;
using PrintBackendServiceRequestDataView =
    mojo::InterfaceRequestDataView<PrintBackendServiceInterfaceBase>;
using PrintBackendServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrintBackendServiceInterfaceBase>;
using PrintBackendServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrintBackendServiceInterfaceBase>;


class PrinterCapsAndInfoDataView {
 public:
  PrinterCapsAndInfoDataView() = default;

  PrinterCapsAndInfoDataView(
      internal::PrinterCapsAndInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPrinterInfoDataView(
      ::printing::mojom::PrinterBasicInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterInfo(UserType* output) {
    
    auto* pointer = data_->printer_info.Get();
    return mojo::internal::Deserialize<::printing::mojom::PrinterBasicInfoDataView>(
        pointer, output, message_);
  }
  inline void GetPrinterCapsDataView(
      ::printing::mojom::PrinterSemanticCapsAndDefaultsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrinterCaps(UserType* output) {
    
    auto* pointer = data_->printer_caps.Get();
    return mojo::internal::Deserialize<::printing::mojom::PrinterSemanticCapsAndDefaultsDataView>(
        pointer, output, message_);
  }
 private:
  internal::PrinterCapsAndInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView {
 public:
  using Tag = internal::PrintBackendService_EnumeratePrinters_ResponseParam_Result_Data::PrintBackendService_EnumeratePrinters_ResponseParam_Result_Tag;

  PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView() = default;

  PrintBackendService_EnumeratePrinters_ResponseParam_ResultDataView(
      internal::PrintBackendService_EnumeratePrinters_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      mojo::ArrayDataView<::printing::mojom::PrinterBasicInfoDataView>* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::printing::mojom::PrinterBasicInfoDataView>>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::printing::mojom::ResultCode>(
        data_->data.f_failure, output);
  }
  ::printing::mojom::ResultCode failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::ResultCode>(data_->data.f_failure));
  }

 private:
  internal::PrintBackendService_EnumeratePrinters_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView {
 public:
  using Tag = internal::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Data::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Tag;

  PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView() = default;

  PrintBackendService_GetDefaultPrinterName_ResponseParam_ResultDataView(
      internal::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      mojo::StringDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<mojo::StringDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::printing::mojom::ResultCode>(
        data_->data.f_failure, output);
  }
  ::printing::mojom::ResultCode failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::ResultCode>(data_->data.f_failure));
  }

 private:
  internal::PrintBackendService_GetDefaultPrinterName_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView {
 public:
  using Tag = internal::PrintBackendService_FetchCapabilities_ResponseParam_Result_Data::PrintBackendService_FetchCapabilities_ResponseParam_Result_Tag;

  PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView() = default;

  PrintBackendService_FetchCapabilities_ResponseParam_ResultDataView(
      internal::PrintBackendService_FetchCapabilities_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      PrinterCapsAndInfoDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::printing::mojom::PrinterCapsAndInfoDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::printing::mojom::ResultCode>(
        data_->data.f_failure, output);
  }
  ::printing::mojom::ResultCode failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::ResultCode>(data_->data.f_failure));
  }

 private:
  internal::PrintBackendService_FetchCapabilities_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView {
 public:
  using Tag = internal::PrintBackendService_UseDefaultSettings_ResponseParam_Result_Data::PrintBackendService_UseDefaultSettings_ResponseParam_Result_Tag;

  PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView() = default;

  PrintBackendService_UseDefaultSettings_ResponseParam_ResultDataView(
      internal::PrintBackendService_UseDefaultSettings_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      ::printing::mojom::PrintSettingsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::printing::mojom::PrintSettingsDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::printing::mojom::ResultCode>(
        data_->data.f_failure, output);
  }
  ::printing::mojom::ResultCode failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::ResultCode>(data_->data.f_failure));
  }

 private:
  internal::PrintBackendService_UseDefaultSettings_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



class PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView {
 public:
  using Tag = internal::PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Data::PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Tag;

  PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView() = default;

  PrintBackendService_UpdatePrintSettings_ResponseParam_ResultDataView(
      internal::PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_success() const { return data_->tag == Tag::kSuccess; }
  inline void GetSuccessDataView(
      ::printing::mojom::PrintSettingsDataView* output) const;

  template <typename UserType>
  [[nodiscard]] bool ReadSuccess(UserType* output) const {
    
    CHECK(is_success());
    return mojo::internal::Deserialize<::printing::mojom::PrintSettingsDataView>(
        data_->data.f_success.Get(), output, message_);
  }
  bool is_failure() const { return data_->tag == Tag::kFailure; }
  template <typename UserType>
  [[nodiscard]] bool ReadFailure(UserType* output) const {
    CHECK(is_failure());
    return mojo::internal::Deserialize<::printing::mojom::ResultCode>(
        data_->data.f_failure, output);
  }
  ::printing::mojom::ResultCode failure() const {
    CHECK(is_failure());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::printing::mojom::ResultCode>(data_->data.f_failure));
  }

 private:
  internal::PrintBackendService_UpdatePrintSettings_ResponseParam_Result_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // printing::mojom

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PRINT_BACKEND_SERVICE_MOJOM_DATA_VIEW_H_