// chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-params-data.h"
#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-shared-message-ids.h"

#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-import-headers.h"
#include "chrome/services/printing/public/mojom/pdf_to_pwg_raster_converter.mojom-test-utils.h"


namespace printing::mojom {
PwgRasterSettings::PwgRasterSettings()
    : duplex_mode(),
      odd_page_transform(),
      rotate_all_pages(),
      reverse_page_order(),
      use_color() {}

PwgRasterSettings::PwgRasterSettings(
    PwgRasterSettings::DuplexMode duplex_mode_in,
    ::printing::PwgRasterTransformType odd_page_transform_in,
    bool rotate_all_pages_in,
    bool reverse_page_order_in,
    bool use_color_in)
    : duplex_mode(std::move(duplex_mode_in)),
      odd_page_transform(std::move(odd_page_transform_in)),
      rotate_all_pages(std::move(rotate_all_pages_in)),
      reverse_page_order(std::move(reverse_page_order_in)),
      use_color(std::move(use_color_in)) {}

PwgRasterSettings::~PwgRasterSettings() = default;

void PwgRasterSettings::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duplex_mode"), this->duplex_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PwgRasterSettings::DuplexMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "odd_page_transform"), this->odd_page_transform,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::printing::PwgRasterTransformType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "rotate_all_pages"), this->rotate_all_pages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reverse_page_order"), this->reverse_page_order,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "use_color"), this->use_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PwgRasterSettings::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PdfToPwgRasterConverter::IPCStableHashFunction PdfToPwgRasterConverter::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PdfToPwgRasterConverter>(message.name())) {
    case messages::PdfToPwgRasterConverter::kConvert: {
      return &PdfToPwgRasterConverter::Convert_Sym::IPCStableHash;
    }
    case messages::PdfToPwgRasterConverter::kSetUseSkiaRendererPolicy: {
      return &PdfToPwgRasterConverter::SetUseSkiaRendererPolicy_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PdfToPwgRasterConverter::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PdfToPwgRasterConverter>(message.name())) {
      case messages::PdfToPwgRasterConverter::kConvert:
            return "Receive printing::mojom::PdfToPwgRasterConverter::Convert";
      case messages::PdfToPwgRasterConverter::kSetUseSkiaRendererPolicy:
            return "Receive printing::mojom::PdfToPwgRasterConverter::SetUseSkiaRendererPolicy";
    }
  } else {
    switch (static_cast<messages::PdfToPwgRasterConverter>(message.name())) {
      case messages::PdfToPwgRasterConverter::kConvert:
            return "Receive reply printing::mojom::PdfToPwgRasterConverter::Convert";
      case messages::PdfToPwgRasterConverter::kSetUseSkiaRendererPolicy:
            return "Receive reply printing::mojom::PdfToPwgRasterConverter::SetUseSkiaRendererPolicy";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PdfToPwgRasterConverter::Convert_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8a259afc;  // IPCStableHash for printing::mojom::PdfToPwgRasterConverter::Convert
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PdfToPwgRasterConverter::SetUseSkiaRendererPolicy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2ca9cadf;  // IPCStableHash for printing::mojom::PdfToPwgRasterConverter::SetUseSkiaRendererPolicy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PdfToPwgRasterConverter_Convert_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PdfToPwgRasterConverter_Convert_ForwardToCallback(
      PdfToPwgRasterConverter::ConvertCallback callback
      ) : callback_(std::move(callback)) {
  }

  PdfToPwgRasterConverter_Convert_ForwardToCallback(const PdfToPwgRasterConverter_Convert_ForwardToCallback&) = delete;
  PdfToPwgRasterConverter_Convert_ForwardToCallback& operator=(const PdfToPwgRasterConverter_Convert_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PdfToPwgRasterConverter::ConvertCallback callback_;
};

PdfToPwgRasterConverterProxy::PdfToPwgRasterConverterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PdfToPwgRasterConverterProxy::Convert(
    ::base::ReadOnlySharedMemoryRegion in_pdf_region, const ::printing::PdfRenderSettings& in_pdf_settings, const ::printing::PwgRasterSettings& in_pwg_raster_settings, ConvertCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PdfToPwgRasterConverter::Convert", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pdf_region"), in_pdf_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pdf_settings"), in_pdf_settings,
                        "<value of type const ::printing::PdfRenderSettings&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pwg_raster_settings"), in_pwg_raster_settings,
                        "<value of type const ::printing::PwgRasterSettings&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfToPwgRasterConverter::kConvert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PdfToPwgRasterConverter_Convert_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pdf_region)::BaseType> pdf_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_pdf_region,
    pdf_region_fragment);

  params->pdf_region.Set(
      pdf_region_fragment.is_null() ? nullptr : pdf_region_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pdf_region.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pdf_region in PdfToPwgRasterConverter.Convert request");
  mojo::internal::MessageFragment<
      typename decltype(params->pdf_settings)::BaseType> pdf_settings_fragment(
          params.message());
  
  mojo::internal::Serialize<::printing::mojom::PdfRenderSettingsDataView>(
    in_pdf_settings,
    pdf_settings_fragment);

  params->pdf_settings.Set(
      pdf_settings_fragment.is_null() ? nullptr : pdf_settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pdf_settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pdf_settings in PdfToPwgRasterConverter.Convert request");
  mojo::internal::MessageFragment<
      typename decltype(params->pwg_raster_settings)::BaseType> pwg_raster_settings_fragment(
          params.message());
  
  mojo::internal::Serialize<::printing::mojom::PwgRasterSettingsDataView>(
    in_pwg_raster_settings,
    pwg_raster_settings_fragment);

  params->pwg_raster_settings.Set(
      pwg_raster_settings_fragment.is_null() ? nullptr : pwg_raster_settings_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pwg_raster_settings.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pwg_raster_settings in PdfToPwgRasterConverter.Convert request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfToPwgRasterConverter::Name_);
  message.set_method_name("Convert");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PdfToPwgRasterConverter_Convert_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PdfToPwgRasterConverterProxy::SetUseSkiaRendererPolicy(
    bool in_use_skia) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send printing::mojom::PdfToPwgRasterConverter::SetUseSkiaRendererPolicy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("use_skia"), in_use_skia,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfToPwgRasterConverter::kSetUseSkiaRendererPolicy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data> params(
          message);
  params.Allocate();

  params->use_skia = in_use_skia;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfToPwgRasterConverter::Name_);
  message.set_method_name("SetUseSkiaRendererPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PdfToPwgRasterConverter_Convert_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PdfToPwgRasterConverter::ConvertCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PdfToPwgRasterConverter_Convert_ProxyToResponder> proxy(
        new PdfToPwgRasterConverter_Convert_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PdfToPwgRasterConverter_Convert_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PdfToPwgRasterConverter_Convert_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PdfToPwgRasterConverter_Convert_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PdfToPwgRasterConverter::ConvertCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::ReadOnlySharedMemoryRegion in_pwg_raster_region, uint32_t in_page_count);
};

bool PdfToPwgRasterConverter_Convert_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PdfToPwgRasterConverter_Convert_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PdfToPwgRasterConverter_Convert_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PdfToPwgRasterConverter.0
  bool success = true;
  ::base::ReadOnlySharedMemoryRegion p_pwg_raster_region{};
  uint32_t p_page_count{};
  PdfToPwgRasterConverter_Convert_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadPwgRasterRegion(&p_pwg_raster_region))
    success = false;
  if (success)
    p_page_count = input_data_view.page_count();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PdfToPwgRasterConverter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_pwg_raster_region), 
std::move(p_page_count));
  }
  return true;
}

void PdfToPwgRasterConverter_Convert_ProxyToResponder::Run(
    ::base::ReadOnlySharedMemoryRegion in_pwg_raster_region, uint32_t in_page_count) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply printing::mojom::PdfToPwgRasterConverter::Convert", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pwg_raster_region"), in_pwg_raster_region,
                        "<value of type ::base::ReadOnlySharedMemoryRegion>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_count"), in_page_count,
                        "<value of type uint32_t>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PdfToPwgRasterConverter::kConvert), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::printing::mojom::internal::PdfToPwgRasterConverter_Convert_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->pwg_raster_region)::BaseType> pwg_raster_region_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView>(
    in_pwg_raster_region,
    pwg_raster_region_fragment);

  params->pwg_raster_region.Set(
      pwg_raster_region_fragment.is_null() ? nullptr : pwg_raster_region_fragment.data());

  params->page_count = in_page_count;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PdfToPwgRasterConverter::Name_);
  message.set_method_name("Convert");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PdfToPwgRasterConverterStubDispatch::Accept(
    PdfToPwgRasterConverter* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PdfToPwgRasterConverter>(message->header()->name)) {
    case messages::PdfToPwgRasterConverter::kConvert: {
      break;
    }
    case messages::PdfToPwgRasterConverter::kSetUseSkiaRendererPolicy: {
      DCHECK(message->is_serialized());
      internal::PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data* params =
          reinterpret_cast<internal::PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PdfToPwgRasterConverter.1
      bool success = true;
      bool p_use_skia{};
      PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_use_skia = input_data_view.use_skia();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfToPwgRasterConverter::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUseSkiaRendererPolicy(        
        std::move(p_use_skia));
      return true;
    }
  }
  return false;
}

// static
bool PdfToPwgRasterConverterStubDispatch::AcceptWithResponder(
    PdfToPwgRasterConverter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PdfToPwgRasterConverter>(message->header()->name)) {
    case messages::PdfToPwgRasterConverter::kConvert: {
      internal::PdfToPwgRasterConverter_Convert_Params_Data* params =
          reinterpret_cast<
              internal::PdfToPwgRasterConverter_Convert_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PdfToPwgRasterConverter.0
      bool success = true;
      ::base::ReadOnlySharedMemoryRegion p_pdf_region{};
      ::printing::PdfRenderSettings p_pdf_settings{};
      ::printing::PwgRasterSettings p_pwg_raster_settings{};
      PdfToPwgRasterConverter_Convert_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPdfRegion(&p_pdf_region))
        success = false;
      if (success && !input_data_view.ReadPdfSettings(&p_pdf_settings))
        success = false;
      if (success && !input_data_view.ReadPwgRasterSettings(&p_pwg_raster_settings))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PdfToPwgRasterConverter::Name_, 0, false);
        return false;
      }
      auto callback =
          PdfToPwgRasterConverter_Convert_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Convert(        
        std::move(p_pdf_region), 
        std::move(p_pdf_settings), 
        std::move(p_pwg_raster_settings), std::move(callback));
      return true;
    }
    case messages::PdfToPwgRasterConverter::kSetUseSkiaRendererPolicy: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPdfToPwgRasterConverterValidationInfo[] = {
    { &internal::PdfToPwgRasterConverter_Convert_Params_Data::Validate,
     &internal::PdfToPwgRasterConverter_Convert_ResponseParams_Data::Validate},
    { &internal::PdfToPwgRasterConverter_SetUseSkiaRendererPolicy_Params_Data::Validate,
     nullptr /* no response */},
};

bool PdfToPwgRasterConverterRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::printing::mojom::PdfToPwgRasterConverter::Name_,
    kPdfToPwgRasterConverterValidationInfo);
}

bool PdfToPwgRasterConverterResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::printing::mojom::PdfToPwgRasterConverter::Name_,
    kPdfToPwgRasterConverterValidationInfo);
}


}  // printing::mojom


namespace mojo {


// static
bool StructTraits<::printing::mojom::PwgRasterSettings::DataView, ::printing::mojom::PwgRasterSettingsPtr>::Read(
    ::printing::mojom::PwgRasterSettings::DataView input,
    ::printing::mojom::PwgRasterSettingsPtr* output) {
  bool success = true;
  ::printing::mojom::PwgRasterSettingsPtr result(::printing::mojom::PwgRasterSettings::New());
  
      if (success && !input.ReadDuplexMode(&result->duplex_mode))
        success = false;
      if (success && !input.ReadOddPageTransform(&result->odd_page_transform))
        success = false;
      if (success)
        result->rotate_all_pages = input.rotate_all_pages();
      if (success)
        result->reverse_page_order = input.reverse_page_order();
      if (success)
        result->use_color = input.use_color();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace printing::mojom {


void PdfToPwgRasterConverterInterceptorForTesting::Convert(::base::ReadOnlySharedMemoryRegion pdf_region, const ::printing::PdfRenderSettings& pdf_settings, const ::printing::PwgRasterSettings& pwg_raster_settings, ConvertCallback callback) {
  GetForwardingInterface()->Convert(
    std::move(pdf_region)
    , 
    std::move(pdf_settings)
    , 
    std::move(pwg_raster_settings)
    , std::move(callback));
}
void PdfToPwgRasterConverterInterceptorForTesting::SetUseSkiaRendererPolicy(bool use_skia) {
  GetForwardingInterface()->SetUseSkiaRendererPolicy(
    std::move(use_skia)
    );
}
PdfToPwgRasterConverterAsyncWaiter::PdfToPwgRasterConverterAsyncWaiter(
    PdfToPwgRasterConverter* proxy) : proxy_(proxy) {}

PdfToPwgRasterConverterAsyncWaiter::~PdfToPwgRasterConverterAsyncWaiter() = default;


void PdfToPwgRasterConverterAsyncWaiter::Convert(
    ::base::ReadOnlySharedMemoryRegion pdf_region, const ::printing::PdfRenderSettings& pdf_settings, const ::printing::PwgRasterSettings& pwg_raster_settings, ::base::ReadOnlySharedMemoryRegion* out_pwg_raster_region, uint32_t* out_page_count) {
  base::RunLoop loop;
  proxy_->Convert(
      std::move(pdf_region),
      std::move(pdf_settings),
      std::move(pwg_raster_settings),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::base::ReadOnlySharedMemoryRegion* out_pwg_raster_region
,
             uint32_t* out_page_count
,
             ::base::ReadOnlySharedMemoryRegion pwg_raster_region,
             uint32_t page_count) {*out_pwg_raster_region = std::move(pwg_raster_region);*out_page_count = std::move(page_count);
            loop->Quit();
          },
          &loop,
          out_pwg_raster_region,
          out_page_count));
  loop.Run();
}








}  // printing::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif