// chrome/services/printing/public/mojom/pdf_render_settings.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_RENDER_SETTINGS_MOJOM_DATA_VIEW_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_RENDER_SETTINGS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/services/printing/public/mojom/pdf_render_settings.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace printing::mojom {
class PdfRenderSettingsDataView;



}  // printing::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::printing::mojom::PdfRenderSettingsDataView> {
  using Data = ::printing::mojom::internal::PdfRenderSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace printing::mojom {


enum class PdfRenderSettings_Mode : int32_t {
  
  NORMAL = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, PdfRenderSettings_Mode value);
inline bool IsKnownEnumValue(PdfRenderSettings_Mode value) {
  return internal::PdfRenderSettings_Mode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PdfRenderSettingsDataView {
 public:
  PdfRenderSettingsDataView() = default;

  PdfRenderSettingsDataView(
      internal::PdfRenderSettings_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAreaDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArea(UserType* output) {
    
    auto* pointer = data_->area.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetOffsetsDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOffsets(UserType* output) {
    
    auto* pointer = data_->offsets.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetDpiDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDpi(UserType* output) {
    
    auto* pointer = data_->dpi.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  bool autorotate() const {
    return data_->autorotate;
  }
  bool use_color() const {
    return data_->use_color;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadMode(UserType* output) const {
    auto data_value = data_->mode;
    return mojo::internal::Deserialize<::printing::mojom::PdfRenderSettings_Mode>(
        data_value, output);
  }
  PdfRenderSettings_Mode mode() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::printing::mojom::PdfRenderSettings_Mode>(data_->mode));
  }
 private:
  internal::PdfRenderSettings_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // printing::mojom

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_RENDER_SETTINGS_MOJOM_DATA_VIEW_H_