// chrome/services/printing/public/mojom/pdf_nup_converter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_NUP_CONVERTER_MOJOM_H_
#define CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_NUP_CONVERTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/shared_memory.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace printing::mojom {

class PdfNupConverterProxy;

template <typename ImplRefTraits>
class PdfNupConverterStub;

class PdfNupConverterRequestValidator;
class PdfNupConverterResponseValidator;


class PdfNupConverter
    : public PdfNupConverterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "printing.mojom.PdfNupConverter";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PdfNupConverterInterfaceBase;
  using Proxy_ = PdfNupConverterProxy;

  template <typename ImplRefTraits>
  using Stub_ = PdfNupConverterStub<ImplRefTraits>;

  using RequestValidator_ = PdfNupConverterRequestValidator;
  using ResponseValidator_ = PdfNupConverterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kNupPageConvertMinVersion = 0,
    kNupDocumentConvertMinVersion = 0,
    kSetWebContentsURLMinVersion = 0,
    kSetUseSkiaRendererPolicyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NupPageConvert_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NupDocumentConvert_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetWebContentsURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUseSkiaRendererPolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using Status = PdfNupConverter_Status;
  virtual ~PdfNupConverter() = default;

  using NupPageConvertCallback = base::OnceCallback<void(PdfNupConverter::Status, ::base::ReadOnlySharedMemoryRegion)>;
  using NupPageConvertMojoCallback = base::OnceCallback<void(PdfNupConverter::Status, ::base::ReadOnlySharedMemoryRegion)>;

  virtual void NupPageConvert(uint32_t pages_per_sheet, const ::gfx::Size& page_size, const ::gfx::Rect& printable_area, std::vector<::base::ReadOnlySharedMemoryRegion> pdf_page_regions, NupPageConvertCallback callback) = 0;

  using NupDocumentConvertCallback = base::OnceCallback<void(PdfNupConverter::Status, ::base::ReadOnlySharedMemoryRegion)>;
  using NupDocumentConvertMojoCallback = base::OnceCallback<void(PdfNupConverter::Status, ::base::ReadOnlySharedMemoryRegion)>;

  virtual void NupDocumentConvert(uint32_t pages_per_sheet, const ::gfx::Size& page_size, const ::gfx::Rect& printable_area, ::base::ReadOnlySharedMemoryRegion src_pdf_region, NupDocumentConvertCallback callback) = 0;

  virtual void SetWebContentsURL(const ::GURL& url) = 0;

  virtual void SetUseSkiaRendererPolicy(bool use_skia) = 0;
};



class  PdfNupConverterProxy
    : public PdfNupConverter {
 public:
  using InterfaceType = PdfNupConverter;

  explicit PdfNupConverterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NupPageConvert(uint32_t pages_per_sheet, const ::gfx::Size& page_size, const ::gfx::Rect& printable_area, std::vector<::base::ReadOnlySharedMemoryRegion> pdf_page_regions, NupPageConvertCallback callback) final;
  
  void NupDocumentConvert(uint32_t pages_per_sheet, const ::gfx::Size& page_size, const ::gfx::Rect& printable_area, ::base::ReadOnlySharedMemoryRegion src_pdf_region, NupDocumentConvertCallback callback) final;
  
  void SetWebContentsURL(const ::GURL& url) final;
  
  void SetUseSkiaRendererPolicy(bool use_skia) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PdfNupConverterStubDispatch {
 public:
  static bool Accept(PdfNupConverter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PdfNupConverter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PdfNupConverter>>
class PdfNupConverterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PdfNupConverterStub() = default;
  ~PdfNupConverterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfNupConverterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PdfNupConverterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PdfNupConverterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PdfNupConverterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // printing::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_SERVICES_PRINTING_PUBLIC_MOJOM_PDF_NUP_CONVERTER_MOJOM_H_