// chrome/services/printing/public/mojom/pdf_nup_converter.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/printing/public/mojom/pdf_nup_converter.mojom-params-data.h"
namespace printing {
namespace mojom {

NOINLINE static const char* PdfNupConverter_StatusToStringHelper(PdfNupConverter_Status value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PdfNupConverter_Status::SUCCESS:
      return "SUCCESS";
    case PdfNupConverter_Status::CONVERSION_FAILURE:
      return "CONVERSION_FAILURE";
    case PdfNupConverter_Status::HANDLE_MAP_ERROR:
      return "HANDLE_MAP_ERROR";
    default:
      return nullptr;
  }
}

std::string PdfNupConverter_StatusToString(PdfNupConverter_Status value) {
  const char *str = PdfNupConverter_StatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PdfNupConverter_Status value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PdfNupConverter_Status value) {
  return os << PdfNupConverter_StatusToString(value);
}

namespace internal {


// static
bool PdfNupConverter_NupPageConvert_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfNupConverter_NupPageConvert_Params_Data* object =
      static_cast<const PdfNupConverter_NupPageConvert_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printable_area, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->printable_area, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pdf_page_regions, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& pdf_page_regions_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->pdf_page_regions, validation_context,
                                         &pdf_page_regions_validate_params)) {
    return false;
  }

  return true;
}

PdfNupConverter_NupPageConvert_Params_Data::PdfNupConverter_NupPageConvert_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfNupConverter_NupPageConvert_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfNupConverter_NupPageConvert_ResponseParams_Data* object =
      static_cast<const PdfNupConverter_NupPageConvert_ResponseParams_Data*>(data);


  if (!::printing::mojom::internal::PdfNupConverter_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pdf_region, validation_context))
    return false;

  return true;
}

PdfNupConverter_NupPageConvert_ResponseParams_Data::PdfNupConverter_NupPageConvert_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfNupConverter_NupDocumentConvert_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfNupConverter_NupDocumentConvert_Params_Data* object =
      static_cast<const PdfNupConverter_NupDocumentConvert_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->printable_area, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->printable_area, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->src_pdf_region, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->src_pdf_region, validation_context))
    return false;

  return true;
}

PdfNupConverter_NupDocumentConvert_Params_Data::PdfNupConverter_NupDocumentConvert_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfNupConverter_NupDocumentConvert_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfNupConverter_NupDocumentConvert_ResponseParams_Data* object =
      static_cast<const PdfNupConverter_NupDocumentConvert_ResponseParams_Data*>(data);


  if (!::printing::mojom::internal::PdfNupConverter_Status_Data
        ::Validate(object->status, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->pdf_region, validation_context))
    return false;

  return true;
}

PdfNupConverter_NupDocumentConvert_ResponseParams_Data::PdfNupConverter_NupDocumentConvert_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfNupConverter_SetWebContentsURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfNupConverter_SetWebContentsURL_Params_Data* object =
      static_cast<const PdfNupConverter_SetWebContentsURL_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

PdfNupConverter_SetWebContentsURL_Params_Data::PdfNupConverter_SetWebContentsURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data* object =
      static_cast<const PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data*>(data);

  return true;
}

PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data::PdfNupConverter_SetUseSkiaRendererPolicy_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace printing

namespace perfetto {

// static
void TraceFormatTraits<::printing::mojom::PdfNupConverter_Status>::WriteIntoTrace(
   perfetto::TracedValue context, ::printing::mojom::PdfNupConverter_Status value) {
  return std::move(context).WriteString(::printing::mojom::PdfNupConverter_StatusToString(value));
}

} // namespace perfetto