// chrome/services/mac_notifications/public/mojom/mac_notifications.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_H_
#define CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "chrome/services/mac_notifications/public/mojom/mac_notifications_mojom_traits.h"




namespace mac_notifications::mojom {

class MacNotificationServiceProxy;

template <typename ImplRefTraits>
class MacNotificationServiceStub;

class MacNotificationServiceRequestValidator;
class MacNotificationServiceResponseValidator;


class MacNotificationService
    : public MacNotificationServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mac_notifications.mojom.MacNotificationService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MacNotificationServiceInterfaceBase;
  using Proxy_ = MacNotificationServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = MacNotificationServiceStub<ImplRefTraits>;

  using RequestValidator_ = MacNotificationServiceRequestValidator;
  using ResponseValidator_ = MacNotificationServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDisplayNotificationMinVersion = 0,
    kGetDisplayedNotificationsMinVersion = 0,
    kCloseNotificationMinVersion = 0,
    kCloseNotificationsForProfileMinVersion = 0,
    kCloseAllNotificationsMinVersion = 0,
    kOkayToTerminateServiceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DisplayNotification_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDisplayedNotifications_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseNotification_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseNotificationsForProfile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseAllNotifications_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OkayToTerminateService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MacNotificationService() = default;

  virtual void DisplayNotification(NotificationPtr notification) = 0;

  using GetDisplayedNotificationsCallback = base::OnceCallback<void(std::vector<NotificationIdentifierPtr>)>;
  using GetDisplayedNotificationsMojoCallback = base::OnceCallback<void(std::vector<NotificationIdentifierPtr>)>;

  virtual void GetDisplayedNotifications(ProfileIdentifierPtr profile, const std::optional<::GURL>& origin, GetDisplayedNotificationsCallback callback) = 0;

  virtual void CloseNotification(NotificationIdentifierPtr identifier) = 0;

  virtual void CloseNotificationsForProfile(ProfileIdentifierPtr profile) = 0;

  virtual void CloseAllNotifications() = 0;

  using OkayToTerminateServiceCallback = base::OnceCallback<void(bool)>;
  using OkayToTerminateServiceMojoCallback = base::OnceCallback<void(bool)>;

  virtual void OkayToTerminateService(OkayToTerminateServiceCallback callback) = 0;
};

class MacNotificationActionHandlerProxy;

template <typename ImplRefTraits>
class MacNotificationActionHandlerStub;

class MacNotificationActionHandlerRequestValidator;


class MacNotificationActionHandler
    : public MacNotificationActionHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mac_notifications.mojom.MacNotificationActionHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MacNotificationActionHandlerInterfaceBase;
  using Proxy_ = MacNotificationActionHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MacNotificationActionHandlerStub<ImplRefTraits>;

  using RequestValidator_ = MacNotificationActionHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnNotificationActionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnNotificationAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MacNotificationActionHandler() = default;

  virtual void OnNotificationAction(NotificationActionInfoPtr info) = 0;
};

class MacNotificationProviderProxy;

template <typename ImplRefTraits>
class MacNotificationProviderStub;

class MacNotificationProviderRequestValidator;


class MacNotificationProvider
    : public MacNotificationProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "mac_notifications.mojom.MacNotificationProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kNoSandbox;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MacNotificationProviderInterfaceBase;
  using Proxy_ = MacNotificationProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = MacNotificationProviderStub<ImplRefTraits>;

  using RequestValidator_ = MacNotificationProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindNotificationServiceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindNotificationService_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MacNotificationProvider() = default;

  virtual void BindNotificationService(::mojo::PendingReceiver<MacNotificationService> service, ::mojo::PendingRemote<MacNotificationActionHandler> handler) = 0;
};



class  MacNotificationServiceProxy
    : public MacNotificationService {
 public:
  using InterfaceType = MacNotificationService;

  explicit MacNotificationServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DisplayNotification(NotificationPtr notification) final;
  
  void GetDisplayedNotifications(ProfileIdentifierPtr profile, const std::optional<::GURL>& origin, GetDisplayedNotificationsCallback callback) final;
  
  void CloseNotification(NotificationIdentifierPtr identifier) final;
  
  void CloseNotificationsForProfile(ProfileIdentifierPtr profile) final;
  
  void CloseAllNotifications() final;
  
  void OkayToTerminateService(OkayToTerminateServiceCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MacNotificationActionHandlerProxy
    : public MacNotificationActionHandler {
 public:
  using InterfaceType = MacNotificationActionHandler;

  explicit MacNotificationActionHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNotificationAction(NotificationActionInfoPtr info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MacNotificationProviderProxy
    : public MacNotificationProvider {
 public:
  using InterfaceType = MacNotificationProvider;

  explicit MacNotificationProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindNotificationService(::mojo::PendingReceiver<MacNotificationService> service, ::mojo::PendingRemote<MacNotificationActionHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MacNotificationServiceStubDispatch {
 public:
  static bool Accept(MacNotificationService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MacNotificationService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MacNotificationService>>
class MacNotificationServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MacNotificationServiceStub() = default;
  ~MacNotificationServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MacNotificationServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MacNotificationServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MacNotificationActionHandlerStubDispatch {
 public:
  static bool Accept(MacNotificationActionHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MacNotificationActionHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MacNotificationActionHandler>>
class MacNotificationActionHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MacNotificationActionHandlerStub() = default;
  ~MacNotificationActionHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MacNotificationActionHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MacNotificationActionHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MacNotificationProviderStubDispatch {
 public:
  static bool Accept(MacNotificationProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MacNotificationProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MacNotificationProvider>>
class MacNotificationProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MacNotificationProviderStub() = default;
  ~MacNotificationProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MacNotificationProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MacNotificationProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MacNotificationServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MacNotificationActionHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MacNotificationProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MacNotificationServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  ProfileIdentifier {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ProfileIdentifier, T>::value>;
  using DataView = ProfileIdentifierDataView;
  using Data_ = internal::ProfileIdentifier_Data;

  template <typename... Args>
  static ProfileIdentifierPtr New(Args&&... args) {
    return ProfileIdentifierPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ProfileIdentifierPtr From(const U& u) {
    return mojo::TypeConverter<ProfileIdentifierPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ProfileIdentifier>::Convert(*this);
  }


  ProfileIdentifier();

  ProfileIdentifier(
      const std::string& id,
      bool incognito);


  ~ProfileIdentifier();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ProfileIdentifierPtr>
  ProfileIdentifierPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ProfileIdentifier::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ProfileIdentifier::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ProfileIdentifier::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProfileIdentifier::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ProfileIdentifier::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ProfileIdentifier::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ProfileIdentifier_UnserializedMessageContext<
            UserType, ProfileIdentifier::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ProfileIdentifier::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ProfileIdentifier::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ProfileIdentifier_UnserializedMessageContext<
            UserType, ProfileIdentifier::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ProfileIdentifier::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  bool incognito;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ProfileIdentifier::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ProfileIdentifier::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ProfileIdentifier::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ProfileIdentifier::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}













class  NotificationIdentifier {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NotificationIdentifier, T>::value>;
  using DataView = NotificationIdentifierDataView;
  using Data_ = internal::NotificationIdentifier_Data;

  template <typename... Args>
  static NotificationIdentifierPtr New(Args&&... args) {
    return NotificationIdentifierPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NotificationIdentifierPtr From(const U& u) {
    return mojo::TypeConverter<NotificationIdentifierPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NotificationIdentifier>::Convert(*this);
  }


  NotificationIdentifier();

  NotificationIdentifier(
      const std::string& id,
      ProfileIdentifierPtr profile);

NotificationIdentifier(const NotificationIdentifier&) = delete;
NotificationIdentifier& operator=(const NotificationIdentifier&) = delete;

  ~NotificationIdentifier();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NotificationIdentifierPtr>
  NotificationIdentifierPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NotificationIdentifier::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NotificationIdentifier::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NotificationIdentifier::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotificationIdentifier::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotificationIdentifier::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NotificationIdentifier::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NotificationIdentifier_UnserializedMessageContext<
            UserType, NotificationIdentifier::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NotificationIdentifier::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NotificationIdentifier::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NotificationIdentifier_UnserializedMessageContext<
            UserType, NotificationIdentifier::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NotificationIdentifier::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  ProfileIdentifierPtr profile;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NotificationIdentifier::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NotificationIdentifier::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NotificationIdentifier::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NotificationIdentifier::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NotificationMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NotificationMetadata, T>::value>;
  using DataView = NotificationMetadataDataView;
  using Data_ = internal::NotificationMetadata_Data;

  template <typename... Args>
  static NotificationMetadataPtr New(Args&&... args) {
    return NotificationMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NotificationMetadataPtr From(const U& u) {
    return mojo::TypeConverter<NotificationMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NotificationMetadata>::Convert(*this);
  }


  NotificationMetadata();

  NotificationMetadata(
      NotificationIdentifierPtr id,
      int32_t type,
      const ::GURL& origin_url,
      const std::string& user_data_dir);

NotificationMetadata(const NotificationMetadata&) = delete;
NotificationMetadata& operator=(const NotificationMetadata&) = delete;

  ~NotificationMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NotificationMetadataPtr>
  NotificationMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NotificationMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NotificationMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NotificationMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotificationMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotificationMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NotificationMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NotificationMetadata_UnserializedMessageContext<
            UserType, NotificationMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NotificationMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NotificationMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NotificationMetadata_UnserializedMessageContext<
            UserType, NotificationMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NotificationMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NotificationIdentifierPtr id;
  
  int32_t type;
  
  ::GURL origin_url;
  
  std::string user_data_dir;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NotificationMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NotificationMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NotificationMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NotificationMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NotificationActionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NotificationActionInfo, T>::value>;
  using DataView = NotificationActionInfoDataView;
  using Data_ = internal::NotificationActionInfo_Data;

  template <typename... Args>
  static NotificationActionInfoPtr New(Args&&... args) {
    return NotificationActionInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NotificationActionInfoPtr From(const U& u) {
    return mojo::TypeConverter<NotificationActionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NotificationActionInfo>::Convert(*this);
  }


  NotificationActionInfo();

  NotificationActionInfo(
      NotificationMetadataPtr meta,
      ::NotificationOperation operation,
      int32_t button_index,
      const std::optional<::std::u16string>& reply);

NotificationActionInfo(const NotificationActionInfo&) = delete;
NotificationActionInfo& operator=(const NotificationActionInfo&) = delete;

  ~NotificationActionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NotificationActionInfoPtr>
  NotificationActionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NotificationActionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NotificationActionInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NotificationActionInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotificationActionInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotificationActionInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NotificationActionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NotificationActionInfo_UnserializedMessageContext<
            UserType, NotificationActionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NotificationActionInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NotificationActionInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NotificationActionInfo_UnserializedMessageContext<
            UserType, NotificationActionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NotificationActionInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NotificationMetadataPtr meta;
  
  ::NotificationOperation operation;
  
  int32_t button_index;
  
  std::optional<::std::u16string> reply;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NotificationActionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NotificationActionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NotificationActionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NotificationActionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NotificationActionButton {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NotificationActionButton, T>::value>;
  using DataView = NotificationActionButtonDataView;
  using Data_ = internal::NotificationActionButton_Data;

  template <typename... Args>
  static NotificationActionButtonPtr New(Args&&... args) {
    return NotificationActionButtonPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NotificationActionButtonPtr From(const U& u) {
    return mojo::TypeConverter<NotificationActionButtonPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NotificationActionButton>::Convert(*this);
  }


  NotificationActionButton();

  NotificationActionButton(
      const ::std::u16string& title,
      const std::optional<::std::u16string>& placeholder);


  ~NotificationActionButton();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NotificationActionButtonPtr>
  NotificationActionButtonPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NotificationActionButton::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NotificationActionButton::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NotificationActionButton::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotificationActionButton::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NotificationActionButton::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NotificationActionButton::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NotificationActionButton_UnserializedMessageContext<
            UserType, NotificationActionButton::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NotificationActionButton::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NotificationActionButton::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NotificationActionButton_UnserializedMessageContext<
            UserType, NotificationActionButton::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NotificationActionButton::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string title;
  
  std::optional<::std::u16string> placeholder;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NotificationActionButton::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NotificationActionButton::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NotificationActionButton::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NotificationActionButton::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Notification {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Notification, T>::value>;
  using DataView = NotificationDataView;
  using Data_ = internal::Notification_Data;

  template <typename... Args>
  static NotificationPtr New(Args&&... args) {
    return NotificationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NotificationPtr From(const U& u) {
    return mojo::TypeConverter<NotificationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Notification>::Convert(*this);
  }


  Notification();

  Notification(
      NotificationMetadataPtr meta,
      const ::std::u16string& title,
      const ::std::u16string& subtitle,
      const ::std::u16string& body,
      bool renotify,
      bool show_settings_button,
      std::vector<NotificationActionButtonPtr> buttons,
      const ::gfx::ImageSkia& icon);

Notification(const Notification&) = delete;
Notification& operator=(const Notification&) = delete;

  ~Notification();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NotificationPtr>
  NotificationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Notification::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Notification::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Notification::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Notification::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Notification_UnserializedMessageContext<
            UserType, Notification::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Notification::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Notification::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Notification_UnserializedMessageContext<
            UserType, Notification::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Notification::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  NotificationMetadataPtr meta;
  
  ::std::u16string title;
  
  ::std::u16string subtitle;
  
  ::std::u16string body;
  
  bool renotify;
  
  bool show_settings_button;
  
  std::vector<NotificationActionButtonPtr> buttons;
  
  ::gfx::ImageSkia icon;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Notification::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Notification::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Notification::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Notification::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ProfileIdentifierPtr ProfileIdentifier::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(incognito)
  );
}

template <typename T, ProfileIdentifier::EnableIfSame<T>*>
bool ProfileIdentifier::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->incognito, other_struct.incognito))
    return false;
  return true;
}

template <typename T, ProfileIdentifier::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.incognito < rhs.incognito)
    return true;
  if (rhs.incognito < lhs.incognito)
    return false;
  return false;
}
template <typename StructPtrType>
NotificationIdentifierPtr NotificationIdentifier::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(profile)
  );
}

template <typename T, NotificationIdentifier::EnableIfSame<T>*>
bool NotificationIdentifier::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->profile, other_struct.profile))
    return false;
  return true;
}

template <typename T, NotificationIdentifier::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.profile < rhs.profile)
    return true;
  if (rhs.profile < lhs.profile)
    return false;
  return false;
}
template <typename StructPtrType>
NotificationMetadataPtr NotificationMetadata::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(type),
      mojo::Clone(origin_url),
      mojo::Clone(user_data_dir)
  );
}

template <typename T, NotificationMetadata::EnableIfSame<T>*>
bool NotificationMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->origin_url, other_struct.origin_url))
    return false;
  if (!mojo::Equals(this->user_data_dir, other_struct.user_data_dir))
    return false;
  return true;
}

template <typename T, NotificationMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.origin_url < rhs.origin_url)
    return true;
  if (rhs.origin_url < lhs.origin_url)
    return false;
  if (lhs.user_data_dir < rhs.user_data_dir)
    return true;
  if (rhs.user_data_dir < lhs.user_data_dir)
    return false;
  return false;
}
template <typename StructPtrType>
NotificationActionInfoPtr NotificationActionInfo::Clone() const {
  return New(
      mojo::Clone(meta),
      mojo::Clone(operation),
      mojo::Clone(button_index),
      mojo::Clone(reply)
  );
}

template <typename T, NotificationActionInfo::EnableIfSame<T>*>
bool NotificationActionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->meta, other_struct.meta))
    return false;
  if (!mojo::Equals(this->operation, other_struct.operation))
    return false;
  if (!mojo::Equals(this->button_index, other_struct.button_index))
    return false;
  if (!mojo::Equals(this->reply, other_struct.reply))
    return false;
  return true;
}

template <typename T, NotificationActionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.meta < rhs.meta)
    return true;
  if (rhs.meta < lhs.meta)
    return false;
  if (lhs.operation < rhs.operation)
    return true;
  if (rhs.operation < lhs.operation)
    return false;
  if (lhs.button_index < rhs.button_index)
    return true;
  if (rhs.button_index < lhs.button_index)
    return false;
  if (lhs.reply < rhs.reply)
    return true;
  if (rhs.reply < lhs.reply)
    return false;
  return false;
}
template <typename StructPtrType>
NotificationActionButtonPtr NotificationActionButton::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(placeholder)
  );
}

template <typename T, NotificationActionButton::EnableIfSame<T>*>
bool NotificationActionButton::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->placeholder, other_struct.placeholder))
    return false;
  return true;
}

template <typename T, NotificationActionButton::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.placeholder < rhs.placeholder)
    return true;
  if (rhs.placeholder < lhs.placeholder)
    return false;
  return false;
}
template <typename StructPtrType>
NotificationPtr Notification::Clone() const {
  return New(
      mojo::Clone(meta),
      mojo::Clone(title),
      mojo::Clone(subtitle),
      mojo::Clone(body),
      mojo::Clone(renotify),
      mojo::Clone(show_settings_button),
      mojo::Clone(buttons),
      mojo::Clone(icon)
  );
}

template <typename T, Notification::EnableIfSame<T>*>
bool Notification::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->meta, other_struct.meta))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->subtitle, other_struct.subtitle))
    return false;
  if (!mojo::Equals(this->body, other_struct.body))
    return false;
  if (!mojo::Equals(this->renotify, other_struct.renotify))
    return false;
  if (!mojo::Equals(this->show_settings_button, other_struct.show_settings_button))
    return false;
  if (!mojo::Equals(this->buttons, other_struct.buttons))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  return true;
}

template <typename T, Notification::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.meta < rhs.meta)
    return true;
  if (rhs.meta < lhs.meta)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.subtitle < rhs.subtitle)
    return true;
  if (rhs.subtitle < lhs.subtitle)
    return false;
  if (lhs.body < rhs.body)
    return true;
  if (rhs.body < lhs.body)
    return false;
  if (lhs.renotify < rhs.renotify)
    return true;
  if (rhs.renotify < lhs.renotify)
    return false;
  if (lhs.show_settings_button < rhs.show_settings_button)
    return true;
  if (rhs.show_settings_button < lhs.show_settings_button)
    return false;
  if (lhs.buttons < rhs.buttons)
    return true;
  if (rhs.buttons < lhs.buttons)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  return false;
}


}  // mac_notifications::mojom

namespace mojo {


template <>
struct  StructTraits<::mac_notifications::mojom::ProfileIdentifier::DataView,
                                         ::mac_notifications::mojom::ProfileIdentifierPtr> {
  static bool IsNull(const ::mac_notifications::mojom::ProfileIdentifierPtr& input) { return !input; }
  static void SetToNull(::mac_notifications::mojom::ProfileIdentifierPtr* output) { output->reset(); }

  static const decltype(::mac_notifications::mojom::ProfileIdentifier::id)& id(
      const ::mac_notifications::mojom::ProfileIdentifierPtr& input) {
    return input->id;
  }

  static decltype(::mac_notifications::mojom::ProfileIdentifier::incognito) incognito(
      const ::mac_notifications::mojom::ProfileIdentifierPtr& input) {
    return input->incognito;
  }

  static bool Read(::mac_notifications::mojom::ProfileIdentifier::DataView input, ::mac_notifications::mojom::ProfileIdentifierPtr* output);
};


template <>
struct  StructTraits<::mac_notifications::mojom::NotificationIdentifier::DataView,
                                         ::mac_notifications::mojom::NotificationIdentifierPtr> {
  static bool IsNull(const ::mac_notifications::mojom::NotificationIdentifierPtr& input) { return !input; }
  static void SetToNull(::mac_notifications::mojom::NotificationIdentifierPtr* output) { output->reset(); }

  static const decltype(::mac_notifications::mojom::NotificationIdentifier::id)& id(
      const ::mac_notifications::mojom::NotificationIdentifierPtr& input) {
    return input->id;
  }

  static const decltype(::mac_notifications::mojom::NotificationIdentifier::profile)& profile(
      const ::mac_notifications::mojom::NotificationIdentifierPtr& input) {
    return input->profile;
  }

  static bool Read(::mac_notifications::mojom::NotificationIdentifier::DataView input, ::mac_notifications::mojom::NotificationIdentifierPtr* output);
};


template <>
struct  StructTraits<::mac_notifications::mojom::NotificationMetadata::DataView,
                                         ::mac_notifications::mojom::NotificationMetadataPtr> {
  static bool IsNull(const ::mac_notifications::mojom::NotificationMetadataPtr& input) { return !input; }
  static void SetToNull(::mac_notifications::mojom::NotificationMetadataPtr* output) { output->reset(); }

  static const decltype(::mac_notifications::mojom::NotificationMetadata::id)& id(
      const ::mac_notifications::mojom::NotificationMetadataPtr& input) {
    return input->id;
  }

  static decltype(::mac_notifications::mojom::NotificationMetadata::type) type(
      const ::mac_notifications::mojom::NotificationMetadataPtr& input) {
    return input->type;
  }

  static const decltype(::mac_notifications::mojom::NotificationMetadata::origin_url)& origin_url(
      const ::mac_notifications::mojom::NotificationMetadataPtr& input) {
    return input->origin_url;
  }

  static const decltype(::mac_notifications::mojom::NotificationMetadata::user_data_dir)& user_data_dir(
      const ::mac_notifications::mojom::NotificationMetadataPtr& input) {
    return input->user_data_dir;
  }

  static bool Read(::mac_notifications::mojom::NotificationMetadata::DataView input, ::mac_notifications::mojom::NotificationMetadataPtr* output);
};


template <>
struct  StructTraits<::mac_notifications::mojom::NotificationActionInfo::DataView,
                                         ::mac_notifications::mojom::NotificationActionInfoPtr> {
  static bool IsNull(const ::mac_notifications::mojom::NotificationActionInfoPtr& input) { return !input; }
  static void SetToNull(::mac_notifications::mojom::NotificationActionInfoPtr* output) { output->reset(); }

  static const decltype(::mac_notifications::mojom::NotificationActionInfo::meta)& meta(
      const ::mac_notifications::mojom::NotificationActionInfoPtr& input) {
    return input->meta;
  }

  static decltype(::mac_notifications::mojom::NotificationActionInfo::operation) operation(
      const ::mac_notifications::mojom::NotificationActionInfoPtr& input) {
    return input->operation;
  }

  static decltype(::mac_notifications::mojom::NotificationActionInfo::button_index) button_index(
      const ::mac_notifications::mojom::NotificationActionInfoPtr& input) {
    return input->button_index;
  }

  static const decltype(::mac_notifications::mojom::NotificationActionInfo::reply)& reply(
      const ::mac_notifications::mojom::NotificationActionInfoPtr& input) {
    return input->reply;
  }

  static bool Read(::mac_notifications::mojom::NotificationActionInfo::DataView input, ::mac_notifications::mojom::NotificationActionInfoPtr* output);
};


template <>
struct  StructTraits<::mac_notifications::mojom::NotificationActionButton::DataView,
                                         ::mac_notifications::mojom::NotificationActionButtonPtr> {
  static bool IsNull(const ::mac_notifications::mojom::NotificationActionButtonPtr& input) { return !input; }
  static void SetToNull(::mac_notifications::mojom::NotificationActionButtonPtr* output) { output->reset(); }

  static const decltype(::mac_notifications::mojom::NotificationActionButton::title)& title(
      const ::mac_notifications::mojom::NotificationActionButtonPtr& input) {
    return input->title;
  }

  static const decltype(::mac_notifications::mojom::NotificationActionButton::placeholder)& placeholder(
      const ::mac_notifications::mojom::NotificationActionButtonPtr& input) {
    return input->placeholder;
  }

  static bool Read(::mac_notifications::mojom::NotificationActionButton::DataView input, ::mac_notifications::mojom::NotificationActionButtonPtr* output);
};


template <>
struct  StructTraits<::mac_notifications::mojom::Notification::DataView,
                                         ::mac_notifications::mojom::NotificationPtr> {
  static bool IsNull(const ::mac_notifications::mojom::NotificationPtr& input) { return !input; }
  static void SetToNull(::mac_notifications::mojom::NotificationPtr* output) { output->reset(); }

  static const decltype(::mac_notifications::mojom::Notification::meta)& meta(
      const ::mac_notifications::mojom::NotificationPtr& input) {
    return input->meta;
  }

  static const decltype(::mac_notifications::mojom::Notification::title)& title(
      const ::mac_notifications::mojom::NotificationPtr& input) {
    return input->title;
  }

  static const decltype(::mac_notifications::mojom::Notification::subtitle)& subtitle(
      const ::mac_notifications::mojom::NotificationPtr& input) {
    return input->subtitle;
  }

  static const decltype(::mac_notifications::mojom::Notification::body)& body(
      const ::mac_notifications::mojom::NotificationPtr& input) {
    return input->body;
  }

  static decltype(::mac_notifications::mojom::Notification::renotify) renotify(
      const ::mac_notifications::mojom::NotificationPtr& input) {
    return input->renotify;
  }

  static decltype(::mac_notifications::mojom::Notification::show_settings_button) show_settings_button(
      const ::mac_notifications::mojom::NotificationPtr& input) {
    return input->show_settings_button;
  }

  static const decltype(::mac_notifications::mojom::Notification::buttons)& buttons(
      const ::mac_notifications::mojom::NotificationPtr& input) {
    return input->buttons;
  }

  static  decltype(::mac_notifications::mojom::Notification::icon)& icon(
       ::mac_notifications::mojom::NotificationPtr& input) {
    return input->icon;
  }

  static bool Read(::mac_notifications::mojom::Notification::DataView input, ::mac_notifications::mojom::NotificationPtr* output);
};

}  // namespace mojo

#endif  // CHROME_SERVICES_MAC_NOTIFICATIONS_PUBLIC_MOJOM_MAC_NOTIFICATIONS_MOJOM_H_