// chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/mac_notifications/public/mojom/mac_notifications.mojom-params-data.h"
namespace mac_notifications {
namespace mojom {

NOINLINE static const char* NotificationOperationToStringHelper(NotificationOperation value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NotificationOperation::kClick:
      return "kClick";
    case NotificationOperation::kClose:
      return "kClose";
    case NotificationOperation::kSettings:
      return "kSettings";
    default:
      return nullptr;
  }
}

std::string NotificationOperationToString(NotificationOperation value) {
  const char *str = NotificationOperationToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NotificationOperation value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NotificationOperation value) {
  return os << NotificationOperationToString(value);
}

NOINLINE static const char* RequestPermissionResultToStringHelper(RequestPermissionResult value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RequestPermissionResult::kRequestFailed:
      return "kRequestFailed";
    case RequestPermissionResult::kPermissionDenied:
      return "kPermissionDenied";
    case RequestPermissionResult::kPermissionGranted:
      return "kPermissionGranted";
    case RequestPermissionResult::kPermissionPreviouslyDenied:
      return "kPermissionPreviouslyDenied";
    case RequestPermissionResult::kPermissionPreviouslyGranted:
      return "kPermissionPreviouslyGranted";
    default:
      return nullptr;
  }
}

std::string RequestPermissionResultToString(RequestPermissionResult value) {
  const char *str = RequestPermissionResultToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RequestPermissionResult value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RequestPermissionResult value) {
  return os << RequestPermissionResultToString(value);
}

NOINLINE static const char* PermissionStatusToStringHelper(PermissionStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PermissionStatus::kNotDetermined:
      return "kNotDetermined";
    case PermissionStatus::kPromptPending:
      return "kPromptPending";
    case PermissionStatus::kDenied:
      return "kDenied";
    case PermissionStatus::kGranted:
      return "kGranted";
    default:
      return nullptr;
  }
}

std::string PermissionStatusToString(PermissionStatus value) {
  const char *str = PermissionStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PermissionStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PermissionStatus value) {
  return os << PermissionStatusToString(value);
}

namespace internal {


// static
bool ProfileIdentifier_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProfileIdentifier_Data* object =
      static_cast<const ProfileIdentifier_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  return true;
}

ProfileIdentifier_Data::ProfileIdentifier_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NotificationIdentifier_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NotificationIdentifier_Data* object =
      static_cast<const NotificationIdentifier_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->profile, validation_context))
    return false;

  return true;
}

NotificationIdentifier_Data::NotificationIdentifier_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NotificationMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NotificationMetadata_Data* object =
      static_cast<const NotificationMetadata_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->user_data_dir, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& user_data_dir_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->user_data_dir, validation_context,
                                         &user_data_dir_validate_params)) {
    return false;
  }

  return true;
}

NotificationMetadata_Data::NotificationMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NotificationActionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NotificationActionInfo_Data* object =
      static_cast<const NotificationActionInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->meta, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->meta, validation_context))
    return false;


  if (!::mac_notifications::mojom::internal::NotificationOperation_Data
        ::Validate(object->operation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->reply, validation_context))
    return false;

  return true;
}

NotificationActionInfo_Data::NotificationActionInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NotificationActionButton_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NotificationActionButton_Data* object =
      static_cast<const NotificationActionButton_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->placeholder, validation_context))
    return false;

  return true;
}

NotificationActionButton_Data::NotificationActionButton_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Notification_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Notification_Data* object =
      static_cast<const Notification_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->meta, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->meta, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->title, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subtitle, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->subtitle, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->body, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->body, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->buttons, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& buttons_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->buttons, validation_context,
                                         &buttons_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->icon, validation_context))
    return false;

  return true;
}

Notification_Data::Notification_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MacNotificationService_DisplayNotification_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MacNotificationService_DisplayNotification_Params_Data* object =
      static_cast<const MacNotificationService_DisplayNotification_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->notification, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->notification, validation_context))
    return false;

  return true;
}

MacNotificationService_DisplayNotification_Params_Data::MacNotificationService_DisplayNotification_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MacNotificationService_GetDisplayedNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MacNotificationService_GetDisplayedNotifications_Params_Data* object =
      static_cast<const MacNotificationService_GetDisplayedNotifications_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->profile, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  return true;
}

MacNotificationService_GetDisplayedNotifications_Params_Data::MacNotificationService_GetDisplayedNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MacNotificationService_GetDisplayedNotifications_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MacNotificationService_GetDisplayedNotifications_ResponseParams_Data* object =
      static_cast<const MacNotificationService_GetDisplayedNotifications_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->notifications, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& notifications_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->notifications, validation_context,
                                         &notifications_validate_params)) {
    return false;
  }

  return true;
}

MacNotificationService_GetDisplayedNotifications_ResponseParams_Data::MacNotificationService_GetDisplayedNotifications_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MacNotificationService_CloseNotification_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MacNotificationService_CloseNotification_Params_Data* object =
      static_cast<const MacNotificationService_CloseNotification_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identifier, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->identifier, validation_context))
    return false;

  return true;
}

MacNotificationService_CloseNotification_Params_Data::MacNotificationService_CloseNotification_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MacNotificationService_CloseNotificationsForProfile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MacNotificationService_CloseNotificationsForProfile_Params_Data* object =
      static_cast<const MacNotificationService_CloseNotificationsForProfile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->profile, validation_context))
    return false;

  return true;
}

MacNotificationService_CloseNotificationsForProfile_Params_Data::MacNotificationService_CloseNotificationsForProfile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MacNotificationService_CloseAllNotifications_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MacNotificationService_CloseAllNotifications_Params_Data* object =
      static_cast<const MacNotificationService_CloseAllNotifications_Params_Data*>(data);

  return true;
}

MacNotificationService_CloseAllNotifications_Params_Data::MacNotificationService_CloseAllNotifications_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MacNotificationService_OkayToTerminateService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MacNotificationService_OkayToTerminateService_Params_Data* object =
      static_cast<const MacNotificationService_OkayToTerminateService_Params_Data*>(data);

  return true;
}

MacNotificationService_OkayToTerminateService_Params_Data::MacNotificationService_OkayToTerminateService_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MacNotificationService_OkayToTerminateService_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MacNotificationService_OkayToTerminateService_ResponseParams_Data* object =
      static_cast<const MacNotificationService_OkayToTerminateService_ResponseParams_Data*>(data);

  return true;
}

MacNotificationService_OkayToTerminateService_ResponseParams_Data::MacNotificationService_OkayToTerminateService_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MacNotificationActionHandler_OnNotificationAction_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MacNotificationActionHandler_OnNotificationAction_Params_Data* object =
      static_cast<const MacNotificationActionHandler_OnNotificationAction_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->info, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->info, validation_context))
    return false;

  return true;
}

MacNotificationActionHandler_OnNotificationAction_Params_Data::MacNotificationActionHandler_OnNotificationAction_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MacNotificationProvider_BindNotificationService_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MacNotificationProvider_BindNotificationService_Params_Data* object =
      static_cast<const MacNotificationProvider_BindNotificationService_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->service, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->service,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MacNotificationProvider_BindNotificationService_Params_Data::MacNotificationProvider_BindNotificationService_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace mac_notifications

namespace perfetto {

// static
void TraceFormatTraits<::mac_notifications::mojom::NotificationOperation>::WriteIntoTrace(
   perfetto::TracedValue context, ::mac_notifications::mojom::NotificationOperation value) {
  return std::move(context).WriteString(::mac_notifications::mojom::NotificationOperationToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::mac_notifications::mojom::RequestPermissionResult>::WriteIntoTrace(
   perfetto::TracedValue context, ::mac_notifications::mojom::RequestPermissionResult value) {
  return std::move(context).WriteString(::mac_notifications::mojom::RequestPermissionResultToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::mac_notifications::mojom::PermissionStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::mac_notifications::mojom::PermissionStatus value) {
  return std::move(context).WriteString(::mac_notifications::mojom::PermissionStatusToString(value));
}

} // namespace perfetto