// chrome/services/file_util/public/mojom/single_file_extractor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/services/file_util/public/mojom/single_file_extractor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/services/file_util/public/mojom/single_file_extractor.mojom-params-data.h"
#include "chrome/services/file_util/public/mojom/single_file_extractor.mojom-shared-message-ids.h"

#include "chrome/services/file_util/public/mojom/single_file_extractor.mojom-import-headers.h"
#include "chrome/services/file_util/public/mojom/single_file_extractor.mojom-test-utils.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

SingleFileExtractor::IPCStableHashFunction SingleFileExtractor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SingleFileExtractor>(message.name())) {
    case messages::SingleFileExtractor::kExtract: {
      return &SingleFileExtractor::Extract_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SingleFileExtractor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SingleFileExtractor>(message.name())) {
      case messages::SingleFileExtractor::kExtract:
            return "Receive chrome::mojom::SingleFileExtractor::Extract";
    }
  } else {
    switch (static_cast<messages::SingleFileExtractor>(message.name())) {
      case messages::SingleFileExtractor::kExtract:
            return "Receive reply chrome::mojom::SingleFileExtractor::Extract";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SingleFileExtractor::Extract_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x250eb21a;  // IPCStableHash for chrome::mojom::SingleFileExtractor::Extract
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SingleFileExtractor_Extract_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SingleFileExtractor_Extract_ForwardToCallback(
      SingleFileExtractor::ExtractCallback callback
      ) : callback_(std::move(callback)) {
  }

  SingleFileExtractor_Extract_ForwardToCallback(const SingleFileExtractor_Extract_ForwardToCallback&) = delete;
  SingleFileExtractor_Extract_ForwardToCallback& operator=(const SingleFileExtractor_Extract_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SingleFileExtractor::ExtractCallback callback_;
};

SingleFileExtractorProxy::SingleFileExtractorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SingleFileExtractorProxy::Extract(
    ::base::File in_src_file, ::base::File in_dst_file, ::mojo::PendingRemote<SingleFileExtractorListener> in_listener, ExtractCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::SingleFileExtractor::Extract", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("src_file"), in_src_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dst_file"), in_dst_file,
                        "<value of type ::base::File>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("listener"), in_listener,
                        "<value of type ::mojo::PendingRemote<SingleFileExtractorListener>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SingleFileExtractor::kExtract), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SingleFileExtractor_Extract_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->src_file)::BaseType> src_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::ReadOnlyFileDataView>(
    in_src_file,
    src_file_fragment);

  params->src_file.Set(
      src_file_fragment.is_null() ? nullptr : src_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->src_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null src_file in SingleFileExtractor.Extract request");
  mojo::internal::MessageFragment<
      typename decltype(params->dst_file)::BaseType> dst_file_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::FileDataView>(
    in_dst_file,
    dst_file_fragment);

  params->dst_file.Set(
      dst_file_fragment.is_null() ? nullptr : dst_file_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->dst_file.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null dst_file in SingleFileExtractor.Extract request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::chrome::mojom::SingleFileExtractorListenerInterfaceBase>>(
    in_listener,
    &params->listener,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->listener)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid listener in SingleFileExtractor.Extract request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SingleFileExtractor::Name_);
  message.set_method_name("Extract");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SingleFileExtractor_Extract_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SingleFileExtractor_Extract_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SingleFileExtractor::ExtractCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SingleFileExtractor_Extract_ProxyToResponder> proxy(
        new SingleFileExtractor_Extract_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SingleFileExtractor_Extract_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SingleFileExtractor_Extract_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SingleFileExtractor_Extract_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SingleFileExtractor::ExtractCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::chrome::file_util::mojom::ExtractionResult in_result);
};

bool SingleFileExtractor_Extract_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SingleFileExtractor_Extract_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SingleFileExtractor_Extract_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SingleFileExtractor.0
  bool success = true;
  ::chrome::file_util::mojom::ExtractionResult p_result{};
  SingleFileExtractor_Extract_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SingleFileExtractor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SingleFileExtractor_Extract_ProxyToResponder::Run(
    ::chrome::file_util::mojom::ExtractionResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply chrome::mojom::SingleFileExtractor::Extract", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::chrome::file_util::mojom::ExtractionResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SingleFileExtractor::kExtract), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SingleFileExtractor_Extract_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::chrome::file_util::mojom::ExtractionResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SingleFileExtractor::Name_);
  message.set_method_name("Extract");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SingleFileExtractorStubDispatch::Accept(
    SingleFileExtractor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SingleFileExtractor>(message->header()->name)) {
    case messages::SingleFileExtractor::kExtract: {
      break;
    }
  }
  return false;
}

// static
bool SingleFileExtractorStubDispatch::AcceptWithResponder(
    SingleFileExtractor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SingleFileExtractor>(message->header()->name)) {
    case messages::SingleFileExtractor::kExtract: {
      internal::SingleFileExtractor_Extract_Params_Data* params =
          reinterpret_cast<
              internal::SingleFileExtractor_Extract_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SingleFileExtractor.0
      bool success = true;
      ::base::File p_src_file{};
      ::base::File p_dst_file{};
      ::mojo::PendingRemote<SingleFileExtractorListener> p_listener{};
      SingleFileExtractor_Extract_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSrcFile(&p_src_file))
        success = false;
      if (success && !input_data_view.ReadDstFile(&p_dst_file))
        success = false;
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SingleFileExtractor::Name_, 0, false);
        return false;
      }
      auto callback =
          SingleFileExtractor_Extract_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Extract(        
        std::move(p_src_file), 
        std::move(p_dst_file), 
        std::move(p_listener), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSingleFileExtractorValidationInfo[] = {
    { &internal::SingleFileExtractor_Extract_Params_Data::Validate,
     &internal::SingleFileExtractor_Extract_ResponseParams_Data::Validate},
};

bool SingleFileExtractorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::SingleFileExtractor::Name_,
    kSingleFileExtractorValidationInfo);
}

bool SingleFileExtractorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::SingleFileExtractor::Name_,
    kSingleFileExtractorValidationInfo);
}
// The declaration includes the definition on other builds.

SingleFileExtractorListener::IPCStableHashFunction SingleFileExtractorListener::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SingleFileExtractorListener>(message.name())) {
    case messages::SingleFileExtractorListener::kOnProgress: {
      return &SingleFileExtractorListener::OnProgress_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SingleFileExtractorListener::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SingleFileExtractorListener>(message.name())) {
      case messages::SingleFileExtractorListener::kOnProgress:
            return "Receive chrome::mojom::SingleFileExtractorListener::OnProgress";
    }
  } else {
    switch (static_cast<messages::SingleFileExtractorListener>(message.name())) {
      case messages::SingleFileExtractorListener::kOnProgress:
            return "Receive reply chrome::mojom::SingleFileExtractorListener::OnProgress";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SingleFileExtractorListener::OnProgress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x42eb6deb;  // IPCStableHash for chrome::mojom::SingleFileExtractorListener::OnProgress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

SingleFileExtractorListenerProxy::SingleFileExtractorListenerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SingleFileExtractorListenerProxy::OnProgress(
    uint64_t in_total_bytes, uint64_t in_progress_bytes) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::SingleFileExtractorListener::OnProgress", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("total_bytes"), in_total_bytes,
                        "<value of type uint64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("progress_bytes"), in_progress_bytes,
                        "<value of type uint64_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SingleFileExtractorListener::kOnProgress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::SingleFileExtractorListener_OnProgress_Params_Data> params(
          message);
  params.Allocate();

  params->total_bytes = in_total_bytes;

  params->progress_bytes = in_progress_bytes;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SingleFileExtractorListener::Name_);
  message.set_method_name("OnProgress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool SingleFileExtractorListenerStubDispatch::Accept(
    SingleFileExtractorListener* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SingleFileExtractorListener>(message->header()->name)) {
    case messages::SingleFileExtractorListener::kOnProgress: {
      DCHECK(message->is_serialized());
      internal::SingleFileExtractorListener_OnProgress_Params_Data* params =
          reinterpret_cast<internal::SingleFileExtractorListener_OnProgress_Params_Data*>(
              message->mutable_payload());
      

      // Validation for SingleFileExtractorListener.0
      bool success = true;
      uint64_t p_total_bytes{};
      uint64_t p_progress_bytes{};
      SingleFileExtractorListener_OnProgress_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_total_bytes = input_data_view.total_bytes();
      if (success)
        p_progress_bytes = input_data_view.progress_bytes();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SingleFileExtractorListener::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnProgress(        
        std::move(p_total_bytes), 
        std::move(p_progress_bytes));
      return true;
    }
  }
  return false;
}

// static
bool SingleFileExtractorListenerStubDispatch::AcceptWithResponder(
    SingleFileExtractorListener* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SingleFileExtractorListener>(message->header()->name)) {
    case messages::SingleFileExtractorListener::kOnProgress: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSingleFileExtractorListenerValidationInfo[] = {
    { &internal::SingleFileExtractorListener_OnProgress_Params_Data::Validate,
     nullptr /* no response */},
};

bool SingleFileExtractorListenerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::SingleFileExtractorListener::Name_,
    kSingleFileExtractorListenerValidationInfo);
}



}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void SingleFileExtractorInterceptorForTesting::Extract(::base::File src_file, ::base::File dst_file, ::mojo::PendingRemote<SingleFileExtractorListener> listener, ExtractCallback callback) {
  GetForwardingInterface()->Extract(
    std::move(src_file)
    , 
    std::move(dst_file)
    , 
    std::move(listener)
    , std::move(callback));
}
SingleFileExtractorAsyncWaiter::SingleFileExtractorAsyncWaiter(
    SingleFileExtractor* proxy) : proxy_(proxy) {}

SingleFileExtractorAsyncWaiter::~SingleFileExtractorAsyncWaiter() = default;


void SingleFileExtractorAsyncWaiter::Extract(
    ::base::File src_file, ::base::File dst_file, ::mojo::PendingRemote<SingleFileExtractorListener> listener, ::chrome::file_util::mojom::ExtractionResult* out_result) {
  base::RunLoop loop;
  proxy_->Extract(
      std::move(src_file),
      std::move(dst_file),
      std::move(listener),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::chrome::file_util::mojom::ExtractionResult* out_result
,
             ::chrome::file_util::mojom::ExtractionResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::chrome::file_util::mojom::ExtractionResult SingleFileExtractorAsyncWaiter::Extract(
    ::base::File src_file, ::base::File dst_file, ::mojo::PendingRemote<SingleFileExtractorListener> listener) {
  ::chrome::file_util::mojom::ExtractionResult async_wait_result;
  Extract(std::move(src_file),std::move(dst_file),std::move(listener),&async_wait_result);
  return async_wait_result;
}




void SingleFileExtractorListenerInterceptorForTesting::OnProgress(uint64_t total_bytes, uint64_t progress_bytes) {
  GetForwardingInterface()->OnProgress(
    std::move(total_bytes)
    , 
    std::move(progress_bytes)
    );
}
SingleFileExtractorListenerAsyncWaiter::SingleFileExtractorListenerAsyncWaiter(
    SingleFileExtractorListener* proxy) : proxy_(proxy) {}

SingleFileExtractorListenerAsyncWaiter::~SingleFileExtractorListenerAsyncWaiter() = default;







}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif