// chrome/services/file_util/public/mojom/file_util_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_FILE_UTIL_SERVICE_MOJOM_H_
#define CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_FILE_UTIL_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/services/file_util/public/mojom/file_util_service.mojom-features.h"  // IWYU pragma: export
#include "chrome/services/file_util/public/mojom/file_util_service.mojom-shared.h"  // IWYU pragma: export
#include "chrome/services/file_util/public/mojom/file_util_service.mojom-forward.h"  // IWYU pragma: export
#include "sandbox/policy/mojom/sandbox.mojom-forward.h"
#include "chrome/services/file_util/public/mojom/safe_archive_analyzer.mojom-forward.h"
#include "chrome/services/file_util/public/mojom/single_file_extractor.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class FileUtilServiceProxy;

template <typename ImplRefTraits>
class FileUtilServiceStub;

class FileUtilServiceRequestValidator;


class FileUtilService
    : public FileUtilServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.FileUtilService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr auto kServiceSandbox = sandbox::mojom::Sandbox::kService;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FileUtilServiceInterfaceBase;
  using Proxy_ = FileUtilServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileUtilServiceStub<ImplRefTraits>;

  using RequestValidator_ = FileUtilServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindSafeArchiveAnalyzerMinVersion = 0,
    kBindSingleFileTarFileExtractorMinVersion = 0,
    kBindSingleFileTarXzFileExtractorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BindSafeArchiveAnalyzer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindSingleFileTarFileExtractor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindSingleFileTarXzFileExtractor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FileUtilService() = default;

  virtual void BindSafeArchiveAnalyzer(::mojo::PendingReceiver<::chrome::mojom::SafeArchiveAnalyzer> receiver) = 0;

  virtual void BindSingleFileTarFileExtractor(::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor> receiver) = 0;

  virtual void BindSingleFileTarXzFileExtractor(::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor> receiver) = 0;
};



class  FileUtilServiceProxy
    : public FileUtilService {
 public:
  using InterfaceType = FileUtilService;

  explicit FileUtilServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindSafeArchiveAnalyzer(::mojo::PendingReceiver<::chrome::mojom::SafeArchiveAnalyzer> receiver) final;
  
  void BindSingleFileTarFileExtractor(::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor> receiver) final;
  
  void BindSingleFileTarXzFileExtractor(::mojo::PendingReceiver<::chrome::mojom::SingleFileExtractor> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  FileUtilServiceStubDispatch {
 public:
  static bool Accept(FileUtilService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileUtilService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileUtilService>>
class FileUtilServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileUtilServiceStub() = default;
  ~FileUtilServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileUtilServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileUtilServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  FileUtilServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_SERVICES_FILE_UTIL_PUBLIC_MOJOM_FILE_UTIL_SERVICE_MOJOM_H_