// chrome/common/trusted_vault_encryption_keys_extension.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/trusted_vault_encryption_keys_extension.mojom-params-data.h"
namespace chrome {
namespace mojom {

namespace internal {


// static
bool TrustedVaultKey_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedVaultKey_Data* object =
      static_cast<const TrustedVaultKey_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bytes, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& bytes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->bytes, validation_context,
                                         &bytes_validate_params)) {
    return false;
  }

  return true;
}

TrustedVaultKey_Data::TrustedVaultKey_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_Params_Data* object =
      static_cast<const TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gaia_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gaia_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gaia_id, validation_context,
                                         &gaia_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->encryption_keys, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& encryption_keys_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->encryption_keys, validation_context,
                                         &encryption_keys_validate_params)) {
    return false;
  }

  return true;
}

TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_Params_Data::TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ResponseParams_Data* object =
      static_cast<const TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ResponseParams_Data*>(data);

  return true;
}

TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ResponseParams_Data::TrustedVaultEncryptionKeysExtension_SetEncryptionKeys_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_Params_Data* object =
      static_cast<const TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gaia_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gaia_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gaia_id, validation_context,
                                         &gaia_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->public_key, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& public_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->public_key, validation_context,
                                         &public_key_validate_params)) {
    return false;
  }

  return true;
}

TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_Params_Data::TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ResponseParams_Data* object =
      static_cast<const TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ResponseParams_Data*>(data);

  return true;
}

TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ResponseParams_Data::TrustedVaultEncryptionKeysExtension_AddTrustedRecoveryMethod_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace chrome