// chrome/common/read_anything/read_anything.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_READ_ANYTHING_READ_ANYTHING_MOJOM_DATA_VIEW_H_
#define CHROME_COMMON_READ_ANYTHING_READ_ANYTHING_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/common/read_anything/read_anything.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/accessibility/ax_features.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared.h"
#include "ui/accessibility/mojom/ax_location_and_scroll_updates.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"


namespace read_anything::mojom {
class VoicePackInfoDataView;

class VoicePackInstallationStateDataView;


}  // read_anything::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::read_anything::mojom::VoicePackInfoDataView> {
  using Data = ::read_anything::mojom::internal::VoicePackInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::read_anything::mojom::VoicePackInstallationStateDataView> {
  using Data = ::read_anything::mojom::internal::VoicePackInstallationState_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace read_anything::mojom {


enum class InstallationState : int32_t {
  
  kUnknown = 0,
  
  kNotInstalled = 1,
  
  kInstalling = 2,
  
  kInstalled = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, InstallationState value);
inline bool IsKnownEnumValue(InstallationState value) {
  return internal::InstallationState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline InstallationState ToKnownEnumValue(InstallationState value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return InstallationState::kDefaultValue;
}


enum class ErrorCode : int32_t {
  
  kNone = 0,
  
  kOther = 1,
  
  kWrongId = 2,
  
  kNeedReboot = 3,
  
  kAllocation = 4,
  
  kUnsupportedPlatform = 5,
  
  kNotReached = 6,
  kMinValue = 0,
  kMaxValue = 6,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ErrorCode value);
inline bool IsKnownEnumValue(ErrorCode value) {
  return internal::ErrorCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ErrorCode ToKnownEnumValue(ErrorCode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ErrorCode::kDefaultValue;
}


enum class Colors : int32_t {
  
  kDefault = 0,
  
  kLight = 1,
  
  kDark = 2,
  
  kYellow = 3,
  
  kBlue = 4,
  
  kHighContrast = 5,
  
  kLowContrast = 6,
  
  kSepiaLight = 7,
  
  kSepiaDark = 8,
  kMinValue = 0,
  kMaxValue = 8,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, Colors value);
inline bool IsKnownEnumValue(Colors value) {
  return internal::Colors_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline Colors ToKnownEnumValue(Colors value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return Colors::kDefaultValue;
}


enum class LetterSpacing : int32_t {
  
  kTightDeprecated = 0,
  
  kStandard = 1,
  
  kWide = 2,
  
  kVeryWide = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 1
};

 std::ostream& operator<<(std::ostream& os, LetterSpacing value);
inline bool IsKnownEnumValue(LetterSpacing value) {
  return internal::LetterSpacing_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline LetterSpacing ToKnownEnumValue(LetterSpacing value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return LetterSpacing::kDefaultValue;
}


enum class LineSpacing : int32_t {
  
  kTightDeprecated = 0,
  
  kStandard = 1,
  
  kLoose = 2,
  
  kVeryLoose = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 2
};

 std::ostream& operator<<(std::ostream& os, LineSpacing value);
inline bool IsKnownEnumValue(LineSpacing value) {
  return internal::LineSpacing_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline LineSpacing ToKnownEnumValue(LineSpacing value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return LineSpacing::kDefaultValue;
}


enum class HighlightGranularity : int32_t {
  
  kOn = 0,
  
  kOff = 1,
  
  kWord = 2,
  
  kPhrase = 3,
  
  kSentence = 4,
  kMinValue = 0,
  kMaxValue = 4,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, HighlightGranularity value);
inline bool IsKnownEnumValue(HighlightGranularity value) {
  return internal::HighlightGranularity_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline HighlightGranularity ToKnownEnumValue(HighlightGranularity value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return HighlightGranularity::kDefaultValue;
}


enum class DistillationStatus : int32_t {
  
  kFailure = 0,
  
  kSuccess = 1,
  
  kStillRunning = 2,
  
  kRestarted = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, DistillationStatus value);
inline bool IsKnownEnumValue(DistillationStatus value) {
  return internal::DistillationStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class UntrustedPageHandlerFactoryInterfaceBase {};

using UntrustedPageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<UntrustedPageHandlerFactoryInterfaceBase>;
using UntrustedPageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<UntrustedPageHandlerFactoryInterfaceBase>;
using UntrustedPageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UntrustedPageHandlerFactoryInterfaceBase>;
using UntrustedPageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UntrustedPageHandlerFactoryInterfaceBase>;
class UntrustedPageHandlerInterfaceBase {};

using UntrustedPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<UntrustedPageHandlerInterfaceBase>;
using UntrustedPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<UntrustedPageHandlerInterfaceBase>;
using UntrustedPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UntrustedPageHandlerInterfaceBase>;
using UntrustedPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UntrustedPageHandlerInterfaceBase>;
class UntrustedPageInterfaceBase {};

using UntrustedPagePtrDataView =
    mojo::InterfacePtrDataView<UntrustedPageInterfaceBase>;
using UntrustedPageRequestDataView =
    mojo::InterfaceRequestDataView<UntrustedPageInterfaceBase>;
using UntrustedPageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<UntrustedPageInterfaceBase>;
using UntrustedPageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<UntrustedPageInterfaceBase>;


class VoicePackInfoDataView {
 public:
  VoicePackInfoDataView() = default;

  VoicePackInfoDataView(
      internal::VoicePackInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPackStateDataView(
      VoicePackInstallationStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPackState(UserType* output) {
    
    auto* pointer = !data_->pack_state.is_null() ? &data_->pack_state : nullptr;
    return mojo::internal::Deserialize<::read_anything::mojom::VoicePackInstallationStateDataView>(
        pointer, output, message_);
  }
  inline void GetLanguageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLanguage(UserType* output) {
    
    auto* pointer = data_->language.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::VoicePackInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class VoicePackInstallationStateDataView {
 public:
  using Tag = internal::VoicePackInstallationState_Data::VoicePackInstallationState_Tag;

  VoicePackInstallationStateDataView() = default;

  VoicePackInstallationStateDataView(
      internal::VoicePackInstallationState_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_installation_state() const { return data_->tag == Tag::kInstallationState; }
  template <typename UserType>
  [[nodiscard]] bool ReadInstallationState(UserType* output) const {
    CHECK(is_installation_state());
    return mojo::internal::Deserialize<::read_anything::mojom::InstallationState>(
        data_->data.f_installation_state, output);
  }
  InstallationState installation_state() const {
    CHECK(is_installation_state());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::read_anything::mojom::InstallationState>(data_->data.f_installation_state));
  }
  bool is_error_code() const { return data_->tag == Tag::kErrorCode; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorCode(UserType* output) const {
    CHECK(is_error_code());
    return mojo::internal::Deserialize<::read_anything::mojom::ErrorCode>(
        data_->data.f_error_code, output);
  }
  ErrorCode error_code() const {
    CHECK(is_error_code());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::read_anything::mojom::ErrorCode>(data_->data.f_error_code));
  }

 private:
  internal::VoicePackInstallationState_Data* data_ = nullptr;
};



}  // read_anything::mojom

#endif  // CHROME_COMMON_READ_ANYTHING_READ_ANYTHING_MOJOM_DATA_VIEW_H_