// chrome/common/privacy_budget/identifiability_study_configurator.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/privacy_budget/identifiability_study_configurator.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/privacy_budget/identifiability_study_configurator.mojom-params-data.h"
#include "chrome/common/privacy_budget/identifiability_study_configurator.mojom-shared-message-ids.h"

#include "chrome/common/privacy_budget/identifiability_study_configurator.mojom-import-headers.h"
#include "chrome/common/privacy_budget/identifiability_study_configurator.mojom-test-utils.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

IdentifiabilityStudyConfigurator::IPCStableHashFunction IdentifiabilityStudyConfigurator::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::IdentifiabilityStudyConfigurator>(message.name())) {
    case messages::IdentifiabilityStudyConfigurator::kConfigureIdentifiabilityStudy: {
      return &IdentifiabilityStudyConfigurator::ConfigureIdentifiabilityStudy_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* IdentifiabilityStudyConfigurator::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::IdentifiabilityStudyConfigurator>(message.name())) {
      case messages::IdentifiabilityStudyConfigurator::kConfigureIdentifiabilityStudy:
            return "Receive chrome::mojom::IdentifiabilityStudyConfigurator::ConfigureIdentifiabilityStudy";
    }
  } else {
    switch (static_cast<messages::IdentifiabilityStudyConfigurator>(message.name())) {
      case messages::IdentifiabilityStudyConfigurator::kConfigureIdentifiabilityStudy:
            return "Receive reply chrome::mojom::IdentifiabilityStudyConfigurator::ConfigureIdentifiabilityStudy";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t IdentifiabilityStudyConfigurator::ConfigureIdentifiabilityStudy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab1f596d;  // IPCStableHash for chrome::mojom::IdentifiabilityStudyConfigurator::ConfigureIdentifiabilityStudy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

IdentifiabilityStudyConfiguratorProxy::IdentifiabilityStudyConfiguratorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void IdentifiabilityStudyConfiguratorProxy::ConfigureIdentifiabilityStudy(
    bool in_meta_experiment_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::IdentifiabilityStudyConfigurator::ConfigureIdentifiabilityStudy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("meta_experiment_active"), in_meta_experiment_active,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::IdentifiabilityStudyConfigurator::kConfigureIdentifiabilityStudy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::IdentifiabilityStudyConfigurator_ConfigureIdentifiabilityStudy_Params_Data> params(
          message);
  params.Allocate();

  params->meta_experiment_active = in_meta_experiment_active;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(IdentifiabilityStudyConfigurator::Name_);
  message.set_method_name("ConfigureIdentifiabilityStudy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool IdentifiabilityStudyConfiguratorStubDispatch::Accept(
    IdentifiabilityStudyConfigurator* impl,
    mojo::Message* message) {
  switch (static_cast<messages::IdentifiabilityStudyConfigurator>(message->header()->name)) {
    case messages::IdentifiabilityStudyConfigurator::kConfigureIdentifiabilityStudy: {
      DCHECK(message->is_serialized());
      internal::IdentifiabilityStudyConfigurator_ConfigureIdentifiabilityStudy_Params_Data* params =
          reinterpret_cast<internal::IdentifiabilityStudyConfigurator_ConfigureIdentifiabilityStudy_Params_Data*>(
              message->mutable_payload());
      

      // Validation for IdentifiabilityStudyConfigurator.0
      bool success = true;
      bool p_meta_experiment_active{};
      IdentifiabilityStudyConfigurator_ConfigureIdentifiabilityStudy_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_meta_experiment_active = input_data_view.meta_experiment_active();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            IdentifiabilityStudyConfigurator::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConfigureIdentifiabilityStudy(        
        std::move(p_meta_experiment_active));
      return true;
    }
  }
  return false;
}

// static
bool IdentifiabilityStudyConfiguratorStubDispatch::AcceptWithResponder(
    IdentifiabilityStudyConfigurator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::IdentifiabilityStudyConfigurator>(message->header()->name)) {
    case messages::IdentifiabilityStudyConfigurator::kConfigureIdentifiabilityStudy: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kIdentifiabilityStudyConfiguratorValidationInfo[] = {
    { &internal::IdentifiabilityStudyConfigurator_ConfigureIdentifiabilityStudy_Params_Data::Validate,
     nullptr /* no response */},
};

bool IdentifiabilityStudyConfiguratorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::IdentifiabilityStudyConfigurator::Name_,
    kIdentifiabilityStudyConfiguratorValidationInfo);
}



}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void IdentifiabilityStudyConfiguratorInterceptorForTesting::ConfigureIdentifiabilityStudy(bool meta_experiment_active) {
  GetForwardingInterface()->ConfigureIdentifiabilityStudy(
    std::move(meta_experiment_active)
    );
}
IdentifiabilityStudyConfiguratorAsyncWaiter::IdentifiabilityStudyConfiguratorAsyncWaiter(
    IdentifiabilityStudyConfigurator* proxy) : proxy_(proxy) {}

IdentifiabilityStudyConfiguratorAsyncWaiter::~IdentifiabilityStudyConfiguratorAsyncWaiter() = default;







}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif