// chrome/common/plugin.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_PLUGIN_MOJOM_H_
#define CHROME_COMMON_PLUGIN_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/plugin.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/plugin.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/plugin.mojom-forward.h"  // IWYU pragma: export
#include "content/public/common/webplugininfo.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"




namespace chrome::mojom {

class PluginHostProxy;

template <typename ImplRefTraits>
class PluginHostStub;

class PluginHostRequestValidator;


class PluginHost
    : public PluginHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.PluginHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PluginHostInterfaceBase;
  using Proxy_ = PluginHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PluginHostStub<ImplRefTraits>;

  using RequestValidator_ = PluginHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCouldNotLoadPluginMinVersion = 0,
    kOpenPDFMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CouldNotLoadPlugin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenPDF_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PluginHost() = default;

  virtual void CouldNotLoadPlugin(const ::base::FilePath& file_path) = 0;

  virtual void OpenPDF(const ::GURL& url) = 0;
};

class PluginAuthHostProxy;

template <typename ImplRefTraits>
class PluginAuthHostStub;

class PluginAuthHostRequestValidator;


class PluginAuthHost
    : public PluginAuthHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.PluginAuthHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PluginAuthHostInterfaceBase;
  using Proxy_ = PluginAuthHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PluginAuthHostStub<ImplRefTraits>;

  using RequestValidator_ = PluginAuthHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBlockedUnauthorizedPluginMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct BlockedUnauthorizedPlugin_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PluginAuthHost() = default;

  virtual void BlockedUnauthorizedPlugin(const ::std::u16string& name, const std::string& group_id) = 0;
};

class PluginInfoHostProxy;

template <typename ImplRefTraits>
class PluginInfoHostStub;

class PluginInfoHostRequestValidator;
class PluginInfoHostResponseValidator;


class PluginInfoHost
    : public PluginInfoHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.PluginInfoHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static inline constexpr uint32_t kSyncMethodOrdinals[] = {
    0
  };
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PluginInfoHostInterfaceBase;
  using Proxy_ = PluginInfoHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PluginInfoHostStub<ImplRefTraits>;

  using RequestValidator_ = PluginInfoHostRequestValidator;
  using ResponseValidator_ = PluginInfoHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetPluginInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetPluginInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PluginInfoHost() = default;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetPluginInfo(const ::GURL& url, const ::url::Origin& origin, const std::string& mime_type, PluginInfoPtr* out_plugin_info);
  using GetPluginInfoCallback = base::OnceCallback<void(PluginInfoPtr)>;
  using GetPluginInfoMojoCallback = base::OnceCallback<void(PluginInfoPtr)>;

  virtual void GetPluginInfo(const ::GURL& url, const ::url::Origin& origin, const std::string& mime_type, GetPluginInfoCallback callback) = 0;
};



class  PluginHostProxy
    : public PluginHost {
 public:
  using InterfaceType = PluginHost;

  explicit PluginHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CouldNotLoadPlugin(const ::base::FilePath& file_path) final;
  
  void OpenPDF(const ::GURL& url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PluginAuthHostProxy
    : public PluginAuthHost {
 public:
  using InterfaceType = PluginAuthHost;

  explicit PluginAuthHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BlockedUnauthorizedPlugin(const ::std::u16string& name, const std::string& group_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PluginInfoHostProxy
    : public PluginInfoHost {
 public:
  using InterfaceType = PluginInfoHost;

  explicit PluginInfoHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GetPluginInfo(const ::GURL& url, const ::url::Origin& origin, const std::string& mime_type, PluginInfoPtr* out_plugin_info) final;
  
  void GetPluginInfo(const ::GURL& url, const ::url::Origin& origin, const std::string& mime_type, GetPluginInfoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PluginHostStubDispatch {
 public:
  static bool Accept(PluginHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PluginHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PluginHost>>
class PluginHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PluginHostStub() = default;
  ~PluginHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PluginHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PluginHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PluginAuthHostStubDispatch {
 public:
  static bool Accept(PluginAuthHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PluginAuthHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PluginAuthHost>>
class PluginAuthHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PluginAuthHostStub() = default;
  ~PluginAuthHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PluginAuthHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PluginAuthHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PluginInfoHostStubDispatch {
 public:
  static bool Accept(PluginInfoHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PluginInfoHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PluginInfoHost>>
class PluginInfoHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PluginInfoHostStub() = default;
  ~PluginInfoHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PluginInfoHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PluginInfoHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PluginHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PluginAuthHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PluginInfoHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PluginInfoHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  PluginInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PluginInfo, T>::value>;
  using DataView = PluginInfoDataView;
  using Data_ = internal::PluginInfo_Data;

  template <typename... Args>
  static PluginInfoPtr New(Args&&... args) {
    return PluginInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PluginInfoPtr From(const U& u) {
    return mojo::TypeConverter<PluginInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PluginInfo>::Convert(*this);
  }


  PluginInfo();

  PluginInfo(
      PluginStatus status,
      const ::content::WebPluginInfo& plugin,
      const std::string& actual_mime_type,
      const std::string& group_identifier,
      const ::std::u16string& group_name);


  ~PluginInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PluginInfoPtr>
  PluginInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PluginInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PluginInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PluginInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PluginInfo_UnserializedMessageContext<
            UserType, PluginInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PluginInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PluginInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PluginInfo_UnserializedMessageContext<
            UserType, PluginInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PluginInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  PluginStatus status;
  
  ::content::WebPluginInfo plugin;
  
  std::string actual_mime_type;
  
  std::string group_identifier;
  
  ::std::u16string group_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PluginInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  PluginParam {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PluginParam, T>::value>;
  using DataView = PluginParamDataView;
  using Data_ = internal::PluginParam_Data;

  template <typename... Args>
  static PluginParamPtr New(Args&&... args) {
    return PluginParamPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PluginParamPtr From(const U& u) {
    return mojo::TypeConverter<PluginParamPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PluginParam>::Convert(*this);
  }


  PluginParam();

  PluginParam(
      const ::std::u16string& name,
      const ::std::u16string& value);


  ~PluginParam();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PluginParamPtr>
  PluginParamPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PluginParam::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PluginParam::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PluginParam::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PluginParam::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PluginParam::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PluginParam::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PluginParam_UnserializedMessageContext<
            UserType, PluginParam::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PluginParam::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PluginParam::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PluginParam_UnserializedMessageContext<
            UserType, PluginParam::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PluginParam::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::std::u16string name;
  
  ::std::u16string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PluginParam::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PluginParam::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PluginParam::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PluginParam::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
PluginInfoPtr PluginInfo::Clone() const {
  return New(
      mojo::Clone(status),
      mojo::Clone(plugin),
      mojo::Clone(actual_mime_type),
      mojo::Clone(group_identifier),
      mojo::Clone(group_name)
  );
}

template <typename T, PluginInfo::EnableIfSame<T>*>
bool PluginInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->plugin, other_struct.plugin))
    return false;
  if (!mojo::Equals(this->actual_mime_type, other_struct.actual_mime_type))
    return false;
  if (!mojo::Equals(this->group_identifier, other_struct.group_identifier))
    return false;
  if (!mojo::Equals(this->group_name, other_struct.group_name))
    return false;
  return true;
}

template <typename T, PluginInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.status < rhs.status)
    return true;
  if (rhs.status < lhs.status)
    return false;
  if (lhs.plugin < rhs.plugin)
    return true;
  if (rhs.plugin < lhs.plugin)
    return false;
  if (lhs.actual_mime_type < rhs.actual_mime_type)
    return true;
  if (rhs.actual_mime_type < lhs.actual_mime_type)
    return false;
  if (lhs.group_identifier < rhs.group_identifier)
    return true;
  if (rhs.group_identifier < lhs.group_identifier)
    return false;
  if (lhs.group_name < rhs.group_name)
    return true;
  if (rhs.group_name < lhs.group_name)
    return false;
  return false;
}
template <typename StructPtrType>
PluginParamPtr PluginParam::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(value)
  );
}

template <typename T, PluginParam::EnableIfSame<T>*>
bool PluginParam::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, PluginParam::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}


}  // chrome::mojom

namespace mojo {


template <>
struct  StructTraits<::chrome::mojom::PluginInfo::DataView,
                                         ::chrome::mojom::PluginInfoPtr> {
  static bool IsNull(const ::chrome::mojom::PluginInfoPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::PluginInfoPtr* output) { output->reset(); }

  static decltype(::chrome::mojom::PluginInfo::status) status(
      const ::chrome::mojom::PluginInfoPtr& input) {
    return input->status;
  }

  static const decltype(::chrome::mojom::PluginInfo::plugin)& plugin(
      const ::chrome::mojom::PluginInfoPtr& input) {
    return input->plugin;
  }

  static const decltype(::chrome::mojom::PluginInfo::actual_mime_type)& actual_mime_type(
      const ::chrome::mojom::PluginInfoPtr& input) {
    return input->actual_mime_type;
  }

  static const decltype(::chrome::mojom::PluginInfo::group_identifier)& group_identifier(
      const ::chrome::mojom::PluginInfoPtr& input) {
    return input->group_identifier;
  }

  static const decltype(::chrome::mojom::PluginInfo::group_name)& group_name(
      const ::chrome::mojom::PluginInfoPtr& input) {
    return input->group_name;
  }

  static bool Read(::chrome::mojom::PluginInfo::DataView input, ::chrome::mojom::PluginInfoPtr* output);
};


template <>
struct  StructTraits<::chrome::mojom::PluginParam::DataView,
                                         ::chrome::mojom::PluginParamPtr> {
  static bool IsNull(const ::chrome::mojom::PluginParamPtr& input) { return !input; }
  static void SetToNull(::chrome::mojom::PluginParamPtr* output) { output->reset(); }

  static const decltype(::chrome::mojom::PluginParam::name)& name(
      const ::chrome::mojom::PluginParamPtr& input) {
    return input->name;
  }

  static const decltype(::chrome::mojom::PluginParam::value)& value(
      const ::chrome::mojom::PluginParamPtr& input) {
    return input->value;
  }

  static bool Read(::chrome::mojom::PluginParam::DataView input, ::chrome::mojom::PluginParamPtr* output);
};

}  // namespace mojo

#endif  // CHROME_COMMON_PLUGIN_MOJOM_H_