// chrome/common/open_search_description_document_handler.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/open_search_description_document_handler.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/open_search_description_document_handler.mojom-params-data.h"
#include "chrome/common/open_search_description_document_handler.mojom-shared-message-ids.h"

#include "chrome/common/open_search_description_document_handler.mojom-import-headers.h"
#include "chrome/common/open_search_description_document_handler.mojom-test-utils.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

OpenSearchDescriptionDocumentHandler::IPCStableHashFunction OpenSearchDescriptionDocumentHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::OpenSearchDescriptionDocumentHandler>(message.name())) {
    case messages::OpenSearchDescriptionDocumentHandler::kPageHasOpenSearchDescriptionDocument: {
      return &OpenSearchDescriptionDocumentHandler::PageHasOpenSearchDescriptionDocument_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* OpenSearchDescriptionDocumentHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::OpenSearchDescriptionDocumentHandler>(message.name())) {
      case messages::OpenSearchDescriptionDocumentHandler::kPageHasOpenSearchDescriptionDocument:
            return "Receive chrome::mojom::OpenSearchDescriptionDocumentHandler::PageHasOpenSearchDescriptionDocument";
    }
  } else {
    switch (static_cast<messages::OpenSearchDescriptionDocumentHandler>(message.name())) {
      case messages::OpenSearchDescriptionDocumentHandler::kPageHasOpenSearchDescriptionDocument:
            return "Receive reply chrome::mojom::OpenSearchDescriptionDocumentHandler::PageHasOpenSearchDescriptionDocument";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t OpenSearchDescriptionDocumentHandler::PageHasOpenSearchDescriptionDocument_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4a3caebf;  // IPCStableHash for chrome::mojom::OpenSearchDescriptionDocumentHandler::PageHasOpenSearchDescriptionDocument
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

OpenSearchDescriptionDocumentHandlerProxy::OpenSearchDescriptionDocumentHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void OpenSearchDescriptionDocumentHandlerProxy::PageHasOpenSearchDescriptionDocument(
    const ::GURL& in_page_url, const ::GURL& in_osdd_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send chrome::mojom::OpenSearchDescriptionDocumentHandler::PageHasOpenSearchDescriptionDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_url"), in_page_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("osdd_url"), in_osdd_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::OpenSearchDescriptionDocumentHandler::kPageHasOpenSearchDescriptionDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::OpenSearchDescriptionDocumentHandler_PageHasOpenSearchDescriptionDocument_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_url)::BaseType> page_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_page_url,
    page_url_fragment);

  params->page_url.Set(
      page_url_fragment.is_null() ? nullptr : page_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_url in OpenSearchDescriptionDocumentHandler.PageHasOpenSearchDescriptionDocument request");
  mojo::internal::MessageFragment<
      typename decltype(params->osdd_url)::BaseType> osdd_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_osdd_url,
    osdd_url_fragment);

  params->osdd_url.Set(
      osdd_url_fragment.is_null() ? nullptr : osdd_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->osdd_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null osdd_url in OpenSearchDescriptionDocumentHandler.PageHasOpenSearchDescriptionDocument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(OpenSearchDescriptionDocumentHandler::Name_);
  message.set_method_name("PageHasOpenSearchDescriptionDocument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool OpenSearchDescriptionDocumentHandlerStubDispatch::Accept(
    OpenSearchDescriptionDocumentHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::OpenSearchDescriptionDocumentHandler>(message->header()->name)) {
    case messages::OpenSearchDescriptionDocumentHandler::kPageHasOpenSearchDescriptionDocument: {
      DCHECK(message->is_serialized());
      internal::OpenSearchDescriptionDocumentHandler_PageHasOpenSearchDescriptionDocument_Params_Data* params =
          reinterpret_cast<internal::OpenSearchDescriptionDocumentHandler_PageHasOpenSearchDescriptionDocument_Params_Data*>(
              message->mutable_payload());
      

      // Validation for OpenSearchDescriptionDocumentHandler.0
      bool success = true;
      ::GURL p_page_url{};
      ::GURL p_osdd_url{};
      OpenSearchDescriptionDocumentHandler_PageHasOpenSearchDescriptionDocument_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPageUrl(&p_page_url))
        success = false;
      if (success && !input_data_view.ReadOsddUrl(&p_osdd_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            OpenSearchDescriptionDocumentHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PageHasOpenSearchDescriptionDocument(        
        std::move(p_page_url), 
        std::move(p_osdd_url));
      return true;
    }
  }
  return false;
}

// static
bool OpenSearchDescriptionDocumentHandlerStubDispatch::AcceptWithResponder(
    OpenSearchDescriptionDocumentHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::OpenSearchDescriptionDocumentHandler>(message->header()->name)) {
    case messages::OpenSearchDescriptionDocumentHandler::kPageHasOpenSearchDescriptionDocument: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kOpenSearchDescriptionDocumentHandlerValidationInfo[] = {
    { &internal::OpenSearchDescriptionDocumentHandler_PageHasOpenSearchDescriptionDocument_Params_Data::Validate,
     nullptr /* no response */},
};

bool OpenSearchDescriptionDocumentHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::OpenSearchDescriptionDocumentHandler::Name_,
    kOpenSearchDescriptionDocumentHandlerValidationInfo);
}



}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void OpenSearchDescriptionDocumentHandlerInterceptorForTesting::PageHasOpenSearchDescriptionDocument(const ::GURL& page_url, const ::GURL& osdd_url) {
  GetForwardingInterface()->PageHasOpenSearchDescriptionDocument(
    std::move(page_url)
    , 
    std::move(osdd_url)
    );
}
OpenSearchDescriptionDocumentHandlerAsyncWaiter::OpenSearchDescriptionDocumentHandlerAsyncWaiter(
    OpenSearchDescriptionDocumentHandler* proxy) : proxy_(proxy) {}

OpenSearchDescriptionDocumentHandlerAsyncWaiter::~OpenSearchDescriptionDocumentHandlerAsyncWaiter() = default;







}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif