// chrome/common/net_benchmarking.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/net_benchmarking.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/net_benchmarking.mojom-params-data.h"
#include "chrome/common/net_benchmarking.mojom-shared-message-ids.h"

#include "chrome/common/net_benchmarking.mojom-import-headers.h"
#include "chrome/common/net_benchmarking.mojom-test-utils.h"


namespace chrome::mojom {
// The declaration includes the definition on other builds.

NetBenchmarking::IPCStableHashFunction NetBenchmarking::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NetBenchmarking>(message.name())) {
    case messages::NetBenchmarking::kCloseCurrentConnections: {
      return &NetBenchmarking::CloseCurrentConnections_Sym::IPCStableHash;
    }
    case messages::NetBenchmarking::kClearCache: {
      return &NetBenchmarking::ClearCache_Sym::IPCStableHash;
    }
    case messages::NetBenchmarking::kClearHostResolverCache: {
      return &NetBenchmarking::ClearHostResolverCache_Sym::IPCStableHash;
    }
    case messages::NetBenchmarking::kClearPredictorCache: {
      return &NetBenchmarking::ClearPredictorCache_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NetBenchmarking::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NetBenchmarking>(message.name())) {
      case messages::NetBenchmarking::kCloseCurrentConnections:
            return "Receive chrome::mojom::NetBenchmarking::CloseCurrentConnections";
      case messages::NetBenchmarking::kClearCache:
            return "Receive chrome::mojom::NetBenchmarking::ClearCache";
      case messages::NetBenchmarking::kClearHostResolverCache:
            return "Receive chrome::mojom::NetBenchmarking::ClearHostResolverCache";
      case messages::NetBenchmarking::kClearPredictorCache:
            return "Receive chrome::mojom::NetBenchmarking::ClearPredictorCache";
    }
  } else {
    switch (static_cast<messages::NetBenchmarking>(message.name())) {
      case messages::NetBenchmarking::kCloseCurrentConnections:
            return "Receive reply chrome::mojom::NetBenchmarking::CloseCurrentConnections";
      case messages::NetBenchmarking::kClearCache:
            return "Receive reply chrome::mojom::NetBenchmarking::ClearCache";
      case messages::NetBenchmarking::kClearHostResolverCache:
            return "Receive reply chrome::mojom::NetBenchmarking::ClearHostResolverCache";
      case messages::NetBenchmarking::kClearPredictorCache:
            return "Receive reply chrome::mojom::NetBenchmarking::ClearPredictorCache";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NetBenchmarking::CloseCurrentConnections_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe8cf278f;  // IPCStableHash for chrome::mojom::NetBenchmarking::CloseCurrentConnections
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetBenchmarking::ClearCache_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x779f93e3;  // IPCStableHash for chrome::mojom::NetBenchmarking::ClearCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetBenchmarking::ClearHostResolverCache_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e5ca21d;  // IPCStableHash for chrome::mojom::NetBenchmarking::ClearHostResolverCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NetBenchmarking::ClearPredictorCache_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7926b94b;  // IPCStableHash for chrome::mojom::NetBenchmarking::ClearPredictorCache
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool NetBenchmarking::CloseCurrentConnections() {
  NOTREACHED();
}
bool NetBenchmarking::ClearCache() {
  NOTREACHED();
}
bool NetBenchmarking::ClearHostResolverCache() {
  NOTREACHED();
}
bool NetBenchmarking::ClearPredictorCache() {
  NOTREACHED();
}
class NetBenchmarking_CloseCurrentConnections_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetBenchmarking_CloseCurrentConnections_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetBenchmarking_CloseCurrentConnections_HandleSyncResponse(const NetBenchmarking_CloseCurrentConnections_HandleSyncResponse&) = delete;
  NetBenchmarking_CloseCurrentConnections_HandleSyncResponse& operator=(const NetBenchmarking_CloseCurrentConnections_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetBenchmarking_CloseCurrentConnections_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetBenchmarking_CloseCurrentConnections_ForwardToCallback(
      NetBenchmarking::CloseCurrentConnectionsCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetBenchmarking_CloseCurrentConnections_ForwardToCallback(const NetBenchmarking_CloseCurrentConnections_ForwardToCallback&) = delete;
  NetBenchmarking_CloseCurrentConnections_ForwardToCallback& operator=(const NetBenchmarking_CloseCurrentConnections_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetBenchmarking::CloseCurrentConnectionsCallback callback_;
};
class NetBenchmarking_ClearCache_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetBenchmarking_ClearCache_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetBenchmarking_ClearCache_HandleSyncResponse(const NetBenchmarking_ClearCache_HandleSyncResponse&) = delete;
  NetBenchmarking_ClearCache_HandleSyncResponse& operator=(const NetBenchmarking_ClearCache_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetBenchmarking_ClearCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetBenchmarking_ClearCache_ForwardToCallback(
      NetBenchmarking::ClearCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetBenchmarking_ClearCache_ForwardToCallback(const NetBenchmarking_ClearCache_ForwardToCallback&) = delete;
  NetBenchmarking_ClearCache_ForwardToCallback& operator=(const NetBenchmarking_ClearCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetBenchmarking::ClearCacheCallback callback_;
};
class NetBenchmarking_ClearHostResolverCache_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetBenchmarking_ClearHostResolverCache_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetBenchmarking_ClearHostResolverCache_HandleSyncResponse(const NetBenchmarking_ClearHostResolverCache_HandleSyncResponse&) = delete;
  NetBenchmarking_ClearHostResolverCache_HandleSyncResponse& operator=(const NetBenchmarking_ClearHostResolverCache_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetBenchmarking_ClearHostResolverCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetBenchmarking_ClearHostResolverCache_ForwardToCallback(
      NetBenchmarking::ClearHostResolverCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetBenchmarking_ClearHostResolverCache_ForwardToCallback(const NetBenchmarking_ClearHostResolverCache_ForwardToCallback&) = delete;
  NetBenchmarking_ClearHostResolverCache_ForwardToCallback& operator=(const NetBenchmarking_ClearHostResolverCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetBenchmarking::ClearHostResolverCacheCallback callback_;
};
class NetBenchmarking_ClearPredictorCache_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetBenchmarking_ClearPredictorCache_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }

  NetBenchmarking_ClearPredictorCache_HandleSyncResponse(const NetBenchmarking_ClearPredictorCache_HandleSyncResponse&) = delete;
  NetBenchmarking_ClearPredictorCache_HandleSyncResponse& operator=(const NetBenchmarking_ClearPredictorCache_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;};

class NetBenchmarking_ClearPredictorCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetBenchmarking_ClearPredictorCache_ForwardToCallback(
      NetBenchmarking::ClearPredictorCacheCallback callback
      ) : callback_(std::move(callback)) {
  }

  NetBenchmarking_ClearPredictorCache_ForwardToCallback(const NetBenchmarking_ClearPredictorCache_ForwardToCallback&) = delete;
  NetBenchmarking_ClearPredictorCache_ForwardToCallback& operator=(const NetBenchmarking_ClearPredictorCache_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  NetBenchmarking::ClearPredictorCacheCallback callback_;
};

NetBenchmarkingProxy::NetBenchmarkingProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool NetBenchmarkingProxy::CloseCurrentConnections(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call chrome::mojom::NetBenchmarking::CloseCurrentConnections (sync)");
#else
  TRACE_EVENT0("mojom", "NetBenchmarking::CloseCurrentConnections");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kCloseCurrentConnections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_CloseCurrentConnections_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("CloseCurrentConnections");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetBenchmarking_CloseCurrentConnections_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetBenchmarking::CloseCurrentConnections");
#endif
  return result;
}

void NetBenchmarkingProxy::CloseCurrentConnections(
    CloseCurrentConnectionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::NetBenchmarking::CloseCurrentConnections");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kCloseCurrentConnections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_CloseCurrentConnections_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("CloseCurrentConnections");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetBenchmarking_CloseCurrentConnections_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetBenchmarkingProxy::ClearCache(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call chrome::mojom::NetBenchmarking::ClearCache (sync)");
#else
  TRACE_EVENT0("mojom", "NetBenchmarking::ClearCache");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kClearCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_ClearCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("ClearCache");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetBenchmarking_ClearCache_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetBenchmarking::ClearCache");
#endif
  return result;
}

void NetBenchmarkingProxy::ClearCache(
    ClearCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::NetBenchmarking::ClearCache");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kClearCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_ClearCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("ClearCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetBenchmarking_ClearCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetBenchmarkingProxy::ClearHostResolverCache(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call chrome::mojom::NetBenchmarking::ClearHostResolverCache (sync)");
#else
  TRACE_EVENT0("mojom", "NetBenchmarking::ClearHostResolverCache");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kClearHostResolverCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_ClearHostResolverCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("ClearHostResolverCache");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetBenchmarking_ClearHostResolverCache_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetBenchmarking::ClearHostResolverCache");
#endif
  return result;
}

void NetBenchmarkingProxy::ClearHostResolverCache(
    ClearHostResolverCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::NetBenchmarking::ClearHostResolverCache");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kClearHostResolverCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_ClearHostResolverCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("ClearHostResolverCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetBenchmarking_ClearHostResolverCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
bool NetBenchmarkingProxy::ClearPredictorCache(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "Call chrome::mojom::NetBenchmarking::ClearPredictorCache (sync)");
#else
  TRACE_EVENT0("mojom", "NetBenchmarking::ClearPredictorCache");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kClearPredictorCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_ClearPredictorCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("ClearPredictorCache");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetBenchmarking_ClearPredictorCache_HandleSyncResponse(
          &result));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "NetBenchmarking::ClearPredictorCache");
#endif
  return result;
}

void NetBenchmarkingProxy::ClearPredictorCache(
    ClearPredictorCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send chrome::mojom::NetBenchmarking::ClearPredictorCache");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kClearPredictorCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_ClearPredictorCache_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("ClearPredictorCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetBenchmarking_ClearPredictorCache_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class NetBenchmarking_CloseCurrentConnections_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetBenchmarking::CloseCurrentConnectionsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetBenchmarking_CloseCurrentConnections_ProxyToResponder> proxy(
        new NetBenchmarking_CloseCurrentConnections_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetBenchmarking_CloseCurrentConnections_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetBenchmarking_CloseCurrentConnections_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetBenchmarking_CloseCurrentConnections_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetBenchmarking::CloseCurrentConnectionsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetBenchmarking_CloseCurrentConnections_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetBenchmarking_CloseCurrentConnections_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetBenchmarking_CloseCurrentConnections_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetBenchmarking.0
  bool success = true;
  NetBenchmarking_CloseCurrentConnections_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetBenchmarking::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetBenchmarking_CloseCurrentConnections_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply chrome::mojom::NetBenchmarking::CloseCurrentConnections");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kCloseCurrentConnections), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_CloseCurrentConnections_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("CloseCurrentConnections");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetBenchmarking_CloseCurrentConnections_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetBenchmarking_CloseCurrentConnections_ResponseParams_Data* params =
      reinterpret_cast<internal::NetBenchmarking_CloseCurrentConnections_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetBenchmarking.0
  bool success = true;
  NetBenchmarking_CloseCurrentConnections_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetBenchmarking::Name_, 0, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetBenchmarking_ClearCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetBenchmarking::ClearCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetBenchmarking_ClearCache_ProxyToResponder> proxy(
        new NetBenchmarking_ClearCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetBenchmarking_ClearCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetBenchmarking_ClearCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetBenchmarking_ClearCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetBenchmarking::ClearCacheCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetBenchmarking_ClearCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetBenchmarking_ClearCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetBenchmarking_ClearCache_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetBenchmarking.1
  bool success = true;
  NetBenchmarking_ClearCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetBenchmarking::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetBenchmarking_ClearCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply chrome::mojom::NetBenchmarking::ClearCache");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kClearCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_ClearCache_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("ClearCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetBenchmarking_ClearCache_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetBenchmarking_ClearCache_ResponseParams_Data* params =
      reinterpret_cast<internal::NetBenchmarking_ClearCache_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetBenchmarking.1
  bool success = true;
  NetBenchmarking_ClearCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetBenchmarking::Name_, 1, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetBenchmarking_ClearHostResolverCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetBenchmarking::ClearHostResolverCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetBenchmarking_ClearHostResolverCache_ProxyToResponder> proxy(
        new NetBenchmarking_ClearHostResolverCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetBenchmarking_ClearHostResolverCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetBenchmarking_ClearHostResolverCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetBenchmarking_ClearHostResolverCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetBenchmarking::ClearHostResolverCacheCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetBenchmarking_ClearHostResolverCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetBenchmarking_ClearHostResolverCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetBenchmarking_ClearHostResolverCache_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetBenchmarking.2
  bool success = true;
  NetBenchmarking_ClearHostResolverCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetBenchmarking::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetBenchmarking_ClearHostResolverCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply chrome::mojom::NetBenchmarking::ClearHostResolverCache");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kClearHostResolverCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_ClearHostResolverCache_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("ClearHostResolverCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetBenchmarking_ClearHostResolverCache_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetBenchmarking_ClearHostResolverCache_ResponseParams_Data* params =
      reinterpret_cast<internal::NetBenchmarking_ClearHostResolverCache_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetBenchmarking.2
  bool success = true;
  NetBenchmarking_ClearHostResolverCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetBenchmarking::Name_, 2, true);
    return false;
  }
  *result_ = true;
  return true;
}
class NetBenchmarking_ClearPredictorCache_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static NetBenchmarking::ClearPredictorCacheCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<NetBenchmarking_ClearPredictorCache_ProxyToResponder> proxy(
        new NetBenchmarking_ClearPredictorCache_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&NetBenchmarking_ClearPredictorCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetBenchmarking_ClearPredictorCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  NetBenchmarking_ClearPredictorCache_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "NetBenchmarking::ClearPredictorCacheCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool NetBenchmarking_ClearPredictorCache_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetBenchmarking_ClearPredictorCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetBenchmarking_ClearPredictorCache_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for NetBenchmarking.3
  bool success = true;
  NetBenchmarking_ClearPredictorCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetBenchmarking::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void NetBenchmarking_ClearPredictorCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply chrome::mojom::NetBenchmarking::ClearPredictorCache");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NetBenchmarking::kClearPredictorCache), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::chrome::mojom::internal::NetBenchmarking_ClearPredictorCache_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetBenchmarking::Name_);
  message.set_method_name("ClearPredictorCache");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetBenchmarking_ClearPredictorCache_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::NetBenchmarking_ClearPredictorCache_ResponseParams_Data* params =
      reinterpret_cast<internal::NetBenchmarking_ClearPredictorCache_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for NetBenchmarking.3
  bool success = true;
  NetBenchmarking_ClearPredictorCache_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetBenchmarking::Name_, 3, true);
    return false;
  }
  *result_ = true;
  return true;
}

// static
bool NetBenchmarkingStubDispatch::Accept(
    NetBenchmarking* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NetBenchmarking>(message->header()->name)) {
    case messages::NetBenchmarking::kCloseCurrentConnections: {
      break;
    }
    case messages::NetBenchmarking::kClearCache: {
      break;
    }
    case messages::NetBenchmarking::kClearHostResolverCache: {
      break;
    }
    case messages::NetBenchmarking::kClearPredictorCache: {
      break;
    }
  }
  return false;
}

// static
bool NetBenchmarkingStubDispatch::AcceptWithResponder(
    NetBenchmarking* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NetBenchmarking>(message->header()->name)) {
    case messages::NetBenchmarking::kCloseCurrentConnections: {
      internal::NetBenchmarking_CloseCurrentConnections_Params_Data* params =
          reinterpret_cast<
              internal::NetBenchmarking_CloseCurrentConnections_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetBenchmarking.0
      bool success = true;
      NetBenchmarking_CloseCurrentConnections_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetBenchmarking::Name_, 0, false);
        return false;
      }
      auto callback =
          NetBenchmarking_CloseCurrentConnections_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseCurrentConnections(std::move(callback));
      return true;
    }
    case messages::NetBenchmarking::kClearCache: {
      internal::NetBenchmarking_ClearCache_Params_Data* params =
          reinterpret_cast<
              internal::NetBenchmarking_ClearCache_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetBenchmarking.1
      bool success = true;
      NetBenchmarking_ClearCache_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetBenchmarking::Name_, 1, false);
        return false;
      }
      auto callback =
          NetBenchmarking_ClearCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearCache(std::move(callback));
      return true;
    }
    case messages::NetBenchmarking::kClearHostResolverCache: {
      internal::NetBenchmarking_ClearHostResolverCache_Params_Data* params =
          reinterpret_cast<
              internal::NetBenchmarking_ClearHostResolverCache_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetBenchmarking.2
      bool success = true;
      NetBenchmarking_ClearHostResolverCache_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetBenchmarking::Name_, 2, false);
        return false;
      }
      auto callback =
          NetBenchmarking_ClearHostResolverCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearHostResolverCache(std::move(callback));
      return true;
    }
    case messages::NetBenchmarking::kClearPredictorCache: {
      internal::NetBenchmarking_ClearPredictorCache_Params_Data* params =
          reinterpret_cast<
              internal::NetBenchmarking_ClearPredictorCache_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for NetBenchmarking.3
      bool success = true;
      NetBenchmarking_ClearPredictorCache_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetBenchmarking::Name_, 3, false);
        return false;
      }
      auto callback =
          NetBenchmarking_ClearPredictorCache_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearPredictorCache(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNetBenchmarkingValidationInfo[] = {
    { &internal::NetBenchmarking_CloseCurrentConnections_Params_Data::Validate,
     &internal::NetBenchmarking_CloseCurrentConnections_ResponseParams_Data::Validate},
    { &internal::NetBenchmarking_ClearCache_Params_Data::Validate,
     &internal::NetBenchmarking_ClearCache_ResponseParams_Data::Validate},
    { &internal::NetBenchmarking_ClearHostResolverCache_Params_Data::Validate,
     &internal::NetBenchmarking_ClearHostResolverCache_ResponseParams_Data::Validate},
    { &internal::NetBenchmarking_ClearPredictorCache_Params_Data::Validate,
     &internal::NetBenchmarking_ClearPredictorCache_ResponseParams_Data::Validate},
};

bool NetBenchmarkingRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::chrome::mojom::NetBenchmarking::Name_,
    kNetBenchmarkingValidationInfo);
}

bool NetBenchmarkingResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::chrome::mojom::NetBenchmarking::Name_,
    kNetBenchmarkingValidationInfo);
}


}  // chrome::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace chrome::mojom {


void NetBenchmarkingInterceptorForTesting::CloseCurrentConnections(CloseCurrentConnectionsCallback callback) {
  GetForwardingInterface()->CloseCurrentConnections(std::move(callback));
}
void NetBenchmarkingInterceptorForTesting::ClearCache(ClearCacheCallback callback) {
  GetForwardingInterface()->ClearCache(std::move(callback));
}
void NetBenchmarkingInterceptorForTesting::ClearHostResolverCache(ClearHostResolverCacheCallback callback) {
  GetForwardingInterface()->ClearHostResolverCache(std::move(callback));
}
void NetBenchmarkingInterceptorForTesting::ClearPredictorCache(ClearPredictorCacheCallback callback) {
  GetForwardingInterface()->ClearPredictorCache(std::move(callback));
}
NetBenchmarkingAsyncWaiter::NetBenchmarkingAsyncWaiter(
    NetBenchmarking* proxy) : proxy_(proxy) {}

NetBenchmarkingAsyncWaiter::~NetBenchmarkingAsyncWaiter() = default;


void NetBenchmarkingAsyncWaiter::CloseCurrentConnections(
    ) {
  base::RunLoop loop;
  proxy_->CloseCurrentConnections(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetBenchmarkingAsyncWaiter::ClearCache(
    ) {
  base::RunLoop loop;
  proxy_->ClearCache(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetBenchmarkingAsyncWaiter::ClearHostResolverCache(
    ) {
  base::RunLoop loop;
  proxy_->ClearHostResolverCache(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void NetBenchmarkingAsyncWaiter::ClearPredictorCache(
    ) {
  base::RunLoop loop;
  proxy_->ClearPredictorCache(
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // chrome::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif