// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// GENERATED FROM THE API DEFINITION IN
//   chrome/common/extensions/api/debugger.json
// by tools/json_schema_compiler.
// DO NOT EDIT.

#include "chrome/common/extensions/api/debugger.h"

#include <memory>
#include <optional>
#include <ostream>
#include <string>
#include <string_view>
#include <utility>
#include <vector>

#include "base/check.h"
#include "base/check_op.h"
#include "base/notreached.h"
#include "base/strings/string_number_conversions.h"
#include "base/strings/utf_string_conversions.h"
#include "base/values.h"
#include "tools/json_schema_compiler/util.h"
#include <string_view>


using base::UTF8ToUTF16;

namespace extensions {
namespace api {
namespace debugger {
//
// Types
//

Debuggee::Debuggee()
 {}

Debuggee::~Debuggee() = default;
Debuggee::Debuggee(Debuggee&& rhs) noexcept = default;
Debuggee& Debuggee::operator=(Debuggee&& rhs) noexcept = default;
Debuggee Debuggee::Clone() const {
  Debuggee out;
  out.tab_id = tab_id;
  out.extension_id = extension_id;
  out.target_id = target_id;
  return out;
}

// static
bool Debuggee::Populate(
    const base::Value::Dict& dict, Debuggee& out) {
  const base::Value* tab_id_value = dict.Find("tabId");
  if (tab_id_value) {
    {
      auto temp = (*tab_id_value).GetIfInt();
      if (!temp.has_value()) {
        out.tab_id = std::nullopt;
        return false;
      }
      out.tab_id = *temp;
    }
  }

  const base::Value* extension_id_value = dict.Find("extensionId");
  if (extension_id_value) {
    {
      auto* temp = (*extension_id_value).GetIfString();
      if (!temp) {
        out.extension_id = std::nullopt;
        return false;
      }
      out.extension_id = *temp;
    }
  }

  const base::Value* target_id_value = dict.Find("targetId");
  if (target_id_value) {
    {
      auto* temp = (*target_id_value).GetIfString();
      if (!temp) {
        out.target_id = std::nullopt;
        return false;
      }
      out.target_id = *temp;
    }
  }

  return true;
}

// static
bool Debuggee::Populate(
    const base::Value& value, Debuggee& out) {
  if (!value.is_dict()) {
    return false;
  }
  return Populate(value.GetDict(), out);
}

// static
std::optional<Debuggee> Debuggee::FromValue(const base::Value::Dict& value) {
  Debuggee out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}

// static
std::optional<Debuggee> Debuggee::FromValue(const base::Value& value) {
  Debuggee out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}

base::Value::Dict Debuggee::ToValue() const {
  base::Value::Dict to_value_result;

  if (this->tab_id) {
    to_value_result.Set("tabId", *this->tab_id);

  }
  if (this->extension_id) {
    to_value_result.Set("extensionId", *this->extension_id);

  }
  if (this->target_id) {
    to_value_result.Set("targetId", *this->target_id);

  }

  return to_value_result;
}


DebuggerSession::DebuggerSession()
 {}

DebuggerSession::~DebuggerSession() = default;
DebuggerSession::DebuggerSession(DebuggerSession&& rhs) noexcept = default;
DebuggerSession& DebuggerSession::operator=(DebuggerSession&& rhs) noexcept = default;
DebuggerSession DebuggerSession::Clone() const {
  DebuggerSession out;
  out.tab_id = tab_id;
  out.extension_id = extension_id;
  out.target_id = target_id;
  out.session_id = session_id;
  return out;
}

// static
bool DebuggerSession::Populate(
    const base::Value::Dict& dict, DebuggerSession& out) {
  const base::Value* tab_id_value = dict.Find("tabId");
  if (tab_id_value) {
    {
      auto temp = (*tab_id_value).GetIfInt();
      if (!temp.has_value()) {
        out.tab_id = std::nullopt;
        return false;
      }
      out.tab_id = *temp;
    }
  }

  const base::Value* extension_id_value = dict.Find("extensionId");
  if (extension_id_value) {
    {
      auto* temp = (*extension_id_value).GetIfString();
      if (!temp) {
        out.extension_id = std::nullopt;
        return false;
      }
      out.extension_id = *temp;
    }
  }

  const base::Value* target_id_value = dict.Find("targetId");
  if (target_id_value) {
    {
      auto* temp = (*target_id_value).GetIfString();
      if (!temp) {
        out.target_id = std::nullopt;
        return false;
      }
      out.target_id = *temp;
    }
  }

  const base::Value* session_id_value = dict.Find("sessionId");
  if (session_id_value) {
    {
      auto* temp = (*session_id_value).GetIfString();
      if (!temp) {
        out.session_id = std::nullopt;
        return false;
      }
      out.session_id = *temp;
    }
  }

  return true;
}

// static
bool DebuggerSession::Populate(
    const base::Value& value, DebuggerSession& out) {
  if (!value.is_dict()) {
    return false;
  }
  return Populate(value.GetDict(), out);
}

// static
std::optional<DebuggerSession> DebuggerSession::FromValue(const base::Value::Dict& value) {
  DebuggerSession out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}

// static
std::optional<DebuggerSession> DebuggerSession::FromValue(const base::Value& value) {
  DebuggerSession out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}

base::Value::Dict DebuggerSession::ToValue() const {
  base::Value::Dict to_value_result;

  if (this->tab_id) {
    to_value_result.Set("tabId", *this->tab_id);

  }
  if (this->extension_id) {
    to_value_result.Set("extensionId", *this->extension_id);

  }
  if (this->target_id) {
    to_value_result.Set("targetId", *this->target_id);

  }
  if (this->session_id) {
    to_value_result.Set("sessionId", *this->session_id);

  }

  return to_value_result;
}


const char* ToString(TargetInfoType enum_param) {
  switch (enum_param) {
    case TargetInfoType::kPage:
      return "page";
    case TargetInfoType::kBackgroundPage:
      return "background_page";
    case TargetInfoType::kWorker:
      return "worker";
    case TargetInfoType::kOther:
      return "other";
    case TargetInfoType::kNone:
      return "";
  }
  NOTREACHED();
}

TargetInfoType ParseTargetInfoType(std::string_view enum_string) {
  if (enum_string == "page")
    return TargetInfoType::kPage;
  if (enum_string == "background_page")
    return TargetInfoType::kBackgroundPage;
  if (enum_string == "worker")
    return TargetInfoType::kWorker;
  if (enum_string == "other")
    return TargetInfoType::kOther;
  return TargetInfoType::kNone;
}

std::u16string GetTargetInfoTypeParseError(std::string_view enum_string) {
  return u"expected \"page\" or \"background_page\" or \"worker\" or \"other\", got \"" + UTF8ToUTF16(enum_string) + u"\"";
}


const char* ToString(DetachReason enum_param) {
  switch (enum_param) {
    case DetachReason::kTargetClosed:
      return "target_closed";
    case DetachReason::kCanceledByUser:
      return "canceled_by_user";
    case DetachReason::kNone:
      return "";
  }
  NOTREACHED();
}

DetachReason ParseDetachReason(std::string_view enum_string) {
  if (enum_string == "target_closed")
    return DetachReason::kTargetClosed;
  if (enum_string == "canceled_by_user")
    return DetachReason::kCanceledByUser;
  return DetachReason::kNone;
}

std::u16string GetDetachReasonParseError(std::string_view enum_string) {
  return u"expected \"target_closed\" or \"canceled_by_user\", got \"" + UTF8ToUTF16(enum_string) + u"\"";
}


TargetInfo::TargetInfo()
: type(),
attached(false) {}

TargetInfo::~TargetInfo() = default;
TargetInfo::TargetInfo(TargetInfo&& rhs) noexcept = default;
TargetInfo& TargetInfo::operator=(TargetInfo&& rhs) noexcept = default;
TargetInfo TargetInfo::Clone() const {
  TargetInfo out;
  out.type = type;
  out.id = id;
  out.tab_id = tab_id;
  out.extension_id = extension_id;
  out.attached = attached;
  out.title = title;
  out.url = url;
  out.favicon_url = favicon_url;
  return out;
}

// static
bool TargetInfo::Populate(
    const base::Value::Dict& dict, TargetInfo& out) {
  const base::Value* type_value = dict.Find("type");
  if (!type_value) {
    return false;
  }
  {
    const std::string* target_info_type_as_string = (*type_value).GetIfString();
    if (!target_info_type_as_string) {
      return false;
    }
    out.type = ParseTargetInfoType(*target_info_type_as_string);
    if (out.type == TargetInfoType()) {
      return false;
    }
  }

  const base::Value* id_value = dict.Find("id");
  if (!id_value) {
    return false;
  }
  {
    auto* temp = (*id_value).GetIfString();
    if (!temp) {
      return false;
    }
    out.id = *temp;
  }

  const base::Value* tab_id_value = dict.Find("tabId");
  if (tab_id_value) {
    {
      auto temp = (*tab_id_value).GetIfInt();
      if (!temp.has_value()) {
        out.tab_id = std::nullopt;
        return false;
      }
      out.tab_id = *temp;
    }
  }

  const base::Value* extension_id_value = dict.Find("extensionId");
  if (extension_id_value) {
    {
      auto* temp = (*extension_id_value).GetIfString();
      if (!temp) {
        out.extension_id = std::nullopt;
        return false;
      }
      out.extension_id = *temp;
    }
  }

  const base::Value* attached_value = dict.Find("attached");
  if (!attached_value) {
    return false;
  }
  {
    auto temp = (*attached_value).GetIfBool();
    if (!temp.has_value()) {
      return false;
    }
    out.attached = *temp;
  }

  const base::Value* title_value = dict.Find("title");
  if (!title_value) {
    return false;
  }
  {
    auto* temp = (*title_value).GetIfString();
    if (!temp) {
      return false;
    }
    out.title = *temp;
  }

  const base::Value* url_value = dict.Find("url");
  if (!url_value) {
    return false;
  }
  {
    auto* temp = (*url_value).GetIfString();
    if (!temp) {
      return false;
    }
    out.url = *temp;
  }

  const base::Value* favicon_url_value = dict.Find("faviconUrl");
  if (favicon_url_value) {
    {
      auto* temp = (*favicon_url_value).GetIfString();
      if (!temp) {
        out.favicon_url = std::nullopt;
        return false;
      }
      out.favicon_url = *temp;
    }
  }

  return true;
}

// static
bool TargetInfo::Populate(
    const base::Value& value, TargetInfo& out) {
  if (!value.is_dict()) {
    return false;
  }
  return Populate(value.GetDict(), out);
}

// static
std::optional<TargetInfo> TargetInfo::FromValue(const base::Value::Dict& value) {
  TargetInfo out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}

// static
std::optional<TargetInfo> TargetInfo::FromValue(const base::Value& value) {
  TargetInfo out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}

base::Value::Dict TargetInfo::ToValue() const {
  base::Value::Dict to_value_result;

  to_value_result.Set("type", debugger::ToString(this->type));

  to_value_result.Set("id", this->id);

  if (this->tab_id) {
    to_value_result.Set("tabId", *this->tab_id);

  }
  if (this->extension_id) {
    to_value_result.Set("extensionId", *this->extension_id);

  }
  to_value_result.Set("attached", this->attached);

  to_value_result.Set("title", this->title);

  to_value_result.Set("url", this->url);

  if (this->favicon_url) {
    to_value_result.Set("faviconUrl", *this->favicon_url);

  }

  return to_value_result;
}



//
// Functions
//

namespace Attach {

Params::Params() = default;
Params::~Params() = default;
Params::Params(Params&& rhs) noexcept = default;
Params& Params::operator=(Params&& rhs) noexcept = default;

// static
std::optional<Params> Params::Create(const base::Value::List& args) {
  if (args.size() != 2) {
    return std::nullopt;
  }
  Params params;

  if (0 < args.size() &&
      !args[0].is_none()) {
    const base::Value& target_value = args[0];
    {
      if (!target_value.is_dict()) {
        return std::nullopt;
      }
      if (!Debuggee::Populate(target_value.GetDict(), params.target)) {
        return std::nullopt;
      }
    }
  }
  else {
    return std::nullopt;
  }

  if (1 < args.size() &&
      !args[1].is_none()) {
    const base::Value& required_version_value = args[1];
    {
      auto* temp = required_version_value.GetIfString();
      if (!temp) {
        return std::nullopt;
      }
      params.required_version = *temp;
    }
  }
  else {
    return std::nullopt;
  }

  return params;
}


base::Value::List Results::Create() {
  base::Value::List create_results;

  return create_results;
}
}  // namespace Attach

namespace Detach {

Params::Params() = default;
Params::~Params() = default;
Params::Params(Params&& rhs) noexcept = default;
Params& Params::operator=(Params&& rhs) noexcept = default;

// static
std::optional<Params> Params::Create(const base::Value::List& args) {
  if (args.size() != 1) {
    return std::nullopt;
  }
  Params params;

  if (0 < args.size() &&
      !args[0].is_none()) {
    const base::Value& target_value = args[0];
    {
      if (!target_value.is_dict()) {
        return std::nullopt;
      }
      if (!Debuggee::Populate(target_value.GetDict(), params.target)) {
        return std::nullopt;
      }
    }
  }
  else {
    return std::nullopt;
  }

  return params;
}


base::Value::List Results::Create() {
  base::Value::List create_results;

  return create_results;
}
}  // namespace Detach

namespace SendCommand {

Params::CommandParams::CommandParams()
 {}

Params::CommandParams::~CommandParams() = default;
Params::CommandParams::CommandParams(CommandParams&& rhs) noexcept = default;
Params::CommandParams& Params::CommandParams::operator=(CommandParams&& rhs) noexcept = default;
Params::CommandParams Params::CommandParams::Clone() const {
  CommandParams out;
  out.additional_properties = additional_properties.Clone();
  return out;
}

// static
bool Params::CommandParams::Populate(
    const base::Value::Dict& dict, CommandParams& out) {
  out.additional_properties.Merge(dict.Clone());
  return true;
}

// static
bool Params::CommandParams::Populate(
    const base::Value& value, CommandParams& out) {
  if (!value.is_dict()) {
    return false;
  }
  return Populate(value.GetDict(), out);
}

// static
std::optional<Params::CommandParams> Params::CommandParams::FromValue(const base::Value::Dict& value) {
  CommandParams out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}

// static
std::optional<Params::CommandParams> Params::CommandParams::FromValue(const base::Value& value) {
  CommandParams out;
  bool result = Populate(value, out);
  if (!result) {
    return std::nullopt;
  }
  return out;
}


Params::Params() = default;
Params::~Params() = default;
Params::Params(Params&& rhs) noexcept = default;
Params& Params::operator=(Params&& rhs) noexcept = default;

// static
std::optional<Params> Params::Create(const base::Value::List& args) {
  if (args.size() < 2 || args.size() > 3) {
    return std::nullopt;
  }
  Params params;

  if (0 < args.size() &&
      !args[0].is_none()) {
    const base::Value& target_value = args[0];
    {
      if (!target_value.is_dict()) {
        return std::nullopt;
      }
      if (!DebuggerSession::Populate(target_value.GetDict(), params.target)) {
        return std::nullopt;
      }
    }
  }
  else {
    return std::nullopt;
  }

  if (1 < args.size() &&
      !args[1].is_none()) {
    const base::Value& method_value = args[1];
    {
      auto* temp = method_value.GetIfString();
      if (!temp) {
        return std::nullopt;
      }
      params.method = *temp;
    }
  }
  else {
    return std::nullopt;
  }

  if (2 < args.size() &&
      !args[2].is_none()) {
    const base::Value& command_params_value = args[2];
    {
      if (!command_params_value.is_dict()) {
        return std::nullopt;
      }
      else {
        CommandParams temp;
        if (!CommandParams::Populate(command_params_value.GetDict(), temp))
          return std::nullopt;
        params.command_params = std::move(temp);
      }
    }
  }

  return params;
}


Results::Result::Result()
 {}

Results::Result::~Result() = default;
Results::Result::Result(Result&& rhs) noexcept = default;
Results::Result& Results::Result::operator=(Result&& rhs) noexcept = default;
base::Value::Dict Results::Result::ToValue() const {
  base::Value::Dict to_value_result;

  to_value_result.Merge(additional_properties.Clone());

  return to_value_result;
}


base::Value::List Results::Create(const Result& result) {
  base::Value::List create_results;
  create_results.reserve(1);
  create_results.Append((result).ToValue());

  return create_results;
}
}  // namespace SendCommand

namespace GetTargets {

base::Value::List Results::Create(const std::vector<TargetInfo>& result) {
  base::Value::List create_results;
  create_results.reserve(1);
  create_results.Append(json_schema_compiler::util::CreateValueFromArray(result));

  return create_results;
}
}  // namespace GetTargets

//
// Events
//

namespace OnEvent {

const char kEventName[] = "debugger.onEvent";

Params::Params()
 {}

Params::~Params() = default;
Params::Params(Params&& rhs) noexcept = default;
Params& Params::operator=(Params&& rhs) noexcept = default;
base::Value::Dict Params::ToValue() const {
  base::Value::Dict to_value_result;

  to_value_result.Merge(additional_properties.Clone());

  return to_value_result;
}


base::Value::List Create(const DebuggerSession& source, const std::string& method, const Params& params) {
  base::Value::List create_results;
  create_results.reserve(3);
  create_results.Append((source).ToValue());

  create_results.Append(method);

  create_results.Append((params).ToValue());

  return create_results;
}

}  // namespace OnEvent

namespace OnDetach {

const char kEventName[] = "debugger.onDetach";

base::Value::List Create(const Debuggee& source, const DetachReason& reason) {
  base::Value::List create_results;
  create_results.reserve(2);
  create_results.Append((source).ToValue());

  create_results.Append(debugger::ToString(reason));

  return create_results;
}

}  // namespace OnDetach

}  // namespace debugger
}  // namespace api
}  // namespace extensions

