// chrome/common/compose/compose.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_DATA_VIEW_H_
#define CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/common/compose/compose.mojom-shared-internal.h"
#include "components/compose/core/browser/compose_enums.mojom-shared.h"


namespace compose::mojom {
class ComposeResponseDataView;

class PartialComposeResponseDataView;

class ComposeStateDataView;

class ConfigurableParamsDataView;

class OpenMetadataDataView;



}  // compose::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::compose::mojom::ComposeResponseDataView> {
  using Data = ::compose::mojom::internal::ComposeResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::compose::mojom::PartialComposeResponseDataView> {
  using Data = ::compose::mojom::internal::PartialComposeResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::compose::mojom::ComposeStateDataView> {
  using Data = ::compose::mojom::internal::ComposeState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::compose::mojom::ConfigurableParamsDataView> {
  using Data = ::compose::mojom::internal::ConfigurableParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::compose::mojom::OpenMetadataDataView> {
  using Data = ::compose::mojom::internal::OpenMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace compose::mojom {


enum class InputMode : int32_t {
  
  kUnset = 0,
  
  kPolish = 1,
  
  kElaborate = 2,
  
  kFormalize = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, InputMode value);
inline bool IsKnownEnumValue(InputMode value) {
  return internal::InputMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class StyleModifier : int32_t {
  
  kUnset = 0,
  
  kFormal = 1,
  
  kCasual = 2,
  
  kLonger = 3,
  
  kShorter = 4,
  
  kRetry = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, StyleModifier value);
inline bool IsKnownEnumValue(StyleModifier value) {
  return internal::StyleModifier_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CloseReason : int32_t {
  
  kFirstRunCloseButton = 0,
  
  kCloseButton = 1,
  
  kInsertButton = 2,
  
  kMSBBCloseButton = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, CloseReason value);
inline bool IsKnownEnumValue(CloseReason value) {
  return internal::CloseReason_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class UserFeedback : int32_t {
  
  kUserFeedbackUnspecified = 0,
  
  kUserFeedbackNegative = 1,
  
  kUserFeedbackPositive = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, UserFeedback value);
inline bool IsKnownEnumValue(UserFeedback value) {
  return internal::UserFeedback_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class ComposeSessionUntrustedPageHandlerFactoryInterfaceBase {};

using ComposeSessionUntrustedPageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<ComposeSessionUntrustedPageHandlerFactoryInterfaceBase>;
using ComposeSessionUntrustedPageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<ComposeSessionUntrustedPageHandlerFactoryInterfaceBase>;
using ComposeSessionUntrustedPageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ComposeSessionUntrustedPageHandlerFactoryInterfaceBase>;
using ComposeSessionUntrustedPageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ComposeSessionUntrustedPageHandlerFactoryInterfaceBase>;
class ComposeSessionUntrustedPageHandlerInterfaceBase {};

using ComposeSessionUntrustedPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<ComposeSessionUntrustedPageHandlerInterfaceBase>;
using ComposeSessionUntrustedPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<ComposeSessionUntrustedPageHandlerInterfaceBase>;
using ComposeSessionUntrustedPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ComposeSessionUntrustedPageHandlerInterfaceBase>;
using ComposeSessionUntrustedPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ComposeSessionUntrustedPageHandlerInterfaceBase>;
class ComposeClientUntrustedPageHandlerInterfaceBase {};

using ComposeClientUntrustedPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<ComposeClientUntrustedPageHandlerInterfaceBase>;
using ComposeClientUntrustedPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<ComposeClientUntrustedPageHandlerInterfaceBase>;
using ComposeClientUntrustedPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ComposeClientUntrustedPageHandlerInterfaceBase>;
using ComposeClientUntrustedPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ComposeClientUntrustedPageHandlerInterfaceBase>;
class ComposeUntrustedDialogInterfaceBase {};

using ComposeUntrustedDialogPtrDataView =
    mojo::InterfacePtrDataView<ComposeUntrustedDialogInterfaceBase>;
using ComposeUntrustedDialogRequestDataView =
    mojo::InterfaceRequestDataView<ComposeUntrustedDialogInterfaceBase>;
using ComposeUntrustedDialogAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<ComposeUntrustedDialogInterfaceBase>;
using ComposeUntrustedDialogAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<ComposeUntrustedDialogInterfaceBase>;


class ComposeResponseDataView {
 public:
  ComposeResponseDataView() = default;

  ComposeResponseDataView(
      internal::ComposeResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::compose::mojom::ComposeStatus>(
        data_value, output);
  }
  ::compose::mojom::ComposeStatus status() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::compose::mojom::ComposeStatus>(data_->status));
  }
  inline void GetResultDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool undo_available() const {
    return data_->undo_available;
  }
  bool redo_available() const {
    return data_->redo_available;
  }
  bool provided_by_user() const {
    return data_->provided_by_user;
  }
  bool on_device_evaluation_used() const {
    return data_->on_device_evaluation_used;
  }
  bool triggered_from_modifier() const {
    return data_->triggered_from_modifier;
  }
 private:
  internal::ComposeResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PartialComposeResponseDataView {
 public:
  PartialComposeResponseDataView() = default;

  PartialComposeResponseDataView(
      internal::PartialComposeResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetResultDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResult(UserType* output) {
    
    auto* pointer = data_->result.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PartialComposeResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ComposeStateDataView {
 public:
  ComposeStateDataView() = default;

  ComposeStateDataView(
      internal::ComposeState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetWebuiStateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadWebuiState(UserType* output) {
    
    auto* pointer = data_->webui_state.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetResponseDataView(
      ComposeResponseDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResponse(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::compose::mojom::ComposeResponseDataView, UserType>(),
    "Attempting to read the optional `response` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadResponse` instead "
    "of `ReadResponse if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->response.Get();
    return mojo::internal::Deserialize<::compose::mojom::ComposeResponseDataView>(
        pointer, output, message_);
  }
  bool has_pending_request() const {
    return data_->has_pending_request;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadFeedback(UserType* output) const {
    auto data_value = data_->feedback;
    return mojo::internal::Deserialize<::compose::mojom::UserFeedback>(
        data_value, output);
  }
  UserFeedback feedback() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::compose::mojom::UserFeedback>(data_->feedback));
  }
 private:
  internal::ComposeState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ConfigurableParamsDataView {
 public:
  ConfigurableParamsDataView() = default;

  ConfigurableParamsDataView(
      internal::ConfigurableParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t min_word_limit() const {
    return data_->min_word_limit;
  }
  int32_t max_word_limit() const {
    return data_->max_word_limit;
  }
  int32_t max_character_limit() const {
    return data_->max_character_limit;
  }
 private:
  internal::ConfigurableParams_Data* data_ = nullptr;
};


class OpenMetadataDataView {
 public:
  OpenMetadataDataView() = default;

  OpenMetadataDataView(
      internal::OpenMetadata_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool fre_complete() const {
    return data_->fre_complete;
  }
  bool msbb_state() const {
    return data_->msbb_state;
  }
  inline void GetInitialInputDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialInput(UserType* output) {
    
    auto* pointer = data_->initial_input.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool text_selected() const {
    return data_->text_selected;
  }
  inline void GetComposeStateDataView(
      ComposeStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComposeState(UserType* output) {
    
    auto* pointer = data_->compose_state.Get();
    return mojo::internal::Deserialize<::compose::mojom::ComposeStateDataView>(
        pointer, output, message_);
  }
  inline void GetConfigurableParamsDataView(
      ConfigurableParamsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConfigurableParams(UserType* output) {
    
    auto* pointer = data_->configurable_params.Get();
    return mojo::internal::Deserialize<::compose::mojom::ConfigurableParamsDataView>(
        pointer, output, message_);
  }
 private:
  internal::OpenMetadata_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // compose::mojom

#endif  // CHROME_COMMON_COMPOSE_COMPOSE_MOJOM_DATA_VIEW_H_