// chrome/common/chrome_render_frame.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_CHROME_RENDER_FRAME_MOJOM_H_
#define CHROME_COMMON_CHROME_RENDER_FRAME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/chrome_render_frame.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/chrome_render_frame.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/chrome_render_frame.mojom-forward.h"  // IWYU pragma: export
#include "chrome/common/actor.mojom.h"
#include "components/lens/lens_metadata.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "skia/public/mojom/bitmap.mojom.h"
#include "third_party/blink/public/mojom/window_features/window_features.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace chrome::mojom {

class ChromeRenderFrameProxy;

template <typename ImplRefTraits>
class ChromeRenderFrameStub;

class ChromeRenderFrameRequestValidator;
class ChromeRenderFrameResponseValidator;


class ChromeRenderFrame
    : public ChromeRenderFrameInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "chrome.mojom.ChromeRenderFrame";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ChromeRenderFrameInterfaceBase;
  using Proxy_ = ChromeRenderFrameProxy;

  template <typename ImplRefTraits>
  using Stub_ = ChromeRenderFrameStub<ImplRefTraits>;

  using RequestValidator_ = ChromeRenderFrameRequestValidator;
  using ResponseValidator_ = ChromeRenderFrameResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetWindowFeaturesMinVersion = 0,
    kRequestReloadImageForContextNodeMinVersion = 0,
    kRequestBitmapForContextNodeMinVersion = 0,
    kRequestBitmapForContextNodeWithBoundsHintMinVersion = 0,
    kRequestBoundsHintForAllImagesMinVersion = 0,
    kRequestImageForContextNodeMinVersion = 0,
    kExecuteWebUIJavaScriptMinVersion = 0,
    kGetMediaFeedURLMinVersion = 0,
    kLoadBlockedPluginsMinVersion = 0,
    kSetSupportsDraggableRegionsMinVersion = 0,
    kSetShouldDeferMediaLoadMinVersion = 0,
    kInvokeToolMinVersion = 0,
    kStartActorJournalMinVersion = 0,
    kCreatePageStabilityMonitorMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetWindowFeatures_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestReloadImageForContextNode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestBitmapForContextNode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestBitmapForContextNodeWithBoundsHint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestBoundsHintForAllImages_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestImageForContextNode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ExecuteWebUIJavaScript_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMediaFeedURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadBlockedPlugins_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSupportsDraggableRegions_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetShouldDeferMediaLoad_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InvokeTool_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartActorJournal_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreatePageStabilityMonitor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ChromeRenderFrame() = default;

  virtual void SetWindowFeatures(::blink::mojom::WindowFeaturesPtr window_features) = 0;

  virtual void RequestReloadImageForContextNode() = 0;

  using RequestBitmapForContextNodeCallback = base::OnceCallback<void(const ::SkBitmap&)>;
  using RequestBitmapForContextNodeMojoCallback = base::OnceCallback<void(const ::SkBitmap&)>;

  virtual void RequestBitmapForContextNode(RequestBitmapForContextNodeCallback callback) = 0;

  using RequestBitmapForContextNodeWithBoundsHintCallback = base::OnceCallback<void(const ::SkBitmap&, const ::gfx::Rect&)>;
  using RequestBitmapForContextNodeWithBoundsHintMojoCallback = base::OnceCallback<void(const ::SkBitmap&, const ::gfx::Rect&)>;

  virtual void RequestBitmapForContextNodeWithBoundsHint(RequestBitmapForContextNodeWithBoundsHintCallback callback) = 0;

  using RequestBoundsHintForAllImagesCallback = base::OnceCallback<void(const std::vector<::gfx::Rect>&)>;
  using RequestBoundsHintForAllImagesMojoCallback = base::OnceCallback<void(const std::vector<::gfx::Rect>&)>;

  virtual void RequestBoundsHintForAllImages(RequestBoundsHintForAllImagesCallback callback) = 0;

  using RequestImageForContextNodeCallback = base::OnceCallback<void(const std::vector<uint8_t>&, const ::gfx::Size&, const ::gfx::Size&, const std::string&, std::vector<::lens::mojom::LatencyLogPtr>)>;
  using RequestImageForContextNodeMojoCallback = base::OnceCallback<void(const std::vector<uint8_t>&, const ::gfx::Size&, const ::gfx::Size&, const std::string&, std::vector<::lens::mojom::LatencyLogPtr>)>;

  virtual void RequestImageForContextNode(int32_t image_min_area_pixels, const ::gfx::Size& image_max_size_pixels, ImageFormat image_format, int32_t quality, RequestImageForContextNodeCallback callback) = 0;

  virtual void ExecuteWebUIJavaScript(const ::std::u16string& javascript) = 0;

  using GetMediaFeedURLCallback = base::OnceCallback<void(const std::optional<::GURL>&)>;
  using GetMediaFeedURLMojoCallback = base::OnceCallback<void(const std::optional<::GURL>&)>;

  virtual void GetMediaFeedURL(GetMediaFeedURLCallback callback) = 0;

  virtual void LoadBlockedPlugins(const std::string& identifier) = 0;

  virtual void SetSupportsDraggableRegions(bool supports_draggable_regions) = 0;

  virtual void SetShouldDeferMediaLoad(bool should_defer) = 0;

  using InvokeToolCallback = base::OnceCallback<void(::actor::mojom::ActionResultPtr)>;
  using InvokeToolMojoCallback = base::OnceCallback<void(::actor::mojom::ActionResultPtr)>;

  virtual void InvokeTool(::actor::mojom::ToolInvocationPtr request, InvokeToolCallback callback) = 0;

  virtual void StartActorJournal(::mojo::PendingAssociatedRemote<::actor::mojom::JournalClient> client) = 0;

  virtual void CreatePageStabilityMonitor(::mojo::PendingReceiver<::actor::mojom::PageStabilityMonitor> monitor, const ::actor::TaskId& task_id, bool supports_paint_stability) = 0;
};



class  ChromeRenderFrameProxy
    : public ChromeRenderFrame {
 public:
  using InterfaceType = ChromeRenderFrame;

  explicit ChromeRenderFrameProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetWindowFeatures(::blink::mojom::WindowFeaturesPtr window_features) final;
  
  void RequestReloadImageForContextNode() final;
  
  void RequestBitmapForContextNode(RequestBitmapForContextNodeCallback callback) final;
  
  void RequestBitmapForContextNodeWithBoundsHint(RequestBitmapForContextNodeWithBoundsHintCallback callback) final;
  
  void RequestBoundsHintForAllImages(RequestBoundsHintForAllImagesCallback callback) final;
  
  void RequestImageForContextNode(int32_t image_min_area_pixels, const ::gfx::Size& image_max_size_pixels, ImageFormat image_format, int32_t quality, RequestImageForContextNodeCallback callback) final;
  
  void ExecuteWebUIJavaScript(const ::std::u16string& javascript) final;
  
  void GetMediaFeedURL(GetMediaFeedURLCallback callback) final;
  
  void LoadBlockedPlugins(const std::string& identifier) final;
  
  void SetSupportsDraggableRegions(bool supports_draggable_regions) final;
  
  void SetShouldDeferMediaLoad(bool should_defer) final;
  
  void InvokeTool(::actor::mojom::ToolInvocationPtr request, InvokeToolCallback callback) final;
  
  void StartActorJournal(::mojo::PendingAssociatedRemote<::actor::mojom::JournalClient> client) final;
  
  void CreatePageStabilityMonitor(::mojo::PendingReceiver<::actor::mojom::PageStabilityMonitor> monitor, const ::actor::TaskId& task_id, bool supports_paint_stability) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ChromeRenderFrameStubDispatch {
 public:
  static bool Accept(ChromeRenderFrame* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ChromeRenderFrame* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ChromeRenderFrame>>
class ChromeRenderFrameStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ChromeRenderFrameStub() = default;
  ~ChromeRenderFrameStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChromeRenderFrameStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ChromeRenderFrameStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ChromeRenderFrameRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ChromeRenderFrameResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // chrome::mojom

namespace mojo {

}  // namespace mojo

#endif  // CHROME_COMMON_CHROME_RENDER_FRAME_MOJOM_H_