// chrome/common/chrome_render_frame.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/chrome_render_frame.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/chrome_render_frame.mojom-params-data.h"
namespace chrome {
namespace mojom {

NOINLINE static const char* ImageFormatToStringHelper(ImageFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImageFormat::JPEG:
      return "JPEG";
    case ImageFormat::PNG:
      return "PNG";
    case ImageFormat::WEBP:
      return "WEBP";
    case ImageFormat::ORIGINAL:
      return "ORIGINAL";
    default:
      return nullptr;
  }
}

std::string ImageFormatToString(ImageFormat value) {
  const char *str = ImageFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImageFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImageFormat value) {
  return os << ImageFormatToString(value);
}

namespace internal {


// static
bool ChromeRenderFrame_SetWindowFeatures_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_SetWindowFeatures_Params_Data* object =
      static_cast<const ChromeRenderFrame_SetWindowFeatures_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->window_features, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->window_features, validation_context))
    return false;

  return true;
}

ChromeRenderFrame_SetWindowFeatures_Params_Data::ChromeRenderFrame_SetWindowFeatures_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_RequestReloadImageForContextNode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_RequestReloadImageForContextNode_Params_Data* object =
      static_cast<const ChromeRenderFrame_RequestReloadImageForContextNode_Params_Data*>(data);

  return true;
}

ChromeRenderFrame_RequestReloadImageForContextNode_Params_Data::ChromeRenderFrame_RequestReloadImageForContextNode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_RequestBitmapForContextNode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_RequestBitmapForContextNode_Params_Data* object =
      static_cast<const ChromeRenderFrame_RequestBitmapForContextNode_Params_Data*>(data);

  return true;
}

ChromeRenderFrame_RequestBitmapForContextNode_Params_Data::ChromeRenderFrame_RequestBitmapForContextNode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_RequestBitmapForContextNode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_RequestBitmapForContextNode_ResponseParams_Data* object =
      static_cast<const ChromeRenderFrame_RequestBitmapForContextNode_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->bitmap, validation_context))
    return false;

  return true;
}

ChromeRenderFrame_RequestBitmapForContextNode_ResponseParams_Data::ChromeRenderFrame_RequestBitmapForContextNode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_Params_Data* object =
      static_cast<const ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_Params_Data*>(data);

  return true;
}

ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_Params_Data::ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ResponseParams_Data* object =
      static_cast<const ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->bitmap, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->bounds, validation_context))
    return false;

  return true;
}

ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ResponseParams_Data::ChromeRenderFrame_RequestBitmapForContextNodeWithBoundsHint_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_RequestBoundsHintForAllImages_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_RequestBoundsHintForAllImages_Params_Data* object =
      static_cast<const ChromeRenderFrame_RequestBoundsHintForAllImages_Params_Data*>(data);

  return true;
}

ChromeRenderFrame_RequestBoundsHintForAllImages_Params_Data::ChromeRenderFrame_RequestBoundsHintForAllImages_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_RequestBoundsHintForAllImages_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_RequestBoundsHintForAllImages_ResponseParams_Data* object =
      static_cast<const ChromeRenderFrame_RequestBoundsHintForAllImages_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_bounds, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& all_bounds_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->all_bounds, validation_context,
                                         &all_bounds_validate_params)) {
    return false;
  }

  return true;
}

ChromeRenderFrame_RequestBoundsHintForAllImages_ResponseParams_Data::ChromeRenderFrame_RequestBoundsHintForAllImages_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_RequestImageForContextNode_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_RequestImageForContextNode_Params_Data* object =
      static_cast<const ChromeRenderFrame_RequestImageForContextNode_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_max_size_pixels, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_max_size_pixels, validation_context))
    return false;


  if (!::chrome::mojom::internal::ImageFormat_Data
        ::Validate(object->image_format, validation_context))
    return false;

  return true;
}

ChromeRenderFrame_RequestImageForContextNode_Params_Data::ChromeRenderFrame_RequestImageForContextNode_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_RequestImageForContextNode_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_RequestImageForContextNode_ResponseParams_Data* object =
      static_cast<const ChromeRenderFrame_RequestImageForContextNode_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_data, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& image_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->image_data, validation_context,
                                         &image_data_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->original_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->downscaled_size, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->downscaled_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->encoded_extension, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& encoded_extension_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->encoded_extension, validation_context,
                                         &encoded_extension_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->log_data, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& log_data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->log_data, validation_context,
                                         &log_data_validate_params)) {
    return false;
  }

  return true;
}

ChromeRenderFrame_RequestImageForContextNode_ResponseParams_Data::ChromeRenderFrame_RequestImageForContextNode_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_ExecuteWebUIJavaScript_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_ExecuteWebUIJavaScript_Params_Data* object =
      static_cast<const ChromeRenderFrame_ExecuteWebUIJavaScript_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->javascript, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->javascript, validation_context))
    return false;

  return true;
}

ChromeRenderFrame_ExecuteWebUIJavaScript_Params_Data::ChromeRenderFrame_ExecuteWebUIJavaScript_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_GetMediaFeedURL_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_GetMediaFeedURL_Params_Data* object =
      static_cast<const ChromeRenderFrame_GetMediaFeedURL_Params_Data*>(data);

  return true;
}

ChromeRenderFrame_GetMediaFeedURL_Params_Data::ChromeRenderFrame_GetMediaFeedURL_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_GetMediaFeedURL_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_GetMediaFeedURL_ResponseParams_Data* object =
      static_cast<const ChromeRenderFrame_GetMediaFeedURL_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ChromeRenderFrame_GetMediaFeedURL_ResponseParams_Data::ChromeRenderFrame_GetMediaFeedURL_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_LoadBlockedPlugins_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_LoadBlockedPlugins_Params_Data* object =
      static_cast<const ChromeRenderFrame_LoadBlockedPlugins_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->identifier, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& identifier_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->identifier, validation_context,
                                         &identifier_validate_params)) {
    return false;
  }

  return true;
}

ChromeRenderFrame_LoadBlockedPlugins_Params_Data::ChromeRenderFrame_LoadBlockedPlugins_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_SetSupportsDraggableRegions_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_SetSupportsDraggableRegions_Params_Data* object =
      static_cast<const ChromeRenderFrame_SetSupportsDraggableRegions_Params_Data*>(data);

  return true;
}

ChromeRenderFrame_SetSupportsDraggableRegions_Params_Data::ChromeRenderFrame_SetSupportsDraggableRegions_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_SetShouldDeferMediaLoad_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_SetShouldDeferMediaLoad_Params_Data* object =
      static_cast<const ChromeRenderFrame_SetShouldDeferMediaLoad_Params_Data*>(data);

  return true;
}

ChromeRenderFrame_SetShouldDeferMediaLoad_Params_Data::ChromeRenderFrame_SetShouldDeferMediaLoad_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_InvokeTool_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_InvokeTool_Params_Data* object =
      static_cast<const ChromeRenderFrame_InvokeTool_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request, validation_context))
    return false;

  return true;
}

ChromeRenderFrame_InvokeTool_Params_Data::ChromeRenderFrame_InvokeTool_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_InvokeTool_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_InvokeTool_ResponseParams_Data* object =
      static_cast<const ChromeRenderFrame_InvokeTool_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

ChromeRenderFrame_InvokeTool_ResponseParams_Data::ChromeRenderFrame_InvokeTool_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_StartActorJournal_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_StartActorJournal_Params_Data* object =
      static_cast<const ChromeRenderFrame_StartActorJournal_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ChromeRenderFrame_StartActorJournal_Params_Data::ChromeRenderFrame_StartActorJournal_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ChromeRenderFrame_CreatePageStabilityMonitor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ChromeRenderFrame_CreatePageStabilityMonitor_Params_Data* object =
      static_cast<const ChromeRenderFrame_CreatePageStabilityMonitor_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->monitor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->monitor,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->task_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->task_id, validation_context))
    return false;

  return true;
}

ChromeRenderFrame_CreatePageStabilityMonitor_Params_Data::ChromeRenderFrame_CreatePageStabilityMonitor_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace chrome

namespace perfetto {

// static
void TraceFormatTraits<::chrome::mojom::ImageFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::chrome::mojom::ImageFormat value) {
  return std::move(context).WriteString(::chrome::mojom::ImageFormatToString(value));
}

} // namespace perfetto