// chrome/common/actor_webui.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_WEBUI_MOJOM_H_
#define CHROME_COMMON_ACTOR_WEBUI_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/actor_webui.mojom-features.h"  // IWYU pragma: export
#include "chrome/common/actor_webui.mojom-shared.h"  // IWYU pragma: export
#include "chrome/common/actor_webui.mojom-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/bitmap.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace actor::webui::mojom {





class  TaskOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TaskOptions, T>::value>;
  using DataView = TaskOptionsDataView;
  using Data_ = internal::TaskOptions_Data;

  template <typename... Args>
  static TaskOptionsPtr New(Args&&... args) {
    return TaskOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TaskOptionsPtr From(const U& u) {
    return mojo::TypeConverter<TaskOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TaskOptions>::Convert(*this);
  }


  TaskOptions();

  explicit TaskOptions(
      const std::optional<std::string>& title);


  ~TaskOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TaskOptionsPtr>
  TaskOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TaskOptions::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TaskOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TaskOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TaskOptions_UnserializedMessageContext<
            UserType, TaskOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TaskOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TaskOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TaskOptions_UnserializedMessageContext<
            UserType, TaskOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TaskOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<std::string> title;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TaskOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  Credential {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Credential, T>::value>;
  using DataView = CredentialDataView;
  using Data_ = internal::Credential_Data;

  template <typename... Args>
  static CredentialPtr New(Args&&... args) {
    return CredentialPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CredentialPtr From(const U& u) {
    return mojo::TypeConverter<CredentialPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Credential>::Convert(*this);
  }


  Credential();

  Credential(
      int32_t id,
      const std::string& username,
      const std::string& source_site_or_app);


  ~Credential();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CredentialPtr>
  CredentialPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Credential::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Credential::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Credential::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Credential::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Credential::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Credential::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Credential_UnserializedMessageContext<
            UserType, Credential::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Credential::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Credential::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Credential_UnserializedMessageContext<
            UserType, Credential::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Credential::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  std::string username;
  
  std::string source_site_or_app;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Credential::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Credential::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Credential::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Credential::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SelectCredentialDialogResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectCredentialDialogResponse, T>::value>;
  using DataView = SelectCredentialDialogResponseDataView;
  using Data_ = internal::SelectCredentialDialogResponse_Data;

  template <typename... Args>
  static SelectCredentialDialogResponsePtr New(Args&&... args) {
    return SelectCredentialDialogResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectCredentialDialogResponsePtr From(const U& u) {
    return mojo::TypeConverter<SelectCredentialDialogResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectCredentialDialogResponse>::Convert(*this);
  }


  SelectCredentialDialogResponse();

  SelectCredentialDialogResponse(
      int32_t task_id,
      std::optional<SelectCredentialDialogErrorReason> error_reason,
      std::optional<UserGrantedPermissionDuration> permission_duration,
      std::optional<int32_t> selected_credential_id);


  ~SelectCredentialDialogResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectCredentialDialogResponsePtr>
  SelectCredentialDialogResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectCredentialDialogResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SelectCredentialDialogResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectCredentialDialogResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectCredentialDialogResponse_UnserializedMessageContext<
            UserType, SelectCredentialDialogResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectCredentialDialogResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectCredentialDialogResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectCredentialDialogResponse_UnserializedMessageContext<
            UserType, SelectCredentialDialogResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectCredentialDialogResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t task_id;
  
  std::optional<SelectCredentialDialogErrorReason> error_reason;
  
  std::optional<UserGrantedPermissionDuration> permission_duration;
  
  std::optional<int32_t> selected_credential_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  UserConfirmationDialogPayload {
 public:
  using DataView = UserConfirmationDialogPayloadDataView;
  using Data_ = internal::UserConfirmationDialogPayload_Data;
  using Tag = Data_::UserConfirmationDialogPayload_Tag;

  template <typename... Args>
  static UserConfirmationDialogPayloadPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |navigation_origin|.
  static UserConfirmationDialogPayloadPtr NewNavigationOrigin(
      const ::url::Origin& value);
  // Construct an instance holding |download_id|.
  static UserConfirmationDialogPayloadPtr NewDownloadId(
      int32_t value);

  template <typename U>
  static UserConfirmationDialogPayloadPtr From(const U& u) {
    return mojo::TypeConverter<UserConfirmationDialogPayloadPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserConfirmationDialogPayload>::Convert(*this);
  }
  ~UserConfirmationDialogPayload();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  UserConfirmationDialogPayload(const UserConfirmationDialogPayload& other) = delete;
  UserConfirmationDialogPayload& operator=(const UserConfirmationDialogPayload& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UserConfirmationDialogPayloadPtr>
  UserConfirmationDialogPayloadPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UserConfirmationDialogPayload>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, UserConfirmationDialogPayload>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_navigation_origin() const { return tag_ == Tag::kNavigationOrigin; }
  const ::url::Origin& get_navigation_origin() const {
    CHECK(tag_ == Tag::kNavigationOrigin);
    return data_.navigation_origin;
  }
  ::url::Origin& get_navigation_origin() {
    CHECK(tag_ == Tag::kNavigationOrigin);
    return data_.navigation_origin;
  }
  void set_navigation_origin(const ::url::Origin& navigation_origin);

  bool is_download_id() const { return tag_ == Tag::kDownloadId; }
  int32_t get_download_id() const {
    CHECK(tag_ == Tag::kDownloadId);
    return data_.download_id;
  }
  void set_download_id(int32_t download_id);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserConfirmationDialogPayload::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UserConfirmationDialogPayload::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNavigationOrigin)>,
        const ::url::Origin& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDownloadId)>,
        int32_t value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    ::url::Origin navigation_origin;
    int32_t download_id;
  };

  UserConfirmationDialogPayload(
      std::in_place_index_t<static_cast<size_t>(Tag::kNavigationOrigin)>,
      const ::url::Origin& value);
  UserConfirmationDialogPayload(
      std::in_place_index_t<static_cast<size_t>(Tag::kDownloadId)>,
      int32_t value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};



class  UserConfirmationDialogResult {
 public:
  using DataView = UserConfirmationDialogResultDataView;
  using Data_ = internal::UserConfirmationDialogResult_Data;
  using Tag = Data_::UserConfirmationDialogResult_Tag;

  template <typename... Args>
  static UserConfirmationDialogResultPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |permission_granted|.
  static UserConfirmationDialogResultPtr NewPermissionGranted(
      bool value);
  // Construct an instance holding |error_reason|.
  static UserConfirmationDialogResultPtr NewErrorReason(
      UserConfirmationDialogErrorReason value);

  template <typename U>
  static UserConfirmationDialogResultPtr From(const U& u) {
    return mojo::TypeConverter<UserConfirmationDialogResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserConfirmationDialogResult>::Convert(*this);
  }
  ~UserConfirmationDialogResult();


  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = UserConfirmationDialogResultPtr>
  UserConfirmationDialogResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, UserConfirmationDialogResult>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, UserConfirmationDialogResult>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }
  size_t Hash(size_t seed) const;

  Tag which() const {
    return tag_;
  }

  bool is_permission_granted() const { return tag_ == Tag::kPermissionGranted; }
  bool get_permission_granted() const {
    CHECK(tag_ == Tag::kPermissionGranted);
    return data_.permission_granted;
  }
  void set_permission_granted(bool permission_granted);

  bool is_error_reason() const { return tag_ == Tag::kErrorReason; }
  UserConfirmationDialogErrorReason get_error_reason() const {
    CHECK(tag_ == Tag::kErrorReason);
    return data_.error_reason;
  }
  void set_error_reason(UserConfirmationDialogErrorReason error_reason);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserConfirmationDialogResult::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<UserConfirmationDialogResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
        UserConfirmationDialogErrorReason value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    bool permission_granted;
    UserConfirmationDialogErrorReason error_reason;
  };

  UserConfirmationDialogResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
      bool value);
  UserConfirmationDialogResult(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
      UserConfirmationDialogErrorReason value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};







class  SelectCredentialDialogRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SelectCredentialDialogRequest, T>::value>;
  using DataView = SelectCredentialDialogRequestDataView;
  using Data_ = internal::SelectCredentialDialogRequest_Data;

  template <typename... Args>
  static SelectCredentialDialogRequestPtr New(Args&&... args) {
    return SelectCredentialDialogRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SelectCredentialDialogRequestPtr From(const U& u) {
    return mojo::TypeConverter<SelectCredentialDialogRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SelectCredentialDialogRequest>::Convert(*this);
  }


  SelectCredentialDialogRequest();

  SelectCredentialDialogRequest(
      int32_t task_id,
      bool show_dialog,
      std::vector<CredentialPtr> credentials,
      const base::flat_map<std::string, ::SkBitmap>& icons);

SelectCredentialDialogRequest(const SelectCredentialDialogRequest&) = delete;
SelectCredentialDialogRequest& operator=(const SelectCredentialDialogRequest&) = delete;

  ~SelectCredentialDialogRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SelectCredentialDialogRequestPtr>
  SelectCredentialDialogRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SelectCredentialDialogRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SelectCredentialDialogRequest_UnserializedMessageContext<
            UserType, SelectCredentialDialogRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SelectCredentialDialogRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SelectCredentialDialogRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SelectCredentialDialogRequest_UnserializedMessageContext<
            UserType, SelectCredentialDialogRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SelectCredentialDialogRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t task_id;
  
  bool show_dialog;
  
  std::vector<CredentialPtr> credentials;
  
  base::flat_map<std::string, ::SkBitmap> icons;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  UserConfirmationDialogRequest {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserConfirmationDialogRequest, T>::value>;
  using DataView = UserConfirmationDialogRequestDataView;
  using Data_ = internal::UserConfirmationDialogRequest_Data;

  template <typename... Args>
  static UserConfirmationDialogRequestPtr New(Args&&... args) {
    return UserConfirmationDialogRequestPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserConfirmationDialogRequestPtr From(const U& u) {
    return mojo::TypeConverter<UserConfirmationDialogRequestPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserConfirmationDialogRequest>::Convert(*this);
  }


  UserConfirmationDialogRequest();

  explicit UserConfirmationDialogRequest(
      UserConfirmationDialogPayloadPtr payload);

UserConfirmationDialogRequest(const UserConfirmationDialogRequest&) = delete;
UserConfirmationDialogRequest& operator=(const UserConfirmationDialogRequest&) = delete;

  ~UserConfirmationDialogRequest();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserConfirmationDialogRequestPtr>
  UserConfirmationDialogRequestPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserConfirmationDialogRequest::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserConfirmationDialogRequest::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserConfirmationDialogRequest::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserConfirmationDialogRequest_UnserializedMessageContext<
            UserType, UserConfirmationDialogRequest::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserConfirmationDialogRequest::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserConfirmationDialogRequest::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserConfirmationDialogRequest_UnserializedMessageContext<
            UserType, UserConfirmationDialogRequest::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserConfirmationDialogRequest::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  UserConfirmationDialogPayloadPtr payload;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  UserConfirmationDialogResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<UserConfirmationDialogResponse, T>::value>;
  using DataView = UserConfirmationDialogResponseDataView;
  using Data_ = internal::UserConfirmationDialogResponse_Data;

  template <typename... Args>
  static UserConfirmationDialogResponsePtr New(Args&&... args) {
    return UserConfirmationDialogResponsePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static UserConfirmationDialogResponsePtr From(const U& u) {
    return mojo::TypeConverter<UserConfirmationDialogResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, UserConfirmationDialogResponse>::Convert(*this);
  }


  UserConfirmationDialogResponse();

  explicit UserConfirmationDialogResponse(
      UserConfirmationDialogResultPtr result);

UserConfirmationDialogResponse(const UserConfirmationDialogResponse&) = delete;
UserConfirmationDialogResponse& operator=(const UserConfirmationDialogResponse&) = delete;

  ~UserConfirmationDialogResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = UserConfirmationDialogResponsePtr>
  UserConfirmationDialogResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserConfirmationDialogResponse::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        UserConfirmationDialogResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        UserConfirmationDialogResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::UserConfirmationDialogResponse_UnserializedMessageContext<
            UserType, UserConfirmationDialogResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<UserConfirmationDialogResponse::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return UserConfirmationDialogResponse::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::UserConfirmationDialogResponse_UnserializedMessageContext<
            UserType, UserConfirmationDialogResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<UserConfirmationDialogResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  UserConfirmationDialogResultPtr result;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
UserConfirmationDialogPayloadPtr UserConfirmationDialogPayload::Clone() const {
  switch (tag_) {
    case Tag::kNavigationOrigin:
      return NewNavigationOrigin(
          mojo::Clone(data_.navigation_origin));
    case Tag::kDownloadId:
      return NewDownloadId(
          mojo::Clone(data_.download_id));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UserConfirmationDialogPayload>::value>::type*>
bool UserConfirmationDialogPayload::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNavigationOrigin:
      return mojo::Equals(data_.navigation_origin, other.data_.navigation_origin);
    case Tag::kDownloadId:
      return mojo::Equals(data_.download_id, other.data_.download_id);
  }

  return false;
}
template <typename UnionPtrType>
UserConfirmationDialogResultPtr UserConfirmationDialogResult::Clone() const {
  switch (tag_) {
    case Tag::kPermissionGranted:
      return NewPermissionGranted(
          mojo::Clone(data_.permission_granted));
    case Tag::kErrorReason:
      return NewErrorReason(
          mojo::Clone(data_.error_reason));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, UserConfirmationDialogResult>::value>::type*>
bool UserConfirmationDialogResult::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kPermissionGranted:
      return mojo::Equals(data_.permission_granted, other.data_.permission_granted);
    case Tag::kErrorReason:
      return mojo::Equals(data_.error_reason, other.data_.error_reason);
  }

  return false;
}
template <typename StructPtrType>
TaskOptionsPtr TaskOptions::Clone() const {
  return New(
      mojo::Clone(title)
  );
}

template <typename T, TaskOptions::EnableIfSame<T>*>
bool TaskOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  return true;
}

template <typename T, TaskOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  return false;
}
template <typename StructPtrType>
CredentialPtr Credential::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(username),
      mojo::Clone(source_site_or_app)
  );
}

template <typename T, Credential::EnableIfSame<T>*>
bool Credential::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->username, other_struct.username))
    return false;
  if (!mojo::Equals(this->source_site_or_app, other_struct.source_site_or_app))
    return false;
  return true;
}

template <typename T, Credential::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.username < rhs.username)
    return true;
  if (rhs.username < lhs.username)
    return false;
  if (lhs.source_site_or_app < rhs.source_site_or_app)
    return true;
  if (rhs.source_site_or_app < lhs.source_site_or_app)
    return false;
  return false;
}
template <typename StructPtrType>
SelectCredentialDialogRequestPtr SelectCredentialDialogRequest::Clone() const {
  return New(
      mojo::Clone(task_id),
      mojo::Clone(show_dialog),
      mojo::Clone(credentials),
      mojo::Clone(icons)
  );
}

template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>*>
bool SelectCredentialDialogRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->task_id, other_struct.task_id))
    return false;
  if (!mojo::Equals(this->show_dialog, other_struct.show_dialog))
    return false;
  if (!mojo::Equals(this->credentials, other_struct.credentials))
    return false;
  if (!mojo::Equals(this->icons, other_struct.icons))
    return false;
  return true;
}

template <typename T, SelectCredentialDialogRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.task_id < rhs.task_id)
    return true;
  if (rhs.task_id < lhs.task_id)
    return false;
  if (lhs.show_dialog < rhs.show_dialog)
    return true;
  if (rhs.show_dialog < lhs.show_dialog)
    return false;
  if (lhs.credentials < rhs.credentials)
    return true;
  if (rhs.credentials < lhs.credentials)
    return false;
  if (lhs.icons < rhs.icons)
    return true;
  if (rhs.icons < lhs.icons)
    return false;
  return false;
}
template <typename StructPtrType>
SelectCredentialDialogResponsePtr SelectCredentialDialogResponse::Clone() const {
  return New(
      mojo::Clone(task_id),
      mojo::Clone(error_reason),
      mojo::Clone(permission_duration),
      mojo::Clone(selected_credential_id)
  );
}

template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>*>
bool SelectCredentialDialogResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->task_id, other_struct.task_id))
    return false;
  if (!mojo::Equals(this->error_reason, other_struct.error_reason))
    return false;
  if (!mojo::Equals(this->permission_duration, other_struct.permission_duration))
    return false;
  if (!mojo::Equals(this->selected_credential_id, other_struct.selected_credential_id))
    return false;
  return true;
}

template <typename T, SelectCredentialDialogResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.task_id < rhs.task_id)
    return true;
  if (rhs.task_id < lhs.task_id)
    return false;
  if (lhs.error_reason < rhs.error_reason)
    return true;
  if (rhs.error_reason < lhs.error_reason)
    return false;
  if (lhs.permission_duration < rhs.permission_duration)
    return true;
  if (rhs.permission_duration < lhs.permission_duration)
    return false;
  if (lhs.selected_credential_id < rhs.selected_credential_id)
    return true;
  if (rhs.selected_credential_id < lhs.selected_credential_id)
    return false;
  return false;
}
template <typename StructPtrType>
UserConfirmationDialogRequestPtr UserConfirmationDialogRequest::Clone() const {
  return New(
      mojo::Clone(payload)
  );
}

template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>*>
bool UserConfirmationDialogRequest::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->payload, other_struct.payload))
    return false;
  return true;
}

template <typename T, UserConfirmationDialogRequest::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.payload < rhs.payload)
    return true;
  if (rhs.payload < lhs.payload)
    return false;
  return false;
}
template <typename StructPtrType>
UserConfirmationDialogResponsePtr UserConfirmationDialogResponse::Clone() const {
  return New(
      mojo::Clone(result)
  );
}

template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>*>
bool UserConfirmationDialogResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->result, other_struct.result))
    return false;
  return true;
}

template <typename T, UserConfirmationDialogResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.result < rhs.result)
    return true;
  if (rhs.result < lhs.result)
    return false;
  return false;
}


}  // actor::webui::mojom

namespace mojo {


template <>
struct  StructTraits<::actor::webui::mojom::TaskOptions::DataView,
                                         ::actor::webui::mojom::TaskOptionsPtr> {
  static bool IsNull(const ::actor::webui::mojom::TaskOptionsPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::TaskOptionsPtr* output) { output->reset(); }

  static const decltype(::actor::webui::mojom::TaskOptions::title)& title(
      const ::actor::webui::mojom::TaskOptionsPtr& input) {
    return input->title;
  }

  static bool Read(::actor::webui::mojom::TaskOptions::DataView input, ::actor::webui::mojom::TaskOptionsPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::Credential::DataView,
                                         ::actor::webui::mojom::CredentialPtr> {
  static bool IsNull(const ::actor::webui::mojom::CredentialPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::CredentialPtr* output) { output->reset(); }

  static decltype(::actor::webui::mojom::Credential::id) id(
      const ::actor::webui::mojom::CredentialPtr& input) {
    return input->id;
  }

  static const decltype(::actor::webui::mojom::Credential::username)& username(
      const ::actor::webui::mojom::CredentialPtr& input) {
    return input->username;
  }

  static const decltype(::actor::webui::mojom::Credential::source_site_or_app)& source_site_or_app(
      const ::actor::webui::mojom::CredentialPtr& input) {
    return input->source_site_or_app;
  }

  static bool Read(::actor::webui::mojom::Credential::DataView input, ::actor::webui::mojom::CredentialPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::SelectCredentialDialogRequest::DataView,
                                         ::actor::webui::mojom::SelectCredentialDialogRequestPtr> {
  static bool IsNull(const ::actor::webui::mojom::SelectCredentialDialogRequestPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::SelectCredentialDialogRequestPtr* output) { output->reset(); }

  static decltype(::actor::webui::mojom::SelectCredentialDialogRequest::task_id) task_id(
      const ::actor::webui::mojom::SelectCredentialDialogRequestPtr& input) {
    return input->task_id;
  }

  static decltype(::actor::webui::mojom::SelectCredentialDialogRequest::show_dialog) show_dialog(
      const ::actor::webui::mojom::SelectCredentialDialogRequestPtr& input) {
    return input->show_dialog;
  }

  static const decltype(::actor::webui::mojom::SelectCredentialDialogRequest::credentials)& credentials(
      const ::actor::webui::mojom::SelectCredentialDialogRequestPtr& input) {
    return input->credentials;
  }

  static  decltype(::actor::webui::mojom::SelectCredentialDialogRequest::icons)& icons(
       ::actor::webui::mojom::SelectCredentialDialogRequestPtr& input) {
    return input->icons;
  }

  static bool Read(::actor::webui::mojom::SelectCredentialDialogRequest::DataView input, ::actor::webui::mojom::SelectCredentialDialogRequestPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::SelectCredentialDialogResponse::DataView,
                                         ::actor::webui::mojom::SelectCredentialDialogResponsePtr> {
  static bool IsNull(const ::actor::webui::mojom::SelectCredentialDialogResponsePtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::SelectCredentialDialogResponsePtr* output) { output->reset(); }

  static decltype(::actor::webui::mojom::SelectCredentialDialogResponse::task_id) task_id(
      const ::actor::webui::mojom::SelectCredentialDialogResponsePtr& input) {
    return input->task_id;
  }

  static decltype(::actor::webui::mojom::SelectCredentialDialogResponse::error_reason) error_reason(
      const ::actor::webui::mojom::SelectCredentialDialogResponsePtr& input) {
    return input->error_reason;
  }

  static decltype(::actor::webui::mojom::SelectCredentialDialogResponse::permission_duration) permission_duration(
      const ::actor::webui::mojom::SelectCredentialDialogResponsePtr& input) {
    return input->permission_duration;
  }

  static decltype(::actor::webui::mojom::SelectCredentialDialogResponse::selected_credential_id) selected_credential_id(
      const ::actor::webui::mojom::SelectCredentialDialogResponsePtr& input) {
    return input->selected_credential_id;
  }

  static bool Read(::actor::webui::mojom::SelectCredentialDialogResponse::DataView input, ::actor::webui::mojom::SelectCredentialDialogResponsePtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::UserConfirmationDialogRequest::DataView,
                                         ::actor::webui::mojom::UserConfirmationDialogRequestPtr> {
  static bool IsNull(const ::actor::webui::mojom::UserConfirmationDialogRequestPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::UserConfirmationDialogRequestPtr* output) { output->reset(); }

  static const decltype(::actor::webui::mojom::UserConfirmationDialogRequest::payload)& payload(
      const ::actor::webui::mojom::UserConfirmationDialogRequestPtr& input) {
    return input->payload;
  }

  static bool Read(::actor::webui::mojom::UserConfirmationDialogRequest::DataView input, ::actor::webui::mojom::UserConfirmationDialogRequestPtr* output);
};


template <>
struct  StructTraits<::actor::webui::mojom::UserConfirmationDialogResponse::DataView,
                                         ::actor::webui::mojom::UserConfirmationDialogResponsePtr> {
  static bool IsNull(const ::actor::webui::mojom::UserConfirmationDialogResponsePtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::UserConfirmationDialogResponsePtr* output) { output->reset(); }

  static const decltype(::actor::webui::mojom::UserConfirmationDialogResponse::result)& result(
      const ::actor::webui::mojom::UserConfirmationDialogResponsePtr& input) {
    return input->result;
  }

  static bool Read(::actor::webui::mojom::UserConfirmationDialogResponse::DataView input, ::actor::webui::mojom::UserConfirmationDialogResponsePtr* output);
};


template <>
struct  UnionTraits<::actor::webui::mojom::UserConfirmationDialogPayload::DataView,
                                        ::actor::webui::mojom::UserConfirmationDialogPayloadPtr> {
  static bool IsNull(const ::actor::webui::mojom::UserConfirmationDialogPayloadPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::UserConfirmationDialogPayloadPtr* output) { output->reset(); }

  static ::actor::webui::mojom::UserConfirmationDialogPayload::Tag GetTag(const ::actor::webui::mojom::UserConfirmationDialogPayloadPtr& input) {
    return input->which();
  }

  static const ::url::Origin& navigation_origin(const ::actor::webui::mojom::UserConfirmationDialogPayloadPtr& input) {
    return input->get_navigation_origin();
  }

  static  int32_t download_id(const ::actor::webui::mojom::UserConfirmationDialogPayloadPtr& input) {
    return input->get_download_id();
  }

  static bool Read(::actor::webui::mojom::UserConfirmationDialogPayload::DataView input, ::actor::webui::mojom::UserConfirmationDialogPayloadPtr* output);
};


template <>
struct  UnionTraits<::actor::webui::mojom::UserConfirmationDialogResult::DataView,
                                        ::actor::webui::mojom::UserConfirmationDialogResultPtr> {
  static bool IsNull(const ::actor::webui::mojom::UserConfirmationDialogResultPtr& input) { return !input; }
  static void SetToNull(::actor::webui::mojom::UserConfirmationDialogResultPtr* output) { output->reset(); }

  static ::actor::webui::mojom::UserConfirmationDialogResult::Tag GetTag(const ::actor::webui::mojom::UserConfirmationDialogResultPtr& input) {
    return input->which();
  }

  static  bool permission_granted(const ::actor::webui::mojom::UserConfirmationDialogResultPtr& input) {
    return input->get_permission_granted();
  }

  static  ::actor::webui::mojom::UserConfirmationDialogErrorReason error_reason(const ::actor::webui::mojom::UserConfirmationDialogResultPtr& input) {
    return input->get_error_reason();
  }

  static bool Read(::actor::webui::mojom::UserConfirmationDialogResult::DataView input, ::actor::webui::mojom::UserConfirmationDialogResultPtr* output);
};

}  // namespace mojo

#endif  // CHROME_COMMON_ACTOR_WEBUI_MOJOM_H_