// chrome/common/actor_webui.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/common/actor_webui.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/actor_webui.mojom-params-data.h"
#include "chrome/common/actor_webui.mojom-shared-message-ids.h"

#include "chrome/common/actor_webui.mojom-import-headers.h"
#include "chrome/common/actor_webui.mojom-test-utils.h"


namespace actor::webui::mojom {
TaskOptions::TaskOptions()
    : title() {}

TaskOptions::TaskOptions(
    const std::optional<std::string>& title_in)
    : title(std::move(title_in)) {}

TaskOptions::~TaskOptions() = default;

void TaskOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TaskOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Credential::Credential()
    : id(),
      username(),
      source_site_or_app() {}

Credential::Credential(
    int32_t id_in,
    const std::string& username_in,
    const std::string& source_site_or_app_in)
    : id(std::move(id_in)),
      username(std::move(username_in)),
      source_site_or_app(std::move(source_site_or_app_in)) {}

Credential::~Credential() = default;
size_t Credential::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->username);
  seed = mojo::internal::Hash(seed, this->source_site_or_app);
  return seed;
}

void Credential::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "username"), this->username,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_site_or_app"), this->source_site_or_app,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Credential::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectCredentialDialogRequest::SelectCredentialDialogRequest()
    : task_id(),
      show_dialog(),
      credentials(),
      icons() {}

SelectCredentialDialogRequest::SelectCredentialDialogRequest(
    int32_t task_id_in,
    bool show_dialog_in,
    std::vector<CredentialPtr> credentials_in,
    const base::flat_map<std::string, ::SkBitmap>& icons_in)
    : task_id(std::move(task_id_in)),
      show_dialog(std::move(show_dialog_in)),
      credentials(std::move(credentials_in)),
      icons(std::move(icons_in)) {}

SelectCredentialDialogRequest::~SelectCredentialDialogRequest() = default;

void SelectCredentialDialogRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "task_id"), this->task_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_dialog"), this->show_dialog,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "credentials"), this->credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<CredentialPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icons"), this->icons,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const base::flat_map<std::string, ::SkBitmap>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectCredentialDialogRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectCredentialDialogResponse::SelectCredentialDialogResponse()
    : task_id(),
      error_reason(),
      permission_duration(),
      selected_credential_id() {}

SelectCredentialDialogResponse::SelectCredentialDialogResponse(
    int32_t task_id_in,
    std::optional<SelectCredentialDialogErrorReason> error_reason_in,
    std::optional<UserGrantedPermissionDuration> permission_duration_in,
    std::optional<int32_t> selected_credential_id_in)
    : task_id(std::move(task_id_in)),
      error_reason(std::move(error_reason_in)),
      permission_duration(std::move(permission_duration_in)),
      selected_credential_id(std::move(selected_credential_id_in)) {}

SelectCredentialDialogResponse::~SelectCredentialDialogResponse() = default;

void SelectCredentialDialogResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "task_id"), this->task_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "error_reason"), this->error_reason,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<SelectCredentialDialogErrorReason>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "permission_duration"), this->permission_duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<UserGrantedPermissionDuration>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_credential_id"), this->selected_credential_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<int32_t>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectCredentialDialogResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UserConfirmationDialogRequest::UserConfirmationDialogRequest()
    : payload() {}

UserConfirmationDialogRequest::UserConfirmationDialogRequest(
    UserConfirmationDialogPayloadPtr payload_in)
    : payload(std::move(payload_in)) {}

UserConfirmationDialogRequest::~UserConfirmationDialogRequest() = default;

void UserConfirmationDialogRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payload"), this->payload,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UserConfirmationDialogPayloadPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UserConfirmationDialogRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UserConfirmationDialogResponse::UserConfirmationDialogResponse()
    : result() {}

UserConfirmationDialogResponse::UserConfirmationDialogResponse(
    UserConfirmationDialogResultPtr result_in)
    : result(std::move(result_in)) {}

UserConfirmationDialogResponse::~UserConfirmationDialogResponse() = default;
size_t UserConfirmationDialogResponse::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->result);
  return seed;
}

void UserConfirmationDialogResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result"), this->result,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UserConfirmationDialogResultPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UserConfirmationDialogResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UserConfirmationDialogPayloadPtr
UserConfirmationDialogPayload::NewNavigationOrigin(
    const ::url::Origin& value) {
  return UserConfirmationDialogPayloadPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kNavigationOrigin)>,
      std::move(value));
}

UserConfirmationDialogPayloadPtr
UserConfirmationDialogPayload::NewDownloadId(
    int32_t value) {
  return UserConfirmationDialogPayloadPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kDownloadId)>,
      std::move(value));
}

UserConfirmationDialogPayload::UserConfirmationDialogPayload(
    std::in_place_index_t<static_cast<size_t>(Tag::kNavigationOrigin)>,
    const ::url::Origin& value)
    : tag_(Tag::kNavigationOrigin),
      data_(std::in_place_index<static_cast<size_t>(Tag::kNavigationOrigin)>,
            std::move(value)) {}

UserConfirmationDialogPayload::UserConfirmationDialogPayload(
    std::in_place_index_t<static_cast<size_t>(Tag::kDownloadId)>,
    int32_t value)
    : tag_(Tag::kDownloadId),
      data_(std::in_place_index<static_cast<size_t>(Tag::kDownloadId)>,
            std::move(value)) {}
UserConfirmationDialogPayload::~UserConfirmationDialogPayload() {
  DestroyActive();
}

void UserConfirmationDialogPayload::set_navigation_origin(const ::url::Origin& navigation_origin) {
  if (tag_ == Tag::kNavigationOrigin) {
    data_.navigation_origin = std::move(navigation_origin);
  } else {
    DestroyActive();
    tag_ = Tag::kNavigationOrigin;
    new (&data_.navigation_origin) ::url::Origin(
        std::move(navigation_origin));
  }
}

void UserConfirmationDialogPayload::set_download_id(int32_t download_id) {
  if (tag_ != Tag::kDownloadId) {
    DestroyActive();
    tag_ = Tag::kDownloadId;
  }
  data_.download_id = download_id;
}


UserConfirmationDialogPayload::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kNavigationOrigin)>,
    const ::url::Origin& value)
    : navigation_origin(std::move(value)) {}

UserConfirmationDialogPayload::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kDownloadId)>,
    int32_t value)
    : download_id(std::move(value)) {}

void UserConfirmationDialogPayload::DestroyActive() {
  switch (tag_) {

    case Tag::kNavigationOrigin:
      std::destroy_at(&data_.navigation_origin);
      break;
    case Tag::kDownloadId:
      std::destroy_at(&data_.download_id);
      break;
  }
}

bool UserConfirmationDialogPayload::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
UserConfirmationDialogResultPtr
UserConfirmationDialogResult::NewPermissionGranted(
    bool value) {
  return UserConfirmationDialogResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPermissionGranted)>,
      std::move(value));
}

UserConfirmationDialogResultPtr
UserConfirmationDialogResult::NewErrorReason(
    UserConfirmationDialogErrorReason value) {
  return UserConfirmationDialogResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
      std::move(value));
}

UserConfirmationDialogResult::UserConfirmationDialogResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
    bool value)
    : tag_(Tag::kPermissionGranted),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPermissionGranted)>,
            std::move(value)) {}

UserConfirmationDialogResult::UserConfirmationDialogResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    UserConfirmationDialogErrorReason value)
    : tag_(Tag::kErrorReason),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorReason)>,
            std::move(value)) {}
UserConfirmationDialogResult::~UserConfirmationDialogResult() {
  DestroyActive();
}

void UserConfirmationDialogResult::set_permission_granted(bool permission_granted) {
  if (tag_ != Tag::kPermissionGranted) {
    DestroyActive();
    tag_ = Tag::kPermissionGranted;
  }
  data_.permission_granted = permission_granted;
}

void UserConfirmationDialogResult::set_error_reason(UserConfirmationDialogErrorReason error_reason) {
  if (tag_ != Tag::kErrorReason) {
    DestroyActive();
    tag_ = Tag::kErrorReason;
  }
  data_.error_reason = error_reason;
}


UserConfirmationDialogResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPermissionGranted)>,
    bool value)
    : permission_granted(std::move(value)) {}

UserConfirmationDialogResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorReason)>,
    UserConfirmationDialogErrorReason value)
    : error_reason(std::move(value)) {}

void UserConfirmationDialogResult::DestroyActive() {
  switch (tag_) {

    case Tag::kPermissionGranted:
      std::destroy_at(&data_.permission_granted);
      break;
    case Tag::kErrorReason:
      std::destroy_at(&data_.error_reason);
      break;
  }
}
size_t UserConfirmationDialogResult::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kPermissionGranted:
      return mojo::internal::Hash(seed, data_.permission_granted);
    case Tag::kErrorReason:
      return mojo::internal::Hash(seed, data_.error_reason);
    default:
      NOTREACHED();
  }
}

bool UserConfirmationDialogResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}


}  // actor::webui::mojom


namespace mojo {


// static
bool StructTraits<::actor::webui::mojom::TaskOptions::DataView, ::actor::webui::mojom::TaskOptionsPtr>::Read(
    ::actor::webui::mojom::TaskOptions::DataView input,
    ::actor::webui::mojom::TaskOptionsPtr* output) {
  bool success = true;
  ::actor::webui::mojom::TaskOptionsPtr result(::actor::webui::mojom::TaskOptions::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::Credential::DataView, ::actor::webui::mojom::CredentialPtr>::Read(
    ::actor::webui::mojom::Credential::DataView input,
    ::actor::webui::mojom::CredentialPtr* output) {
  bool success = true;
  ::actor::webui::mojom::CredentialPtr result(::actor::webui::mojom::Credential::New());
  
      if (success)
        result->id = input.id();
      if (success && !input.ReadUsername(&result->username))
        success = false;
      if (success && !input.ReadSourceSiteOrApp(&result->source_site_or_app))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::SelectCredentialDialogRequest::DataView, ::actor::webui::mojom::SelectCredentialDialogRequestPtr>::Read(
    ::actor::webui::mojom::SelectCredentialDialogRequest::DataView input,
    ::actor::webui::mojom::SelectCredentialDialogRequestPtr* output) {
  bool success = true;
  ::actor::webui::mojom::SelectCredentialDialogRequestPtr result(::actor::webui::mojom::SelectCredentialDialogRequest::New());
  
      if (success)
        result->task_id = input.task_id();
      if (success)
        result->show_dialog = input.show_dialog();
      if (success && !input.ReadCredentials(&result->credentials))
        success = false;
      if (success && !input.ReadIcons(&result->icons))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::SelectCredentialDialogResponse::DataView, ::actor::webui::mojom::SelectCredentialDialogResponsePtr>::Read(
    ::actor::webui::mojom::SelectCredentialDialogResponse::DataView input,
    ::actor::webui::mojom::SelectCredentialDialogResponsePtr* output) {
  bool success = true;
  ::actor::webui::mojom::SelectCredentialDialogResponsePtr result(::actor::webui::mojom::SelectCredentialDialogResponse::New());
  
      if (success)
        result->task_id = input.task_id();
      if (success && !input.ReadErrorReason(&result->error_reason)) {
        success = false;
      }
      if (success && !input.ReadPermissionDuration(&result->permission_duration)) {
        success = false;
      }
      if (success) {
        result->selected_credential_id = input.selected_credential_id();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::UserConfirmationDialogRequest::DataView, ::actor::webui::mojom::UserConfirmationDialogRequestPtr>::Read(
    ::actor::webui::mojom::UserConfirmationDialogRequest::DataView input,
    ::actor::webui::mojom::UserConfirmationDialogRequestPtr* output) {
  bool success = true;
  ::actor::webui::mojom::UserConfirmationDialogRequestPtr result(::actor::webui::mojom::UserConfirmationDialogRequest::New());
  
      if (success && !input.ReadPayload(&result->payload))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::actor::webui::mojom::UserConfirmationDialogResponse::DataView, ::actor::webui::mojom::UserConfirmationDialogResponsePtr>::Read(
    ::actor::webui::mojom::UserConfirmationDialogResponse::DataView input,
    ::actor::webui::mojom::UserConfirmationDialogResponsePtr* output) {
  bool success = true;
  ::actor::webui::mojom::UserConfirmationDialogResponsePtr result(::actor::webui::mojom::UserConfirmationDialogResponse::New());
  
      if (success && !input.ReadResult(&result->result))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::actor::webui::mojom::UserConfirmationDialogPayload::DataView, ::actor::webui::mojom::UserConfirmationDialogPayloadPtr>::Read(
    ::actor::webui::mojom::UserConfirmationDialogPayload::DataView input,
    ::actor::webui::mojom::UserConfirmationDialogPayloadPtr* output) {
  using UnionType = ::actor::webui::mojom::UserConfirmationDialogPayload;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kNavigationOrigin: {
      ::url::Origin result_navigation_origin{};
      if (!input.ReadNavigationOrigin(&result_navigation_origin))
        return false;

      *output = UnionType::NewNavigationOrigin(
          std::move(result_navigation_origin));
      break;
    }
    case Tag::kDownloadId: {
      *output = UnionType::NewDownloadId(input.download_id());
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::actor::webui::mojom::UserConfirmationDialogResult::DataView, ::actor::webui::mojom::UserConfirmationDialogResultPtr>::Read(
    ::actor::webui::mojom::UserConfirmationDialogResult::DataView input,
    ::actor::webui::mojom::UserConfirmationDialogResultPtr* output) {
  using UnionType = ::actor::webui::mojom::UserConfirmationDialogResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kPermissionGranted: {
      *output = UnionType::NewPermissionGranted(input.permission_granted());
      break;
    }
    case Tag::kErrorReason: {
      ::actor::webui::mojom::UserConfirmationDialogErrorReason result_error_reason;
      if (!input.ReadErrorReason(&result_error_reason))
        return false;

      *output = UnionType::NewErrorReason(result_error_reason);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace actor::webui::mojom {




}  // actor::webui::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif