// chrome/common/actor_webui.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_WEBUI_MOJOM_SHARED_H_
#define CHROME_COMMON_ACTOR_WEBUI_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/actor_webui.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/common/actor_webui.mojom-data-view.h"




namespace std {

template <>
struct hash<::actor::webui::mojom::UserGrantedPermissionDuration>
    : public mojo::internal::EnumHashImpl<::actor::webui::mojom::UserGrantedPermissionDuration> {};

template <>
struct hash<::actor::webui::mojom::SelectCredentialDialogErrorReason>
    : public mojo::internal::EnumHashImpl<::actor::webui::mojom::SelectCredentialDialogErrorReason> {};

template <>
struct hash<::actor::webui::mojom::UserConfirmationDialogErrorReason>
    : public mojo::internal::EnumHashImpl<::actor::webui::mojom::UserConfirmationDialogErrorReason> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserGrantedPermissionDuration, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::webui::mojom::UserGrantedPermissionDuration, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::UserGrantedPermissionDuration>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::SelectCredentialDialogErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::webui::mojom::SelectCredentialDialogErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::SelectCredentialDialogErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserConfirmationDialogErrorReason, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::webui::mojom::UserConfirmationDialogErrorReason, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::webui::mojom::UserConfirmationDialogErrorReason>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::TaskOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::TaskOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::TaskOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());
  }

  static bool Deserialize(::actor::webui::mojom::internal::TaskOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::TaskOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::CredentialDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::CredentialDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::Credential_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::username(input)) in_username = Traits::username(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->username)::BaseType> username_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_username,
      username_fragment);

    fragment->username.Set(
        username_fragment.is_null() ? nullptr : username_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->username.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null username in Credential struct");

    decltype(Traits::source_site_or_app(input)) in_source_site_or_app = Traits::source_site_or_app(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_site_or_app)::BaseType> source_site_or_app_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_source_site_or_app,
      source_site_or_app_fragment);

    fragment->source_site_or_app.Set(
        source_site_or_app_fragment.is_null() ? nullptr : source_site_or_app_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->source_site_or_app.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_site_or_app in Credential struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::Credential_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::CredentialDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::SelectCredentialDialogRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::SelectCredentialDialogRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::SelectCredentialDialogRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->task_id = Traits::task_id(input);

    fragment->show_dialog = Traits::show_dialog(input);

    decltype(Traits::credentials(input)) in_credentials = Traits::credentials(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->credentials)::BaseType>
        credentials_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& credentials_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::actor::webui::mojom::CredentialDataView>>(
      in_credentials,
      credentials_fragment,
      &credentials_validate_params);

    fragment->credentials.Set(
        credentials_fragment.is_null() ? nullptr : credentials_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->credentials.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credentials in SelectCredentialDialogRequest struct");

    decltype(Traits::icons(input)) in_icons = Traits::icons(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icons)::BaseType>
        icons_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icons_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>>(
      in_icons,
      icons_fragment,
      &icons_validate_params);

    fragment->icons.Set(
        icons_fragment.is_null() ? nullptr : icons_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icons.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icons in SelectCredentialDialogRequest struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::SelectCredentialDialogRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::SelectCredentialDialogRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::SelectCredentialDialogResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::SelectCredentialDialogResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::SelectCredentialDialogResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->task_id = Traits::task_id(input);
    fragment->error_reason_$flag = Traits::error_reason(input).has_value();
    if (Traits::error_reason(input).has_value()) {
      
      mojo::internal::Serialize<::actor::webui::mojom::SelectCredentialDialogErrorReason>(
        Traits::error_reason(input).value(),
        &fragment->error_reason_$value);
    } else {
      fragment->error_reason_$value =
          static_cast<int32_t>(::actor::webui::mojom::SelectCredentialDialogErrorReason::kMinValue);
    }
    fragment->permission_duration_$flag = Traits::permission_duration(input).has_value();
    if (Traits::permission_duration(input).has_value()) {
      
      mojo::internal::Serialize<::actor::webui::mojom::UserGrantedPermissionDuration>(
        Traits::permission_duration(input).value(),
        &fragment->permission_duration_$value);
    } else {
      fragment->permission_duration_$value =
          static_cast<int32_t>(::actor::webui::mojom::UserGrantedPermissionDuration::kMinValue);
    }
    fragment->selected_credential_id_$flag = Traits::selected_credential_id(input).has_value();
    if (Traits::selected_credential_id(input).has_value()) {
      fragment->selected_credential_id_$value = Traits::selected_credential_id(input).value();
    }
  }

  static bool Deserialize(::actor::webui::mojom::internal::SelectCredentialDialogResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::SelectCredentialDialogResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserConfirmationDialogRequestDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::UserConfirmationDialogRequestDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogRequest_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::payload(input)) in_payload = Traits::payload(input);
    mojo::internal::MessageFragment<decltype(fragment->payload)>
        payload_fragment(fragment.message());
    payload_fragment.Claim(&fragment->payload);
    
    mojo::internal::Serialize<::actor::webui::mojom::UserConfirmationDialogPayloadDataView>(
      in_payload,
      payload_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->payload.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null payload in UserConfirmationDialogRequest struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::UserConfirmationDialogRequest_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::UserConfirmationDialogRequestDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserConfirmationDialogResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::webui::mojom::UserConfirmationDialogResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::result(input)) in_result = Traits::result(input);
    mojo::internal::MessageFragment<decltype(fragment->result)>
        result_fragment(fragment.message());
    result_fragment.Claim(&fragment->result);
    
    mojo::internal::Serialize<::actor::webui::mojom::UserConfirmationDialogResultDataView>(
      in_result,
      result_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->result.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in UserConfirmationDialogResponse struct");
  }

  static bool Deserialize(::actor::webui::mojom::internal::UserConfirmationDialogResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::UserConfirmationDialogResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserConfirmationDialogPayloadDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::webui::mojom::UserConfirmationDialogPayloadDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogPayload_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::webui::mojom::UserConfirmationDialogPayloadDataView::Tag::kNavigationOrigin: {
    decltype(Traits::navigation_origin(input))
    in_navigation_origin = Traits::navigation_origin(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_navigation_origin)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::url::mojom::OriginDataView>(
  in_navigation_origin,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null navigation_origin in UserConfirmationDialogPayload union");
    fragment->data.f_navigation_origin.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::webui::mojom::UserConfirmationDialogPayloadDataView::Tag::kDownloadId: {
    decltype(Traits::download_id(input))
    in_download_id = Traits::download_id(input);
    fragment->data.f_download_id = in_download_id;
    break;
  }
}
  }

  static bool Deserialize(::actor::webui::mojom::internal::UserConfirmationDialogPayload_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::UserConfirmationDialogPayloadDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::webui::mojom::UserConfirmationDialogResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::webui::mojom::UserConfirmationDialogResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::webui::mojom::internal::UserConfirmationDialogResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::webui::mojom::UserConfirmationDialogResultDataView::Tag::kPermissionGranted: {
    decltype(Traits::permission_granted(input))
    in_permission_granted = Traits::permission_granted(input);
    fragment->data.f_permission_granted = in_permission_granted;
    break;
  }
  case ::actor::webui::mojom::UserConfirmationDialogResultDataView::Tag::kErrorReason: {
    decltype(Traits::error_reason(input))
    in_error_reason = Traits::error_reason(input);
        
mojo::internal::Serialize<::actor::webui::mojom::UserConfirmationDialogErrorReason>(
  in_error_reason,
  &fragment->data.f_error_reason);
    break;
  }
}
  }

  static bool Deserialize(::actor::webui::mojom::internal::UserConfirmationDialogResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::actor::webui::mojom::UserConfirmationDialogResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace actor::webui::mojom {

inline void TaskOptionsDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CredentialDataView::GetUsernameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->username.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CredentialDataView::GetSourceSiteOrAppDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->source_site_or_app.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SelectCredentialDialogRequestDataView::GetCredentialsDataView(
    mojo::ArrayDataView<CredentialDataView>* output) {
  auto pointer = data_->credentials.Get();
  *output = mojo::ArrayDataView<CredentialDataView>(pointer, message_);
}
inline void SelectCredentialDialogRequestDataView::GetIconsDataView(
    mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>* output) {
  auto pointer = data_->icons.Get();
  *output = mojo::MapDataView<mojo::StringDataView, ::skia::mojom::BitmapN32DataView>(pointer, message_);
}




inline void UserConfirmationDialogRequestDataView::GetPayloadDataView(
    UserConfirmationDialogPayloadDataView* output) {
  auto pointer = &data_->payload;
  *output = UserConfirmationDialogPayloadDataView(pointer, message_);
}


inline void UserConfirmationDialogResponseDataView::GetResultDataView(
    UserConfirmationDialogResultDataView* output) {
  auto pointer = &data_->result;
  *output = UserConfirmationDialogResultDataView(pointer, message_);
}


inline void UserConfirmationDialogPayloadDataView::GetNavigationOriginDataView(
    ::url::mojom::OriginDataView* output) const {
  CHECK(is_navigation_origin());
  *output = ::url::mojom::OriginDataView(data_->data.f_navigation_origin.Get(), message_);
}



}  // actor::webui::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::webui::mojom::UserGrantedPermissionDuration> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::webui::mojom::UserGrantedPermissionDuration value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::webui::mojom::SelectCredentialDialogErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::webui::mojom::SelectCredentialDialogErrorReason value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::webui::mojom::UserConfirmationDialogErrorReason> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::webui::mojom::UserConfirmationDialogErrorReason value);
};

} // namespace perfetto

#endif  // CHROME_COMMON_ACTOR_WEBUI_MOJOM_SHARED_H_