// chrome/common/actor_webui.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_WEBUI_MOJOM_SHARED_INTERNAL_H_
#define CHROME_COMMON_ACTOR_WEBUI_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "skia/public/mojom/bitmap.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace actor::webui::mojom {
namespace internal {
class TaskOptions_Data;
class Credential_Data;
class SelectCredentialDialogRequest_Data;
class SelectCredentialDialogResponse_Data;
class UserConfirmationDialogRequest_Data;
class UserConfirmationDialogResponse_Data;
class UserConfirmationDialogPayload_Data;
class UserConfirmationDialogResult_Data;

struct UserGrantedPermissionDuration_Data {
 public:
  static bool constexpr kIsExtensible = true;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct SelectCredentialDialogErrorReason_Data {
 public:
  static bool constexpr kIsExtensible = true;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct UserConfirmationDialogErrorReason_Data {
 public:
  static bool constexpr kIsExtensible = true;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  UserConfirmationDialogPayload_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  UserConfirmationDialogPayload_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~UserConfirmationDialogPayload_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<UserConfirmationDialogPayload_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class UserConfirmationDialogPayload_Tag : uint32_t {

    
    kNavigationOrigin,
    
    kDownloadId,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<::url::mojom::internal::Origin_Data> f_navigation_origin;
    int32_t f_download_id;
    uint64_t unknown;
  };

  uint32_t size;
  UserConfirmationDialogPayload_Tag tag;
  Union_ data;
};
static_assert(sizeof(UserConfirmationDialogPayload_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(UserConfirmationDialogPayload_Data)");


class  UserConfirmationDialogResult_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  UserConfirmationDialogResult_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~UserConfirmationDialogResult_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<UserConfirmationDialogResult_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class UserConfirmationDialogResult_Tag : uint32_t {

    
    kPermissionGranted,
    
    kErrorReason,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    uint8_t f_permission_granted : 1;
    int32_t f_error_reason;
    uint64_t unknown;
  };

  uint32_t size;
  UserConfirmationDialogResult_Tag tag;
  Union_ data;
};
static_assert(sizeof(UserConfirmationDialogResult_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(UserConfirmationDialogResult_Data)");
class  TaskOptions_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> title;

 private:
  friend class mojo::internal::MessageFragment<TaskOptions_Data>;

  TaskOptions_Data();
  ~TaskOptions_Data() = delete;
};
static_assert(sizeof(TaskOptions_Data) == 16,
              "Bad sizeof(TaskOptions_Data)");
// Used by TaskOptions::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct TaskOptions_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  TaskOptions_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~TaskOptions_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<TaskOptions_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    TaskOptions_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  Credential_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> username;
  mojo::internal::Pointer<mojo::internal::String_Data> source_site_or_app;

 private:
  friend class mojo::internal::MessageFragment<Credential_Data>;

  Credential_Data();
  ~Credential_Data() = delete;
};
static_assert(sizeof(Credential_Data) == 32,
              "Bad sizeof(Credential_Data)");
// Used by Credential::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Credential_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Credential_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Credential_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Credential_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Credential_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SelectCredentialDialogRequest_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t task_id;
  uint8_t show_dialog : 1;
  uint8_t pad1_[3];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::Credential_Data>>> credentials;
  mojo::internal::Pointer<mojo::internal::Map_Data<mojo::internal::Pointer<mojo::internal::String_Data>, mojo::internal::Pointer<::skia::mojom::internal::BitmapN32_Data>>> icons;

 private:
  friend class mojo::internal::MessageFragment<SelectCredentialDialogRequest_Data>;

  SelectCredentialDialogRequest_Data();
  ~SelectCredentialDialogRequest_Data() = delete;
};
static_assert(sizeof(SelectCredentialDialogRequest_Data) == 32,
              "Bad sizeof(SelectCredentialDialogRequest_Data)");
// Used by SelectCredentialDialogRequest::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SelectCredentialDialogRequest_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SelectCredentialDialogRequest_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SelectCredentialDialogRequest_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SelectCredentialDialogRequest_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SelectCredentialDialogRequest_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  SelectCredentialDialogResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t task_id;
  uint8_t error_reason_$flag : 1;
  uint8_t permission_duration_$flag : 1;
  uint8_t selected_credential_id_$flag : 1;
  uint8_t pad3_[3];
  int32_t error_reason_$value;
  int32_t permission_duration_$value;
  int32_t selected_credential_id_$value;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<SelectCredentialDialogResponse_Data>;

  SelectCredentialDialogResponse_Data();
  ~SelectCredentialDialogResponse_Data() = delete;
};
static_assert(sizeof(SelectCredentialDialogResponse_Data) == 32,
              "Bad sizeof(SelectCredentialDialogResponse_Data)");
// Used by SelectCredentialDialogResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct SelectCredentialDialogResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  SelectCredentialDialogResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~SelectCredentialDialogResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<SelectCredentialDialogResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    SelectCredentialDialogResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  UserConfirmationDialogRequest_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::UserConfirmationDialogPayload_Data payload;

 private:
  friend class mojo::internal::MessageFragment<UserConfirmationDialogRequest_Data>;

  UserConfirmationDialogRequest_Data();
  ~UserConfirmationDialogRequest_Data() = delete;
};
static_assert(sizeof(UserConfirmationDialogRequest_Data) == 24,
              "Bad sizeof(UserConfirmationDialogRequest_Data)");
// Used by UserConfirmationDialogRequest::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UserConfirmationDialogRequest_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UserConfirmationDialogRequest_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UserConfirmationDialogRequest_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<UserConfirmationDialogRequest_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UserConfirmationDialogRequest_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  UserConfirmationDialogResponse_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::UserConfirmationDialogResult_Data result;

 private:
  friend class mojo::internal::MessageFragment<UserConfirmationDialogResponse_Data>;

  UserConfirmationDialogResponse_Data();
  ~UserConfirmationDialogResponse_Data() = delete;
};
static_assert(sizeof(UserConfirmationDialogResponse_Data) == 24,
              "Bad sizeof(UserConfirmationDialogResponse_Data)");
// Used by UserConfirmationDialogResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct UserConfirmationDialogResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  UserConfirmationDialogResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~UserConfirmationDialogResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<UserConfirmationDialogResponse_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    UserConfirmationDialogResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // actor::webui::mojom

#endif  // CHROME_COMMON_ACTOR_WEBUI_MOJOM_SHARED_INTERNAL_H_