// chrome/common/actor.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_MOJOM_SHARED_H_
#define CHROME_COMMON_ACTOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/common/actor.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/common/actor.mojom-data-view.h"




namespace std {

template <>
struct hash<::actor::mojom::ActionResultCode>
    : public mojo::internal::EnumHashImpl<::actor::mojom::ActionResultCode> {};

template <>
struct hash<::actor::mojom::JournalEntryType>
    : public mojo::internal::EnumHashImpl<::actor::mojom::JournalEntryType> {};

template <>
struct hash<::actor::mojom::JournalTrack>
    : public mojo::internal::EnumHashImpl<::actor::mojom::JournalTrack> {};

template <>
struct hash<::actor::mojom::ClickAction_Type>
    : public mojo::internal::EnumHashImpl<::actor::mojom::ClickAction_Type> {};

template <>
struct hash<::actor::mojom::ClickAction_Count>
    : public mojo::internal::EnumHashImpl<::actor::mojom::ClickAction_Count> {};

template <>
struct hash<::actor::mojom::TypeAction_Mode>
    : public mojo::internal::EnumHashImpl<::actor::mojom::TypeAction_Mode> {};

template <>
struct hash<::actor::mojom::ScrollAction_ScrollDirection>
    : public mojo::internal::EnumHashImpl<::actor::mojom::ScrollAction_ScrollDirection> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ActionResultCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::mojom::ActionResultCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::mojom::ActionResultCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::JournalEntryType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::mojom::JournalEntryType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::mojom::JournalEntryType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::JournalTrack, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::mojom::JournalTrack, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::mojom::JournalTrack>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ClickAction_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::mojom::ClickAction_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::mojom::ClickAction_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ClickAction_Count, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::mojom::ClickAction_Count, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::mojom::ClickAction_Count>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::TypeAction_Mode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::mojom::TypeAction_Mode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::mojom::TypeAction_Mode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ScrollAction_ScrollDirection, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::actor::mojom::ScrollAction_ScrollDirection, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::actor::mojom::ScrollAction_ScrollDirection>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ObservedToolTargetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ObservedToolTargetDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ObservedToolTarget_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::node_attribute(input)) in_node_attribute = Traits::node_attribute(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->node_attribute)::BaseType> node_attribute_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::blink::mojom::AIPageContentAttributesDataView>(
      in_node_attribute,
      node_attribute_fragment);

    fragment->node_attribute.Set(
        node_attribute_fragment.is_null() ? nullptr : node_attribute_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->node_attribute.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null node_attribute in ObservedToolTarget struct");
  }

  static bool Deserialize(::actor::mojom::internal::ObservedToolTarget_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::ObservedToolTargetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ClickActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ClickActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ClickAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::actor::mojom::ClickAction_Type>(
      Traits::type(input),
      &fragment->type);

    
    mojo::internal::Serialize<::actor::mojom::ClickAction_Count>(
      Traits::count(input),
      &fragment->count);
  }

  static bool Deserialize(::actor::mojom::internal::ClickAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::ClickActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::MouseMoveActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::MouseMoveActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::MouseMoveAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::actor::mojom::internal::MouseMoveAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::MouseMoveActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ScrollToActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ScrollToActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ScrollToAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::actor::mojom::internal::ScrollToAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::ScrollToActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::TypeActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::TypeActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::TypeAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::actor::mojom::TypeAction_Mode>(
      Traits::mode(input),
      &fragment->mode);

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in TypeAction struct");

    fragment->follow_by_enter = Traits::follow_by_enter(input);
  }

  static bool Deserialize(::actor::mojom::internal::TypeAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::TypeActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ScrollActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ScrollActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ScrollAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::actor::mojom::ScrollAction_ScrollDirection>(
      Traits::direction(input),
      &fragment->direction);

    fragment->distance = Traits::distance(input);
  }

  static bool Deserialize(::actor::mojom::internal::ScrollAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::ScrollActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::SelectActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::SelectActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::SelectAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in SelectAction struct");
  }

  static bool Deserialize(::actor::mojom::internal::SelectAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::SelectActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::DragAndReleaseActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::DragAndReleaseActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::DragAndReleaseAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::to_target(input)) in_to_target = Traits::to_target(input);
    mojo::internal::MessageFragment<decltype(fragment->to_target)>
        to_target_fragment(fragment.message());
    to_target_fragment.Claim(&fragment->to_target);
    
    mojo::internal::Serialize<::actor::mojom::ToolTargetDataView>(
      in_to_target,
      to_target_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->to_target.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null to_target in DragAndReleaseAction struct");
  }

  static bool Deserialize(::actor::mojom::internal::DragAndReleaseAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::DragAndReleaseActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ScriptToolActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ScriptToolActionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ScriptToolAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in ScriptToolAction struct");

    decltype(Traits::input_arguments(input)) in_input_arguments = Traits::input_arguments(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_arguments)::BaseType> input_arguments_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_input_arguments,
      input_arguments_fragment);

    fragment->input_arguments.Set(
        input_arguments_fragment.is_null() ? nullptr : input_arguments_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_arguments.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_arguments in ScriptToolAction struct");
  }

  static bool Deserialize(::actor::mojom::internal::ScriptToolAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::ScriptToolActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::TaskIdDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::TaskIdDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::TaskId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);
  }

  static bool Deserialize(::actor::mojom::internal::TaskId_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::TaskIdDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ToolInvocationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ToolInvocationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ToolInvocation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::task_id(input)) in_task_id = Traits::task_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->task_id)::BaseType> task_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::actor::mojom::TaskIdDataView>(
      in_task_id,
      task_id_fragment);

    fragment->task_id.Set(
        task_id_fragment.is_null() ? nullptr : task_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->task_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null task_id in ToolInvocation struct");

    decltype(Traits::action(input)) in_action = Traits::action(input);
    mojo::internal::MessageFragment<decltype(fragment->action)>
        action_fragment(fragment.message());
    action_fragment.Claim(&fragment->action);
    
    mojo::internal::Serialize<::actor::mojom::ToolActionDataView>(
      in_action,
      action_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->action.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null action in ToolInvocation struct");

    decltype(Traits::target(input)) in_target = Traits::target(input);
    mojo::internal::MessageFragment<decltype(fragment->target)>
        target_fragment(fragment.message());
    target_fragment.Claim(&fragment->target);
    
    mojo::internal::Serialize<::actor::mojom::ToolTargetDataView>(
      in_target,
      target_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->target.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target in ToolInvocation struct");

    decltype(Traits::observed_target(input)) in_observed_target = Traits::observed_target(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->observed_target)::BaseType> observed_target_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::actor::mojom::ObservedToolTargetDataView>(
      in_observed_target,
      observed_target_fragment);

    fragment->observed_target.Set(
        observed_target_fragment.is_null() ? nullptr : observed_target_fragment.data());
  }

  static bool Deserialize(::actor::mojom::internal::ToolInvocation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::ToolInvocationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ActionResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ActionResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ActionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::actor::mojom::ActionResultCode>(
      Traits::code(input),
      &fragment->code);

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null message in ActionResult struct");

    decltype(Traits::script_tool_response(input)) in_script_tool_response = Traits::script_tool_response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->script_tool_response)::BaseType> script_tool_response_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_script_tool_response,
      script_tool_response_fragment);

    fragment->script_tool_response.Set(
        script_tool_response_fragment.is_null() ? nullptr : script_tool_response_fragment.data());

    decltype(Traits::execution_end_time(input)) in_execution_end_time = Traits::execution_end_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->execution_end_time)::BaseType> execution_end_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_execution_end_time,
      execution_end_time_fragment);

    fragment->execution_end_time.Set(
        execution_end_time_fragment.is_null() ? nullptr : execution_end_time_fragment.data());
  }

  static bool Deserialize(::actor::mojom::internal::ActionResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::ActionResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::JournalDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::JournalDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::JournalDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in JournalDetails struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in JournalDetails struct");
  }

  static bool Deserialize(::actor::mojom::internal::JournalDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::JournalDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::JournalEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::JournalEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::JournalEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::actor::mojom::JournalEntryType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::task_id(input)) in_task_id = Traits::task_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->task_id)::BaseType> task_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::actor::mojom::TaskIdDataView>(
      in_task_id,
      task_id_fragment);

    fragment->task_id.Set(
        task_id_fragment.is_null() ? nullptr : task_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->task_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null task_id in JournalEntry struct");

    
    mojo::internal::Serialize<::actor::mojom::JournalTrack>(
      Traits::track(input),
      &fragment->track);

    decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_timestamp,
      timestamp_fragment);

    fragment->timestamp.Set(
        timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->timestamp.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null timestamp in JournalEntry struct");

    decltype(Traits::event(input)) in_event = Traits::event(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->event)::BaseType> event_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_event,
      event_fragment);

    fragment->event.Set(
        event_fragment.is_null() ? nullptr : event_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->event.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event in JournalEntry struct");

    decltype(Traits::details(input)) in_details = Traits::details(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->details)::BaseType>
        details_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::actor::mojom::JournalDetailsDataView>>(
      in_details,
      details_fragment,
      &details_validate_params);

    fragment->details.Set(
        details_fragment.is_null() ? nullptr : details_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->details.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null details in JournalEntry struct");
  }

  static bool Deserialize(::actor::mojom::internal::JournalEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::JournalEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ToolTargetDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::mojom::ToolTargetDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::mojom::internal::ToolTarget_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::mojom::ToolTargetDataView::Tag::kDomNodeId: {
    decltype(Traits::dom_node_id(input))
    in_dom_node_id = Traits::dom_node_id(input);
    fragment->data.f_dom_node_id = in_dom_node_id;
    break;
  }
  case ::actor::mojom::ToolTargetDataView::Tag::kCoordinate: {
    decltype(Traits::coordinate(input))
    in_coordinate = Traits::coordinate(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_coordinate)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::PointDataView>(
  in_coordinate,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null coordinate in ToolTarget union");
    fragment->data.f_coordinate.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::actor::mojom::internal::ToolTarget_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::ToolTargetDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::actor::mojom::ToolActionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::mojom::ToolActionDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::mojom::internal::ToolAction_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::mojom::ToolActionDataView::Tag::kClick: {
    decltype(Traits::click(input))
    in_click = Traits::click(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_click)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::ClickActionDataView>(
  in_click,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null click in ToolAction union");
    fragment->data.f_click.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kDragAndRelease: {
    decltype(Traits::drag_and_release(input))
    in_drag_and_release = Traits::drag_and_release(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_drag_and_release)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::DragAndReleaseActionDataView>(
  in_drag_and_release,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null drag_and_release in ToolAction union");
    fragment->data.f_drag_and_release.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kMouseMove: {
    decltype(Traits::mouse_move(input))
    in_mouse_move = Traits::mouse_move(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_mouse_move)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::MouseMoveActionDataView>(
  in_mouse_move,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null mouse_move in ToolAction union");
    fragment->data.f_mouse_move.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kScroll: {
    decltype(Traits::scroll(input))
    in_scroll = Traits::scroll(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_scroll)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::ScrollActionDataView>(
  in_scroll,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null scroll in ToolAction union");
    fragment->data.f_scroll.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kSelect: {
    decltype(Traits::select(input))
    in_select = Traits::select(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_select)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::SelectActionDataView>(
  in_select,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null select in ToolAction union");
    fragment->data.f_select.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kType: {
    decltype(Traits::type(input))
    in_type = Traits::type(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_type)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::TypeActionDataView>(
  in_type,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null type in ToolAction union");
    fragment->data.f_type.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kScriptTool: {
    decltype(Traits::script_tool(input))
    in_script_tool = Traits::script_tool(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_script_tool)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::ScriptToolActionDataView>(
  in_script_tool,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null script_tool in ToolAction union");
    fragment->data.f_script_tool.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kScrollTo: {
    decltype(Traits::scroll_to(input))
    in_scroll_to = Traits::scroll_to(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_scroll_to)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::ScrollToActionDataView>(
  in_scroll_to,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null scroll_to in ToolAction union");
    fragment->data.f_scroll_to.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::actor::mojom::internal::ToolAction_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::actor::mojom::ToolActionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace actor::mojom {

inline void ObservedToolTargetDataView::GetNodeAttributeDataView(
    ::blink::mojom::AIPageContentAttributesDataView* output) {
  auto pointer = data_->node_attribute.Get();
  *output = ::blink::mojom::AIPageContentAttributesDataView(pointer, message_);
}








inline void TypeActionDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void SelectActionDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DragAndReleaseActionDataView::GetToTargetDataView(
    ToolTargetDataView* output) {
  auto pointer = &data_->to_target;
  *output = ToolTargetDataView(pointer, message_);
}


inline void ScriptToolActionDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ScriptToolActionDataView::GetInputArgumentsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->input_arguments.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void ToolInvocationDataView::GetTaskIdDataView(
    TaskIdDataView* output) {
  auto pointer = data_->task_id.Get();
  *output = TaskIdDataView(pointer, message_);
}
inline void ToolInvocationDataView::GetActionDataView(
    ToolActionDataView* output) {
  auto pointer = &data_->action;
  *output = ToolActionDataView(pointer, message_);
}
inline void ToolInvocationDataView::GetTargetDataView(
    ToolTargetDataView* output) {
  auto pointer = &data_->target;
  *output = ToolTargetDataView(pointer, message_);
}
inline void ToolInvocationDataView::GetObservedTargetDataView(
    ObservedToolTargetDataView* output) {
  auto pointer = data_->observed_target.Get();
  *output = ObservedToolTargetDataView(pointer, message_);
}


inline void ActionResultDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ActionResultDataView::GetScriptToolResponseDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->script_tool_response.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ActionResultDataView::GetExecutionEndTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->execution_end_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, message_);
}


inline void JournalDetailsDataView::GetKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->key.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void JournalDetailsDataView::GetValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->value.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void JournalEntryDataView::GetTaskIdDataView(
    TaskIdDataView* output) {
  auto pointer = data_->task_id.Get();
  *output = TaskIdDataView(pointer, message_);
}
inline void JournalEntryDataView::GetTimestampDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->timestamp.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}
inline void JournalEntryDataView::GetEventDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->event.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void JournalEntryDataView::GetDetailsDataView(
    mojo::ArrayDataView<JournalDetailsDataView>* output) {
  auto pointer = data_->details.Get();
  *output = mojo::ArrayDataView<JournalDetailsDataView>(pointer, message_);
}


inline void ToolTargetDataView::GetCoordinateDataView(
    ::gfx::mojom::PointDataView* output) const {
  CHECK(is_coordinate());
  *output = ::gfx::mojom::PointDataView(data_->data.f_coordinate.Get(), message_);
}

inline void ToolActionDataView::GetClickDataView(
    ClickActionDataView* output) const {
  CHECK(is_click());
  *output = ClickActionDataView(data_->data.f_click.Get(), message_);
}
inline void ToolActionDataView::GetDragAndReleaseDataView(
    DragAndReleaseActionDataView* output) const {
  CHECK(is_drag_and_release());
  *output = DragAndReleaseActionDataView(data_->data.f_drag_and_release.Get(), message_);
}
inline void ToolActionDataView::GetMouseMoveDataView(
    MouseMoveActionDataView* output) const {
  CHECK(is_mouse_move());
  *output = MouseMoveActionDataView(data_->data.f_mouse_move.Get(), message_);
}
inline void ToolActionDataView::GetScrollDataView(
    ScrollActionDataView* output) const {
  CHECK(is_scroll());
  *output = ScrollActionDataView(data_->data.f_scroll.Get(), message_);
}
inline void ToolActionDataView::GetSelectDataView(
    SelectActionDataView* output) const {
  CHECK(is_select());
  *output = SelectActionDataView(data_->data.f_select.Get(), message_);
}
inline void ToolActionDataView::GetTypeDataView(
    TypeActionDataView* output) const {
  CHECK(is_type());
  *output = TypeActionDataView(data_->data.f_type.Get(), message_);
}
inline void ToolActionDataView::GetScriptToolDataView(
    ScriptToolActionDataView* output) const {
  CHECK(is_script_tool());
  *output = ScriptToolActionDataView(data_->data.f_script_tool.Get(), message_);
}
inline void ToolActionDataView::GetScrollToDataView(
    ScrollToActionDataView* output) const {
  CHECK(is_scroll_to());
  *output = ScrollToActionDataView(data_->data.f_scroll_to.Get(), message_);
}


}  // actor::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::mojom::ActionResultCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::mojom::ActionResultCode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::mojom::JournalEntryType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::mojom::JournalEntryType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::mojom::JournalTrack> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::mojom::JournalTrack value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::mojom::ClickAction_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::mojom::ClickAction_Type value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::mojom::ClickAction_Count> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::mojom::ClickAction_Count value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::mojom::TypeAction_Mode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::mojom::TypeAction_Mode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::actor::mojom::ScrollAction_ScrollDirection> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::actor::mojom::ScrollAction_ScrollDirection value);
};

} // namespace perfetto

#endif  // CHROME_COMMON_ACTOR_MOJOM_SHARED_H_