// chrome/common/actor.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/common/actor.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/common/actor.mojom-params-data.h"
namespace actor {
namespace mojom {

NOINLINE static const char* ActionResultCodeToStringHelper(ActionResultCode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ActionResultCode::kOk:
      return "kOk";
    case ActionResultCode::kError:
      return "kError";
    case ActionResultCode::kUrlBlocked:
      return "kUrlBlocked";
    case ActionResultCode::kNewTabCreationFailed:
      return "kNewTabCreationFailed";
    case ActionResultCode::kTabWentAway:
      return "kTabWentAway";
    case ActionResultCode::kTaskWentAway:
      return "kTaskWentAway";
    case ActionResultCode::kCrossOriginNavigation:
      return "kCrossOriginNavigation";
    case ActionResultCode::kToolUnknown:
      return "kToolUnknown";
    case ActionResultCode::kFrameWentAway:
      return "kFrameWentAway";
    case ActionResultCode::kInvalidDomNodeId:
      return "kInvalidDomNodeId";
    case ActionResultCode::kElementDisabled:
      return "kElementDisabled";
    case ActionResultCode::kElementOffscreen:
      return "kElementOffscreen";
    case ActionResultCode::kCoordinatesOutOfBounds:
      return "kCoordinatesOutOfBounds";
    case ActionResultCode::kArgumentsInvalid:
      return "kArgumentsInvalid";
    case ActionResultCode::kTaskPaused:
      return "kTaskPaused";
    case ActionResultCode::kExecutorDestroyed:
      return "kExecutorDestroyed";
    case ActionResultCode::kWindowWentAway:
      return "kWindowWentAway";
    case ActionResultCode::kFrameLocationChangedSinceObservation:
      return "kFrameLocationChangedSinceObservation";
    case ActionResultCode::kTriggeredNavigationBlocked:
      return "kTriggeredNavigationBlocked";
    case ActionResultCode::kEmptyActionSequence:
      return "kEmptyActionSequence";
    case ActionResultCode::kExecutorBusy:
      return "kExecutorBusy";
    case ActionResultCode::kObservedTargetElementDestroyed:
      return "kObservedTargetElementDestroyed";
    case ActionResultCode::kObservedTargetElementChanged:
      return "kObservedTargetElementChanged";
    case ActionResultCode::kTargetNodeInteractionPointObscured:
      return "kTargetNodeInteractionPointObscured";
    case ActionResultCode::kNavigateInvalidUrl:
      return "kNavigateInvalidUrl";
    case ActionResultCode::kClickSuppressed:
      return "kClickSuppressed";
    case ActionResultCode::kDragAndReleaseFromOffscreen:
      return "kDragAndReleaseFromOffscreen";
    case ActionResultCode::kDragAndReleaseToOffscreen:
      return "kDragAndReleaseToOffscreen";
    case ActionResultCode::kDragAndReleaseFromMoveSuppressed:
      return "kDragAndReleaseFromMoveSuppressed";
    case ActionResultCode::kDragAndReleaseDownSuppressed:
      return "kDragAndReleaseDownSuppressed";
    case ActionResultCode::kDragAndReleaseToMoveSuppressed:
      return "kDragAndReleaseToMoveSuppressed";
    case ActionResultCode::kDragAndReleaseUpSuppressed:
      return "kDragAndReleaseUpSuppressed";
    case ActionResultCode::kMouseMoveEventSuppressed:
      return "kMouseMoveEventSuppressed";
    case ActionResultCode::kScrollNoScrollingElement:
      return "kScrollNoScrollingElement";
    case ActionResultCode::kScrollTargetNotUserScrollable:
      return "kScrollTargetNotUserScrollable";
    case ActionResultCode::kScrollOffsetDidNotChange:
      return "kScrollOffsetDidNotChange";
    case ActionResultCode::kSelectInvalidElement:
      return "kSelectInvalidElement";
    case ActionResultCode::kSelectNoSuchOption:
      return "kSelectNoSuchOption";
    case ActionResultCode::kSelectOptionDisabled:
      return "kSelectOptionDisabled";
    case ActionResultCode::kSelectUnexpectedValue:
      return "kSelectUnexpectedValue";
    case ActionResultCode::kTypeTargetNotElement:
      return "kTypeTargetNotElement";
    case ActionResultCode::kTypeTargetNotFocusable:
      return "kTypeTargetNotFocusable";
    case ActionResultCode::kTypeUnsupportedCharacters:
      return "kTypeUnsupportedCharacters";
    case ActionResultCode::kTypeFailedMappingCharToKey:
      return "kTypeFailedMappingCharToKey";
    case ActionResultCode::kTypeKeyDownSuppressed:
      return "kTypeKeyDownSuppressed";
    case ActionResultCode::kHistoryNoNavigationsCreated:
      return "kHistoryNoNavigationsCreated";
    case ActionResultCode::kHistoryCancelledBeforeStart:
      return "kHistoryCancelledBeforeStart";
    case ActionResultCode::kHistoryNoBackEntries:
      return "kHistoryNoBackEntries";
    case ActionResultCode::kHistoryNoForwardEntries:
      return "kHistoryNoForwardEntries";
    case ActionResultCode::kHistoryFailedBeforeCommit:
      return "kHistoryFailedBeforeCommit";
    case ActionResultCode::kHistoryErrorPage:
      return "kHistoryErrorPage";
    case ActionResultCode::kLoginNoCredentialsAvailable:
      return "kLoginNoCredentialsAvailable";
    case ActionResultCode::kLoginNotLoginPage:
      return "kLoginNotLoginPage";
    case ActionResultCode::kLoginCredentialsEnteredButAnotherActionNeeded:
      return "kLoginCredentialsEnteredButAnotherActionNeeded";
    case ActionResultCode::kLoginNoFillableFields:
      return "kLoginNoFillableFields";
    default:
      return nullptr;
  }
}

std::string ActionResultCodeToString(ActionResultCode value) {
  const char *str = ActionResultCodeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ActionResultCode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ActionResultCode value) {
  return os << ActionResultCodeToString(value);
}

NOINLINE static const char* JournalEntryTypeToStringHelper(JournalEntryType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case JournalEntryType::kBegin:
      return "kBegin";
    case JournalEntryType::kEnd:
      return "kEnd";
    case JournalEntryType::kInstant:
      return "kInstant";
    default:
      return nullptr;
  }
}

std::string JournalEntryTypeToString(JournalEntryType value) {
  const char *str = JournalEntryTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown JournalEntryType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, JournalEntryType value) {
  return os << JournalEntryTypeToString(value);
}

NOINLINE static const char* JournalTrackToStringHelper(JournalTrack value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case JournalTrack::kFrontEnd:
      return "kFrontEnd";
    case JournalTrack::kActor:
      return "kActor";
    default:
      return nullptr;
  }
}

std::string JournalTrackToString(JournalTrack value) {
  const char *str = JournalTrackToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown JournalTrack value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, JournalTrack value) {
  return os << JournalTrackToString(value);
}

NOINLINE static const char* ClickAction_TypeToStringHelper(ClickAction_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ClickAction_Type::kLeft:
      return "kLeft";
    case ClickAction_Type::kRight:
      return "kRight";
    default:
      return nullptr;
  }
}

std::string ClickAction_TypeToString(ClickAction_Type value) {
  const char *str = ClickAction_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ClickAction_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ClickAction_Type value) {
  return os << ClickAction_TypeToString(value);
}

NOINLINE static const char* ClickAction_CountToStringHelper(ClickAction_Count value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ClickAction_Count::kSingle:
      return "kSingle";
    case ClickAction_Count::kDouble:
      return "kDouble";
    default:
      return nullptr;
  }
}

std::string ClickAction_CountToString(ClickAction_Count value) {
  const char *str = ClickAction_CountToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ClickAction_Count value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ClickAction_Count value) {
  return os << ClickAction_CountToString(value);
}

NOINLINE static const char* TypeAction_ModeToStringHelper(TypeAction_Mode value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TypeAction_Mode::kDeleteExisting:
      return "kDeleteExisting";
    case TypeAction_Mode::kPrepend:
      return "kPrepend";
    case TypeAction_Mode::kAppend:
      return "kAppend";
    default:
      return nullptr;
  }
}

std::string TypeAction_ModeToString(TypeAction_Mode value) {
  const char *str = TypeAction_ModeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TypeAction_Mode value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TypeAction_Mode value) {
  return os << TypeAction_ModeToString(value);
}

NOINLINE static const char* ScrollAction_ScrollDirectionToStringHelper(ScrollAction_ScrollDirection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ScrollAction_ScrollDirection::kLeft:
      return "kLeft";
    case ScrollAction_ScrollDirection::kRight:
      return "kRight";
    case ScrollAction_ScrollDirection::kUp:
      return "kUp";
    case ScrollAction_ScrollDirection::kDown:
      return "kDown";
    default:
      return nullptr;
  }
}

std::string ScrollAction_ScrollDirectionToString(ScrollAction_ScrollDirection value) {
  const char *str = ScrollAction_ScrollDirectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ScrollAction_ScrollDirection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ScrollAction_ScrollDirection value) {
  return os << ScrollAction_ScrollDirectionToString(value);
}

namespace internal {
// static
bool ToolTarget_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ToolTarget_Data* object = static_cast<const ToolTarget_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ToolTarget_Tag::kDomNodeId: {

      return true;
    }
    case ToolTarget_Tag::kCoordinate: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_coordinate, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_coordinate, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ToolTarget");
      return false;
    }
  }
}
// static
bool ToolAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ToolAction_Data* object = static_cast<const ToolAction_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ToolAction_Tag::kClick: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_click, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_click, validation_context))
        return false;
      return true;
    }
    case ToolAction_Tag::kDragAndRelease: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_drag_and_release, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_drag_and_release, validation_context))
        return false;
      return true;
    }
    case ToolAction_Tag::kMouseMove: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_mouse_move, 3, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_mouse_move, validation_context))
        return false;
      return true;
    }
    case ToolAction_Tag::kScroll: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_scroll, 4, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_scroll, validation_context))
        return false;
      return true;
    }
    case ToolAction_Tag::kSelect: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_select, 5, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_select, validation_context))
        return false;
      return true;
    }
    case ToolAction_Tag::kType: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_type, 6, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_type, validation_context))
        return false;
      return true;
    }
    case ToolAction_Tag::kScriptTool: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_script_tool, 7, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_script_tool, validation_context))
        return false;
      return true;
    }
    case ToolAction_Tag::kScrollTo: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_scroll_to, 8, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_scroll_to, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ToolAction");
      return false;
    }
  }
}


// static
bool ObservedToolTarget_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ObservedToolTarget_Data* object =
      static_cast<const ObservedToolTarget_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->node_attribute, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->node_attribute, validation_context))
    return false;

  return true;
}

ObservedToolTarget_Data::ObservedToolTarget_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ClickAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ClickAction_Data* object =
      static_cast<const ClickAction_Data*>(data);


  if (!::actor::mojom::internal::ClickAction_Type_Data
        ::Validate(object->type, validation_context))
    return false;


  if (!::actor::mojom::internal::ClickAction_Count_Data
        ::Validate(object->count, validation_context))
    return false;

  return true;
}

ClickAction_Data::ClickAction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MouseMoveAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MouseMoveAction_Data* object =
      static_cast<const MouseMoveAction_Data*>(data);

  return true;
}

MouseMoveAction_Data::MouseMoveAction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollToAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollToAction_Data* object =
      static_cast<const ScrollToAction_Data*>(data);

  return true;
}

ScrollToAction_Data::ScrollToAction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TypeAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TypeAction_Data* object =
      static_cast<const TypeAction_Data*>(data);


  if (!::actor::mojom::internal::TypeAction_Mode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->text, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->text, validation_context,
                                         &text_validate_params)) {
    return false;
  }

  return true;
}

TypeAction_Data::TypeAction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScrollAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScrollAction_Data* object =
      static_cast<const ScrollAction_Data*>(data);


  if (!::actor::mojom::internal::ScrollAction_ScrollDirection_Data
        ::Validate(object->direction, validation_context))
    return false;

  return true;
}

ScrollAction_Data::ScrollAction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SelectAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SelectAction_Data* object =
      static_cast<const SelectAction_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

SelectAction_Data::SelectAction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DragAndReleaseAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DragAndReleaseAction_Data* object =
      static_cast<const DragAndReleaseAction_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->to_target, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->to_target, validation_context))
    return false;

  return true;
}

DragAndReleaseAction_Data::DragAndReleaseAction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ScriptToolAction_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ScriptToolAction_Data* object =
      static_cast<const ScriptToolAction_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_arguments, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& input_arguments_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->input_arguments, validation_context,
                                         &input_arguments_validate_params)) {
    return false;
  }

  return true;
}

ScriptToolAction_Data::ScriptToolAction_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool TaskId_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const TaskId_Data* object =
      static_cast<const TaskId_Data*>(data);

  return true;
}

TaskId_Data::TaskId_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ToolInvocation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ToolInvocation_Data* object =
      static_cast<const ToolInvocation_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->task_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->task_id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->action, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->target, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->target, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->observed_target, validation_context))
    return false;

  return true;
}

ToolInvocation_Data::ToolInvocation_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ActionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ActionResult_Data* object =
      static_cast<const ActionResult_Data*>(data);


  if (!::actor::mojom::internal::ActionResultCode_Data
        ::Validate(object->code, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& script_tool_response_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->script_tool_response, validation_context,
                                         &script_tool_response_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->execution_end_time, validation_context))
    return false;

  return true;
}

ActionResult_Data::ActionResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool JournalDetails_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const JournalDetails_Data* object =
      static_cast<const JournalDetails_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->key, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->key, validation_context,
                                         &key_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

JournalDetails_Data::JournalDetails_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool JournalEntry_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const JournalEntry_Data* object =
      static_cast<const JournalEntry_Data*>(data);


  if (!::actor::mojom::internal::JournalEntryType_Data
        ::Validate(object->type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->task_id, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->task_id, validation_context))
    return false;


  if (!::actor::mojom::internal::JournalTrack_Data
        ::Validate(object->track, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->event, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& event_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->event, validation_context,
                                         &event_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->details, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->details, validation_context,
                                         &details_validate_params)) {
    return false;
  }

  return true;
}

JournalEntry_Data::JournalEntry_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool JournalClient_AddEntriesToJournal_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const JournalClient_AddEntriesToJournal_Params_Data* object =
      static_cast<const JournalClient_AddEntriesToJournal_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }

  return true;
}

JournalClient_AddEntriesToJournal_Params_Data::JournalClient_AddEntriesToJournal_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageStabilityMonitor_NotifyWhenStable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageStabilityMonitor_NotifyWhenStable_Params_Data* object =
      static_cast<const PageStabilityMonitor_NotifyWhenStable_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->observation_delay, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->observation_delay, validation_context))
    return false;

  return true;
}

PageStabilityMonitor_NotifyWhenStable_Params_Data::PageStabilityMonitor_NotifyWhenStable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageStabilityMonitor_NotifyWhenStable_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageStabilityMonitor_NotifyWhenStable_ResponseParams_Data* object =
      static_cast<const PageStabilityMonitor_NotifyWhenStable_ResponseParams_Data*>(data);

  return true;
}

PageStabilityMonitor_NotifyWhenStable_ResponseParams_Data::PageStabilityMonitor_NotifyWhenStable_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace actor

namespace perfetto {

// static
void TraceFormatTraits<::actor::mojom::ActionResultCode>::WriteIntoTrace(
   perfetto::TracedValue context, ::actor::mojom::ActionResultCode value) {
  return std::move(context).WriteString(::actor::mojom::ActionResultCodeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::actor::mojom::JournalEntryType>::WriteIntoTrace(
   perfetto::TracedValue context, ::actor::mojom::JournalEntryType value) {
  return std::move(context).WriteString(::actor::mojom::JournalEntryTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::actor::mojom::JournalTrack>::WriteIntoTrace(
   perfetto::TracedValue context, ::actor::mojom::JournalTrack value) {
  return std::move(context).WriteString(::actor::mojom::JournalTrackToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::actor::mojom::ClickAction_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::actor::mojom::ClickAction_Type value) {
  return std::move(context).WriteString(::actor::mojom::ClickAction_TypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::actor::mojom::ClickAction_Count>::WriteIntoTrace(
   perfetto::TracedValue context, ::actor::mojom::ClickAction_Count value) {
  return std::move(context).WriteString(::actor::mojom::ClickAction_CountToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::actor::mojom::TypeAction_Mode>::WriteIntoTrace(
   perfetto::TracedValue context, ::actor::mojom::TypeAction_Mode value) {
  return std::move(context).WriteString(::actor::mojom::TypeAction_ModeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::actor::mojom::ScrollAction_ScrollDirection>::WriteIntoTrace(
   perfetto::TracedValue context, ::actor::mojom::ScrollAction_ScrollDirection value) {
  return std::move(context).WriteString(::actor::mojom::ScrollAction_ScrollDirectionToString(value));
}

} // namespace perfetto