// chrome/common/actor.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_COMMON_ACTOR_MOJOM_SEND_VALIDATION_H_
#define CHROME_COMMON_ACTOR_MOJOM_SEND_VALIDATION_H_

#include "chrome/common/actor.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/content_extraction/ai_page_content.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "chrome/common/actor.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::actor::mojom::ActionResultCode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::actor::mojom::JournalEntryType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::actor::mojom::JournalTrack, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::ObservedToolTargetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ObservedToolTargetDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ObservedToolTarget_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::node_attribute(input)) in_node_attribute = Traits::node_attribute(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->node_attribute)::BaseType> node_attribute_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::AIPageContentAttributesDataView, send_validation>(
        in_node_attribute,
        node_attribute_fragment);

      fragment->node_attribute.Set(
          node_attribute_fragment.is_null() ? nullptr : node_attribute_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->node_attribute.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null node_attribute in ObservedToolTarget struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::ClickActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ClickActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ClickAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::actor::mojom::ClickAction_Type>(
        Traits::type(input),
        &fragment->type);

      
      mojo::internal::Serialize<::actor::mojom::ClickAction_Count>(
        Traits::count(input),
        &fragment->count);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::MouseMoveActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::MouseMoveActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::MouseMoveAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::ScrollToActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ScrollToActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ScrollToAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::TypeActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::TypeActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::TypeAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::actor::mojom::TypeAction_Mode>(
        Traits::mode(input),
        &fragment->mode);

      decltype(Traits::text(input)) in_text = Traits::text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text)::BaseType> text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text,
        text_fragment);

      fragment->text.Set(
          text_fragment.is_null() ? nullptr : text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in TypeAction struct");

      fragment->follow_by_enter = Traits::follow_by_enter(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::ScrollActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ScrollActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ScrollAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::actor::mojom::ScrollAction_ScrollDirection>(
        Traits::direction(input),
        &fragment->direction);

      fragment->distance = Traits::distance(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::SelectActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::SelectActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::SelectAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in SelectAction struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::DragAndReleaseActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::DragAndReleaseActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::DragAndReleaseAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::to_target(input)) in_to_target = Traits::to_target(input);
      mojo::internal::MessageFragment<decltype(fragment->to_target)>
          to_target_fragment(fragment.message());
      to_target_fragment.Claim(&fragment->to_target);
      
      mojo::internal::Serialize<::actor::mojom::ToolTargetDataView, send_validation>(
        in_to_target,
        to_target_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->to_target.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null to_target in DragAndReleaseAction struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::ScriptToolActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ScriptToolActionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ScriptToolAction_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ScriptToolAction struct");

      decltype(Traits::input_arguments(input)) in_input_arguments = Traits::input_arguments(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->input_arguments)::BaseType> input_arguments_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_input_arguments,
        input_arguments_fragment);

      fragment->input_arguments.Set(
          input_arguments_fragment.is_null() ? nullptr : input_arguments_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->input_arguments.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null input_arguments in ScriptToolAction struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::TaskIdDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::TaskIdDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::TaskId_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::ToolInvocationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ToolInvocationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ToolInvocation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::task_id(input)) in_task_id = Traits::task_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->task_id)::BaseType> task_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::actor::mojom::TaskIdDataView, send_validation>(
        in_task_id,
        task_id_fragment);

      fragment->task_id.Set(
          task_id_fragment.is_null() ? nullptr : task_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->task_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null task_id in ToolInvocation struct");

      decltype(Traits::action(input)) in_action = Traits::action(input);
      mojo::internal::MessageFragment<decltype(fragment->action)>
          action_fragment(fragment.message());
      action_fragment.Claim(&fragment->action);
      
      mojo::internal::Serialize<::actor::mojom::ToolActionDataView, send_validation>(
        in_action,
        action_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->action.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null action in ToolInvocation struct");

      decltype(Traits::target(input)) in_target = Traits::target(input);
      mojo::internal::MessageFragment<decltype(fragment->target)>
          target_fragment(fragment.message());
      target_fragment.Claim(&fragment->target);
      
      mojo::internal::Serialize<::actor::mojom::ToolTargetDataView, send_validation>(
        in_target,
        target_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->target.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null target in ToolInvocation struct");

      decltype(Traits::observed_target(input)) in_observed_target = Traits::observed_target(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->observed_target)::BaseType> observed_target_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::actor::mojom::ObservedToolTargetDataView, send_validation>(
        in_observed_target,
        observed_target_fragment);

      fragment->observed_target.Set(
          observed_target_fragment.is_null() ? nullptr : observed_target_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::ActionResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::ActionResultDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::ActionResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::actor::mojom::ActionResultCode>(
        Traits::code(input),
        &fragment->code);

      decltype(Traits::message(input)) in_message = Traits::message(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->message)::BaseType> message_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_message,
        message_fragment);

      fragment->message.Set(
          message_fragment.is_null() ? nullptr : message_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->message.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null message in ActionResult struct");

      decltype(Traits::script_tool_response(input)) in_script_tool_response = Traits::script_tool_response(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->script_tool_response)::BaseType> script_tool_response_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_script_tool_response,
        script_tool_response_fragment);

      fragment->script_tool_response.Set(
          script_tool_response_fragment.is_null() ? nullptr : script_tool_response_fragment.data());

      decltype(Traits::execution_end_time(input)) in_execution_end_time = Traits::execution_end_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->execution_end_time)::BaseType> execution_end_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_execution_end_time,
        execution_end_time_fragment);

      fragment->execution_end_time.Set(
          execution_end_time_fragment.is_null() ? nullptr : execution_end_time_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::JournalDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::JournalDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::JournalDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::key(input)) in_key = Traits::key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->key)::BaseType> key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_key,
        key_fragment);

      fragment->key.Set(
          key_fragment.is_null() ? nullptr : key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null key in JournalDetails struct");

      decltype(Traits::value(input)) in_value = Traits::value(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->value)::BaseType> value_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_value,
        value_fragment);

      fragment->value.Set(
          value_fragment.is_null() ? nullptr : value_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->value.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null value in JournalDetails struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::JournalEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::actor::mojom::JournalEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::actor::mojom::internal::JournalEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::actor::mojom::JournalEntryType>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::task_id(input)) in_task_id = Traits::task_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->task_id)::BaseType> task_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::actor::mojom::TaskIdDataView, send_validation>(
        in_task_id,
        task_id_fragment);

      fragment->task_id.Set(
          task_id_fragment.is_null() ? nullptr : task_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->task_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null task_id in JournalEntry struct");

      
      mojo::internal::Serialize<::actor::mojom::JournalTrack>(
        Traits::track(input),
        &fragment->track);

      decltype(Traits::timestamp(input)) in_timestamp = Traits::timestamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timestamp)::BaseType> timestamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_timestamp,
        timestamp_fragment);

      fragment->timestamp.Set(
          timestamp_fragment.is_null() ? nullptr : timestamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->timestamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null timestamp in JournalEntry struct");

      decltype(Traits::event(input)) in_event = Traits::event(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->event)::BaseType> event_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_event,
        event_fragment);

      fragment->event.Set(
          event_fragment.is_null() ? nullptr : event_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->event.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event in JournalEntry struct");

      decltype(Traits::details(input)) in_details = Traits::details(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->details)::BaseType>
          details_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& details_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::actor::mojom::JournalDetailsDataView>, send_validation>(
        in_details,
        details_fragment,
        &details_validate_params);

      fragment->details.Set(
          details_fragment.is_null() ? nullptr : details_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->details.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null details in JournalEntry struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::ToolTargetDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::mojom::ToolTargetDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::mojom::internal::ToolTarget_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::mojom::ToolTargetDataView::Tag::kDomNodeId: {
    decltype(Traits::dom_node_id(input))
    in_dom_node_id = Traits::dom_node_id(input);
    fragment->data.f_dom_node_id = in_dom_node_id;
    break;
  }
  case ::actor::mojom::ToolTargetDataView::Tag::kCoordinate: {
    decltype(Traits::coordinate(input))
    in_coordinate = Traits::coordinate(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_coordinate)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
  in_coordinate,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null coordinate in ToolTarget union");
    fragment->data.f_coordinate.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::actor::mojom::ToolActionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::actor::mojom::ToolActionDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::actor::mojom::internal::ToolAction_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::actor::mojom::ToolActionDataView::Tag::kClick: {
    decltype(Traits::click(input))
    in_click = Traits::click(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_click)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::ClickActionDataView, send_validation>(
  in_click,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null click in ToolAction union");
    fragment->data.f_click.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kDragAndRelease: {
    decltype(Traits::drag_and_release(input))
    in_drag_and_release = Traits::drag_and_release(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_drag_and_release)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::DragAndReleaseActionDataView, send_validation>(
  in_drag_and_release,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null drag_and_release in ToolAction union");
    fragment->data.f_drag_and_release.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kMouseMove: {
    decltype(Traits::mouse_move(input))
    in_mouse_move = Traits::mouse_move(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_mouse_move)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::MouseMoveActionDataView, send_validation>(
  in_mouse_move,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null mouse_move in ToolAction union");
    fragment->data.f_mouse_move.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kScroll: {
    decltype(Traits::scroll(input))
    in_scroll = Traits::scroll(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_scroll)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::ScrollActionDataView, send_validation>(
  in_scroll,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null scroll in ToolAction union");
    fragment->data.f_scroll.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kSelect: {
    decltype(Traits::select(input))
    in_select = Traits::select(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_select)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::SelectActionDataView, send_validation>(
  in_select,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null select in ToolAction union");
    fragment->data.f_select.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kType: {
    decltype(Traits::type(input))
    in_type = Traits::type(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_type)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::TypeActionDataView, send_validation>(
  in_type,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null type in ToolAction union");
    fragment->data.f_type.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kScriptTool: {
    decltype(Traits::script_tool(input))
    in_script_tool = Traits::script_tool(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_script_tool)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::ScriptToolActionDataView, send_validation>(
  in_script_tool,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null script_tool in ToolAction union");
    fragment->data.f_script_tool.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::actor::mojom::ToolActionDataView::Tag::kScrollTo: {
    decltype(Traits::scroll_to(input))
    in_scroll_to = Traits::scroll_to(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_scroll_to)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::actor::mojom::ScrollToActionDataView, send_validation>(
  in_scroll_to,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null scroll_to in ToolAction union");
    fragment->data.f_scroll_to.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // CHROME_COMMON_ACTOR_MOJOM_SEND_VALIDATION_H_