// chrome/browser/ui/webui/whats_new/whats_new.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/whats_new/whats_new.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/whats_new/whats_new.mojom-params-data.h"
#include "chrome/browser/ui/webui/whats_new/whats_new.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/whats_new/whats_new.mojom-import-headers.h"
#include "chrome/browser/ui/webui/whats_new/whats_new.mojom-test-utils.h"


namespace whats_new::mojom {
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive whats_new::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply whats_new::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb906c31e;  // IPCStableHash for whats_new::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::whats_new::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::whats_new::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::whats_new::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetServerUrl: {
      return &PageHandler::GetServerUrl_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordTimeToLoadContent: {
      return &PageHandler::RecordTimeToLoadContent_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordVersionPageLoaded: {
      return &PageHandler::RecordVersionPageLoaded_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordEditionPageLoaded: {
      return &PageHandler::RecordEditionPageLoaded_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordModuleImpression: {
      return &PageHandler::RecordModuleImpression_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordExploreMoreToggled: {
      return &PageHandler::RecordExploreMoreToggled_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordScrollDepth: {
      return &PageHandler::RecordScrollDepth_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordTimeOnPage: {
      return &PageHandler::RecordTimeOnPage_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordModuleLinkClicked: {
      return &PageHandler::RecordModuleLinkClicked_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordModuleVideoStarted: {
      return &PageHandler::RecordModuleVideoStarted_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordModuleVideoEnded: {
      return &PageHandler::RecordModuleVideoEnded_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordModulePlayClicked: {
      return &PageHandler::RecordModulePlayClicked_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordModulePauseClicked: {
      return &PageHandler::RecordModulePauseClicked_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordModuleRestartClicked: {
      return &PageHandler::RecordModuleRestartClicked_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordBrowserCommandExecuted: {
      return &PageHandler::RecordBrowserCommandExecuted_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordQrCodeToggled: {
      return &PageHandler::RecordQrCodeToggled_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordNavClick: {
      return &PageHandler::RecordNavClick_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordFeatureTileNavigation: {
      return &PageHandler::RecordFeatureTileNavigation_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordCarouselScrollButtonClick: {
      return &PageHandler::RecordCarouselScrollButtonClick_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordExpandMediaToggled: {
      return &PageHandler::RecordExpandMediaToggled_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordCtaClick: {
      return &PageHandler::RecordCtaClick_Sym::IPCStableHash;
    }
    case messages::PageHandler::kRecordNextButtonClick: {
      return &PageHandler::RecordNextButtonClick_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetServerUrl:
            return "Receive whats_new::mojom::PageHandler::GetServerUrl";
      case messages::PageHandler::kRecordTimeToLoadContent:
            return "Receive whats_new::mojom::PageHandler::RecordTimeToLoadContent";
      case messages::PageHandler::kRecordVersionPageLoaded:
            return "Receive whats_new::mojom::PageHandler::RecordVersionPageLoaded";
      case messages::PageHandler::kRecordEditionPageLoaded:
            return "Receive whats_new::mojom::PageHandler::RecordEditionPageLoaded";
      case messages::PageHandler::kRecordModuleImpression:
            return "Receive whats_new::mojom::PageHandler::RecordModuleImpression";
      case messages::PageHandler::kRecordExploreMoreToggled:
            return "Receive whats_new::mojom::PageHandler::RecordExploreMoreToggled";
      case messages::PageHandler::kRecordScrollDepth:
            return "Receive whats_new::mojom::PageHandler::RecordScrollDepth";
      case messages::PageHandler::kRecordTimeOnPage:
            return "Receive whats_new::mojom::PageHandler::RecordTimeOnPage";
      case messages::PageHandler::kRecordModuleLinkClicked:
            return "Receive whats_new::mojom::PageHandler::RecordModuleLinkClicked";
      case messages::PageHandler::kRecordModuleVideoStarted:
            return "Receive whats_new::mojom::PageHandler::RecordModuleVideoStarted";
      case messages::PageHandler::kRecordModuleVideoEnded:
            return "Receive whats_new::mojom::PageHandler::RecordModuleVideoEnded";
      case messages::PageHandler::kRecordModulePlayClicked:
            return "Receive whats_new::mojom::PageHandler::RecordModulePlayClicked";
      case messages::PageHandler::kRecordModulePauseClicked:
            return "Receive whats_new::mojom::PageHandler::RecordModulePauseClicked";
      case messages::PageHandler::kRecordModuleRestartClicked:
            return "Receive whats_new::mojom::PageHandler::RecordModuleRestartClicked";
      case messages::PageHandler::kRecordBrowserCommandExecuted:
            return "Receive whats_new::mojom::PageHandler::RecordBrowserCommandExecuted";
      case messages::PageHandler::kRecordQrCodeToggled:
            return "Receive whats_new::mojom::PageHandler::RecordQrCodeToggled";
      case messages::PageHandler::kRecordNavClick:
            return "Receive whats_new::mojom::PageHandler::RecordNavClick";
      case messages::PageHandler::kRecordFeatureTileNavigation:
            return "Receive whats_new::mojom::PageHandler::RecordFeatureTileNavigation";
      case messages::PageHandler::kRecordCarouselScrollButtonClick:
            return "Receive whats_new::mojom::PageHandler::RecordCarouselScrollButtonClick";
      case messages::PageHandler::kRecordExpandMediaToggled:
            return "Receive whats_new::mojom::PageHandler::RecordExpandMediaToggled";
      case messages::PageHandler::kRecordCtaClick:
            return "Receive whats_new::mojom::PageHandler::RecordCtaClick";
      case messages::PageHandler::kRecordNextButtonClick:
            return "Receive whats_new::mojom::PageHandler::RecordNextButtonClick";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetServerUrl:
            return "Receive reply whats_new::mojom::PageHandler::GetServerUrl";
      case messages::PageHandler::kRecordTimeToLoadContent:
            return "Receive reply whats_new::mojom::PageHandler::RecordTimeToLoadContent";
      case messages::PageHandler::kRecordVersionPageLoaded:
            return "Receive reply whats_new::mojom::PageHandler::RecordVersionPageLoaded";
      case messages::PageHandler::kRecordEditionPageLoaded:
            return "Receive reply whats_new::mojom::PageHandler::RecordEditionPageLoaded";
      case messages::PageHandler::kRecordModuleImpression:
            return "Receive reply whats_new::mojom::PageHandler::RecordModuleImpression";
      case messages::PageHandler::kRecordExploreMoreToggled:
            return "Receive reply whats_new::mojom::PageHandler::RecordExploreMoreToggled";
      case messages::PageHandler::kRecordScrollDepth:
            return "Receive reply whats_new::mojom::PageHandler::RecordScrollDepth";
      case messages::PageHandler::kRecordTimeOnPage:
            return "Receive reply whats_new::mojom::PageHandler::RecordTimeOnPage";
      case messages::PageHandler::kRecordModuleLinkClicked:
            return "Receive reply whats_new::mojom::PageHandler::RecordModuleLinkClicked";
      case messages::PageHandler::kRecordModuleVideoStarted:
            return "Receive reply whats_new::mojom::PageHandler::RecordModuleVideoStarted";
      case messages::PageHandler::kRecordModuleVideoEnded:
            return "Receive reply whats_new::mojom::PageHandler::RecordModuleVideoEnded";
      case messages::PageHandler::kRecordModulePlayClicked:
            return "Receive reply whats_new::mojom::PageHandler::RecordModulePlayClicked";
      case messages::PageHandler::kRecordModulePauseClicked:
            return "Receive reply whats_new::mojom::PageHandler::RecordModulePauseClicked";
      case messages::PageHandler::kRecordModuleRestartClicked:
            return "Receive reply whats_new::mojom::PageHandler::RecordModuleRestartClicked";
      case messages::PageHandler::kRecordBrowserCommandExecuted:
            return "Receive reply whats_new::mojom::PageHandler::RecordBrowserCommandExecuted";
      case messages::PageHandler::kRecordQrCodeToggled:
            return "Receive reply whats_new::mojom::PageHandler::RecordQrCodeToggled";
      case messages::PageHandler::kRecordNavClick:
            return "Receive reply whats_new::mojom::PageHandler::RecordNavClick";
      case messages::PageHandler::kRecordFeatureTileNavigation:
            return "Receive reply whats_new::mojom::PageHandler::RecordFeatureTileNavigation";
      case messages::PageHandler::kRecordCarouselScrollButtonClick:
            return "Receive reply whats_new::mojom::PageHandler::RecordCarouselScrollButtonClick";
      case messages::PageHandler::kRecordExpandMediaToggled:
            return "Receive reply whats_new::mojom::PageHandler::RecordExpandMediaToggled";
      case messages::PageHandler::kRecordCtaClick:
            return "Receive reply whats_new::mojom::PageHandler::RecordCtaClick";
      case messages::PageHandler::kRecordNextButtonClick:
            return "Receive reply whats_new::mojom::PageHandler::RecordNextButtonClick";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetServerUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa4c440ea;  // IPCStableHash for whats_new::mojom::PageHandler::GetServerUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordTimeToLoadContent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb6121051;  // IPCStableHash for whats_new::mojom::PageHandler::RecordTimeToLoadContent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordVersionPageLoaded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x02395666;  // IPCStableHash for whats_new::mojom::PageHandler::RecordVersionPageLoaded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordEditionPageLoaded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xab9bc2fb;  // IPCStableHash for whats_new::mojom::PageHandler::RecordEditionPageLoaded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordModuleImpression_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x558aafc7;  // IPCStableHash for whats_new::mojom::PageHandler::RecordModuleImpression
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordExploreMoreToggled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5b4e7031;  // IPCStableHash for whats_new::mojom::PageHandler::RecordExploreMoreToggled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordScrollDepth_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x002b94f2;  // IPCStableHash for whats_new::mojom::PageHandler::RecordScrollDepth
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordTimeOnPage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b9e8689;  // IPCStableHash for whats_new::mojom::PageHandler::RecordTimeOnPage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordModuleLinkClicked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x606f2ec1;  // IPCStableHash for whats_new::mojom::PageHandler::RecordModuleLinkClicked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordModuleVideoStarted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x60bd0bfd;  // IPCStableHash for whats_new::mojom::PageHandler::RecordModuleVideoStarted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordModuleVideoEnded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xee7d856d;  // IPCStableHash for whats_new::mojom::PageHandler::RecordModuleVideoEnded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordModulePlayClicked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd09f2f74;  // IPCStableHash for whats_new::mojom::PageHandler::RecordModulePlayClicked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordModulePauseClicked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x20c387ac;  // IPCStableHash for whats_new::mojom::PageHandler::RecordModulePauseClicked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordModuleRestartClicked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x78b92741;  // IPCStableHash for whats_new::mojom::PageHandler::RecordModuleRestartClicked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordBrowserCommandExecuted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa90ea30c;  // IPCStableHash for whats_new::mojom::PageHandler::RecordBrowserCommandExecuted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordQrCodeToggled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc13cd587;  // IPCStableHash for whats_new::mojom::PageHandler::RecordQrCodeToggled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordNavClick_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x344046f1;  // IPCStableHash for whats_new::mojom::PageHandler::RecordNavClick
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordFeatureTileNavigation_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x71dded77;  // IPCStableHash for whats_new::mojom::PageHandler::RecordFeatureTileNavigation
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordCarouselScrollButtonClick_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x93b619b4;  // IPCStableHash for whats_new::mojom::PageHandler::RecordCarouselScrollButtonClick
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordExpandMediaToggled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9d472ab8;  // IPCStableHash for whats_new::mojom::PageHandler::RecordExpandMediaToggled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordCtaClick_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1ca9cc7c;  // IPCStableHash for whats_new::mojom::PageHandler::RecordCtaClick
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::RecordNextButtonClick_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d496179;  // IPCStableHash for whats_new::mojom::PageHandler::RecordNextButtonClick
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetServerUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetServerUrl_ForwardToCallback(
      PageHandler::GetServerUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetServerUrl_ForwardToCallback(const PageHandler_GetServerUrl_ForwardToCallback&) = delete;
  PageHandler_GetServerUrl_ForwardToCallback& operator=(const PageHandler_GetServerUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetServerUrlCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetServerUrl(
    bool in_is_staging, GetServerUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::GetServerUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_staging"), in_is_staging,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetServerUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_GetServerUrl_Params_Data> params(
          message);
  params.Allocate();

  params->is_staging = in_is_staging;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetServerUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetServerUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::RecordTimeToLoadContent(
    ::base::Time in_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordTimeToLoadContent", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type ::base::Time>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordTimeToLoadContent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordTimeToLoadContent_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->time)::BaseType> time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::JSTimeDataView>(
    in_time,
    time_fragment);

  params->time.Set(
      time_fragment.is_null() ? nullptr : time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time in PageHandler.RecordTimeToLoadContent request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordTimeToLoadContent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordVersionPageLoaded(
    bool in_is_auto_open) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordVersionPageLoaded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_auto_open"), in_is_auto_open,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordVersionPageLoaded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordVersionPageLoaded_Params_Data> params(
          message);
  params.Allocate();

  params->is_auto_open = in_is_auto_open;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordVersionPageLoaded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordEditionPageLoaded(
    const std::string& in_page_uid, bool in_is_auto_open) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordEditionPageLoaded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page_uid"), in_page_uid,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_auto_open"), in_is_auto_open,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordEditionPageLoaded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordEditionPageLoaded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->page_uid)::BaseType> page_uid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_page_uid,
    page_uid_fragment);

  params->page_uid.Set(
      page_uid_fragment.is_null() ? nullptr : page_uid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->page_uid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null page_uid in PageHandler.RecordEditionPageLoaded request");

  params->is_auto_open = in_is_auto_open;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordEditionPageLoaded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordModuleImpression(
    const std::string& in_module_name, ModulePosition in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordModuleImpression", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_name"), in_module_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type ModulePosition>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordModuleImpression), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordModuleImpression_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_name)::BaseType> module_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_name,
    module_name_fragment);

  params->module_name.Set(
      module_name_fragment.is_null() ? nullptr : module_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_name in PageHandler.RecordModuleImpression request");

  
  mojo::internal::Serialize<::whats_new::mojom::ModulePosition>(
    in_position,
    &params->position);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordModuleImpression");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordExploreMoreToggled(
    bool in_expanded) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordExploreMoreToggled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expanded"), in_expanded,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordExploreMoreToggled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordExploreMoreToggled_Params_Data> params(
          message);
  params.Allocate();

  params->expanded = in_expanded;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordExploreMoreToggled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordScrollDepth(
    ScrollDepth in_depth) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordScrollDepth", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("depth"), in_depth,
                        "<value of type ScrollDepth>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordScrollDepth), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordScrollDepth_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::whats_new::mojom::ScrollDepth>(
    in_depth,
    &params->depth);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordScrollDepth");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordTimeOnPage(
    ::base::TimeDelta in_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordTimeOnPage", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordTimeOnPage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordTimeOnPage_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->time)::BaseType> time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_time,
    time_fragment);

  params->time.Set(
      time_fragment.is_null() ? nullptr : time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time in PageHandler.RecordTimeOnPage request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordTimeOnPage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordModuleLinkClicked(
    const std::string& in_module_name, ModulePosition in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordModuleLinkClicked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_name"), in_module_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type ModulePosition>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordModuleLinkClicked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordModuleLinkClicked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_name)::BaseType> module_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_name,
    module_name_fragment);

  params->module_name.Set(
      module_name_fragment.is_null() ? nullptr : module_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_name in PageHandler.RecordModuleLinkClicked request");

  
  mojo::internal::Serialize<::whats_new::mojom::ModulePosition>(
    in_position,
    &params->position);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordModuleLinkClicked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordModuleVideoStarted(
    const std::string& in_module_name, ModulePosition in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordModuleVideoStarted", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_name"), in_module_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type ModulePosition>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordModuleVideoStarted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordModuleVideoStarted_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_name)::BaseType> module_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_name,
    module_name_fragment);

  params->module_name.Set(
      module_name_fragment.is_null() ? nullptr : module_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_name in PageHandler.RecordModuleVideoStarted request");

  
  mojo::internal::Serialize<::whats_new::mojom::ModulePosition>(
    in_position,
    &params->position);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordModuleVideoStarted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordModuleVideoEnded(
    const std::string& in_module_name, ModulePosition in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordModuleVideoEnded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_name"), in_module_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type ModulePosition>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordModuleVideoEnded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordModuleVideoEnded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_name)::BaseType> module_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_name,
    module_name_fragment);

  params->module_name.Set(
      module_name_fragment.is_null() ? nullptr : module_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_name in PageHandler.RecordModuleVideoEnded request");

  
  mojo::internal::Serialize<::whats_new::mojom::ModulePosition>(
    in_position,
    &params->position);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordModuleVideoEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordModulePlayClicked(
    const std::string& in_module_name, ModulePosition in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordModulePlayClicked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_name"), in_module_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type ModulePosition>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordModulePlayClicked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordModulePlayClicked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_name)::BaseType> module_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_name,
    module_name_fragment);

  params->module_name.Set(
      module_name_fragment.is_null() ? nullptr : module_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_name in PageHandler.RecordModulePlayClicked request");

  
  mojo::internal::Serialize<::whats_new::mojom::ModulePosition>(
    in_position,
    &params->position);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordModulePlayClicked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordModulePauseClicked(
    const std::string& in_module_name, ModulePosition in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordModulePauseClicked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_name"), in_module_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type ModulePosition>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordModulePauseClicked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordModulePauseClicked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_name)::BaseType> module_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_name,
    module_name_fragment);

  params->module_name.Set(
      module_name_fragment.is_null() ? nullptr : module_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_name in PageHandler.RecordModulePauseClicked request");

  
  mojo::internal::Serialize<::whats_new::mojom::ModulePosition>(
    in_position,
    &params->position);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordModulePauseClicked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordModuleRestartClicked(
    const std::string& in_module_name, ModulePosition in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordModuleRestartClicked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_name"), in_module_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("position"), in_position,
                        "<value of type ModulePosition>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordModuleRestartClicked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordModuleRestartClicked_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_name)::BaseType> module_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_name,
    module_name_fragment);

  params->module_name.Set(
      module_name_fragment.is_null() ? nullptr : module_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_name in PageHandler.RecordModuleRestartClicked request");

  
  mojo::internal::Serialize<::whats_new::mojom::ModulePosition>(
    in_position,
    &params->position);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordModuleRestartClicked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordBrowserCommandExecuted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send whats_new::mojom::PageHandler::RecordBrowserCommandExecuted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordBrowserCommandExecuted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordBrowserCommandExecuted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordBrowserCommandExecuted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordQrCodeToggled(
    bool in_expanded) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordQrCodeToggled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expanded"), in_expanded,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordQrCodeToggled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordQrCodeToggled_Params_Data> params(
          message);
  params.Allocate();

  params->expanded = in_expanded;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordQrCodeToggled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordNavClick(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send whats_new::mojom::PageHandler::RecordNavClick");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordNavClick), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordNavClick_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordNavClick");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordFeatureTileNavigation(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send whats_new::mojom::PageHandler::RecordFeatureTileNavigation");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordFeatureTileNavigation), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordFeatureTileNavigation_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordFeatureTileNavigation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordCarouselScrollButtonClick(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send whats_new::mojom::PageHandler::RecordCarouselScrollButtonClick");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordCarouselScrollButtonClick), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordCarouselScrollButtonClick_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordCarouselScrollButtonClick");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordExpandMediaToggled(
    const std::string& in_module_name, bool in_expanded) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send whats_new::mojom::PageHandler::RecordExpandMediaToggled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("module_name"), in_module_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("expanded"), in_expanded,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordExpandMediaToggled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordExpandMediaToggled_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->module_name)::BaseType> module_name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_module_name,
    module_name_fragment);

  params->module_name.Set(
      module_name_fragment.is_null() ? nullptr : module_name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->module_name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null module_name in PageHandler.RecordExpandMediaToggled request");

  params->expanded = in_expanded;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordExpandMediaToggled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordCtaClick(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send whats_new::mojom::PageHandler::RecordCtaClick");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordCtaClick), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordCtaClick_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordCtaClick");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::RecordNextButtonClick(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send whats_new::mojom::PageHandler::RecordNextButtonClick");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kRecordNextButtonClick), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_RecordNextButtonClick_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("RecordNextButtonClick");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetServerUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetServerUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetServerUrl_ProxyToResponder> proxy(
        new PageHandler_GetServerUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetServerUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetServerUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetServerUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetServerUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::GURL& in_url);
};

bool PageHandler_GetServerUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetServerUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetServerUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  ::GURL p_url{};
  PageHandler_GetServerUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadUrl(&p_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_url));
  }
  return true;
}

void PageHandler_GetServerUrl_ProxyToResponder::Run(
    const ::GURL& in_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply whats_new::mojom::PageHandler::GetServerUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetServerUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::whats_new::mojom::internal::PageHandler_GetServerUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetServerUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetServerUrl: {
      break;
    }
    case messages::PageHandler::kRecordTimeToLoadContent: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordTimeToLoadContent_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordTimeToLoadContent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      ::base::Time p_time{};
      PageHandler_RecordTimeToLoadContent_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTime(&p_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordTimeToLoadContent(        
        std::move(p_time));
      return true;
    }
    case messages::PageHandler::kRecordVersionPageLoaded: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordVersionPageLoaded_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordVersionPageLoaded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      bool p_is_auto_open{};
      PageHandler_RecordVersionPageLoaded_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_auto_open = input_data_view.is_auto_open();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordVersionPageLoaded(        
        std::move(p_is_auto_open));
      return true;
    }
    case messages::PageHandler::kRecordEditionPageLoaded: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordEditionPageLoaded_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordEditionPageLoaded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      std::string p_page_uid{};
      bool p_is_auto_open{};
      PageHandler_RecordEditionPageLoaded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPageUid(&p_page_uid))
        success = false;
      if (success)
        p_is_auto_open = input_data_view.is_auto_open();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordEditionPageLoaded(        
        std::move(p_page_uid), 
        std::move(p_is_auto_open));
      return true;
    }
    case messages::PageHandler::kRecordModuleImpression: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordModuleImpression_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordModuleImpression_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      std::string p_module_name{};
      ModulePosition p_position{};
      PageHandler_RecordModuleImpression_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleName(&p_module_name))
        success = false;
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordModuleImpression(        
        std::move(p_module_name), 
        std::move(p_position));
      return true;
    }
    case messages::PageHandler::kRecordExploreMoreToggled: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordExploreMoreToggled_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordExploreMoreToggled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      bool p_expanded{};
      PageHandler_RecordExploreMoreToggled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_expanded = input_data_view.expanded();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordExploreMoreToggled(        
        std::move(p_expanded));
      return true;
    }
    case messages::PageHandler::kRecordScrollDepth: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordScrollDepth_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordScrollDepth_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      ScrollDepth p_depth{};
      PageHandler_RecordScrollDepth_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDepth(&p_depth))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordScrollDepth(        
        std::move(p_depth));
      return true;
    }
    case messages::PageHandler::kRecordTimeOnPage: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordTimeOnPage_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordTimeOnPage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      ::base::TimeDelta p_time{};
      PageHandler_RecordTimeOnPage_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTime(&p_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordTimeOnPage(        
        std::move(p_time));
      return true;
    }
    case messages::PageHandler::kRecordModuleLinkClicked: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordModuleLinkClicked_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordModuleLinkClicked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      std::string p_module_name{};
      ModulePosition p_position{};
      PageHandler_RecordModuleLinkClicked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleName(&p_module_name))
        success = false;
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordModuleLinkClicked(        
        std::move(p_module_name), 
        std::move(p_position));
      return true;
    }
    case messages::PageHandler::kRecordModuleVideoStarted: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordModuleVideoStarted_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordModuleVideoStarted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      std::string p_module_name{};
      ModulePosition p_position{};
      PageHandler_RecordModuleVideoStarted_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleName(&p_module_name))
        success = false;
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordModuleVideoStarted(        
        std::move(p_module_name), 
        std::move(p_position));
      return true;
    }
    case messages::PageHandler::kRecordModuleVideoEnded: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordModuleVideoEnded_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordModuleVideoEnded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      std::string p_module_name{};
      ModulePosition p_position{};
      PageHandler_RecordModuleVideoEnded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleName(&p_module_name))
        success = false;
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordModuleVideoEnded(        
        std::move(p_module_name), 
        std::move(p_position));
      return true;
    }
    case messages::PageHandler::kRecordModulePlayClicked: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordModulePlayClicked_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordModulePlayClicked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      std::string p_module_name{};
      ModulePosition p_position{};
      PageHandler_RecordModulePlayClicked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleName(&p_module_name))
        success = false;
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordModulePlayClicked(        
        std::move(p_module_name), 
        std::move(p_position));
      return true;
    }
    case messages::PageHandler::kRecordModulePauseClicked: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordModulePauseClicked_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordModulePauseClicked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      std::string p_module_name{};
      ModulePosition p_position{};
      PageHandler_RecordModulePauseClicked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleName(&p_module_name))
        success = false;
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordModulePauseClicked(        
        std::move(p_module_name), 
        std::move(p_position));
      return true;
    }
    case messages::PageHandler::kRecordModuleRestartClicked: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordModuleRestartClicked_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordModuleRestartClicked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.13
      bool success = true;
      std::string p_module_name{};
      ModulePosition p_position{};
      PageHandler_RecordModuleRestartClicked_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleName(&p_module_name))
        success = false;
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordModuleRestartClicked(        
        std::move(p_module_name), 
        std::move(p_position));
      return true;
    }
    case messages::PageHandler::kRecordBrowserCommandExecuted: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordBrowserCommandExecuted_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordBrowserCommandExecuted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.14
      bool success = true;
      PageHandler_RecordBrowserCommandExecuted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordBrowserCommandExecuted(        );
      return true;
    }
    case messages::PageHandler::kRecordQrCodeToggled: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordQrCodeToggled_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordQrCodeToggled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.15
      bool success = true;
      bool p_expanded{};
      PageHandler_RecordQrCodeToggled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_expanded = input_data_view.expanded();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordQrCodeToggled(        
        std::move(p_expanded));
      return true;
    }
    case messages::PageHandler::kRecordNavClick: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordNavClick_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordNavClick_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.16
      bool success = true;
      PageHandler_RecordNavClick_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordNavClick(        );
      return true;
    }
    case messages::PageHandler::kRecordFeatureTileNavigation: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordFeatureTileNavigation_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordFeatureTileNavigation_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.17
      bool success = true;
      PageHandler_RecordFeatureTileNavigation_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordFeatureTileNavigation(        );
      return true;
    }
    case messages::PageHandler::kRecordCarouselScrollButtonClick: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordCarouselScrollButtonClick_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordCarouselScrollButtonClick_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.18
      bool success = true;
      PageHandler_RecordCarouselScrollButtonClick_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordCarouselScrollButtonClick(        );
      return true;
    }
    case messages::PageHandler::kRecordExpandMediaToggled: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordExpandMediaToggled_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordExpandMediaToggled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.19
      bool success = true;
      std::string p_module_name{};
      bool p_expanded{};
      PageHandler_RecordExpandMediaToggled_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadModuleName(&p_module_name))
        success = false;
      if (success)
        p_expanded = input_data_view.expanded();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordExpandMediaToggled(        
        std::move(p_module_name), 
        std::move(p_expanded));
      return true;
    }
    case messages::PageHandler::kRecordCtaClick: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordCtaClick_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordCtaClick_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.20
      bool success = true;
      PageHandler_RecordCtaClick_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 20, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordCtaClick(        );
      return true;
    }
    case messages::PageHandler::kRecordNextButtonClick: {
      DCHECK(message->is_serialized());
      internal::PageHandler_RecordNextButtonClick_Params_Data* params =
          reinterpret_cast<internal::PageHandler_RecordNextButtonClick_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.21
      bool success = true;
      PageHandler_RecordNextButtonClick_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 21, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RecordNextButtonClick(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetServerUrl: {
      internal::PageHandler_GetServerUrl_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetServerUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      bool p_is_staging{};
      PageHandler_GetServerUrl_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_staging = input_data_view.is_staging();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetServerUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetServerUrl(        
        std::move(p_is_staging), std::move(callback));
      return true;
    }
    case messages::PageHandler::kRecordTimeToLoadContent: {
      break;
    }
    case messages::PageHandler::kRecordVersionPageLoaded: {
      break;
    }
    case messages::PageHandler::kRecordEditionPageLoaded: {
      break;
    }
    case messages::PageHandler::kRecordModuleImpression: {
      break;
    }
    case messages::PageHandler::kRecordExploreMoreToggled: {
      break;
    }
    case messages::PageHandler::kRecordScrollDepth: {
      break;
    }
    case messages::PageHandler::kRecordTimeOnPage: {
      break;
    }
    case messages::PageHandler::kRecordModuleLinkClicked: {
      break;
    }
    case messages::PageHandler::kRecordModuleVideoStarted: {
      break;
    }
    case messages::PageHandler::kRecordModuleVideoEnded: {
      break;
    }
    case messages::PageHandler::kRecordModulePlayClicked: {
      break;
    }
    case messages::PageHandler::kRecordModulePauseClicked: {
      break;
    }
    case messages::PageHandler::kRecordModuleRestartClicked: {
      break;
    }
    case messages::PageHandler::kRecordBrowserCommandExecuted: {
      break;
    }
    case messages::PageHandler::kRecordQrCodeToggled: {
      break;
    }
    case messages::PageHandler::kRecordNavClick: {
      break;
    }
    case messages::PageHandler::kRecordFeatureTileNavigation: {
      break;
    }
    case messages::PageHandler::kRecordCarouselScrollButtonClick: {
      break;
    }
    case messages::PageHandler::kRecordExpandMediaToggled: {
      break;
    }
    case messages::PageHandler::kRecordCtaClick: {
      break;
    }
    case messages::PageHandler::kRecordNextButtonClick: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetServerUrl_Params_Data::Validate,
     &internal::PageHandler_GetServerUrl_ResponseParams_Data::Validate},
    { &internal::PageHandler_RecordTimeToLoadContent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordVersionPageLoaded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordEditionPageLoaded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordModuleImpression_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordExploreMoreToggled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordScrollDepth_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordTimeOnPage_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordModuleLinkClicked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordModuleVideoStarted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordModuleVideoEnded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordModulePlayClicked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordModulePauseClicked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordModuleRestartClicked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordBrowserCommandExecuted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordQrCodeToggled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordNavClick_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordFeatureTileNavigation_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordCarouselScrollButtonClick_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordExpandMediaToggled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordCtaClick_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_RecordNextButtonClick_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::whats_new::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::whats_new::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::whats_new::mojom::Page::Name_,
    {});
}



}  // whats_new::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace whats_new::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetServerUrl(bool is_staging, GetServerUrlCallback callback) {
  GetForwardingInterface()->GetServerUrl(
    std::move(is_staging)
    , std::move(callback));
}
void PageHandlerInterceptorForTesting::RecordTimeToLoadContent(::base::Time time) {
  GetForwardingInterface()->RecordTimeToLoadContent(
    std::move(time)
    );
}
void PageHandlerInterceptorForTesting::RecordVersionPageLoaded(bool is_auto_open) {
  GetForwardingInterface()->RecordVersionPageLoaded(
    std::move(is_auto_open)
    );
}
void PageHandlerInterceptorForTesting::RecordEditionPageLoaded(const std::string& page_uid, bool is_auto_open) {
  GetForwardingInterface()->RecordEditionPageLoaded(
    std::move(page_uid)
    , 
    std::move(is_auto_open)
    );
}
void PageHandlerInterceptorForTesting::RecordModuleImpression(const std::string& module_name, ModulePosition position) {
  GetForwardingInterface()->RecordModuleImpression(
    std::move(module_name)
    , 
    std::move(position)
    );
}
void PageHandlerInterceptorForTesting::RecordExploreMoreToggled(bool expanded) {
  GetForwardingInterface()->RecordExploreMoreToggled(
    std::move(expanded)
    );
}
void PageHandlerInterceptorForTesting::RecordScrollDepth(ScrollDepth depth) {
  GetForwardingInterface()->RecordScrollDepth(
    std::move(depth)
    );
}
void PageHandlerInterceptorForTesting::RecordTimeOnPage(::base::TimeDelta time) {
  GetForwardingInterface()->RecordTimeOnPage(
    std::move(time)
    );
}
void PageHandlerInterceptorForTesting::RecordModuleLinkClicked(const std::string& module_name, ModulePosition position) {
  GetForwardingInterface()->RecordModuleLinkClicked(
    std::move(module_name)
    , 
    std::move(position)
    );
}
void PageHandlerInterceptorForTesting::RecordModuleVideoStarted(const std::string& module_name, ModulePosition position) {
  GetForwardingInterface()->RecordModuleVideoStarted(
    std::move(module_name)
    , 
    std::move(position)
    );
}
void PageHandlerInterceptorForTesting::RecordModuleVideoEnded(const std::string& module_name, ModulePosition position) {
  GetForwardingInterface()->RecordModuleVideoEnded(
    std::move(module_name)
    , 
    std::move(position)
    );
}
void PageHandlerInterceptorForTesting::RecordModulePlayClicked(const std::string& module_name, ModulePosition position) {
  GetForwardingInterface()->RecordModulePlayClicked(
    std::move(module_name)
    , 
    std::move(position)
    );
}
void PageHandlerInterceptorForTesting::RecordModulePauseClicked(const std::string& module_name, ModulePosition position) {
  GetForwardingInterface()->RecordModulePauseClicked(
    std::move(module_name)
    , 
    std::move(position)
    );
}
void PageHandlerInterceptorForTesting::RecordModuleRestartClicked(const std::string& module_name, ModulePosition position) {
  GetForwardingInterface()->RecordModuleRestartClicked(
    std::move(module_name)
    , 
    std::move(position)
    );
}
void PageHandlerInterceptorForTesting::RecordBrowserCommandExecuted() {
  GetForwardingInterface()->RecordBrowserCommandExecuted();
}
void PageHandlerInterceptorForTesting::RecordQrCodeToggled(bool expanded) {
  GetForwardingInterface()->RecordQrCodeToggled(
    std::move(expanded)
    );
}
void PageHandlerInterceptorForTesting::RecordNavClick() {
  GetForwardingInterface()->RecordNavClick();
}
void PageHandlerInterceptorForTesting::RecordFeatureTileNavigation() {
  GetForwardingInterface()->RecordFeatureTileNavigation();
}
void PageHandlerInterceptorForTesting::RecordCarouselScrollButtonClick() {
  GetForwardingInterface()->RecordCarouselScrollButtonClick();
}
void PageHandlerInterceptorForTesting::RecordExpandMediaToggled(const std::string& module_name, bool expanded) {
  GetForwardingInterface()->RecordExpandMediaToggled(
    std::move(module_name)
    , 
    std::move(expanded)
    );
}
void PageHandlerInterceptorForTesting::RecordCtaClick() {
  GetForwardingInterface()->RecordCtaClick();
}
void PageHandlerInterceptorForTesting::RecordNextButtonClick() {
  GetForwardingInterface()->RecordNextButtonClick();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetServerUrl(
    bool is_staging, ::GURL* out_url) {
  base::RunLoop loop;
  proxy_->GetServerUrl(
      std::move(is_staging),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::GURL* out_url
,
             const ::GURL& url) {*out_url = std::move(url);
            loop->Quit();
          },
          &loop,
          out_url));
  loop.Run();
}

::GURL PageHandlerAsyncWaiter::GetServerUrl(
    bool is_staging) {
  ::GURL async_wait_result;
  GetServerUrl(std::move(is_staging),&async_wait_result);
  return async_wait_result;
}




PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // whats_new::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif