// chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-params-data.h"
#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-import-headers.h"
#include "chrome/browser/ui/webui/web_app_internals/web_app_internals.mojom-test-utils.h"


namespace mojom {
InstallIsolatedWebAppSuccess::InstallIsolatedWebAppSuccess()
    : web_bundle_id() {}

InstallIsolatedWebAppSuccess::InstallIsolatedWebAppSuccess(
    const std::string& web_bundle_id_in)
    : web_bundle_id(std::move(web_bundle_id_in)) {}

InstallIsolatedWebAppSuccess::~InstallIsolatedWebAppSuccess() = default;
size_t InstallIsolatedWebAppSuccess::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->web_bundle_id);
  return seed;
}

void InstallIsolatedWebAppSuccess::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_id"), this->web_bundle_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InstallIsolatedWebAppSuccess::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UpdateInfo::UpdateInfo()
    : update_manifest_url(),
      update_channel(),
      pinned_version(),
      allow_downgrades(false) {}

UpdateInfo::UpdateInfo(
    const ::GURL& update_manifest_url_in,
    const std::string& update_channel_in,
    const std::optional<std::string>& pinned_version_in,
    bool allow_downgrades_in)
    : update_manifest_url(std::move(update_manifest_url_in)),
      update_channel(std::move(update_channel_in)),
      pinned_version(std::move(pinned_version_in)),
      allow_downgrades(std::move(allow_downgrades_in)) {}

UpdateInfo::~UpdateInfo() = default;

void UpdateInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_manifest_url"), this->update_manifest_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_channel"), this->update_channel,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinned_version"), this->pinned_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_downgrades"), this->allow_downgrades,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UpdateInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IwaDevModeAppInfo::IwaDevModeAppInfo()
    : app_id(),
      name(),
      location(),
      installed_version(),
      update_info() {}

IwaDevModeAppInfo::IwaDevModeAppInfo(
    const std::string& app_id_in,
    const std::string& name_in,
    IwaDevModeLocationPtr location_in,
    const std::string& installed_version_in,
    UpdateInfoPtr update_info_in)
    : app_id(std::move(app_id_in)),
      name(std::move(name_in)),
      location(std::move(location_in)),
      installed_version(std::move(installed_version_in)),
      update_info(std::move(update_info_in)) {}

IwaDevModeAppInfo::~IwaDevModeAppInfo() = default;

void IwaDevModeAppInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_id"), this->app_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "location"), this->location,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IwaDevModeLocationPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "installed_version"), this->installed_version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_info"), this->update_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UpdateInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IwaDevModeAppInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
VersionEntry::VersionEntry()
    : version(),
      web_bundle_url() {}

VersionEntry::VersionEntry(
    const std::string& version_in,
    const ::GURL& web_bundle_url_in)
    : version(std::move(version_in)),
      web_bundle_url(std::move(web_bundle_url_in)) {}

VersionEntry::~VersionEntry() = default;

void VersionEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_url"), this->web_bundle_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool VersionEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UpdateManifest::UpdateManifest()
    : versions() {}

UpdateManifest::UpdateManifest(
    std::vector<VersionEntryPtr> versions_in)
    : versions(std::move(versions_in)) {}

UpdateManifest::~UpdateManifest() = default;

void UpdateManifest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "versions"), this->versions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<VersionEntryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UpdateManifest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InstallFromBundleUrlParams::InstallFromBundleUrlParams()
    : web_bundle_url(),
      update_info() {}

InstallFromBundleUrlParams::InstallFromBundleUrlParams(
    const ::GURL& web_bundle_url_in,
    UpdateInfoPtr update_info_in)
    : web_bundle_url(std::move(web_bundle_url_in)),
      update_info(std::move(update_info_in)) {}

InstallFromBundleUrlParams::~InstallFromBundleUrlParams() = default;

void InstallFromBundleUrlParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "web_bundle_url"), this->web_bundle_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "update_info"), this->update_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UpdateInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool InstallFromBundleUrlParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
InstallIsolatedWebAppResultPtr
InstallIsolatedWebAppResult::NewSuccess(
    InstallIsolatedWebAppSuccessPtr value) {
  return InstallIsolatedWebAppResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
      std::move(value));
}

InstallIsolatedWebAppResultPtr
InstallIsolatedWebAppResult::NewError(
    const std::string& value) {
  return InstallIsolatedWebAppResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

InstallIsolatedWebAppResult::InstallIsolatedWebAppResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    InstallIsolatedWebAppSuccessPtr value)
    : tag_(Tag::kSuccess),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSuccess)>,
            std::move(value)) {}

InstallIsolatedWebAppResult::InstallIsolatedWebAppResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    const std::string& value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
InstallIsolatedWebAppResult::~InstallIsolatedWebAppResult() {
  DestroyActive();
}

void InstallIsolatedWebAppResult::set_success(InstallIsolatedWebAppSuccessPtr success) {
  if (tag_ == Tag::kSuccess) {
    data_.success = std::move(success);
  } else {
    DestroyActive();
    tag_ = Tag::kSuccess;
    new (&data_.success) InstallIsolatedWebAppSuccessPtr(
        std::move(success));
  }
}

void InstallIsolatedWebAppResult::set_error(const std::string& error) {
  if (tag_ == Tag::kError) {
    data_.error = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    new (&data_.error) std::string(
        std::move(error));
  }
}


InstallIsolatedWebAppResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSuccess)>,
    InstallIsolatedWebAppSuccessPtr value)
    : success(std::move(value)) {}

InstallIsolatedWebAppResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    const std::string& value)
    : error(std::move(value)) {}

void InstallIsolatedWebAppResult::DestroyActive() {
  switch (tag_) {

    case Tag::kSuccess:
      std::destroy_at(&data_.success);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}
size_t InstallIsolatedWebAppResult::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::kSuccess:
      return mojo::internal::Hash(seed, data_.success);
    case Tag::kError:
      return mojo::internal::Hash(seed, data_.error);
    default:
      NOTREACHED();
  }
}

bool InstallIsolatedWebAppResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
IwaDevModeLocationPtr
IwaDevModeLocation::NewProxyOrigin(
    const ::url::Origin& value) {
  return IwaDevModeLocationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kProxyOrigin)>,
      std::move(value));
}

IwaDevModeLocationPtr
IwaDevModeLocation::NewBundlePath(
    const ::base::FilePath& value) {
  return IwaDevModeLocationPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kBundlePath)>,
      std::move(value));
}

IwaDevModeLocation::IwaDevModeLocation(
    std::in_place_index_t<static_cast<size_t>(Tag::kProxyOrigin)>,
    const ::url::Origin& value)
    : tag_(Tag::kProxyOrigin),
      data_(std::in_place_index<static_cast<size_t>(Tag::kProxyOrigin)>,
            std::move(value)) {}

IwaDevModeLocation::IwaDevModeLocation(
    std::in_place_index_t<static_cast<size_t>(Tag::kBundlePath)>,
    const ::base::FilePath& value)
    : tag_(Tag::kBundlePath),
      data_(std::in_place_index<static_cast<size_t>(Tag::kBundlePath)>,
            std::move(value)) {}
IwaDevModeLocation::~IwaDevModeLocation() {
  DestroyActive();
}

void IwaDevModeLocation::set_proxy_origin(const ::url::Origin& proxy_origin) {
  if (tag_ == Tag::kProxyOrigin) {
    data_.proxy_origin = std::move(proxy_origin);
  } else {
    DestroyActive();
    tag_ = Tag::kProxyOrigin;
    new (&data_.proxy_origin) ::url::Origin(
        std::move(proxy_origin));
  }
}

void IwaDevModeLocation::set_bundle_path(const ::base::FilePath& bundle_path) {
  if (tag_ == Tag::kBundlePath) {
    data_.bundle_path = std::move(bundle_path);
  } else {
    DestroyActive();
    tag_ = Tag::kBundlePath;
    new (&data_.bundle_path) ::base::FilePath(
        std::move(bundle_path));
  }
}


IwaDevModeLocation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kProxyOrigin)>,
    const ::url::Origin& value)
    : proxy_origin(std::move(value)) {}

IwaDevModeLocation::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kBundlePath)>,
    const ::base::FilePath& value)
    : bundle_path(std::move(value)) {}

void IwaDevModeLocation::DestroyActive() {
  switch (tag_) {

    case Tag::kProxyOrigin:
      std::destroy_at(&data_.proxy_origin);
      break;
    case Tag::kBundlePath:
      std::destroy_at(&data_.bundle_path);
      break;
  }
}

bool IwaDevModeLocation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
ParseUpdateManifestFromUrlResultPtr
ParseUpdateManifestFromUrlResult::NewUpdateManifest(
    UpdateManifestPtr value) {
  return ParseUpdateManifestFromUrlResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUpdateManifest)>,
      std::move(value));
}

ParseUpdateManifestFromUrlResultPtr
ParseUpdateManifestFromUrlResult::NewError(
    const std::string& value) {
  return ParseUpdateManifestFromUrlResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

ParseUpdateManifestFromUrlResult::ParseUpdateManifestFromUrlResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kUpdateManifest)>,
    UpdateManifestPtr value)
    : tag_(Tag::kUpdateManifest),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUpdateManifest)>,
            std::move(value)) {}

ParseUpdateManifestFromUrlResult::ParseUpdateManifestFromUrlResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    const std::string& value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
ParseUpdateManifestFromUrlResult::~ParseUpdateManifestFromUrlResult() {
  DestroyActive();
}

void ParseUpdateManifestFromUrlResult::set_update_manifest(UpdateManifestPtr update_manifest) {
  if (tag_ == Tag::kUpdateManifest) {
    data_.update_manifest = std::move(update_manifest);
  } else {
    DestroyActive();
    tag_ = Tag::kUpdateManifest;
    new (&data_.update_manifest) UpdateManifestPtr(
        std::move(update_manifest));
  }
}

void ParseUpdateManifestFromUrlResult::set_error(const std::string& error) {
  if (tag_ == Tag::kError) {
    data_.error = std::move(error);
  } else {
    DestroyActive();
    tag_ = Tag::kError;
    new (&data_.error) std::string(
        std::move(error));
  }
}


ParseUpdateManifestFromUrlResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUpdateManifest)>,
    UpdateManifestPtr value)
    : update_manifest(std::move(value)) {}

ParseUpdateManifestFromUrlResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    const std::string& value)
    : error(std::move(value)) {}

void ParseUpdateManifestFromUrlResult::DestroyActive() {
  switch (tag_) {

    case Tag::kUpdateManifest:
      std::destroy_at(&data_.update_manifest);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool ParseUpdateManifestFromUrlResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

WebAppInternalsHandler::IPCStableHashFunction WebAppInternalsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebAppInternalsHandler>(message.name())) {
    case messages::WebAppInternalsHandler::kGetDebugInfoAsJsonString: {
      return &WebAppInternalsHandler::GetDebugInfoAsJsonString_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromDevProxy: {
      return &WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxy_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kSelectFileAndInstallIsolatedWebAppFromDevBundle: {
      return &WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundle_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kParseUpdateManifestFromUrl: {
      return &WebAppInternalsHandler::ParseUpdateManifestFromUrl_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromBundleUrl: {
      return &WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrl_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kUpdateDevProxyIsolatedWebApp: {
      return &WebAppInternalsHandler::UpdateDevProxyIsolatedWebApp_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kSelectFileAndUpdateIsolatedWebAppFromDevBundle: {
      return &WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundle_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kUpdateManifestInstalledIsolatedWebApp: {
      return &WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebApp_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kSetUpdateChannelForIsolatedWebApp: {
      return &WebAppInternalsHandler::SetUpdateChannelForIsolatedWebApp_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kSetPinnedVersionForIsolatedWebApp: {
      return &WebAppInternalsHandler::SetPinnedVersionForIsolatedWebApp_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kResetPinnedVersionForIsolatedWebApp: {
      return &WebAppInternalsHandler::ResetPinnedVersionForIsolatedWebApp_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kSetAllowDowngradesForIsolatedWebApp: {
      return &WebAppInternalsHandler::SetAllowDowngradesForIsolatedWebApp_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kSearchForIsolatedWebAppUpdates: {
      return &WebAppInternalsHandler::SearchForIsolatedWebAppUpdates_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kGetIsolatedWebAppDevModeAppInfo: {
      return &WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfo_Sym::IPCStableHash;
    }
    case messages::WebAppInternalsHandler::kRotateKey: {
      return &WebAppInternalsHandler::RotateKey_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebAppInternalsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebAppInternalsHandler>(message.name())) {
      case messages::WebAppInternalsHandler::kGetDebugInfoAsJsonString:
            return "Receive mojom::WebAppInternalsHandler::GetDebugInfoAsJsonString";
      case messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromDevProxy:
            return "Receive mojom::WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxy";
      case messages::WebAppInternalsHandler::kSelectFileAndInstallIsolatedWebAppFromDevBundle:
            return "Receive mojom::WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundle";
      case messages::WebAppInternalsHandler::kParseUpdateManifestFromUrl:
            return "Receive mojom::WebAppInternalsHandler::ParseUpdateManifestFromUrl";
      case messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromBundleUrl:
            return "Receive mojom::WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrl";
      case messages::WebAppInternalsHandler::kUpdateDevProxyIsolatedWebApp:
            return "Receive mojom::WebAppInternalsHandler::UpdateDevProxyIsolatedWebApp";
      case messages::WebAppInternalsHandler::kSelectFileAndUpdateIsolatedWebAppFromDevBundle:
            return "Receive mojom::WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundle";
      case messages::WebAppInternalsHandler::kUpdateManifestInstalledIsolatedWebApp:
            return "Receive mojom::WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebApp";
      case messages::WebAppInternalsHandler::kSetUpdateChannelForIsolatedWebApp:
            return "Receive mojom::WebAppInternalsHandler::SetUpdateChannelForIsolatedWebApp";
      case messages::WebAppInternalsHandler::kSetPinnedVersionForIsolatedWebApp:
            return "Receive mojom::WebAppInternalsHandler::SetPinnedVersionForIsolatedWebApp";
      case messages::WebAppInternalsHandler::kResetPinnedVersionForIsolatedWebApp:
            return "Receive mojom::WebAppInternalsHandler::ResetPinnedVersionForIsolatedWebApp";
      case messages::WebAppInternalsHandler::kSetAllowDowngradesForIsolatedWebApp:
            return "Receive mojom::WebAppInternalsHandler::SetAllowDowngradesForIsolatedWebApp";
      case messages::WebAppInternalsHandler::kSearchForIsolatedWebAppUpdates:
            return "Receive mojom::WebAppInternalsHandler::SearchForIsolatedWebAppUpdates";
      case messages::WebAppInternalsHandler::kGetIsolatedWebAppDevModeAppInfo:
            return "Receive mojom::WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfo";
      case messages::WebAppInternalsHandler::kRotateKey:
            return "Receive mojom::WebAppInternalsHandler::RotateKey";
    }
  } else {
    switch (static_cast<messages::WebAppInternalsHandler>(message.name())) {
      case messages::WebAppInternalsHandler::kGetDebugInfoAsJsonString:
            return "Receive reply mojom::WebAppInternalsHandler::GetDebugInfoAsJsonString";
      case messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromDevProxy:
            return "Receive reply mojom::WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxy";
      case messages::WebAppInternalsHandler::kSelectFileAndInstallIsolatedWebAppFromDevBundle:
            return "Receive reply mojom::WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundle";
      case messages::WebAppInternalsHandler::kParseUpdateManifestFromUrl:
            return "Receive reply mojom::WebAppInternalsHandler::ParseUpdateManifestFromUrl";
      case messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromBundleUrl:
            return "Receive reply mojom::WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrl";
      case messages::WebAppInternalsHandler::kUpdateDevProxyIsolatedWebApp:
            return "Receive reply mojom::WebAppInternalsHandler::UpdateDevProxyIsolatedWebApp";
      case messages::WebAppInternalsHandler::kSelectFileAndUpdateIsolatedWebAppFromDevBundle:
            return "Receive reply mojom::WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundle";
      case messages::WebAppInternalsHandler::kUpdateManifestInstalledIsolatedWebApp:
            return "Receive reply mojom::WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebApp";
      case messages::WebAppInternalsHandler::kSetUpdateChannelForIsolatedWebApp:
            return "Receive reply mojom::WebAppInternalsHandler::SetUpdateChannelForIsolatedWebApp";
      case messages::WebAppInternalsHandler::kSetPinnedVersionForIsolatedWebApp:
            return "Receive reply mojom::WebAppInternalsHandler::SetPinnedVersionForIsolatedWebApp";
      case messages::WebAppInternalsHandler::kResetPinnedVersionForIsolatedWebApp:
            return "Receive reply mojom::WebAppInternalsHandler::ResetPinnedVersionForIsolatedWebApp";
      case messages::WebAppInternalsHandler::kSetAllowDowngradesForIsolatedWebApp:
            return "Receive reply mojom::WebAppInternalsHandler::SetAllowDowngradesForIsolatedWebApp";
      case messages::WebAppInternalsHandler::kSearchForIsolatedWebAppUpdates:
            return "Receive reply mojom::WebAppInternalsHandler::SearchForIsolatedWebAppUpdates";
      case messages::WebAppInternalsHandler::kGetIsolatedWebAppDevModeAppInfo:
            return "Receive reply mojom::WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfo";
      case messages::WebAppInternalsHandler::kRotateKey:
            return "Receive reply mojom::WebAppInternalsHandler::RotateKey";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebAppInternalsHandler::GetDebugInfoAsJsonString_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x126fa24c;  // IPCStableHash for mojom::WebAppInternalsHandler::GetDebugInfoAsJsonString
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxy_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x10fcefd5;  // IPCStableHash for mojom::WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxy
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2e55559b;  // IPCStableHash for mojom::WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::ParseUpdateManifestFromUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc765bd75;  // IPCStableHash for mojom::WebAppInternalsHandler::ParseUpdateManifestFromUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrl_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf4bd8fe3;  // IPCStableHash for mojom::WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrl
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::UpdateDevProxyIsolatedWebApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6bcc4ac6;  // IPCStableHash for mojom::WebAppInternalsHandler::UpdateDevProxyIsolatedWebApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundle_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa66192ed;  // IPCStableHash for mojom::WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundle
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95ff97b9;  // IPCStableHash for mojom::WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::SetUpdateChannelForIsolatedWebApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x831ab47a;  // IPCStableHash for mojom::WebAppInternalsHandler::SetUpdateChannelForIsolatedWebApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::SetPinnedVersionForIsolatedWebApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbffa273b;  // IPCStableHash for mojom::WebAppInternalsHandler::SetPinnedVersionForIsolatedWebApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::ResetPinnedVersionForIsolatedWebApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x80fcca12;  // IPCStableHash for mojom::WebAppInternalsHandler::ResetPinnedVersionForIsolatedWebApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::SetAllowDowngradesForIsolatedWebApp_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x76d881ab;  // IPCStableHash for mojom::WebAppInternalsHandler::SetAllowDowngradesForIsolatedWebApp
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::SearchForIsolatedWebAppUpdates_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9edc04cb;  // IPCStableHash for mojom::WebAppInternalsHandler::SearchForIsolatedWebAppUpdates
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x078d49f0;  // IPCStableHash for mojom::WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t WebAppInternalsHandler::RotateKey_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5b32fc9b;  // IPCStableHash for mojom::WebAppInternalsHandler::RotateKey
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebAppInternalsHandler_GetDebugInfoAsJsonString_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_GetDebugInfoAsJsonString_ForwardToCallback(
      WebAppInternalsHandler::GetDebugInfoAsJsonStringCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_GetDebugInfoAsJsonString_ForwardToCallback(const WebAppInternalsHandler_GetDebugInfoAsJsonString_ForwardToCallback&) = delete;
  WebAppInternalsHandler_GetDebugInfoAsJsonString_ForwardToCallback& operator=(const WebAppInternalsHandler_GetDebugInfoAsJsonString_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::GetDebugInfoAsJsonStringCallback callback_;
};

class WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ForwardToCallback(
      WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxyCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ForwardToCallback(const WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ForwardToCallback&) = delete;
  WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ForwardToCallback& operator=(const WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxyCallback callback_;
};

class WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ForwardToCallback(
      WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundleCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ForwardToCallback(const WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ForwardToCallback&) = delete;
  WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ForwardToCallback& operator=(const WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundleCallback callback_;
};

class WebAppInternalsHandler_ParseUpdateManifestFromUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_ParseUpdateManifestFromUrl_ForwardToCallback(
      WebAppInternalsHandler::ParseUpdateManifestFromUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_ParseUpdateManifestFromUrl_ForwardToCallback(const WebAppInternalsHandler_ParseUpdateManifestFromUrl_ForwardToCallback&) = delete;
  WebAppInternalsHandler_ParseUpdateManifestFromUrl_ForwardToCallback& operator=(const WebAppInternalsHandler_ParseUpdateManifestFromUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::ParseUpdateManifestFromUrlCallback callback_;
};

class WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ForwardToCallback(
      WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrlCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ForwardToCallback(const WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ForwardToCallback&) = delete;
  WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ForwardToCallback& operator=(const WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrlCallback callback_;
};

class WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ForwardToCallback(
      WebAppInternalsHandler::UpdateDevProxyIsolatedWebAppCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ForwardToCallback(const WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ForwardToCallback&) = delete;
  WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ForwardToCallback& operator=(const WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::UpdateDevProxyIsolatedWebAppCallback callback_;
};

class WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ForwardToCallback(
      WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundleCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ForwardToCallback(const WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ForwardToCallback&) = delete;
  WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ForwardToCallback& operator=(const WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundleCallback callback_;
};

class WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ForwardToCallback(
      WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebAppCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ForwardToCallback(const WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ForwardToCallback&) = delete;
  WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ForwardToCallback& operator=(const WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebAppCallback callback_;
};

class WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ForwardToCallback(
      WebAppInternalsHandler::SetUpdateChannelForIsolatedWebAppCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ForwardToCallback(const WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ForwardToCallback&) = delete;
  WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ForwardToCallback& operator=(const WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::SetUpdateChannelForIsolatedWebAppCallback callback_;
};

class WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ForwardToCallback(
      WebAppInternalsHandler::SetPinnedVersionForIsolatedWebAppCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ForwardToCallback(const WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ForwardToCallback&) = delete;
  WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ForwardToCallback& operator=(const WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::SetPinnedVersionForIsolatedWebAppCallback callback_;
};

class WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ForwardToCallback(
      WebAppInternalsHandler::SearchForIsolatedWebAppUpdatesCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ForwardToCallback(const WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ForwardToCallback&) = delete;
  WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ForwardToCallback& operator=(const WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::SearchForIsolatedWebAppUpdatesCallback callback_;
};

class WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ForwardToCallback(
      WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ForwardToCallback(const WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ForwardToCallback&) = delete;
  WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ForwardToCallback& operator=(const WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfoCallback callback_;
};

WebAppInternalsHandlerProxy::WebAppInternalsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebAppInternalsHandlerProxy::GetDebugInfoAsJsonString(
    GetDebugInfoAsJsonStringCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::WebAppInternalsHandler::GetDebugInfoAsJsonString");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kGetDebugInfoAsJsonString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_GetDebugInfoAsJsonString_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("GetDebugInfoAsJsonString");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_GetDebugInfoAsJsonString_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::InstallIsolatedWebAppFromDevProxy(
    const ::GURL& in_url, InstallIsolatedWebAppFromDevProxyCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxy", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromDevProxy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in WebAppInternalsHandler.InstallIsolatedWebAppFromDevProxy request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("InstallIsolatedWebAppFromDevProxy");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::SelectFileAndInstallIsolatedWebAppFromDevBundle(
    SelectFileAndInstallIsolatedWebAppFromDevBundleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundle");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSelectFileAndInstallIsolatedWebAppFromDevBundle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SelectFileAndInstallIsolatedWebAppFromDevBundle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::ParseUpdateManifestFromUrl(
    const ::GURL& in_update_manifest_url, ParseUpdateManifestFromUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::ParseUpdateManifestFromUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_manifest_url"), in_update_manifest_url,
                        "<value of type const ::GURL&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kParseUpdateManifestFromUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->update_manifest_url)::BaseType> update_manifest_url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_update_manifest_url,
    update_manifest_url_fragment);

  params->update_manifest_url.Set(
      update_manifest_url_fragment.is_null() ? nullptr : update_manifest_url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->update_manifest_url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null update_manifest_url in WebAppInternalsHandler.ParseUpdateManifestFromUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("ParseUpdateManifestFromUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_ParseUpdateManifestFromUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::InstallIsolatedWebAppFromBundleUrl(
    InstallFromBundleUrlParamsPtr in_params, InstallIsolatedWebAppFromBundleUrlCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrl", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type InstallFromBundleUrlParamsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromBundleUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojom::InstallFromBundleUrlParamsDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in WebAppInternalsHandler.InstallIsolatedWebAppFromBundleUrl request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("InstallIsolatedWebAppFromBundleUrl");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::UpdateDevProxyIsolatedWebApp(
    const std::string& in_app_id, UpdateDevProxyIsolatedWebAppCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::UpdateDevProxyIsolatedWebApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kUpdateDevProxyIsolatedWebApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in WebAppInternalsHandler.UpdateDevProxyIsolatedWebApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("UpdateDevProxyIsolatedWebApp");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::SelectFileAndUpdateIsolatedWebAppFromDevBundle(
    const std::string& in_app_id, SelectFileAndUpdateIsolatedWebAppFromDevBundleCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundle", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSelectFileAndUpdateIsolatedWebAppFromDevBundle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in WebAppInternalsHandler.SelectFileAndUpdateIsolatedWebAppFromDevBundle request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SelectFileAndUpdateIsolatedWebAppFromDevBundle");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::UpdateManifestInstalledIsolatedWebApp(
    const std::string& in_app_id, UpdateManifestInstalledIsolatedWebAppCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kUpdateManifestInstalledIsolatedWebApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in WebAppInternalsHandler.UpdateManifestInstalledIsolatedWebApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("UpdateManifestInstalledIsolatedWebApp");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::SetUpdateChannelForIsolatedWebApp(
    const std::string& in_app_id, const std::string& in_update_channel, SetUpdateChannelForIsolatedWebAppCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::SetUpdateChannelForIsolatedWebApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("update_channel"), in_update_channel,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSetUpdateChannelForIsolatedWebApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in WebAppInternalsHandler.SetUpdateChannelForIsolatedWebApp request");
  mojo::internal::MessageFragment<
      typename decltype(params->update_channel)::BaseType> update_channel_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_update_channel,
    update_channel_fragment);

  params->update_channel.Set(
      update_channel_fragment.is_null() ? nullptr : update_channel_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->update_channel.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null update_channel in WebAppInternalsHandler.SetUpdateChannelForIsolatedWebApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SetUpdateChannelForIsolatedWebApp");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::SetPinnedVersionForIsolatedWebApp(
    const std::string& in_app_id, const std::string& in_pinned_version, SetPinnedVersionForIsolatedWebAppCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::SetPinnedVersionForIsolatedWebApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("pinned_version"), in_pinned_version,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSetPinnedVersionForIsolatedWebApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in WebAppInternalsHandler.SetPinnedVersionForIsolatedWebApp request");
  mojo::internal::MessageFragment<
      typename decltype(params->pinned_version)::BaseType> pinned_version_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_pinned_version,
    pinned_version_fragment);

  params->pinned_version.Set(
      pinned_version_fragment.is_null() ? nullptr : pinned_version_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->pinned_version.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null pinned_version in WebAppInternalsHandler.SetPinnedVersionForIsolatedWebApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SetPinnedVersionForIsolatedWebApp");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::ResetPinnedVersionForIsolatedWebApp(
    const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::ResetPinnedVersionForIsolatedWebApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kResetPinnedVersionForIsolatedWebApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in WebAppInternalsHandler.ResetPinnedVersionForIsolatedWebApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("ResetPinnedVersionForIsolatedWebApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebAppInternalsHandlerProxy::SetAllowDowngradesForIsolatedWebApp(
    bool in_allow_downgrades, const std::string& in_app_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::SetAllowDowngradesForIsolatedWebApp", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_downgrades"), in_allow_downgrades,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("app_id"), in_app_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSetAllowDowngradesForIsolatedWebApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params_Data> params(
          message);
  params.Allocate();

  params->allow_downgrades = in_allow_downgrades;
  mojo::internal::MessageFragment<
      typename decltype(params->app_id)::BaseType> app_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_app_id,
    app_id_fragment);

  params->app_id.Set(
      app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->app_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null app_id in WebAppInternalsHandler.SetAllowDowngradesForIsolatedWebApp request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SetAllowDowngradesForIsolatedWebApp");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void WebAppInternalsHandlerProxy::SearchForIsolatedWebAppUpdates(
    SearchForIsolatedWebAppUpdatesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::WebAppInternalsHandler::SearchForIsolatedWebAppUpdates");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSearchForIsolatedWebAppUpdates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SearchForIsolatedWebAppUpdates");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::GetIsolatedWebAppDevModeAppInfo(
    GetIsolatedWebAppDevModeAppInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kGetIsolatedWebAppDevModeAppInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("GetIsolatedWebAppDevModeAppInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void WebAppInternalsHandlerProxy::RotateKey(
    const std::string& in_web_bundle_id, const std::optional<std::vector<uint8_t>>& in_rotated_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send mojom::WebAppInternalsHandler::RotateKey", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("web_bundle_id"), in_web_bundle_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("rotated_key"), in_rotated_key,
                        "<value of type const std::optional<std::vector<uint8_t>>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kRotateKey), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_RotateKey_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->web_bundle_id)::BaseType> web_bundle_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_web_bundle_id,
    web_bundle_id_fragment);

  params->web_bundle_id.Set(
      web_bundle_id_fragment.is_null() ? nullptr : web_bundle_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->web_bundle_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null web_bundle_id in WebAppInternalsHandler.RotateKey request");
  mojo::internal::MessageFragment<
      typename decltype(params->rotated_key)::BaseType>
      rotated_key_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& rotated_key_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_rotated_key,
    rotated_key_fragment,
    &rotated_key_validate_params);

  params->rotated_key.Set(
      rotated_key_fragment.is_null() ? nullptr : rotated_key_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("RotateKey");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class WebAppInternalsHandler_GetDebugInfoAsJsonString_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::GetDebugInfoAsJsonStringCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_GetDebugInfoAsJsonString_ProxyToResponder> proxy(
        new WebAppInternalsHandler_GetDebugInfoAsJsonString_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_GetDebugInfoAsJsonString_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_GetDebugInfoAsJsonString_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_GetDebugInfoAsJsonString_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::GetDebugInfoAsJsonStringCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_result);
};

bool WebAppInternalsHandler_GetDebugInfoAsJsonString_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.0
  bool success = true;
  std::string p_result{};
  WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebAppInternalsHandler_GetDebugInfoAsJsonString_ProxyToResponder::Run(
    const std::string& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::GetDebugInfoAsJsonString", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kGetDebugInfoAsJsonString), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("GetDebugInfoAsJsonString");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxyCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ProxyToResponder> proxy(
        new WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxyCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      InstallIsolatedWebAppResultPtr in_result);
};

bool WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.1
  bool success = true;
  InstallIsolatedWebAppResultPtr p_result{};
  WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ProxyToResponder::Run(
    InstallIsolatedWebAppResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::InstallIsolatedWebAppFromDevProxy", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type InstallIsolatedWebAppResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromDevProxy), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojom::InstallIsolatedWebAppResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("InstallIsolatedWebAppFromDevProxy");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ProxyToResponder> proxy(
        new WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      InstallIsolatedWebAppResultPtr in_result);
};

bool WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.2
  bool success = true;
  InstallIsolatedWebAppResultPtr p_result{};
  WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ProxyToResponder::Run(
    InstallIsolatedWebAppResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::SelectFileAndInstallIsolatedWebAppFromDevBundle", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type InstallIsolatedWebAppResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSelectFileAndInstallIsolatedWebAppFromDevBundle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojom::InstallIsolatedWebAppResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SelectFileAndInstallIsolatedWebAppFromDevBundle");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_ParseUpdateManifestFromUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::ParseUpdateManifestFromUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_ParseUpdateManifestFromUrl_ProxyToResponder> proxy(
        new WebAppInternalsHandler_ParseUpdateManifestFromUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_ParseUpdateManifestFromUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_ParseUpdateManifestFromUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_ParseUpdateManifestFromUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::ParseUpdateManifestFromUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ParseUpdateManifestFromUrlResultPtr in_result);
};

bool WebAppInternalsHandler_ParseUpdateManifestFromUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.3
  bool success = true;
  ParseUpdateManifestFromUrlResultPtr p_result{};
  WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebAppInternalsHandler_ParseUpdateManifestFromUrl_ProxyToResponder::Run(
    ParseUpdateManifestFromUrlResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::ParseUpdateManifestFromUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ParseUpdateManifestFromUrlResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kParseUpdateManifestFromUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojom::ParseUpdateManifestFromUrlResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("ParseUpdateManifestFromUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrlCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ProxyToResponder> proxy(
        new WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrlCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      InstallIsolatedWebAppResultPtr in_result);
};

bool WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.4
  bool success = true;
  InstallIsolatedWebAppResultPtr p_result{};
  WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ProxyToResponder::Run(
    InstallIsolatedWebAppResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::InstallIsolatedWebAppFromBundleUrl", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type InstallIsolatedWebAppResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromBundleUrl), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::mojom::InstallIsolatedWebAppResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("InstallIsolatedWebAppFromBundleUrl");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::UpdateDevProxyIsolatedWebAppCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ProxyToResponder> proxy(
        new WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::UpdateDevProxyIsolatedWebAppCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_result);
};

bool WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.5
  bool success = true;
  std::string p_result{};
  WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ProxyToResponder::Run(
    const std::string& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::UpdateDevProxyIsolatedWebApp", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kUpdateDevProxyIsolatedWebApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("UpdateDevProxyIsolatedWebApp");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundleCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ProxyToResponder> proxy(
        new WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundleCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_result);
};

bool WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.6
  bool success = true;
  std::string p_result{};
  WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ProxyToResponder::Run(
    const std::string& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::SelectFileAndUpdateIsolatedWebAppFromDevBundle", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSelectFileAndUpdateIsolatedWebAppFromDevBundle), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SelectFileAndUpdateIsolatedWebAppFromDevBundle");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebAppCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ProxyToResponder> proxy(
        new WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebAppCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_result);
};

bool WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.7
  bool success = true;
  std::string p_result{};
  WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ProxyToResponder::Run(
    const std::string& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::UpdateManifestInstalledIsolatedWebApp", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kUpdateManifestInstalledIsolatedWebApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("UpdateManifestInstalledIsolatedWebApp");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::SetUpdateChannelForIsolatedWebAppCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ProxyToResponder> proxy(
        new WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::SetUpdateChannelForIsolatedWebAppCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.8
  bool success = true;
  bool p_success{};
  WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::SetUpdateChannelForIsolatedWebApp", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSetUpdateChannelForIsolatedWebApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SetUpdateChannelForIsolatedWebApp");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::SetPinnedVersionForIsolatedWebAppCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ProxyToResponder> proxy(
        new WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::SetPinnedVersionForIsolatedWebAppCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.9
  bool success = true;
  bool p_success{};
  WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::SetPinnedVersionForIsolatedWebApp", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSetPinnedVersionForIsolatedWebApp), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SetPinnedVersionForIsolatedWebApp");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::SearchForIsolatedWebAppUpdatesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ProxyToResponder> proxy(
        new WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::SearchForIsolatedWebAppUpdatesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::string& in_result);
};

bool WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.12
  bool success = true;
  std::string p_result{};
  WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ProxyToResponder::Run(
    const std::string& in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::SearchForIsolatedWebAppUpdates", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kSearchForIsolatedWebAppUpdates), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("SearchForIsolatedWebAppUpdates");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ProxyToResponder> proxy(
        new WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<IwaDevModeAppInfoPtr> in_apps);
};

bool WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebAppInternalsHandler.13
  bool success = true;
  std::vector<IwaDevModeAppInfoPtr> p_apps{};
  WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadApps(&p_apps))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebAppInternalsHandler::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_apps));
  }
  return true;
}

void WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ProxyToResponder::Run(
    std::vector<IwaDevModeAppInfoPtr> in_apps) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::WebAppInternalsHandler::GetIsolatedWebAppDevModeAppInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("apps"), in_apps,
                        "<value of type std::vector<IwaDevModeAppInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebAppInternalsHandler::kGetIsolatedWebAppDevModeAppInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::internal::WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->apps)::BaseType>
      apps_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& apps_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::mojom::IwaDevModeAppInfoDataView>>(
    in_apps,
    apps_fragment,
    &apps_validate_params);

  params->apps.Set(
      apps_fragment.is_null() ? nullptr : apps_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->apps.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null apps in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebAppInternalsHandler::Name_);
  message.set_method_name("GetIsolatedWebAppDevModeAppInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebAppInternalsHandlerStubDispatch::Accept(
    WebAppInternalsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebAppInternalsHandler>(message->header()->name)) {
    case messages::WebAppInternalsHandler::kGetDebugInfoAsJsonString: {
      break;
    }
    case messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromDevProxy: {
      break;
    }
    case messages::WebAppInternalsHandler::kSelectFileAndInstallIsolatedWebAppFromDevBundle: {
      break;
    }
    case messages::WebAppInternalsHandler::kParseUpdateManifestFromUrl: {
      break;
    }
    case messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromBundleUrl: {
      break;
    }
    case messages::WebAppInternalsHandler::kUpdateDevProxyIsolatedWebApp: {
      break;
    }
    case messages::WebAppInternalsHandler::kSelectFileAndUpdateIsolatedWebAppFromDevBundle: {
      break;
    }
    case messages::WebAppInternalsHandler::kUpdateManifestInstalledIsolatedWebApp: {
      break;
    }
    case messages::WebAppInternalsHandler::kSetUpdateChannelForIsolatedWebApp: {
      break;
    }
    case messages::WebAppInternalsHandler::kSetPinnedVersionForIsolatedWebApp: {
      break;
    }
    case messages::WebAppInternalsHandler::kResetPinnedVersionForIsolatedWebApp: {
      DCHECK(message->is_serialized());
      internal::WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params_Data* params =
          reinterpret_cast<internal::WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.10
      bool success = true;
      std::string p_app_id{};
      WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetPinnedVersionForIsolatedWebApp(        
        std::move(p_app_id));
      return true;
    }
    case messages::WebAppInternalsHandler::kSetAllowDowngradesForIsolatedWebApp: {
      DCHECK(message->is_serialized());
      internal::WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params_Data* params =
          reinterpret_cast<internal::WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.11
      bool success = true;
      bool p_allow_downgrades{};
      std::string p_app_id{};
      WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_allow_downgrades = input_data_view.allow_downgrades();
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAllowDowngradesForIsolatedWebApp(        
        std::move(p_allow_downgrades), 
        std::move(p_app_id));
      return true;
    }
    case messages::WebAppInternalsHandler::kSearchForIsolatedWebAppUpdates: {
      break;
    }
    case messages::WebAppInternalsHandler::kGetIsolatedWebAppDevModeAppInfo: {
      break;
    }
    case messages::WebAppInternalsHandler::kRotateKey: {
      DCHECK(message->is_serialized());
      internal::WebAppInternalsHandler_RotateKey_Params_Data* params =
          reinterpret_cast<internal::WebAppInternalsHandler_RotateKey_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.14
      bool success = true;
      std::string p_web_bundle_id{};
      std::optional<std::vector<uint8_t>> p_rotated_key{};
      WebAppInternalsHandler_RotateKey_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadWebBundleId(&p_web_bundle_id))
        success = false;
      if (success && !input_data_view.ReadRotatedKey(&p_rotated_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RotateKey(        
        std::move(p_web_bundle_id), 
        std::move(p_rotated_key));
      return true;
    }
  }
  return false;
}

// static
bool WebAppInternalsHandlerStubDispatch::AcceptWithResponder(
    WebAppInternalsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebAppInternalsHandler>(message->header()->name)) {
    case messages::WebAppInternalsHandler::kGetDebugInfoAsJsonString: {
      internal::WebAppInternalsHandler_GetDebugInfoAsJsonString_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_GetDebugInfoAsJsonString_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.0
      bool success = true;
      WebAppInternalsHandler_GetDebugInfoAsJsonString_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_GetDebugInfoAsJsonString_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDebugInfoAsJsonString(std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromDevProxy: {
      internal::WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.1
      bool success = true;
      ::GURL p_url{};
      WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstallIsolatedWebAppFromDevProxy(        
        std::move(p_url), std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kSelectFileAndInstallIsolatedWebAppFromDevBundle: {
      internal::WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.2
      bool success = true;
      WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 2, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectFileAndInstallIsolatedWebAppFromDevBundle(std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kParseUpdateManifestFromUrl: {
      internal::WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.3
      bool success = true;
      ::GURL p_update_manifest_url{};
      WebAppInternalsHandler_ParseUpdateManifestFromUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUpdateManifestUrl(&p_update_manifest_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 3, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_ParseUpdateManifestFromUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseUpdateManifestFromUrl(        
        std::move(p_update_manifest_url), std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kInstallIsolatedWebAppFromBundleUrl: {
      internal::WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.4
      bool success = true;
      InstallFromBundleUrlParamsPtr p_params{};
      WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 4, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->InstallIsolatedWebAppFromBundleUrl(        
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kUpdateDevProxyIsolatedWebApp: {
      internal::WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.5
      bool success = true;
      std::string p_app_id{};
      WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 5, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateDevProxyIsolatedWebApp(        
        std::move(p_app_id), std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kSelectFileAndUpdateIsolatedWebAppFromDevBundle: {
      internal::WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.6
      bool success = true;
      std::string p_app_id{};
      WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 6, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectFileAndUpdateIsolatedWebAppFromDevBundle(        
        std::move(p_app_id), std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kUpdateManifestInstalledIsolatedWebApp: {
      internal::WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.7
      bool success = true;
      std::string p_app_id{};
      WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 7, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateManifestInstalledIsolatedWebApp(        
        std::move(p_app_id), std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kSetUpdateChannelForIsolatedWebApp: {
      internal::WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.8
      bool success = true;
      std::string p_app_id{};
      std::string p_update_channel{};
      WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadUpdateChannel(&p_update_channel))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUpdateChannelForIsolatedWebApp(        
        std::move(p_app_id), 
        std::move(p_update_channel), std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kSetPinnedVersionForIsolatedWebApp: {
      internal::WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.9
      bool success = true;
      std::string p_app_id{};
      std::string p_pinned_version{};
      WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAppId(&p_app_id))
        success = false;
      if (success && !input_data_view.ReadPinnedVersion(&p_pinned_version))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 9, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetPinnedVersionForIsolatedWebApp(        
        std::move(p_app_id), 
        std::move(p_pinned_version), std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kResetPinnedVersionForIsolatedWebApp: {
      break;
    }
    case messages::WebAppInternalsHandler::kSetAllowDowngradesForIsolatedWebApp: {
      break;
    }
    case messages::WebAppInternalsHandler::kSearchForIsolatedWebAppUpdates: {
      internal::WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.12
      bool success = true;
      WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 12, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SearchForIsolatedWebAppUpdates(std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kGetIsolatedWebAppDevModeAppInfo: {
      internal::WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params_Data* params =
          reinterpret_cast<
              internal::WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebAppInternalsHandler.13
      bool success = true;
      WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebAppInternalsHandler::Name_, 13, false);
        return false;
      }
      auto callback =
          WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetIsolatedWebAppDevModeAppInfo(std::move(callback));
      return true;
    }
    case messages::WebAppInternalsHandler::kRotateKey: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebAppInternalsHandlerValidationInfo[] = {
    { &internal::WebAppInternalsHandler_GetDebugInfoAsJsonString_Params_Data::Validate,
     &internal::WebAppInternalsHandler_GetDebugInfoAsJsonString_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_Params_Data::Validate,
     &internal::WebAppInternalsHandler_InstallIsolatedWebAppFromDevProxy_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_Params_Data::Validate,
     &internal::WebAppInternalsHandler_SelectFileAndInstallIsolatedWebAppFromDevBundle_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_ParseUpdateManifestFromUrl_Params_Data::Validate,
     &internal::WebAppInternalsHandler_ParseUpdateManifestFromUrl_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_Params_Data::Validate,
     &internal::WebAppInternalsHandler_InstallIsolatedWebAppFromBundleUrl_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_Params_Data::Validate,
     &internal::WebAppInternalsHandler_UpdateDevProxyIsolatedWebApp_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_Params_Data::Validate,
     &internal::WebAppInternalsHandler_SelectFileAndUpdateIsolatedWebAppFromDevBundle_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_Params_Data::Validate,
     &internal::WebAppInternalsHandler_UpdateManifestInstalledIsolatedWebApp_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_Params_Data::Validate,
     &internal::WebAppInternalsHandler_SetUpdateChannelForIsolatedWebApp_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_Params_Data::Validate,
     &internal::WebAppInternalsHandler_SetPinnedVersionForIsolatedWebApp_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_ResetPinnedVersionForIsolatedWebApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebAppInternalsHandler_SetAllowDowngradesForIsolatedWebApp_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_Params_Data::Validate,
     &internal::WebAppInternalsHandler_SearchForIsolatedWebAppUpdates_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_Params_Data::Validate,
     &internal::WebAppInternalsHandler_GetIsolatedWebAppDevModeAppInfo_ResponseParams_Data::Validate},
    { &internal::WebAppInternalsHandler_RotateKey_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebAppInternalsHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mojom::WebAppInternalsHandler::Name_,
    kWebAppInternalsHandlerValidationInfo);
}

bool WebAppInternalsHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::mojom::WebAppInternalsHandler::Name_,
    kWebAppInternalsHandlerValidationInfo);
}


}  // mojom


namespace mojo {


// static
bool StructTraits<::mojom::InstallIsolatedWebAppSuccess::DataView, ::mojom::InstallIsolatedWebAppSuccessPtr>::Read(
    ::mojom::InstallIsolatedWebAppSuccess::DataView input,
    ::mojom::InstallIsolatedWebAppSuccessPtr* output) {
  bool success = true;
  ::mojom::InstallIsolatedWebAppSuccessPtr result(::mojom::InstallIsolatedWebAppSuccess::New());
  
      if (success && !input.ReadWebBundleId(&result->web_bundle_id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::UpdateInfo::DataView, ::mojom::UpdateInfoPtr>::Read(
    ::mojom::UpdateInfo::DataView input,
    ::mojom::UpdateInfoPtr* output) {
  bool success = true;
  ::mojom::UpdateInfoPtr result(::mojom::UpdateInfo::New());
  
      if (success && !input.ReadUpdateManifestUrl(&result->update_manifest_url))
        success = false;
      if (success && !input.ReadUpdateChannel(&result->update_channel))
        success = false;
      if (success && !input.ReadPinnedVersion(&result->pinned_version))
        success = false;
      if (success)
        result->allow_downgrades = input.allow_downgrades();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::IwaDevModeAppInfo::DataView, ::mojom::IwaDevModeAppInfoPtr>::Read(
    ::mojom::IwaDevModeAppInfo::DataView input,
    ::mojom::IwaDevModeAppInfoPtr* output) {
  bool success = true;
  ::mojom::IwaDevModeAppInfoPtr result(::mojom::IwaDevModeAppInfo::New());
  
      if (success && !input.ReadAppId(&result->app_id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadLocation(&result->location))
        success = false;
      if (success && !input.ReadInstalledVersion(&result->installed_version))
        success = false;
      if (success && !input.ReadUpdateInfo(&result->update_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::VersionEntry::DataView, ::mojom::VersionEntryPtr>::Read(
    ::mojom::VersionEntry::DataView input,
    ::mojom::VersionEntryPtr* output) {
  bool success = true;
  ::mojom::VersionEntryPtr result(::mojom::VersionEntry::New());
  
      if (success && !input.ReadVersion(&result->version))
        success = false;
      if (success && !input.ReadWebBundleUrl(&result->web_bundle_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::UpdateManifest::DataView, ::mojom::UpdateManifestPtr>::Read(
    ::mojom::UpdateManifest::DataView input,
    ::mojom::UpdateManifestPtr* output) {
  bool success = true;
  ::mojom::UpdateManifestPtr result(::mojom::UpdateManifest::New());
  
      if (success && !input.ReadVersions(&result->versions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::InstallFromBundleUrlParams::DataView, ::mojom::InstallFromBundleUrlParamsPtr>::Read(
    ::mojom::InstallFromBundleUrlParams::DataView input,
    ::mojom::InstallFromBundleUrlParamsPtr* output) {
  bool success = true;
  ::mojom::InstallFromBundleUrlParamsPtr result(::mojom::InstallFromBundleUrlParams::New());
  
      if (success && !input.ReadWebBundleUrl(&result->web_bundle_url))
        success = false;
      if (success && !input.ReadUpdateInfo(&result->update_info))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::mojom::InstallIsolatedWebAppResult::DataView, ::mojom::InstallIsolatedWebAppResultPtr>::Read(
    ::mojom::InstallIsolatedWebAppResult::DataView input,
    ::mojom::InstallIsolatedWebAppResultPtr* output) {
  using UnionType = ::mojom::InstallIsolatedWebAppResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kSuccess: {
      ::mojom::InstallIsolatedWebAppSuccessPtr result_success{};
      if (!input.ReadSuccess(&result_success))
        return false;

      *output = UnionType::NewSuccess(
          std::move(result_success));
      break;
    }
    case Tag::kError: {
      std::string result_error{};
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::mojom::IwaDevModeLocation::DataView, ::mojom::IwaDevModeLocationPtr>::Read(
    ::mojom::IwaDevModeLocation::DataView input,
    ::mojom::IwaDevModeLocationPtr* output) {
  using UnionType = ::mojom::IwaDevModeLocation;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kProxyOrigin: {
      ::url::Origin result_proxy_origin{};
      if (!input.ReadProxyOrigin(&result_proxy_origin))
        return false;

      *output = UnionType::NewProxyOrigin(
          std::move(result_proxy_origin));
      break;
    }
    case Tag::kBundlePath: {
      ::base::FilePath result_bundle_path{};
      if (!input.ReadBundlePath(&result_bundle_path))
        return false;

      *output = UnionType::NewBundlePath(
          std::move(result_bundle_path));
      break;
    }
    default:

      return false;
  }
  return true;
}

// static
bool UnionTraits<::mojom::ParseUpdateManifestFromUrlResult::DataView, ::mojom::ParseUpdateManifestFromUrlResultPtr>::Read(
    ::mojom::ParseUpdateManifestFromUrlResult::DataView input,
    ::mojom::ParseUpdateManifestFromUrlResultPtr* output) {
  using UnionType = ::mojom::ParseUpdateManifestFromUrlResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kUpdateManifest: {
      ::mojom::UpdateManifestPtr result_update_manifest{};
      if (!input.ReadUpdateManifest(&result_update_manifest))
        return false;

      *output = UnionType::NewUpdateManifest(
          std::move(result_update_manifest));
      break;
    }
    case Tag::kError: {
      std::string result_error{};
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(
          std::move(result_error));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mojom {


void WebAppInternalsHandlerInterceptorForTesting::GetDebugInfoAsJsonString(GetDebugInfoAsJsonStringCallback callback) {
  GetForwardingInterface()->GetDebugInfoAsJsonString(std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::InstallIsolatedWebAppFromDevProxy(const ::GURL& url, InstallIsolatedWebAppFromDevProxyCallback callback) {
  GetForwardingInterface()->InstallIsolatedWebAppFromDevProxy(
    std::move(url)
    , std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::SelectFileAndInstallIsolatedWebAppFromDevBundle(SelectFileAndInstallIsolatedWebAppFromDevBundleCallback callback) {
  GetForwardingInterface()->SelectFileAndInstallIsolatedWebAppFromDevBundle(std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::ParseUpdateManifestFromUrl(const ::GURL& update_manifest_url, ParseUpdateManifestFromUrlCallback callback) {
  GetForwardingInterface()->ParseUpdateManifestFromUrl(
    std::move(update_manifest_url)
    , std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::InstallIsolatedWebAppFromBundleUrl(InstallFromBundleUrlParamsPtr params, InstallIsolatedWebAppFromBundleUrlCallback callback) {
  GetForwardingInterface()->InstallIsolatedWebAppFromBundleUrl(
    std::move(params)
    , std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::UpdateDevProxyIsolatedWebApp(const std::string& app_id, UpdateDevProxyIsolatedWebAppCallback callback) {
  GetForwardingInterface()->UpdateDevProxyIsolatedWebApp(
    std::move(app_id)
    , std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::SelectFileAndUpdateIsolatedWebAppFromDevBundle(const std::string& app_id, SelectFileAndUpdateIsolatedWebAppFromDevBundleCallback callback) {
  GetForwardingInterface()->SelectFileAndUpdateIsolatedWebAppFromDevBundle(
    std::move(app_id)
    , std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::UpdateManifestInstalledIsolatedWebApp(const std::string& app_id, UpdateManifestInstalledIsolatedWebAppCallback callback) {
  GetForwardingInterface()->UpdateManifestInstalledIsolatedWebApp(
    std::move(app_id)
    , std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::SetUpdateChannelForIsolatedWebApp(const std::string& app_id, const std::string& update_channel, SetUpdateChannelForIsolatedWebAppCallback callback) {
  GetForwardingInterface()->SetUpdateChannelForIsolatedWebApp(
    std::move(app_id)
    , 
    std::move(update_channel)
    , std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::SetPinnedVersionForIsolatedWebApp(const std::string& app_id, const std::string& pinned_version, SetPinnedVersionForIsolatedWebAppCallback callback) {
  GetForwardingInterface()->SetPinnedVersionForIsolatedWebApp(
    std::move(app_id)
    , 
    std::move(pinned_version)
    , std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::ResetPinnedVersionForIsolatedWebApp(const std::string& app_id) {
  GetForwardingInterface()->ResetPinnedVersionForIsolatedWebApp(
    std::move(app_id)
    );
}
void WebAppInternalsHandlerInterceptorForTesting::SetAllowDowngradesForIsolatedWebApp(bool allow_downgrades, const std::string& app_id) {
  GetForwardingInterface()->SetAllowDowngradesForIsolatedWebApp(
    std::move(allow_downgrades)
    , 
    std::move(app_id)
    );
}
void WebAppInternalsHandlerInterceptorForTesting::SearchForIsolatedWebAppUpdates(SearchForIsolatedWebAppUpdatesCallback callback) {
  GetForwardingInterface()->SearchForIsolatedWebAppUpdates(std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::GetIsolatedWebAppDevModeAppInfo(GetIsolatedWebAppDevModeAppInfoCallback callback) {
  GetForwardingInterface()->GetIsolatedWebAppDevModeAppInfo(std::move(callback));
}
void WebAppInternalsHandlerInterceptorForTesting::RotateKey(const std::string& web_bundle_id, const std::optional<std::vector<uint8_t>>& rotated_key) {
  GetForwardingInterface()->RotateKey(
    std::move(web_bundle_id)
    , 
    std::move(rotated_key)
    );
}
WebAppInternalsHandlerAsyncWaiter::WebAppInternalsHandlerAsyncWaiter(
    WebAppInternalsHandler* proxy) : proxy_(proxy) {}

WebAppInternalsHandlerAsyncWaiter::~WebAppInternalsHandlerAsyncWaiter() = default;


void WebAppInternalsHandlerAsyncWaiter::GetDebugInfoAsJsonString(
    std::string* out_result) {
  base::RunLoop loop;
  proxy_->GetDebugInfoAsJsonString(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_result
,
             const std::string& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::string WebAppInternalsHandlerAsyncWaiter::GetDebugInfoAsJsonString(
    ) {
  std::string async_wait_result;
  GetDebugInfoAsJsonString(&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::InstallIsolatedWebAppFromDevProxy(
    const ::GURL& url, InstallIsolatedWebAppResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->InstallIsolatedWebAppFromDevProxy(
      std::move(url),
      base::BindOnce(
          [](base::RunLoop* loop,
             InstallIsolatedWebAppResultPtr* out_result
,
             InstallIsolatedWebAppResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

InstallIsolatedWebAppResultPtr WebAppInternalsHandlerAsyncWaiter::InstallIsolatedWebAppFromDevProxy(
    const ::GURL& url) {
  InstallIsolatedWebAppResultPtr async_wait_result;
  InstallIsolatedWebAppFromDevProxy(std::move(url),&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::SelectFileAndInstallIsolatedWebAppFromDevBundle(
    InstallIsolatedWebAppResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->SelectFileAndInstallIsolatedWebAppFromDevBundle(
      base::BindOnce(
          [](base::RunLoop* loop,
             InstallIsolatedWebAppResultPtr* out_result
,
             InstallIsolatedWebAppResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

InstallIsolatedWebAppResultPtr WebAppInternalsHandlerAsyncWaiter::SelectFileAndInstallIsolatedWebAppFromDevBundle(
    ) {
  InstallIsolatedWebAppResultPtr async_wait_result;
  SelectFileAndInstallIsolatedWebAppFromDevBundle(&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::ParseUpdateManifestFromUrl(
    const ::GURL& update_manifest_url, ParseUpdateManifestFromUrlResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->ParseUpdateManifestFromUrl(
      std::move(update_manifest_url),
      base::BindOnce(
          [](base::RunLoop* loop,
             ParseUpdateManifestFromUrlResultPtr* out_result
,
             ParseUpdateManifestFromUrlResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

ParseUpdateManifestFromUrlResultPtr WebAppInternalsHandlerAsyncWaiter::ParseUpdateManifestFromUrl(
    const ::GURL& update_manifest_url) {
  ParseUpdateManifestFromUrlResultPtr async_wait_result;
  ParseUpdateManifestFromUrl(std::move(update_manifest_url),&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::InstallIsolatedWebAppFromBundleUrl(
    InstallFromBundleUrlParamsPtr params, InstallIsolatedWebAppResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->InstallIsolatedWebAppFromBundleUrl(
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop,
             InstallIsolatedWebAppResultPtr* out_result
,
             InstallIsolatedWebAppResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

InstallIsolatedWebAppResultPtr WebAppInternalsHandlerAsyncWaiter::InstallIsolatedWebAppFromBundleUrl(
    InstallFromBundleUrlParamsPtr params) {
  InstallIsolatedWebAppResultPtr async_wait_result;
  InstallIsolatedWebAppFromBundleUrl(std::move(params),&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::UpdateDevProxyIsolatedWebApp(
    const std::string& app_id, std::string* out_result) {
  base::RunLoop loop;
  proxy_->UpdateDevProxyIsolatedWebApp(
      std::move(app_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_result
,
             const std::string& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::string WebAppInternalsHandlerAsyncWaiter::UpdateDevProxyIsolatedWebApp(
    const std::string& app_id) {
  std::string async_wait_result;
  UpdateDevProxyIsolatedWebApp(std::move(app_id),&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::SelectFileAndUpdateIsolatedWebAppFromDevBundle(
    const std::string& app_id, std::string* out_result) {
  base::RunLoop loop;
  proxy_->SelectFileAndUpdateIsolatedWebAppFromDevBundle(
      std::move(app_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_result
,
             const std::string& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::string WebAppInternalsHandlerAsyncWaiter::SelectFileAndUpdateIsolatedWebAppFromDevBundle(
    const std::string& app_id) {
  std::string async_wait_result;
  SelectFileAndUpdateIsolatedWebAppFromDevBundle(std::move(app_id),&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::UpdateManifestInstalledIsolatedWebApp(
    const std::string& app_id, std::string* out_result) {
  base::RunLoop loop;
  proxy_->UpdateManifestInstalledIsolatedWebApp(
      std::move(app_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_result
,
             const std::string& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::string WebAppInternalsHandlerAsyncWaiter::UpdateManifestInstalledIsolatedWebApp(
    const std::string& app_id) {
  std::string async_wait_result;
  UpdateManifestInstalledIsolatedWebApp(std::move(app_id),&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::SetUpdateChannelForIsolatedWebApp(
    const std::string& app_id, const std::string& update_channel, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetUpdateChannelForIsolatedWebApp(
      std::move(app_id),
      std::move(update_channel),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool WebAppInternalsHandlerAsyncWaiter::SetUpdateChannelForIsolatedWebApp(
    const std::string& app_id, const std::string& update_channel) {
  bool async_wait_result;
  SetUpdateChannelForIsolatedWebApp(std::move(app_id),std::move(update_channel),&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::SetPinnedVersionForIsolatedWebApp(
    const std::string& app_id, const std::string& pinned_version, bool* out_success) {
  base::RunLoop loop;
  proxy_->SetPinnedVersionForIsolatedWebApp(
      std::move(app_id),
      std::move(pinned_version),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool WebAppInternalsHandlerAsyncWaiter::SetPinnedVersionForIsolatedWebApp(
    const std::string& app_id, const std::string& pinned_version) {
  bool async_wait_result;
  SetPinnedVersionForIsolatedWebApp(std::move(app_id),std::move(pinned_version),&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::SearchForIsolatedWebAppUpdates(
    std::string* out_result) {
  base::RunLoop loop;
  proxy_->SearchForIsolatedWebAppUpdates(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::string* out_result
,
             const std::string& result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

std::string WebAppInternalsHandlerAsyncWaiter::SearchForIsolatedWebAppUpdates(
    ) {
  std::string async_wait_result;
  SearchForIsolatedWebAppUpdates(&async_wait_result);
  return async_wait_result;
}

void WebAppInternalsHandlerAsyncWaiter::GetIsolatedWebAppDevModeAppInfo(
    std::vector<IwaDevModeAppInfoPtr>* out_apps) {
  base::RunLoop loop;
  proxy_->GetIsolatedWebAppDevModeAppInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<IwaDevModeAppInfoPtr>* out_apps
,
             std::vector<IwaDevModeAppInfoPtr> apps) {*out_apps = std::move(apps);
            loop->Quit();
          },
          &loop,
          out_apps));
  loop.Run();
}

std::vector<IwaDevModeAppInfoPtr> WebAppInternalsHandlerAsyncWaiter::GetIsolatedWebAppDevModeAppInfo(
    ) {
  std::vector<IwaDevModeAppInfoPtr> async_wait_result;
  GetIsolatedWebAppDevModeAppInfo(&async_wait_result);
  return async_wait_result;
}






}  // mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif