// chrome/browser/ui/webui/tabs/tabs.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/tabs/tabs.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/tabs/tabs.mojom-params-data.h"
namespace tabs {
namespace mojom {

NOINLINE static const char* TabAlertStateToStringHelper(TabAlertState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabAlertState::kAudioMuting:
      return "kAudioMuting";
    case TabAlertState::kAudioRecording:
      return "kAudioRecording";
    case TabAlertState::kAudioPlaying:
      return "kAudioPlaying";
    case TabAlertState::kBluetoothConnected:
      return "kBluetoothConnected";
    case TabAlertState::kBluetoothScanActive:
      return "kBluetoothScanActive";
    case TabAlertState::kDesktopCapturing:
      return "kDesktopCapturing";
    case TabAlertState::kActorAccessing:
      return "kActorAccessing";
    case TabAlertState::kGlicAccessing:
      return "kGlicAccessing";
    case TabAlertState::kGlicSharing:
      return "kGlicSharing";
    case TabAlertState::kHidConnected:
      return "kHidConnected";
    case TabAlertState::kMediaRecording:
      return "kMediaRecording";
    case TabAlertState::kPipPlaying:
      return "kPipPlaying";
    case TabAlertState::kSerialConnected:
      return "kSerialConnected";
    case TabAlertState::kTabCapturing:
      return "kTabCapturing";
    case TabAlertState::kUsbConnected:
      return "kUsbConnected";
    case TabAlertState::kVideoRecording:
      return "kVideoRecording";
    case TabAlertState::kVrPresentingInHeadset:
      return "kVrPresentingInHeadset";
    default:
      return nullptr;
  }
}

std::string TabAlertStateToString(TabAlertState value) {
  const char *str = TabAlertStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabAlertState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabAlertState value) {
  return os << TabAlertStateToString(value);
}

NOINLINE static const char* TabNetworkStateToStringHelper(TabNetworkState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case TabNetworkState::kNone:
      return "kNone";
    case TabNetworkState::kWaiting:
      return "kWaiting";
    case TabNetworkState::kLoading:
      return "kLoading";
    case TabNetworkState::kError:
      return "kError";
    default:
      return nullptr;
  }
}

std::string TabNetworkStateToString(TabNetworkState value) {
  const char *str = TabNetworkStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown TabNetworkState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, TabNetworkState value) {
  return os << TabNetworkStateToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace tabs

namespace perfetto {

// static
void TraceFormatTraits<::tabs::mojom::TabAlertState>::WriteIntoTrace(
   perfetto::TracedValue context, ::tabs::mojom::TabAlertState value) {
  return std::move(context).WriteString(::tabs::mojom::TabAlertStateToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::tabs::mojom::TabNetworkState>::WriteIntoTrace(
   perfetto::TracedValue context, ::tabs::mojom::TabNetworkState value) {
  return std::move(context).WriteString(::tabs::mojom::TabNetworkStateToString(value));
}

} // namespace perfetto