// chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-params-data.h"
#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-import-headers.h"
#include "chrome/browser/ui/webui/tab_strip_internals/tab_strip_internals.mojom-test-utils.h"


namespace tab_strip_internals::mojom {
Container::Container()
    : tabstrip_tree() {}

Container::Container(
    TabStripTreePtr tabstrip_tree_in)
    : tabstrip_tree(std::move(tabstrip_tree_in)) {}

Container::~Container() = default;

void Container::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tabstrip_tree"), this->tabstrip_tree,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabStripTreePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Container::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabStripTree::TabStripTree()
    : windows() {}

TabStripTree::TabStripTree(
    std::vector<WindowNodePtr> windows_in)
    : windows(std::move(windows_in)) {}

TabStripTree::~TabStripTree() = default;

void TabStripTree::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "windows"), this->windows,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<WindowNodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabStripTree::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WindowNode::WindowNode()
    : id(),
      tabstrip_model(),
      selection_model() {}

WindowNode::WindowNode(
    NodeIdPtr id_in,
    TabStripModelPtr tabstrip_model_in,
    SelectionModelPtr selection_model_in)
    : id(std::move(id_in)),
      tabstrip_model(std::move(tabstrip_model_in)),
      selection_model(std::move(selection_model_in)) {}

WindowNode::~WindowNode() = default;

void WindowNode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NodeIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tabstrip_model"), this->tabstrip_model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabStripModelPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection_model"), this->selection_model,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SelectionModelPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WindowNode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NodeId::NodeId()
    : node_id(),
      type() {}

NodeId::NodeId(
    const std::string& node_id_in,
    NodeId::Type type_in)
    : node_id(std::move(node_id_in)),
      type(std::move(type_in)) {}

NodeId::~NodeId() = default;
size_t NodeId::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->node_id);
  seed = mojo::internal::Hash(seed, this->type);
  return seed;
}

void NodeId::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_id"), this->node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NodeId::Type>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool NodeId::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabStripModel::TabStripModel()
    : root() {}

TabStripModel::TabStripModel(
    NodePtr root_in)
    : root(std::move(root_in)) {}

TabStripModel::~TabStripModel() = default;

void TabStripModel::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root"), this->root,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NodePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabStripModel::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Node::Node()
    : data(),
      children() {}

Node::Node(
    DataPtr data_in,
    std::vector<NodePtr> children_in)
    : data(std::move(data_in)),
      children(std::move(children_in)) {}

Node::~Node() = default;

void Node::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "data"), this->data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type DataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children"), this->children,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<NodePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Node::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
Tab::Tab()
    : id(),
      title(),
      url() {}

Tab::Tab(
    NodeIdPtr id_in,
    const std::string& title_in,
    const ::GURL& url_in)
    : id(std::move(id_in)),
      title(std::move(title_in)),
      url(std::move(url_in)) {}

Tab::~Tab() = default;

void Tab::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NodeIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Tab::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabStripCollection::TabStripCollection()
    : id() {}

TabStripCollection::TabStripCollection(
    NodeIdPtr id_in)
    : id(std::move(id_in)) {}

TabStripCollection::~TabStripCollection() = default;
size_t TabStripCollection::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  return seed;
}

void TabStripCollection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NodeIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabStripCollection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PinnedCollection::PinnedCollection()
    : id() {}

PinnedCollection::PinnedCollection(
    NodeIdPtr id_in)
    : id(std::move(id_in)) {}

PinnedCollection::~PinnedCollection() = default;
size_t PinnedCollection::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  return seed;
}

void PinnedCollection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NodeIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PinnedCollection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
UnpinnedCollection::UnpinnedCollection()
    : id() {}

UnpinnedCollection::UnpinnedCollection(
    NodeIdPtr id_in)
    : id(std::move(id_in)) {}

UnpinnedCollection::~UnpinnedCollection() = default;
size_t UnpinnedCollection::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  return seed;
}

void UnpinnedCollection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NodeIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool UnpinnedCollection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GroupCollection::GroupCollection()
    : id(),
      visualData() {}

GroupCollection::GroupCollection(
    NodeIdPtr id_in,
    TabGroupVisualDataPtr visualData_in)
    : id(std::move(id_in)),
      visualData(std::move(visualData_in)) {}

GroupCollection::~GroupCollection() = default;

void GroupCollection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NodeIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visualData"), this->visualData,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TabGroupVisualDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GroupCollection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabGroupVisualData::TabGroupVisualData()
    : title(),
      color(),
      is_collapsed() {}

TabGroupVisualData::TabGroupVisualData(
    const std::string& title_in,
    ::tab_groups::TabGroupColorId color_in,
    bool is_collapsed_in)
    : title(std::move(title_in)),
      color(std::move(color_in)),
      is_collapsed(std::move(is_collapsed_in)) {}

TabGroupVisualData::~TabGroupVisualData() = default;

void TabGroupVisualData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::tab_groups::TabGroupColorId>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_collapsed"), this->is_collapsed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabGroupVisualData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SplitCollection::SplitCollection()
    : id(),
      visualData() {}

SplitCollection::SplitCollection(
    NodeIdPtr id_in,
    SplitTabVisualDataPtr visualData_in)
    : id(std::move(id_in)),
      visualData(std::move(visualData_in)) {}

SplitCollection::~SplitCollection() = default;
size_t SplitCollection::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->visualData);
  return seed;
}

void SplitCollection::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type NodeIdPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "visualData"), this->visualData,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SplitTabVisualDataPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SplitCollection::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SplitTabVisualData::SplitTabVisualData()
    : layout(),
      split_ratio() {}

SplitTabVisualData::SplitTabVisualData(
    SplitTabVisualData::Layout layout_in,
    double split_ratio_in)
    : layout(std::move(layout_in)),
      split_ratio(std::move(split_ratio_in)) {}

SplitTabVisualData::~SplitTabVisualData() = default;
size_t SplitTabVisualData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->layout);
  seed = mojo::internal::Hash(seed, this->split_ratio);
  return seed;
}

void SplitTabVisualData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "layout"), this->layout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SplitTabVisualData::Layout>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "split_ratio"), this->split_ratio,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SplitTabVisualData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SelectionModel::SelectionModel()
    : active_index(-1),
      anchor_index(-1),
      selected_indices() {}

SelectionModel::SelectionModel(
    int32_t active_index_in,
    int32_t anchor_index_in,
    std::vector<int32_t> selected_indices_in)
    : active_index(std::move(active_index_in)),
      anchor_index(std::move(anchor_index_in)),
      selected_indices(std::move(selected_indices_in)) {}

SelectionModel::~SelectionModel() = default;

void SelectionModel::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_index"), this->active_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "anchor_index"), this->anchor_index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selected_indices"), this->selected_indices,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<int32_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SelectionModel::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DataPtr
Data::NewTab(
    TabPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTab)>,
      std::move(value));
}

DataPtr
Data::NewTabStripCollection(
    TabStripCollectionPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTabStripCollection)>,
      std::move(value));
}

DataPtr
Data::NewPinnedTabCollection(
    PinnedCollectionPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kPinnedTabCollection)>,
      std::move(value));
}

DataPtr
Data::NewUnpinnedTabCollection(
    UnpinnedCollectionPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kUnpinnedTabCollection)>,
      std::move(value));
}

DataPtr
Data::NewTabGroupCollection(
    GroupCollectionPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTabGroupCollection)>,
      std::move(value));
}

DataPtr
Data::NewSplitTabCollection(
    SplitCollectionPtr value) {
  return DataPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kSplitTabCollection)>,
      std::move(value));
}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kTab)>,
    TabPtr value)
    : tag_(Tag::kTab),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTab)>,
            std::move(value)) {}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabStripCollection)>,
    TabStripCollectionPtr value)
    : tag_(Tag::kTabStripCollection),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTabStripCollection)>,
            std::move(value)) {}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kPinnedTabCollection)>,
    PinnedCollectionPtr value)
    : tag_(Tag::kPinnedTabCollection),
      data_(std::in_place_index<static_cast<size_t>(Tag::kPinnedTabCollection)>,
            std::move(value)) {}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnpinnedTabCollection)>,
    UnpinnedCollectionPtr value)
    : tag_(Tag::kUnpinnedTabCollection),
      data_(std::in_place_index<static_cast<size_t>(Tag::kUnpinnedTabCollection)>,
            std::move(value)) {}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabGroupCollection)>,
    GroupCollectionPtr value)
    : tag_(Tag::kTabGroupCollection),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTabGroupCollection)>,
            std::move(value)) {}

Data::Data(
    std::in_place_index_t<static_cast<size_t>(Tag::kSplitTabCollection)>,
    SplitCollectionPtr value)
    : tag_(Tag::kSplitTabCollection),
      data_(std::in_place_index<static_cast<size_t>(Tag::kSplitTabCollection)>,
            std::move(value)) {}
Data::~Data() {
  DestroyActive();
}

void Data::set_tab(TabPtr tab) {
  if (tag_ == Tag::kTab) {
    data_.tab = std::move(tab);
  } else {
    DestroyActive();
    tag_ = Tag::kTab;
    new (&data_.tab) TabPtr(
        std::move(tab));
  }
}

void Data::set_tab_strip_collection(TabStripCollectionPtr tab_strip_collection) {
  if (tag_ == Tag::kTabStripCollection) {
    data_.tab_strip_collection = std::move(tab_strip_collection);
  } else {
    DestroyActive();
    tag_ = Tag::kTabStripCollection;
    new (&data_.tab_strip_collection) TabStripCollectionPtr(
        std::move(tab_strip_collection));
  }
}

void Data::set_pinned_tab_collection(PinnedCollectionPtr pinned_tab_collection) {
  if (tag_ == Tag::kPinnedTabCollection) {
    data_.pinned_tab_collection = std::move(pinned_tab_collection);
  } else {
    DestroyActive();
    tag_ = Tag::kPinnedTabCollection;
    new (&data_.pinned_tab_collection) PinnedCollectionPtr(
        std::move(pinned_tab_collection));
  }
}

void Data::set_unpinned_tab_collection(UnpinnedCollectionPtr unpinned_tab_collection) {
  if (tag_ == Tag::kUnpinnedTabCollection) {
    data_.unpinned_tab_collection = std::move(unpinned_tab_collection);
  } else {
    DestroyActive();
    tag_ = Tag::kUnpinnedTabCollection;
    new (&data_.unpinned_tab_collection) UnpinnedCollectionPtr(
        std::move(unpinned_tab_collection));
  }
}

void Data::set_tab_group_collection(GroupCollectionPtr tab_group_collection) {
  if (tag_ == Tag::kTabGroupCollection) {
    data_.tab_group_collection = std::move(tab_group_collection);
  } else {
    DestroyActive();
    tag_ = Tag::kTabGroupCollection;
    new (&data_.tab_group_collection) GroupCollectionPtr(
        std::move(tab_group_collection));
  }
}

void Data::set_split_tab_collection(SplitCollectionPtr split_tab_collection) {
  if (tag_ == Tag::kSplitTabCollection) {
    data_.split_tab_collection = std::move(split_tab_collection);
  } else {
    DestroyActive();
    tag_ = Tag::kSplitTabCollection;
    new (&data_.split_tab_collection) SplitCollectionPtr(
        std::move(split_tab_collection));
  }
}


Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTab)>,
    TabPtr value)
    : tab(std::move(value)) {}

Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabStripCollection)>,
    TabStripCollectionPtr value)
    : tab_strip_collection(std::move(value)) {}

Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kPinnedTabCollection)>,
    PinnedCollectionPtr value)
    : pinned_tab_collection(std::move(value)) {}

Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kUnpinnedTabCollection)>,
    UnpinnedCollectionPtr value)
    : unpinned_tab_collection(std::move(value)) {}

Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTabGroupCollection)>,
    GroupCollectionPtr value)
    : tab_group_collection(std::move(value)) {}

Data::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kSplitTabCollection)>,
    SplitCollectionPtr value)
    : split_tab_collection(std::move(value)) {}

void Data::DestroyActive() {
  switch (tag_) {

    case Tag::kTab:
      std::destroy_at(&data_.tab);
      break;
    case Tag::kTabStripCollection:
      std::destroy_at(&data_.tab_strip_collection);
      break;
    case Tag::kPinnedTabCollection:
      std::destroy_at(&data_.pinned_tab_collection);
      break;
    case Tag::kUnpinnedTabCollection:
      std::destroy_at(&data_.unpinned_tab_collection);
      break;
    case Tag::kTabGroupCollection:
      std::destroy_at(&data_.tab_group_collection);
      break;
    case Tag::kSplitTabCollection:
      std::destroy_at(&data_.split_tab_collection);
      break;
  }
}

bool Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive tab_strip_internals::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply tab_strip_internals::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe4e9ff93;  // IPCStableHash for tab_strip_internals::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip_internals::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip_internals::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::tab_strip_internals::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tab_strip_internals::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tab_strip_internals::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetTabStripData: {
      return &PageHandler::GetTabStripData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetTabStripData:
            return "Receive tab_strip_internals::mojom::PageHandler::GetTabStripData";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetTabStripData:
            return "Receive reply tab_strip_internals::mojom::PageHandler::GetTabStripData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetTabStripData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf0018c3;  // IPCStableHash for tab_strip_internals::mojom::PageHandler::GetTabStripData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetTabStripData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTabStripData_ForwardToCallback(
      PageHandler::GetTabStripDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTabStripData_ForwardToCallback(const PageHandler_GetTabStripData_ForwardToCallback&) = delete;
  PageHandler_GetTabStripData_ForwardToCallback& operator=(const PageHandler_GetTabStripData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTabStripDataCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetTabStripData(
    GetTabStripDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_strip_internals::mojom::PageHandler::GetTabStripData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabStripData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip_internals::mojom::internal::PageHandler_GetTabStripData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabStripData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTabStripData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PageHandler_GetTabStripData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTabStripDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTabStripData_ProxyToResponder> proxy(
        new PageHandler_GetTabStripData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTabStripData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTabStripData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTabStripData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTabStripDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ContainerPtr in_data);
};

bool PageHandler_GetTabStripData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTabStripData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTabStripData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  ContainerPtr p_data{};
  PageHandler_GetTabStripData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void PageHandler_GetTabStripData_ProxyToResponder::Run(
    ContainerPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_strip_internals::mojom::PageHandler::GetTabStripData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ContainerPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabStripData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip_internals::mojom::internal::PageHandler_GetTabStripData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_strip_internals::mojom::ContainerDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabStripData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetTabStripData: {
      break;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetTabStripData: {
      internal::PageHandler_GetTabStripData_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTabStripData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetTabStripData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetTabStripData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabStripData(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetTabStripData_Params_Data::Validate,
     &internal::PageHandler_GetTabStripData_ResponseParams_Data::Validate},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tab_strip_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::tab_strip_internals::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kOnTabStripUpdated: {
      return &Page::OnTabStripUpdated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnTabStripUpdated:
            return "Receive tab_strip_internals::mojom::Page::OnTabStripUpdated";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kOnTabStripUpdated:
            return "Receive reply tab_strip_internals::mojom::Page::OnTabStripUpdated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::OnTabStripUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x17df0306;  // IPCStableHash for tab_strip_internals::mojom::Page::OnTabStripUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::OnTabStripUpdated(
    ContainerPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip_internals::mojom::Page::OnTabStripUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type ContainerPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kOnTabStripUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip_internals::mojom::internal::Page_OnTabStripUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_strip_internals::mojom::ContainerDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in Page.OnTabStripUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("OnTabStripUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnTabStripUpdated: {
      DCHECK(message->is_serialized());
      internal::Page_OnTabStripUpdated_Params_Data* params =
          reinterpret_cast<internal::Page_OnTabStripUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      ContainerPtr p_data{};
      Page_OnTabStripUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnTabStripUpdated(        
        std::move(p_data));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kOnTabStripUpdated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_OnTabStripUpdated_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tab_strip_internals::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // tab_strip_internals::mojom


namespace mojo {


// static
bool StructTraits<::tab_strip_internals::mojom::Container::DataView, ::tab_strip_internals::mojom::ContainerPtr>::Read(
    ::tab_strip_internals::mojom::Container::DataView input,
    ::tab_strip_internals::mojom::ContainerPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::ContainerPtr result(::tab_strip_internals::mojom::Container::New());
  
      if (success && !input.ReadTabstripTree(&result->tabstrip_tree))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::TabStripTree::DataView, ::tab_strip_internals::mojom::TabStripTreePtr>::Read(
    ::tab_strip_internals::mojom::TabStripTree::DataView input,
    ::tab_strip_internals::mojom::TabStripTreePtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::TabStripTreePtr result(::tab_strip_internals::mojom::TabStripTree::New());
  
      if (success && !input.ReadWindows(&result->windows))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::WindowNode::DataView, ::tab_strip_internals::mojom::WindowNodePtr>::Read(
    ::tab_strip_internals::mojom::WindowNode::DataView input,
    ::tab_strip_internals::mojom::WindowNodePtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::WindowNodePtr result(::tab_strip_internals::mojom::WindowNode::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTabstripModel(&result->tabstrip_model))
        success = false;
      if (success && !input.ReadSelectionModel(&result->selection_model))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::NodeId::DataView, ::tab_strip_internals::mojom::NodeIdPtr>::Read(
    ::tab_strip_internals::mojom::NodeId::DataView input,
    ::tab_strip_internals::mojom::NodeIdPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::NodeIdPtr result(::tab_strip_internals::mojom::NodeId::New());
  
      if (success && !input.ReadNodeId(&result->node_id))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::TabStripModel::DataView, ::tab_strip_internals::mojom::TabStripModelPtr>::Read(
    ::tab_strip_internals::mojom::TabStripModel::DataView input,
    ::tab_strip_internals::mojom::TabStripModelPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::TabStripModelPtr result(::tab_strip_internals::mojom::TabStripModel::New());
  
      if (success && !input.ReadRoot(&result->root))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::Node::DataView, ::tab_strip_internals::mojom::NodePtr>::Read(
    ::tab_strip_internals::mojom::Node::DataView input,
    ::tab_strip_internals::mojom::NodePtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::NodePtr result(::tab_strip_internals::mojom::Node::New());
  
      if (success && !input.ReadData(&result->data))
        success = false;
      if (success && !input.ReadChildren(&result->children))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::Tab::DataView, ::tab_strip_internals::mojom::TabPtr>::Read(
    ::tab_strip_internals::mojom::Tab::DataView input,
    ::tab_strip_internals::mojom::TabPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::TabPtr result(::tab_strip_internals::mojom::Tab::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::TabStripCollection::DataView, ::tab_strip_internals::mojom::TabStripCollectionPtr>::Read(
    ::tab_strip_internals::mojom::TabStripCollection::DataView input,
    ::tab_strip_internals::mojom::TabStripCollectionPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::TabStripCollectionPtr result(::tab_strip_internals::mojom::TabStripCollection::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::PinnedCollection::DataView, ::tab_strip_internals::mojom::PinnedCollectionPtr>::Read(
    ::tab_strip_internals::mojom::PinnedCollection::DataView input,
    ::tab_strip_internals::mojom::PinnedCollectionPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::PinnedCollectionPtr result(::tab_strip_internals::mojom::PinnedCollection::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::UnpinnedCollection::DataView, ::tab_strip_internals::mojom::UnpinnedCollectionPtr>::Read(
    ::tab_strip_internals::mojom::UnpinnedCollection::DataView input,
    ::tab_strip_internals::mojom::UnpinnedCollectionPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::UnpinnedCollectionPtr result(::tab_strip_internals::mojom::UnpinnedCollection::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::GroupCollection::DataView, ::tab_strip_internals::mojom::GroupCollectionPtr>::Read(
    ::tab_strip_internals::mojom::GroupCollection::DataView input,
    ::tab_strip_internals::mojom::GroupCollectionPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::GroupCollectionPtr result(::tab_strip_internals::mojom::GroupCollection::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadVisualData(&result->visualData))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::TabGroupVisualData::DataView, ::tab_strip_internals::mojom::TabGroupVisualDataPtr>::Read(
    ::tab_strip_internals::mojom::TabGroupVisualData::DataView input,
    ::tab_strip_internals::mojom::TabGroupVisualDataPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::TabGroupVisualDataPtr result(::tab_strip_internals::mojom::TabGroupVisualData::New());
  
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success)
        result->is_collapsed = input.is_collapsed();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::SplitCollection::DataView, ::tab_strip_internals::mojom::SplitCollectionPtr>::Read(
    ::tab_strip_internals::mojom::SplitCollection::DataView input,
    ::tab_strip_internals::mojom::SplitCollectionPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::SplitCollectionPtr result(::tab_strip_internals::mojom::SplitCollection::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadVisualData(&result->visualData))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::SplitTabVisualData::DataView, ::tab_strip_internals::mojom::SplitTabVisualDataPtr>::Read(
    ::tab_strip_internals::mojom::SplitTabVisualData::DataView input,
    ::tab_strip_internals::mojom::SplitTabVisualDataPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::SplitTabVisualDataPtr result(::tab_strip_internals::mojom::SplitTabVisualData::New());
  
      if (success && !input.ReadLayout(&result->layout))
        success = false;
      if (success)
        result->split_ratio = input.split_ratio();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip_internals::mojom::SelectionModel::DataView, ::tab_strip_internals::mojom::SelectionModelPtr>::Read(
    ::tab_strip_internals::mojom::SelectionModel::DataView input,
    ::tab_strip_internals::mojom::SelectionModelPtr* output) {
  bool success = true;
  ::tab_strip_internals::mojom::SelectionModelPtr result(::tab_strip_internals::mojom::SelectionModel::New());
  
      if (success)
        result->active_index = input.active_index();
      if (success)
        result->anchor_index = input.anchor_index();
      if (success && !input.ReadSelectedIndices(&result->selected_indices))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::tab_strip_internals::mojom::Data::DataView, ::tab_strip_internals::mojom::DataPtr>::Read(
    ::tab_strip_internals::mojom::Data::DataView input,
    ::tab_strip_internals::mojom::DataPtr* output) {
  using UnionType = ::tab_strip_internals::mojom::Data;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kTab: {
      ::tab_strip_internals::mojom::TabPtr result_tab{};
      if (!input.ReadTab(&result_tab))
        return false;

      *output = UnionType::NewTab(
          std::move(result_tab));
      break;
    }
    case Tag::kTabStripCollection: {
      ::tab_strip_internals::mojom::TabStripCollectionPtr result_tab_strip_collection{};
      if (!input.ReadTabStripCollection(&result_tab_strip_collection))
        return false;

      *output = UnionType::NewTabStripCollection(
          std::move(result_tab_strip_collection));
      break;
    }
    case Tag::kPinnedTabCollection: {
      ::tab_strip_internals::mojom::PinnedCollectionPtr result_pinned_tab_collection{};
      if (!input.ReadPinnedTabCollection(&result_pinned_tab_collection))
        return false;

      *output = UnionType::NewPinnedTabCollection(
          std::move(result_pinned_tab_collection));
      break;
    }
    case Tag::kUnpinnedTabCollection: {
      ::tab_strip_internals::mojom::UnpinnedCollectionPtr result_unpinned_tab_collection{};
      if (!input.ReadUnpinnedTabCollection(&result_unpinned_tab_collection))
        return false;

      *output = UnionType::NewUnpinnedTabCollection(
          std::move(result_unpinned_tab_collection));
      break;
    }
    case Tag::kTabGroupCollection: {
      ::tab_strip_internals::mojom::GroupCollectionPtr result_tab_group_collection{};
      if (!input.ReadTabGroupCollection(&result_tab_group_collection))
        return false;

      *output = UnionType::NewTabGroupCollection(
          std::move(result_tab_group_collection));
      break;
    }
    case Tag::kSplitTabCollection: {
      ::tab_strip_internals::mojom::SplitCollectionPtr result_split_tab_collection{};
      if (!input.ReadSplitTabCollection(&result_split_tab_collection))
        return false;

      *output = UnionType::NewSplitTabCollection(
          std::move(result_split_tab_collection));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace tab_strip_internals::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetTabStripData(GetTabStripDataCallback callback) {
  GetForwardingInterface()->GetTabStripData(std::move(callback));
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetTabStripData(
    ContainerPtr* out_data) {
  base::RunLoop loop;
  proxy_->GetTabStripData(
      base::BindOnce(
          [](base::RunLoop* loop,
             ContainerPtr* out_data
,
             ContainerPtr data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

ContainerPtr PageHandlerAsyncWaiter::GetTabStripData(
    ) {
  ContainerPtr async_wait_result;
  GetTabStripData(&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::OnTabStripUpdated(ContainerPtr data) {
  GetForwardingInterface()->OnTabStripUpdated(
    std::move(data)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // tab_strip_internals::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif