// chrome/browser/ui/webui/tab_strip/tab_strip.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-params-data.h"
#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-import-headers.h"
#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-test-utils.h"


namespace tab_strip::mojom {
Tab::Tab()
    : active(),
      alert_states(),
      blocked(),
      crashed(),
      favicon_url(),
      active_favicon_url(),
      group_id(),
      id(),
      index(),
      is_default_favicon(),
      network_state(),
      pinned(),
      should_hide_throbber(),
      show_icon(),
      title(),
      url() {}

Tab::Tab(
    bool active_in,
    std::vector<::tabs::TabAlert> alert_states_in,
    bool blocked_in,
    bool crashed_in,
    const std::optional<::GURL>& favicon_url_in,
    const std::optional<::GURL>& active_favicon_url_in,
    const std::optional<std::string>& group_id_in,
    int32_t id_in,
    int32_t index_in,
    bool is_default_favicon_in,
    ::TabNetworkState network_state_in,
    bool pinned_in,
    bool should_hide_throbber_in,
    bool show_icon_in,
    const std::string& title_in,
    const ::GURL& url_in)
    : active(std::move(active_in)),
      alert_states(std::move(alert_states_in)),
      blocked(std::move(blocked_in)),
      crashed(std::move(crashed_in)),
      favicon_url(std::move(favicon_url_in)),
      active_favicon_url(std::move(active_favicon_url_in)),
      group_id(std::move(group_id_in)),
      id(std::move(id_in)),
      index(std::move(index_in)),
      is_default_favicon(std::move(is_default_favicon_in)),
      network_state(std::move(network_state_in)),
      pinned(std::move(pinned_in)),
      should_hide_throbber(std::move(should_hide_throbber_in)),
      show_icon(std::move(show_icon_in)),
      title(std::move(title_in)),
      url(std::move(url_in)) {}

Tab::~Tab() = default;

void Tab::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active"), this->active,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "alert_states"), this->alert_states,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::tabs::TabAlert>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "blocked"), this->blocked,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "crashed"), this->crashed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "favicon_url"), this->favicon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_favicon_url"), this->active_favicon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::GURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_id"), this->group_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "index"), this->index,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_default_favicon"), this->is_default_favicon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "network_state"), this->network_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::TabNetworkState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pinned"), this->pinned,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "should_hide_throbber"), this->should_hide_throbber,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_icon"), this->show_icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Tab::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TabGroupVisualData::TabGroupVisualData()
    : color(),
      text_color(),
      title() {}

TabGroupVisualData::TabGroupVisualData(
    const std::string& color_in,
    const std::string& text_color_in,
    const std::string& title_in)
    : color(std::move(color_in)),
      text_color(std::move(text_color_in)),
      title(std::move(title_in)) {}

TabGroupVisualData::~TabGroupVisualData() = default;
size_t TabGroupVisualData::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->color);
  seed = mojo::internal::Hash(seed, this->text_color);
  seed = mojo::internal::Hash(seed, this->title);
  return seed;
}

void TabGroupVisualData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color"), this->color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "text_color"), this->text_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TabGroupVisualData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      return &PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive tab_strip::mojom::PageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreatePageHandler:
            return "Receive reply tab_strip::mojom::PageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4d6a9729;  // IPCStableHash for tab_strip::mojom::PageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::tab_strip::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::tab_strip::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tab_strip::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kGetGroupVisualData: {
      return &PageHandler::GetGroupVisualData_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetTabs: {
      return &PageHandler::GetTabs_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCloseTab: {
      return &PageHandler::CloseTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGroupTab: {
      return &PageHandler::GroupTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kMoveGroup: {
      return &PageHandler::MoveGroup_Sym::IPCStableHash;
    }
    case messages::PageHandler::kMoveTab: {
      return &PageHandler::MoveTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kSetThumbnailTracked: {
      return &PageHandler::SetThumbnailTracked_Sym::IPCStableHash;
    }
    case messages::PageHandler::kUngroupTab: {
      return &PageHandler::UngroupTab_Sym::IPCStableHash;
    }
    case messages::PageHandler::kGetLayout: {
      return &PageHandler::GetLayout_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowEditDialogForGroup: {
      return &PageHandler::ShowEditDialogForGroup_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowTabContextMenu: {
      return &PageHandler::ShowTabContextMenu_Sym::IPCStableHash;
    }
    case messages::PageHandler::kShowBackgroundContextMenu: {
      return &PageHandler::ShowBackgroundContextMenu_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCloseContainer: {
      return &PageHandler::CloseContainer_Sym::IPCStableHash;
    }
    case messages::PageHandler::kReportTabActivationDuration: {
      return &PageHandler::ReportTabActivationDuration_Sym::IPCStableHash;
    }
    case messages::PageHandler::kReportTabDataReceivedDuration: {
      return &PageHandler::ReportTabDataReceivedDuration_Sym::IPCStableHash;
    }
    case messages::PageHandler::kReportTabCreationDuration: {
      return &PageHandler::ReportTabCreationDuration_Sym::IPCStableHash;
    }
    case messages::PageHandler::kActivateTab: {
      return &PageHandler::ActivateTab_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetGroupVisualData:
            return "Receive tab_strip::mojom::PageHandler::GetGroupVisualData";
      case messages::PageHandler::kGetTabs:
            return "Receive tab_strip::mojom::PageHandler::GetTabs";
      case messages::PageHandler::kCloseTab:
            return "Receive tab_strip::mojom::PageHandler::CloseTab";
      case messages::PageHandler::kGroupTab:
            return "Receive tab_strip::mojom::PageHandler::GroupTab";
      case messages::PageHandler::kMoveGroup:
            return "Receive tab_strip::mojom::PageHandler::MoveGroup";
      case messages::PageHandler::kMoveTab:
            return "Receive tab_strip::mojom::PageHandler::MoveTab";
      case messages::PageHandler::kSetThumbnailTracked:
            return "Receive tab_strip::mojom::PageHandler::SetThumbnailTracked";
      case messages::PageHandler::kUngroupTab:
            return "Receive tab_strip::mojom::PageHandler::UngroupTab";
      case messages::PageHandler::kGetLayout:
            return "Receive tab_strip::mojom::PageHandler::GetLayout";
      case messages::PageHandler::kShowEditDialogForGroup:
            return "Receive tab_strip::mojom::PageHandler::ShowEditDialogForGroup";
      case messages::PageHandler::kShowTabContextMenu:
            return "Receive tab_strip::mojom::PageHandler::ShowTabContextMenu";
      case messages::PageHandler::kShowBackgroundContextMenu:
            return "Receive tab_strip::mojom::PageHandler::ShowBackgroundContextMenu";
      case messages::PageHandler::kCloseContainer:
            return "Receive tab_strip::mojom::PageHandler::CloseContainer";
      case messages::PageHandler::kReportTabActivationDuration:
            return "Receive tab_strip::mojom::PageHandler::ReportTabActivationDuration";
      case messages::PageHandler::kReportTabDataReceivedDuration:
            return "Receive tab_strip::mojom::PageHandler::ReportTabDataReceivedDuration";
      case messages::PageHandler::kReportTabCreationDuration:
            return "Receive tab_strip::mojom::PageHandler::ReportTabCreationDuration";
      case messages::PageHandler::kActivateTab:
            return "Receive tab_strip::mojom::PageHandler::ActivateTab";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kGetGroupVisualData:
            return "Receive reply tab_strip::mojom::PageHandler::GetGroupVisualData";
      case messages::PageHandler::kGetTabs:
            return "Receive reply tab_strip::mojom::PageHandler::GetTabs";
      case messages::PageHandler::kCloseTab:
            return "Receive reply tab_strip::mojom::PageHandler::CloseTab";
      case messages::PageHandler::kGroupTab:
            return "Receive reply tab_strip::mojom::PageHandler::GroupTab";
      case messages::PageHandler::kMoveGroup:
            return "Receive reply tab_strip::mojom::PageHandler::MoveGroup";
      case messages::PageHandler::kMoveTab:
            return "Receive reply tab_strip::mojom::PageHandler::MoveTab";
      case messages::PageHandler::kSetThumbnailTracked:
            return "Receive reply tab_strip::mojom::PageHandler::SetThumbnailTracked";
      case messages::PageHandler::kUngroupTab:
            return "Receive reply tab_strip::mojom::PageHandler::UngroupTab";
      case messages::PageHandler::kGetLayout:
            return "Receive reply tab_strip::mojom::PageHandler::GetLayout";
      case messages::PageHandler::kShowEditDialogForGroup:
            return "Receive reply tab_strip::mojom::PageHandler::ShowEditDialogForGroup";
      case messages::PageHandler::kShowTabContextMenu:
            return "Receive reply tab_strip::mojom::PageHandler::ShowTabContextMenu";
      case messages::PageHandler::kShowBackgroundContextMenu:
            return "Receive reply tab_strip::mojom::PageHandler::ShowBackgroundContextMenu";
      case messages::PageHandler::kCloseContainer:
            return "Receive reply tab_strip::mojom::PageHandler::CloseContainer";
      case messages::PageHandler::kReportTabActivationDuration:
            return "Receive reply tab_strip::mojom::PageHandler::ReportTabActivationDuration";
      case messages::PageHandler::kReportTabDataReceivedDuration:
            return "Receive reply tab_strip::mojom::PageHandler::ReportTabDataReceivedDuration";
      case messages::PageHandler::kReportTabCreationDuration:
            return "Receive reply tab_strip::mojom::PageHandler::ReportTabCreationDuration";
      case messages::PageHandler::kActivateTab:
            return "Receive reply tab_strip::mojom::PageHandler::ActivateTab";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::GetGroupVisualData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x72044a24;  // IPCStableHash for tab_strip::mojom::PageHandler::GetGroupVisualData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetTabs_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf627858c;  // IPCStableHash for tab_strip::mojom::PageHandler::GetTabs
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::CloseTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd2830127;  // IPCStableHash for tab_strip::mojom::PageHandler::CloseTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GroupTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x18bec2f0;  // IPCStableHash for tab_strip::mojom::PageHandler::GroupTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::MoveGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x082a1c7a;  // IPCStableHash for tab_strip::mojom::PageHandler::MoveGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::MoveTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6b1dcd31;  // IPCStableHash for tab_strip::mojom::PageHandler::MoveTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::SetThumbnailTracked_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x85341402;  // IPCStableHash for tab_strip::mojom::PageHandler::SetThumbnailTracked
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::UngroupTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x99cd1da2;  // IPCStableHash for tab_strip::mojom::PageHandler::UngroupTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::GetLayout_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3ee5c5b3;  // IPCStableHash for tab_strip::mojom::PageHandler::GetLayout
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowEditDialogForGroup_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdf5b387b;  // IPCStableHash for tab_strip::mojom::PageHandler::ShowEditDialogForGroup
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowTabContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2d264165;  // IPCStableHash for tab_strip::mojom::PageHandler::ShowTabContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ShowBackgroundContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8b0b1b9c;  // IPCStableHash for tab_strip::mojom::PageHandler::ShowBackgroundContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::CloseContainer_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb35b2f02;  // IPCStableHash for tab_strip::mojom::PageHandler::CloseContainer
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ReportTabActivationDuration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xe759497a;  // IPCStableHash for tab_strip::mojom::PageHandler::ReportTabActivationDuration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ReportTabDataReceivedDuration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3e31cef5;  // IPCStableHash for tab_strip::mojom::PageHandler::ReportTabDataReceivedDuration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ReportTabCreationDuration_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7db74f46;  // IPCStableHash for tab_strip::mojom::PageHandler::ReportTabCreationDuration
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::ActivateTab_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62bfb935;  // IPCStableHash for tab_strip::mojom::PageHandler::ActivateTab
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PageHandler_GetGroupVisualData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetGroupVisualData_ForwardToCallback(
      PageHandler::GetGroupVisualDataCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetGroupVisualData_ForwardToCallback(const PageHandler_GetGroupVisualData_ForwardToCallback&) = delete;
  PageHandler_GetGroupVisualData_ForwardToCallback& operator=(const PageHandler_GetGroupVisualData_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetGroupVisualDataCallback callback_;
};

class PageHandler_GetTabs_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetTabs_ForwardToCallback(
      PageHandler::GetTabsCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetTabs_ForwardToCallback(const PageHandler_GetTabs_ForwardToCallback&) = delete;
  PageHandler_GetTabs_ForwardToCallback& operator=(const PageHandler_GetTabs_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetTabsCallback callback_;
};

class PageHandler_GetLayout_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PageHandler_GetLayout_ForwardToCallback(
      PageHandler::GetLayoutCallback callback
      ) : callback_(std::move(callback)) {
  }

  PageHandler_GetLayout_ForwardToCallback(const PageHandler_GetLayout_ForwardToCallback&) = delete;
  PageHandler_GetLayout_ForwardToCallback& operator=(const PageHandler_GetLayout_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PageHandler::GetLayoutCallback callback_;
};

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::GetGroupVisualData(
    GetGroupVisualDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_strip::mojom::PageHandler::GetGroupVisualData");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetGroupVisualData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_GetGroupVisualData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetGroupVisualData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetGroupVisualData_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::GetTabs(
    GetTabsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_strip::mojom::PageHandler::GetTabs");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_GetTabs_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabs");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetTabs_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::CloseTab(
    int32_t in_tab_id, bool in_tab_was_swiped) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::CloseTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_was_swiped"), in_tab_was_swiped,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCloseTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_CloseTab_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->tab_was_swiped = in_tab_was_swiped;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CloseTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GroupTab(
    int32_t in_tab_id, const std::string& in_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::GroupTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGroupTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_GroupTab_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in PageHandler.GroupTab request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GroupTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::MoveGroup(
    const std::string& in_group_id, int32_t in_to_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::MoveGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("to_index"), in_to_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kMoveGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_MoveGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in PageHandler.MoveGroup request");

  params->to_index = in_to_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("MoveGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::MoveTab(
    int32_t in_tab_id, int32_t in_to_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::MoveTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("to_index"), in_to_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kMoveTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_MoveTab_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->to_index = in_to_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("MoveTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::SetThumbnailTracked(
    int32_t in_tab_id, bool in_thumbnail_tracked) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::SetThumbnailTracked", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("thumbnail_tracked"), in_thumbnail_tracked,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kSetThumbnailTracked), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_SetThumbnailTracked_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->thumbnail_tracked = in_thumbnail_tracked;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("SetThumbnailTracked");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::UngroupTab(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::UngroupTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUngroupTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_UngroupTab_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UngroupTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::GetLayout(
    GetLayoutCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_strip::mojom::PageHandler::GetLayout");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetLayout), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_GetLayout_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetLayout");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PageHandler_GetLayout_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PageHandlerProxy::ShowEditDialogForGroup(
    const std::string& in_group_id, int32_t in_location_x, int32_t in_location_y, int32_t in_width, int32_t in_height) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::ShowEditDialogForGroup", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location_x"), in_location_x,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location_y"), in_location_y,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("width"), in_width,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("height"), in_height,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowEditDialogForGroup), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_ShowEditDialogForGroup_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in PageHandler.ShowEditDialogForGroup request");

  params->location_x = in_location_x;

  params->location_y = in_location_y;

  params->width = in_width;

  params->height = in_height;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowEditDialogForGroup");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowTabContextMenu(
    int32_t in_tab_id, int32_t in_location_x, int32_t in_location_y) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::ShowTabContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location_x"), in_location_x,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location_y"), in_location_y,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowTabContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_ShowTabContextMenu_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->location_x = in_location_x;

  params->location_y = in_location_y;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowTabContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ShowBackgroundContextMenu(
    int32_t in_location_x, int32_t in_location_y) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::ShowBackgroundContextMenu", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location_x"), in_location_x,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location_y"), in_location_y,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kShowBackgroundContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_ShowBackgroundContextMenu_Params_Data> params(
          message);
  params.Allocate();

  params->location_x = in_location_x;

  params->location_y = in_location_y;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ShowBackgroundContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::CloseContainer(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_strip::mojom::PageHandler::CloseContainer");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCloseContainer), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_CloseContainer_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("CloseContainer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ReportTabActivationDuration(
    uint32_t in_duration_ms) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::ReportTabActivationDuration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration_ms"), in_duration_ms,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kReportTabActivationDuration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_ReportTabActivationDuration_Params_Data> params(
          message);
  params.Allocate();

  params->duration_ms = in_duration_ms;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ReportTabActivationDuration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ReportTabDataReceivedDuration(
    uint32_t in_tab_count, uint32_t in_duration_ms) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::ReportTabDataReceivedDuration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_count"), in_tab_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration_ms"), in_duration_ms,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kReportTabDataReceivedDuration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_ReportTabDataReceivedDuration_Params_Data> params(
          message);
  params.Allocate();

  params->tab_count = in_tab_count;

  params->duration_ms = in_duration_ms;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ReportTabDataReceivedDuration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ReportTabCreationDuration(
    uint32_t in_tab_count, uint32_t in_duration_ms) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::ReportTabCreationDuration", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_count"), in_tab_count,
                        "<value of type uint32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("duration_ms"), in_duration_ms,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kReportTabCreationDuration), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_ReportTabCreationDuration_Params_Data> params(
          message);
  params.Allocate();

  params->tab_count = in_tab_count;

  params->duration_ms = in_duration_ms;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ReportTabCreationDuration");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::ActivateTab(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::PageHandler::ActivateTab", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kActivateTab), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_ActivateTab_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("ActivateTab");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class PageHandler_GetGroupVisualData_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetGroupVisualDataCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetGroupVisualData_ProxyToResponder> proxy(
        new PageHandler_GetGroupVisualData_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetGroupVisualData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetGroupVisualData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetGroupVisualData_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetGroupVisualDataCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      base::flat_map<std::string, TabGroupVisualDataPtr> in_data);
};

bool PageHandler_GetGroupVisualData_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetGroupVisualData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetGroupVisualData_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.0
  bool success = true;
  base::flat_map<std::string, TabGroupVisualDataPtr> p_data{};
  PageHandler_GetGroupVisualData_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_data));
  }
  return true;
}

void PageHandler_GetGroupVisualData_ProxyToResponder::Run(
    base::flat_map<std::string, TabGroupVisualDataPtr> in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_strip::mojom::PageHandler::GetGroupVisualData", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type base::flat_map<std::string, TabGroupVisualDataPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetGroupVisualData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_GetGroupVisualData_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType>
      data_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::tab_strip::mojom::TabGroupVisualDataDataView>>(
    in_data,
    data_fragment,
    &data_validate_params);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetGroupVisualData");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetTabs_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetTabsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetTabs_ProxyToResponder> proxy(
        new PageHandler_GetTabs_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetTabs_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetTabs_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetTabs_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetTabsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<TabPtr> in_tabs);
};

bool PageHandler_GetTabs_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetTabs_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetTabs_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.1
  bool success = true;
  std::vector<TabPtr> p_tabs{};
  PageHandler_GetTabs_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadTabs(&p_tabs))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_tabs));
  }
  return true;
}

void PageHandler_GetTabs_ProxyToResponder::Run(
    std::vector<TabPtr> in_tabs) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_strip::mojom::PageHandler::GetTabs", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tabs"), in_tabs,
                        "<value of type std::vector<TabPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetTabs), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_GetTabs_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tabs)::BaseType>
      tabs_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& tabs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::tab_strip::mojom::TabDataView>>(
    in_tabs,
    tabs_fragment,
    &tabs_validate_params);

  params->tabs.Set(
      tabs_fragment.is_null() ? nullptr : tabs_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tabs.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tabs in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetTabs");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PageHandler_GetLayout_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PageHandler::GetLayoutCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PageHandler_GetLayout_ProxyToResponder> proxy(
        new PageHandler_GetLayout_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PageHandler_GetLayout_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PageHandler_GetLayout_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PageHandler_GetLayout_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PageHandler::GetLayoutCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::flat_map<std::string, std::string>& in_layout);
};

bool PageHandler_GetLayout_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PageHandler_GetLayout_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PageHandler_GetLayout_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PageHandler.8
  bool success = true;
  base::flat_map<std::string, std::string> p_layout{};
  PageHandler_GetLayout_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadLayout(&p_layout))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PageHandler::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_layout));
  }
  return true;
}

void PageHandler_GetLayout_ProxyToResponder::Run(
    const base::flat_map<std::string, std::string>& in_layout) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply tab_strip::mojom::PageHandler::GetLayout", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("layout"), in_layout,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kGetLayout), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::PageHandler_GetLayout_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->layout)::BaseType>
      layout_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& layout_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_layout,
    layout_fragment,
    &layout_validate_params);

  params->layout.Set(
      layout_fragment.is_null() ? nullptr : layout_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->layout.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null layout in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("GetLayout");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetGroupVisualData: {
      break;
    }
    case messages::PageHandler::kGetTabs: {
      break;
    }
    case messages::PageHandler::kCloseTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_CloseTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_CloseTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      int32_t p_tab_id{};
      bool p_tab_was_swiped{};
      PageHandler_CloseTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_tab_was_swiped = input_data_view.tab_was_swiped();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseTab(        
        std::move(p_tab_id), 
        std::move(p_tab_was_swiped));
      return true;
    }
    case messages::PageHandler::kGroupTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_GroupTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_GroupTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      int32_t p_tab_id{};
      std::string p_group_id{};
      PageHandler_GroupTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GroupTab(        
        std::move(p_tab_id), 
        std::move(p_group_id));
      return true;
    }
    case messages::PageHandler::kMoveGroup: {
      DCHECK(message->is_serialized());
      internal::PageHandler_MoveGroup_Params_Data* params =
          reinterpret_cast<internal::PageHandler_MoveGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.4
      bool success = true;
      std::string p_group_id{};
      int32_t p_to_index{};
      PageHandler_MoveGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (success)
        p_to_index = input_data_view.to_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveGroup(        
        std::move(p_group_id), 
        std::move(p_to_index));
      return true;
    }
    case messages::PageHandler::kMoveTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_MoveTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_MoveTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.5
      bool success = true;
      int32_t p_tab_id{};
      int32_t p_to_index{};
      PageHandler_MoveTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_to_index = input_data_view.to_index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MoveTab(        
        std::move(p_tab_id), 
        std::move(p_to_index));
      return true;
    }
    case messages::PageHandler::kSetThumbnailTracked: {
      DCHECK(message->is_serialized());
      internal::PageHandler_SetThumbnailTracked_Params_Data* params =
          reinterpret_cast<internal::PageHandler_SetThumbnailTracked_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.6
      bool success = true;
      int32_t p_tab_id{};
      bool p_thumbnail_tracked{};
      PageHandler_SetThumbnailTracked_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_thumbnail_tracked = input_data_view.thumbnail_tracked();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetThumbnailTracked(        
        std::move(p_tab_id), 
        std::move(p_thumbnail_tracked));
      return true;
    }
    case messages::PageHandler::kUngroupTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UngroupTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UngroupTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.7
      bool success = true;
      int32_t p_tab_id{};
      PageHandler_UngroupTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UngroupTab(        
        std::move(p_tab_id));
      return true;
    }
    case messages::PageHandler::kGetLayout: {
      break;
    }
    case messages::PageHandler::kShowEditDialogForGroup: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowEditDialogForGroup_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowEditDialogForGroup_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.9
      bool success = true;
      std::string p_group_id{};
      int32_t p_location_x{};
      int32_t p_location_y{};
      int32_t p_width{};
      int32_t p_height{};
      PageHandler_ShowEditDialogForGroup_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (success)
        p_location_x = input_data_view.location_x();
      if (success)
        p_location_y = input_data_view.location_y();
      if (success)
        p_width = input_data_view.width();
      if (success)
        p_height = input_data_view.height();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowEditDialogForGroup(        
        std::move(p_group_id), 
        std::move(p_location_x), 
        std::move(p_location_y), 
        std::move(p_width), 
        std::move(p_height));
      return true;
    }
    case messages::PageHandler::kShowTabContextMenu: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowTabContextMenu_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowTabContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.10
      bool success = true;
      int32_t p_tab_id{};
      int32_t p_location_x{};
      int32_t p_location_y{};
      PageHandler_ShowTabContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_location_x = input_data_view.location_x();
      if (success)
        p_location_y = input_data_view.location_y();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowTabContextMenu(        
        std::move(p_tab_id), 
        std::move(p_location_x), 
        std::move(p_location_y));
      return true;
    }
    case messages::PageHandler::kShowBackgroundContextMenu: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ShowBackgroundContextMenu_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ShowBackgroundContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.11
      bool success = true;
      int32_t p_location_x{};
      int32_t p_location_y{};
      PageHandler_ShowBackgroundContextMenu_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_location_x = input_data_view.location_x();
      if (success)
        p_location_y = input_data_view.location_y();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowBackgroundContextMenu(        
        std::move(p_location_x), 
        std::move(p_location_y));
      return true;
    }
    case messages::PageHandler::kCloseContainer: {
      DCHECK(message->is_serialized());
      internal::PageHandler_CloseContainer_Params_Data* params =
          reinterpret_cast<internal::PageHandler_CloseContainer_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.12
      bool success = true;
      PageHandler_CloseContainer_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseContainer(        );
      return true;
    }
    case messages::PageHandler::kReportTabActivationDuration: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ReportTabActivationDuration_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ReportTabActivationDuration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.13
      bool success = true;
      uint32_t p_duration_ms{};
      PageHandler_ReportTabActivationDuration_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_duration_ms = input_data_view.duration_ms();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportTabActivationDuration(        
        std::move(p_duration_ms));
      return true;
    }
    case messages::PageHandler::kReportTabDataReceivedDuration: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ReportTabDataReceivedDuration_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ReportTabDataReceivedDuration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.14
      bool success = true;
      uint32_t p_tab_count{};
      uint32_t p_duration_ms{};
      PageHandler_ReportTabDataReceivedDuration_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_count = input_data_view.tab_count();
      if (success)
        p_duration_ms = input_data_view.duration_ms();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportTabDataReceivedDuration(        
        std::move(p_tab_count), 
        std::move(p_duration_ms));
      return true;
    }
    case messages::PageHandler::kReportTabCreationDuration: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ReportTabCreationDuration_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ReportTabCreationDuration_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.15
      bool success = true;
      uint32_t p_tab_count{};
      uint32_t p_duration_ms{};
      PageHandler_ReportTabCreationDuration_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_count = input_data_view.tab_count();
      if (success)
        p_duration_ms = input_data_view.duration_ms();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReportTabCreationDuration(        
        std::move(p_tab_count), 
        std::move(p_duration_ms));
      return true;
    }
    case messages::PageHandler::kActivateTab: {
      DCHECK(message->is_serialized());
      internal::PageHandler_ActivateTab_Params_Data* params =
          reinterpret_cast<internal::PageHandler_ActivateTab_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.16
      bool success = true;
      int32_t p_tab_id{};
      PageHandler_ActivateTab_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ActivateTab(        
        std::move(p_tab_id));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kGetGroupVisualData: {
      internal::PageHandler_GetGroupVisualData_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetGroupVisualData_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      PageHandler_GetGroupVisualData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          PageHandler_GetGroupVisualData_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetGroupVisualData(std::move(callback));
      return true;
    }
    case messages::PageHandler::kGetTabs: {
      internal::PageHandler_GetTabs_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetTabs_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      PageHandler_GetTabs_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      auto callback =
          PageHandler_GetTabs_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTabs(std::move(callback));
      return true;
    }
    case messages::PageHandler::kCloseTab: {
      break;
    }
    case messages::PageHandler::kGroupTab: {
      break;
    }
    case messages::PageHandler::kMoveGroup: {
      break;
    }
    case messages::PageHandler::kMoveTab: {
      break;
    }
    case messages::PageHandler::kSetThumbnailTracked: {
      break;
    }
    case messages::PageHandler::kUngroupTab: {
      break;
    }
    case messages::PageHandler::kGetLayout: {
      internal::PageHandler_GetLayout_Params_Data* params =
          reinterpret_cast<
              internal::PageHandler_GetLayout_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PageHandler.8
      bool success = true;
      PageHandler_GetLayout_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 8, false);
        return false;
      }
      auto callback =
          PageHandler_GetLayout_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetLayout(std::move(callback));
      return true;
    }
    case messages::PageHandler::kShowEditDialogForGroup: {
      break;
    }
    case messages::PageHandler::kShowTabContextMenu: {
      break;
    }
    case messages::PageHandler::kShowBackgroundContextMenu: {
      break;
    }
    case messages::PageHandler::kCloseContainer: {
      break;
    }
    case messages::PageHandler::kReportTabActivationDuration: {
      break;
    }
    case messages::PageHandler::kReportTabDataReceivedDuration: {
      break;
    }
    case messages::PageHandler::kReportTabCreationDuration: {
      break;
    }
    case messages::PageHandler::kActivateTab: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_GetGroupVisualData_Params_Data::Validate,
     &internal::PageHandler_GetGroupVisualData_ResponseParams_Data::Validate},
    { &internal::PageHandler_GetTabs_Params_Data::Validate,
     &internal::PageHandler_GetTabs_ResponseParams_Data::Validate},
    { &internal::PageHandler_CloseTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GroupTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_MoveGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_MoveTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_SetThumbnailTracked_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_UngroupTab_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_GetLayout_Params_Data::Validate,
     &internal::PageHandler_GetLayout_ResponseParams_Data::Validate},
    { &internal::PageHandler_ShowEditDialogForGroup_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowTabContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ShowBackgroundContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_CloseContainer_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ReportTabActivationDuration_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ReportTabDataReceivedDuration_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ReportTabCreationDuration_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_ActivateTab_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tab_strip::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

bool PageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::tab_strip::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kLayoutChanged: {
      return &Page::LayoutChanged_Sym::IPCStableHash;
    }
    case messages::Page::kReceivedKeyboardFocus: {
      return &Page::ReceivedKeyboardFocus_Sym::IPCStableHash;
    }
    case messages::Page::kContextMenuClosed: {
      return &Page::ContextMenuClosed_Sym::IPCStableHash;
    }
    case messages::Page::kLongPress: {
      return &Page::LongPress_Sym::IPCStableHash;
    }
    case messages::Page::kTabGroupVisualsChanged: {
      return &Page::TabGroupVisualsChanged_Sym::IPCStableHash;
    }
    case messages::Page::kTabGroupMoved: {
      return &Page::TabGroupMoved_Sym::IPCStableHash;
    }
    case messages::Page::kTabGroupClosed: {
      return &Page::TabGroupClosed_Sym::IPCStableHash;
    }
    case messages::Page::kTabGroupStateChanged: {
      return &Page::TabGroupStateChanged_Sym::IPCStableHash;
    }
    case messages::Page::kTabCloseCancelled: {
      return &Page::TabCloseCancelled_Sym::IPCStableHash;
    }
    case messages::Page::kTabCreated: {
      return &Page::TabCreated_Sym::IPCStableHash;
    }
    case messages::Page::kTabRemoved: {
      return &Page::TabRemoved_Sym::IPCStableHash;
    }
    case messages::Page::kTabMoved: {
      return &Page::TabMoved_Sym::IPCStableHash;
    }
    case messages::Page::kTabReplaced: {
      return &Page::TabReplaced_Sym::IPCStableHash;
    }
    case messages::Page::kTabActiveChanged: {
      return &Page::TabActiveChanged_Sym::IPCStableHash;
    }
    case messages::Page::kTabUpdated: {
      return &Page::TabUpdated_Sym::IPCStableHash;
    }
    case messages::Page::kTabThumbnailUpdated: {
      return &Page::TabThumbnailUpdated_Sym::IPCStableHash;
    }
    case messages::Page::kShowContextMenu: {
      return &Page::ShowContextMenu_Sym::IPCStableHash;
    }
    case messages::Page::kThemeChanged: {
      return &Page::ThemeChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kLayoutChanged:
            return "Receive tab_strip::mojom::Page::LayoutChanged";
      case messages::Page::kReceivedKeyboardFocus:
            return "Receive tab_strip::mojom::Page::ReceivedKeyboardFocus";
      case messages::Page::kContextMenuClosed:
            return "Receive tab_strip::mojom::Page::ContextMenuClosed";
      case messages::Page::kLongPress:
            return "Receive tab_strip::mojom::Page::LongPress";
      case messages::Page::kTabGroupVisualsChanged:
            return "Receive tab_strip::mojom::Page::TabGroupVisualsChanged";
      case messages::Page::kTabGroupMoved:
            return "Receive tab_strip::mojom::Page::TabGroupMoved";
      case messages::Page::kTabGroupClosed:
            return "Receive tab_strip::mojom::Page::TabGroupClosed";
      case messages::Page::kTabGroupStateChanged:
            return "Receive tab_strip::mojom::Page::TabGroupStateChanged";
      case messages::Page::kTabCloseCancelled:
            return "Receive tab_strip::mojom::Page::TabCloseCancelled";
      case messages::Page::kTabCreated:
            return "Receive tab_strip::mojom::Page::TabCreated";
      case messages::Page::kTabRemoved:
            return "Receive tab_strip::mojom::Page::TabRemoved";
      case messages::Page::kTabMoved:
            return "Receive tab_strip::mojom::Page::TabMoved";
      case messages::Page::kTabReplaced:
            return "Receive tab_strip::mojom::Page::TabReplaced";
      case messages::Page::kTabActiveChanged:
            return "Receive tab_strip::mojom::Page::TabActiveChanged";
      case messages::Page::kTabUpdated:
            return "Receive tab_strip::mojom::Page::TabUpdated";
      case messages::Page::kTabThumbnailUpdated:
            return "Receive tab_strip::mojom::Page::TabThumbnailUpdated";
      case messages::Page::kShowContextMenu:
            return "Receive tab_strip::mojom::Page::ShowContextMenu";
      case messages::Page::kThemeChanged:
            return "Receive tab_strip::mojom::Page::ThemeChanged";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kLayoutChanged:
            return "Receive reply tab_strip::mojom::Page::LayoutChanged";
      case messages::Page::kReceivedKeyboardFocus:
            return "Receive reply tab_strip::mojom::Page::ReceivedKeyboardFocus";
      case messages::Page::kContextMenuClosed:
            return "Receive reply tab_strip::mojom::Page::ContextMenuClosed";
      case messages::Page::kLongPress:
            return "Receive reply tab_strip::mojom::Page::LongPress";
      case messages::Page::kTabGroupVisualsChanged:
            return "Receive reply tab_strip::mojom::Page::TabGroupVisualsChanged";
      case messages::Page::kTabGroupMoved:
            return "Receive reply tab_strip::mojom::Page::TabGroupMoved";
      case messages::Page::kTabGroupClosed:
            return "Receive reply tab_strip::mojom::Page::TabGroupClosed";
      case messages::Page::kTabGroupStateChanged:
            return "Receive reply tab_strip::mojom::Page::TabGroupStateChanged";
      case messages::Page::kTabCloseCancelled:
            return "Receive reply tab_strip::mojom::Page::TabCloseCancelled";
      case messages::Page::kTabCreated:
            return "Receive reply tab_strip::mojom::Page::TabCreated";
      case messages::Page::kTabRemoved:
            return "Receive reply tab_strip::mojom::Page::TabRemoved";
      case messages::Page::kTabMoved:
            return "Receive reply tab_strip::mojom::Page::TabMoved";
      case messages::Page::kTabReplaced:
            return "Receive reply tab_strip::mojom::Page::TabReplaced";
      case messages::Page::kTabActiveChanged:
            return "Receive reply tab_strip::mojom::Page::TabActiveChanged";
      case messages::Page::kTabUpdated:
            return "Receive reply tab_strip::mojom::Page::TabUpdated";
      case messages::Page::kTabThumbnailUpdated:
            return "Receive reply tab_strip::mojom::Page::TabThumbnailUpdated";
      case messages::Page::kShowContextMenu:
            return "Receive reply tab_strip::mojom::Page::ShowContextMenu";
      case messages::Page::kThemeChanged:
            return "Receive reply tab_strip::mojom::Page::ThemeChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::LayoutChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x13921830;  // IPCStableHash for tab_strip::mojom::Page::LayoutChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ReceivedKeyboardFocus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xdc5834a5;  // IPCStableHash for tab_strip::mojom::Page::ReceivedKeyboardFocus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ContextMenuClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x573efe9d;  // IPCStableHash for tab_strip::mojom::Page::ContextMenuClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::LongPress_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x014e2fb0;  // IPCStableHash for tab_strip::mojom::Page::LongPress
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabGroupVisualsChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd2dc61a9;  // IPCStableHash for tab_strip::mojom::Page::TabGroupVisualsChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabGroupMoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa2d8c8c0;  // IPCStableHash for tab_strip::mojom::Page::TabGroupMoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabGroupClosed_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x55e74f1f;  // IPCStableHash for tab_strip::mojom::Page::TabGroupClosed
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabGroupStateChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9e9b4e04;  // IPCStableHash for tab_strip::mojom::Page::TabGroupStateChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabCloseCancelled_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x083c0c42;  // IPCStableHash for tab_strip::mojom::Page::TabCloseCancelled
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x62abd63f;  // IPCStableHash for tab_strip::mojom::Page::TabCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeb8b9f0e;  // IPCStableHash for tab_strip::mojom::Page::TabRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabMoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8e0f84db;  // IPCStableHash for tab_strip::mojom::Page::TabMoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabReplaced_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x52dbdcd9;  // IPCStableHash for tab_strip::mojom::Page::TabReplaced
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabActiveChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9ff895bc;  // IPCStableHash for tab_strip::mojom::Page::TabActiveChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf839e960;  // IPCStableHash for tab_strip::mojom::Page::TabUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::TabThumbnailUpdated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b4ba340;  // IPCStableHash for tab_strip::mojom::Page::TabThumbnailUpdated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ShowContextMenu_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3773619d;  // IPCStableHash for tab_strip::mojom::Page::ShowContextMenu
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Page::ThemeChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf07e7114;  // IPCStableHash for tab_strip::mojom::Page::ThemeChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::LayoutChanged(
    const base::flat_map<std::string, std::string>& in_layout) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::LayoutChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("layout"), in_layout,
                        "<value of type const base::flat_map<std::string, std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kLayoutChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_LayoutChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->layout)::BaseType>
      layout_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& layout_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  
  mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
    in_layout,
    layout_fragment,
    &layout_validate_params);

  params->layout.Set(
      layout_fragment.is_null() ? nullptr : layout_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->layout.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null layout in Page.LayoutChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("LayoutChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ReceivedKeyboardFocus(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_strip::mojom::Page::ReceivedKeyboardFocus");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kReceivedKeyboardFocus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_ReceivedKeyboardFocus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ReceivedKeyboardFocus");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ContextMenuClosed(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_strip::mojom::Page::ContextMenuClosed");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kContextMenuClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_ContextMenuClosed_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ContextMenuClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::LongPress(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_strip::mojom::Page::LongPress");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kLongPress), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_LongPress_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("LongPress");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabGroupVisualsChanged(
    const std::string& in_group_id, TabGroupVisualDataPtr in_tab_group) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabGroupVisualsChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_group"), in_tab_group,
                        "<value of type TabGroupVisualDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabGroupVisualsChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabGroupVisualsChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in Page.TabGroupVisualsChanged request");
  mojo::internal::MessageFragment<
      typename decltype(params->tab_group)::BaseType> tab_group_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_strip::mojom::TabGroupVisualDataDataView>(
    in_tab_group,
    tab_group_fragment);

  params->tab_group.Set(
      tab_group_fragment.is_null() ? nullptr : tab_group_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab_group.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab_group in Page.TabGroupVisualsChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabGroupVisualsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabGroupMoved(
    const std::string& in_group_id, int32_t in_index) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabGroupMoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabGroupMoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabGroupMoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in Page.TabGroupMoved request");

  params->index = in_index;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabGroupMoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabGroupClosed(
    const std::string& in_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabGroupClosed", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabGroupClosed), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabGroupClosed_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->group_id.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null group_id in Page.TabGroupClosed request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabGroupClosed");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabGroupStateChanged(
    int32_t in_tab_id, int32_t in_index, const std::optional<std::string>& in_group_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabGroupStateChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("index"), in_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("group_id"), in_group_id,
                        "<value of type const std::optional<std::string>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabGroupStateChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabGroupStateChanged_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->index = in_index;
  mojo::internal::MessageFragment<
      typename decltype(params->group_id)::BaseType> group_id_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_group_id,
    group_id_fragment);

  params->group_id.Set(
      group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabGroupStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabCloseCancelled(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabCloseCancelled", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabCloseCancelled), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabCloseCancelled_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabCloseCancelled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabCreated(
    TabPtr in_tab) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab"), in_tab,
                        "<value of type TabPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabCreated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab)::BaseType> tab_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_strip::mojom::TabDataView>(
    in_tab,
    tab_fragment);

  params->tab.Set(
      tab_fragment.is_null() ? nullptr : tab_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab in Page.TabCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabRemoved(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabRemoved_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabMoved(
    int32_t in_tab_id, int32_t in_to_index, bool in_in_pinned) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabMoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("to_index"), in_to_index,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("in_pinned"), in_in_pinned,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabMoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabMoved_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->to_index = in_to_index;

  params->in_pinned = in_in_pinned;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabMoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabReplaced(
    int32_t in_tab_id, int32_t in_new_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabReplaced", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("new_tab_id"), in_new_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabReplaced), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabReplaced_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

  params->new_tab_id = in_new_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabReplaced");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabActiveChanged(
    int32_t in_tab_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabActiveChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabActiveChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabActiveChanged_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabActiveChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabUpdated(
    TabPtr in_tab) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab"), in_tab,
                        "<value of type TabPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->tab)::BaseType> tab_fragment(
          params.message());
  
  mojo::internal::Serialize<::tab_strip::mojom::TabDataView>(
    in_tab,
    tab_fragment);

  params->tab.Set(
      tab_fragment.is_null() ? nullptr : tab_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->tab.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null tab in Page.TabUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::TabThumbnailUpdated(
    int32_t in_tab_id, const std::string& in_data_uri) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send tab_strip::mojom::Page::TabThumbnailUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("tab_id"), in_tab_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data_uri"), in_data_uri,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kTabThumbnailUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_TabThumbnailUpdated_Params_Data> params(
          message);
  params.Allocate();

  params->tab_id = in_tab_id;
  mojo::internal::MessageFragment<
      typename decltype(params->data_uri)::BaseType> data_uri_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_data_uri,
    data_uri_fragment);

  params->data_uri.Set(
      data_uri_fragment.is_null() ? nullptr : data_uri_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data_uri.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data_uri in Page.TabThumbnailUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("TabThumbnailUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ShowContextMenu(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_strip::mojom::Page::ShowContextMenu");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kShowContextMenu), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_ShowContextMenu_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ShowContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageProxy::ThemeChanged(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send tab_strip::mojom::Page::ThemeChanged");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kThemeChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::tab_strip::mojom::internal::Page_ThemeChanged_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("ThemeChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kLayoutChanged: {
      DCHECK(message->is_serialized());
      internal::Page_LayoutChanged_Params_Data* params =
          reinterpret_cast<internal::Page_LayoutChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      base::flat_map<std::string, std::string> p_layout{};
      Page_LayoutChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadLayout(&p_layout))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LayoutChanged(        
        std::move(p_layout));
      return true;
    }
    case messages::Page::kReceivedKeyboardFocus: {
      DCHECK(message->is_serialized());
      internal::Page_ReceivedKeyboardFocus_Params_Data* params =
          reinterpret_cast<internal::Page_ReceivedKeyboardFocus_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.1
      bool success = true;
      Page_ReceivedKeyboardFocus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ReceivedKeyboardFocus(        );
      return true;
    }
    case messages::Page::kContextMenuClosed: {
      DCHECK(message->is_serialized());
      internal::Page_ContextMenuClosed_Params_Data* params =
          reinterpret_cast<internal::Page_ContextMenuClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.2
      bool success = true;
      Page_ContextMenuClosed_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContextMenuClosed(        );
      return true;
    }
    case messages::Page::kLongPress: {
      DCHECK(message->is_serialized());
      internal::Page_LongPress_Params_Data* params =
          reinterpret_cast<internal::Page_LongPress_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.3
      bool success = true;
      Page_LongPress_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LongPress(        );
      return true;
    }
    case messages::Page::kTabGroupVisualsChanged: {
      DCHECK(message->is_serialized());
      internal::Page_TabGroupVisualsChanged_Params_Data* params =
          reinterpret_cast<internal::Page_TabGroupVisualsChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.4
      bool success = true;
      std::string p_group_id{};
      TabGroupVisualDataPtr p_tab_group{};
      Page_TabGroupVisualsChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (success && !input_data_view.ReadTabGroup(&p_tab_group))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabGroupVisualsChanged(        
        std::move(p_group_id), 
        std::move(p_tab_group));
      return true;
    }
    case messages::Page::kTabGroupMoved: {
      DCHECK(message->is_serialized());
      internal::Page_TabGroupMoved_Params_Data* params =
          reinterpret_cast<internal::Page_TabGroupMoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.5
      bool success = true;
      std::string p_group_id{};
      int32_t p_index{};
      Page_TabGroupMoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (success)
        p_index = input_data_view.index();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabGroupMoved(        
        std::move(p_group_id), 
        std::move(p_index));
      return true;
    }
    case messages::Page::kTabGroupClosed: {
      DCHECK(message->is_serialized());
      internal::Page_TabGroupClosed_Params_Data* params =
          reinterpret_cast<internal::Page_TabGroupClosed_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.6
      bool success = true;
      std::string p_group_id{};
      Page_TabGroupClosed_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabGroupClosed(        
        std::move(p_group_id));
      return true;
    }
    case messages::Page::kTabGroupStateChanged: {
      DCHECK(message->is_serialized());
      internal::Page_TabGroupStateChanged_Params_Data* params =
          reinterpret_cast<internal::Page_TabGroupStateChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.7
      bool success = true;
      int32_t p_tab_id{};
      int32_t p_index{};
      std::optional<std::string> p_group_id{};
      Page_TabGroupStateChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_index = input_data_view.index();
      if (success && !input_data_view.ReadGroupId(&p_group_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabGroupStateChanged(        
        std::move(p_tab_id), 
        std::move(p_index), 
        std::move(p_group_id));
      return true;
    }
    case messages::Page::kTabCloseCancelled: {
      DCHECK(message->is_serialized());
      internal::Page_TabCloseCancelled_Params_Data* params =
          reinterpret_cast<internal::Page_TabCloseCancelled_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.8
      bool success = true;
      int32_t p_tab_id{};
      Page_TabCloseCancelled_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabCloseCancelled(        
        std::move(p_tab_id));
      return true;
    }
    case messages::Page::kTabCreated: {
      DCHECK(message->is_serialized());
      internal::Page_TabCreated_Params_Data* params =
          reinterpret_cast<internal::Page_TabCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.9
      bool success = true;
      TabPtr p_tab{};
      Page_TabCreated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTab(&p_tab))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabCreated(        
        std::move(p_tab));
      return true;
    }
    case messages::Page::kTabRemoved: {
      DCHECK(message->is_serialized());
      internal::Page_TabRemoved_Params_Data* params =
          reinterpret_cast<internal::Page_TabRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.10
      bool success = true;
      int32_t p_tab_id{};
      Page_TabRemoved_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabRemoved(        
        std::move(p_tab_id));
      return true;
    }
    case messages::Page::kTabMoved: {
      DCHECK(message->is_serialized());
      internal::Page_TabMoved_Params_Data* params =
          reinterpret_cast<internal::Page_TabMoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.11
      bool success = true;
      int32_t p_tab_id{};
      int32_t p_to_index{};
      bool p_in_pinned{};
      Page_TabMoved_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_to_index = input_data_view.to_index();
      if (success)
        p_in_pinned = input_data_view.in_pinned();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabMoved(        
        std::move(p_tab_id), 
        std::move(p_to_index), 
        std::move(p_in_pinned));
      return true;
    }
    case messages::Page::kTabReplaced: {
      DCHECK(message->is_serialized());
      internal::Page_TabReplaced_Params_Data* params =
          reinterpret_cast<internal::Page_TabReplaced_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.12
      bool success = true;
      int32_t p_tab_id{};
      int32_t p_new_tab_id{};
      Page_TabReplaced_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success)
        p_new_tab_id = input_data_view.new_tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabReplaced(        
        std::move(p_tab_id), 
        std::move(p_new_tab_id));
      return true;
    }
    case messages::Page::kTabActiveChanged: {
      DCHECK(message->is_serialized());
      internal::Page_TabActiveChanged_Params_Data* params =
          reinterpret_cast<internal::Page_TabActiveChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.13
      bool success = true;
      int32_t p_tab_id{};
      Page_TabActiveChanged_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabActiveChanged(        
        std::move(p_tab_id));
      return true;
    }
    case messages::Page::kTabUpdated: {
      DCHECK(message->is_serialized());
      internal::Page_TabUpdated_Params_Data* params =
          reinterpret_cast<internal::Page_TabUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.14
      bool success = true;
      TabPtr p_tab{};
      Page_TabUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTab(&p_tab))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabUpdated(        
        std::move(p_tab));
      return true;
    }
    case messages::Page::kTabThumbnailUpdated: {
      DCHECK(message->is_serialized());
      internal::Page_TabThumbnailUpdated_Params_Data* params =
          reinterpret_cast<internal::Page_TabThumbnailUpdated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.15
      bool success = true;
      int32_t p_tab_id{};
      std::string p_data_uri{};
      Page_TabThumbnailUpdated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_tab_id = input_data_view.tab_id();
      if (success && !input_data_view.ReadDataUri(&p_data_uri))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TabThumbnailUpdated(        
        std::move(p_tab_id), 
        std::move(p_data_uri));
      return true;
    }
    case messages::Page::kShowContextMenu: {
      DCHECK(message->is_serialized());
      internal::Page_ShowContextMenu_Params_Data* params =
          reinterpret_cast<internal::Page_ShowContextMenu_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.16
      bool success = true;
      Page_ShowContextMenu_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 16, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenu(        );
      return true;
    }
    case messages::Page::kThemeChanged: {
      DCHECK(message->is_serialized());
      internal::Page_ThemeChanged_Params_Data* params =
          reinterpret_cast<internal::Page_ThemeChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.17
      bool success = true;
      Page_ThemeChanged_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 17, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ThemeChanged(        );
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kLayoutChanged: {
      break;
    }
    case messages::Page::kReceivedKeyboardFocus: {
      break;
    }
    case messages::Page::kContextMenuClosed: {
      break;
    }
    case messages::Page::kLongPress: {
      break;
    }
    case messages::Page::kTabGroupVisualsChanged: {
      break;
    }
    case messages::Page::kTabGroupMoved: {
      break;
    }
    case messages::Page::kTabGroupClosed: {
      break;
    }
    case messages::Page::kTabGroupStateChanged: {
      break;
    }
    case messages::Page::kTabCloseCancelled: {
      break;
    }
    case messages::Page::kTabCreated: {
      break;
    }
    case messages::Page::kTabRemoved: {
      break;
    }
    case messages::Page::kTabMoved: {
      break;
    }
    case messages::Page::kTabReplaced: {
      break;
    }
    case messages::Page::kTabActiveChanged: {
      break;
    }
    case messages::Page::kTabUpdated: {
      break;
    }
    case messages::Page::kTabThumbnailUpdated: {
      break;
    }
    case messages::Page::kShowContextMenu: {
      break;
    }
    case messages::Page::kThemeChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_LayoutChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ReceivedKeyboardFocus_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ContextMenuClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_LongPress_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabGroupVisualsChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabGroupMoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabGroupClosed_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabGroupStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabCloseCancelled_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabCreated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabRemoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabMoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabReplaced_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabActiveChanged_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_TabThumbnailUpdated_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ShowContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::Page_ThemeChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::tab_strip::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // tab_strip::mojom


namespace mojo {


// static
bool StructTraits<::tab_strip::mojom::Tab::DataView, ::tab_strip::mojom::TabPtr>::Read(
    ::tab_strip::mojom::Tab::DataView input,
    ::tab_strip::mojom::TabPtr* output) {
  bool success = true;
  ::tab_strip::mojom::TabPtr result(::tab_strip::mojom::Tab::New());
  
      if (success)
        result->active = input.active();
      if (success && !input.ReadAlertStates(&result->alert_states))
        success = false;
      if (success)
        result->blocked = input.blocked();
      if (success)
        result->crashed = input.crashed();
      if (success && !input.ReadFaviconUrl(&result->favicon_url))
        success = false;
      if (success && !input.ReadActiveFaviconUrl(&result->active_favicon_url))
        success = false;
      if (success && !input.ReadGroupId(&result->group_id))
        success = false;
      if (success)
        result->id = input.id();
      if (success)
        result->index = input.index();
      if (success)
        result->is_default_favicon = input.is_default_favicon();
      if (success && !input.ReadNetworkState(&result->network_state))
        success = false;
      if (success)
        result->pinned = input.pinned();
      if (success)
        result->should_hide_throbber = input.should_hide_throbber();
      if (success)
        result->show_icon = input.show_icon();
      if (success && !input.ReadTitle(&result->title))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::tab_strip::mojom::TabGroupVisualData::DataView, ::tab_strip::mojom::TabGroupVisualDataPtr>::Read(
    ::tab_strip::mojom::TabGroupVisualData::DataView input,
    ::tab_strip::mojom::TabGroupVisualDataPtr* output) {
  bool success = true;
  ::tab_strip::mojom::TabGroupVisualDataPtr result(::tab_strip::mojom::TabGroupVisualData::New());
  
      if (success && !input.ReadColor(&result->color))
        success = false;
      if (success && !input.ReadTextColor(&result->text_color))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace tab_strip::mojom {


void PageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::GetGroupVisualData(GetGroupVisualDataCallback callback) {
  GetForwardingInterface()->GetGroupVisualData(std::move(callback));
}
void PageHandlerInterceptorForTesting::GetTabs(GetTabsCallback callback) {
  GetForwardingInterface()->GetTabs(std::move(callback));
}
void PageHandlerInterceptorForTesting::CloseTab(int32_t tab_id, bool tab_was_swiped) {
  GetForwardingInterface()->CloseTab(
    std::move(tab_id)
    , 
    std::move(tab_was_swiped)
    );
}
void PageHandlerInterceptorForTesting::GroupTab(int32_t tab_id, const std::string& group_id) {
  GetForwardingInterface()->GroupTab(
    std::move(tab_id)
    , 
    std::move(group_id)
    );
}
void PageHandlerInterceptorForTesting::MoveGroup(const std::string& group_id, int32_t to_index) {
  GetForwardingInterface()->MoveGroup(
    std::move(group_id)
    , 
    std::move(to_index)
    );
}
void PageHandlerInterceptorForTesting::MoveTab(int32_t tab_id, int32_t to_index) {
  GetForwardingInterface()->MoveTab(
    std::move(tab_id)
    , 
    std::move(to_index)
    );
}
void PageHandlerInterceptorForTesting::SetThumbnailTracked(int32_t tab_id, bool thumbnail_tracked) {
  GetForwardingInterface()->SetThumbnailTracked(
    std::move(tab_id)
    , 
    std::move(thumbnail_tracked)
    );
}
void PageHandlerInterceptorForTesting::UngroupTab(int32_t tab_id) {
  GetForwardingInterface()->UngroupTab(
    std::move(tab_id)
    );
}
void PageHandlerInterceptorForTesting::GetLayout(GetLayoutCallback callback) {
  GetForwardingInterface()->GetLayout(std::move(callback));
}
void PageHandlerInterceptorForTesting::ShowEditDialogForGroup(const std::string& group_id, int32_t location_x, int32_t location_y, int32_t width, int32_t height) {
  GetForwardingInterface()->ShowEditDialogForGroup(
    std::move(group_id)
    , 
    std::move(location_x)
    , 
    std::move(location_y)
    , 
    std::move(width)
    , 
    std::move(height)
    );
}
void PageHandlerInterceptorForTesting::ShowTabContextMenu(int32_t tab_id, int32_t location_x, int32_t location_y) {
  GetForwardingInterface()->ShowTabContextMenu(
    std::move(tab_id)
    , 
    std::move(location_x)
    , 
    std::move(location_y)
    );
}
void PageHandlerInterceptorForTesting::ShowBackgroundContextMenu(int32_t location_x, int32_t location_y) {
  GetForwardingInterface()->ShowBackgroundContextMenu(
    std::move(location_x)
    , 
    std::move(location_y)
    );
}
void PageHandlerInterceptorForTesting::CloseContainer() {
  GetForwardingInterface()->CloseContainer();
}
void PageHandlerInterceptorForTesting::ReportTabActivationDuration(uint32_t duration_ms) {
  GetForwardingInterface()->ReportTabActivationDuration(
    std::move(duration_ms)
    );
}
void PageHandlerInterceptorForTesting::ReportTabDataReceivedDuration(uint32_t tab_count, uint32_t duration_ms) {
  GetForwardingInterface()->ReportTabDataReceivedDuration(
    std::move(tab_count)
    , 
    std::move(duration_ms)
    );
}
void PageHandlerInterceptorForTesting::ReportTabCreationDuration(uint32_t tab_count, uint32_t duration_ms) {
  GetForwardingInterface()->ReportTabCreationDuration(
    std::move(tab_count)
    , 
    std::move(duration_ms)
    );
}
void PageHandlerInterceptorForTesting::ActivateTab(int32_t tab_id) {
  GetForwardingInterface()->ActivateTab(
    std::move(tab_id)
    );
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;


void PageHandlerAsyncWaiter::GetGroupVisualData(
    base::flat_map<std::string, TabGroupVisualDataPtr>* out_data) {
  base::RunLoop loop;
  proxy_->GetGroupVisualData(
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<std::string, TabGroupVisualDataPtr>* out_data
,
             base::flat_map<std::string, TabGroupVisualDataPtr> data) {*out_data = std::move(data);
            loop->Quit();
          },
          &loop,
          out_data));
  loop.Run();
}

base::flat_map<std::string, TabGroupVisualDataPtr> PageHandlerAsyncWaiter::GetGroupVisualData(
    ) {
  base::flat_map<std::string, TabGroupVisualDataPtr> async_wait_result;
  GetGroupVisualData(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetTabs(
    std::vector<TabPtr>* out_tabs) {
  base::RunLoop loop;
  proxy_->GetTabs(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<TabPtr>* out_tabs
,
             std::vector<TabPtr> tabs) {*out_tabs = std::move(tabs);
            loop->Quit();
          },
          &loop,
          out_tabs));
  loop.Run();
}

std::vector<TabPtr> PageHandlerAsyncWaiter::GetTabs(
    ) {
  std::vector<TabPtr> async_wait_result;
  GetTabs(&async_wait_result);
  return async_wait_result;
}

void PageHandlerAsyncWaiter::GetLayout(
    base::flat_map<std::string, std::string>* out_layout) {
  base::RunLoop loop;
  proxy_->GetLayout(
      base::BindOnce(
          [](base::RunLoop* loop,
             base::flat_map<std::string, std::string>* out_layout
,
             const base::flat_map<std::string, std::string>& layout) {*out_layout = std::move(layout);
            loop->Quit();
          },
          &loop,
          out_layout));
  loop.Run();
}

base::flat_map<std::string, std::string> PageHandlerAsyncWaiter::GetLayout(
    ) {
  base::flat_map<std::string, std::string> async_wait_result;
  GetLayout(&async_wait_result);
  return async_wait_result;
}




void PageInterceptorForTesting::LayoutChanged(const base::flat_map<std::string, std::string>& layout) {
  GetForwardingInterface()->LayoutChanged(
    std::move(layout)
    );
}
void PageInterceptorForTesting::ReceivedKeyboardFocus() {
  GetForwardingInterface()->ReceivedKeyboardFocus();
}
void PageInterceptorForTesting::ContextMenuClosed() {
  GetForwardingInterface()->ContextMenuClosed();
}
void PageInterceptorForTesting::LongPress() {
  GetForwardingInterface()->LongPress();
}
void PageInterceptorForTesting::TabGroupVisualsChanged(const std::string& group_id, TabGroupVisualDataPtr tab_group) {
  GetForwardingInterface()->TabGroupVisualsChanged(
    std::move(group_id)
    , 
    std::move(tab_group)
    );
}
void PageInterceptorForTesting::TabGroupMoved(const std::string& group_id, int32_t index) {
  GetForwardingInterface()->TabGroupMoved(
    std::move(group_id)
    , 
    std::move(index)
    );
}
void PageInterceptorForTesting::TabGroupClosed(const std::string& group_id) {
  GetForwardingInterface()->TabGroupClosed(
    std::move(group_id)
    );
}
void PageInterceptorForTesting::TabGroupStateChanged(int32_t tab_id, int32_t index, const std::optional<std::string>& group_id) {
  GetForwardingInterface()->TabGroupStateChanged(
    std::move(tab_id)
    , 
    std::move(index)
    , 
    std::move(group_id)
    );
}
void PageInterceptorForTesting::TabCloseCancelled(int32_t tab_id) {
  GetForwardingInterface()->TabCloseCancelled(
    std::move(tab_id)
    );
}
void PageInterceptorForTesting::TabCreated(TabPtr tab) {
  GetForwardingInterface()->TabCreated(
    std::move(tab)
    );
}
void PageInterceptorForTesting::TabRemoved(int32_t tab_id) {
  GetForwardingInterface()->TabRemoved(
    std::move(tab_id)
    );
}
void PageInterceptorForTesting::TabMoved(int32_t tab_id, int32_t to_index, bool in_pinned) {
  GetForwardingInterface()->TabMoved(
    std::move(tab_id)
    , 
    std::move(to_index)
    , 
    std::move(in_pinned)
    );
}
void PageInterceptorForTesting::TabReplaced(int32_t tab_id, int32_t new_tab_id) {
  GetForwardingInterface()->TabReplaced(
    std::move(tab_id)
    , 
    std::move(new_tab_id)
    );
}
void PageInterceptorForTesting::TabActiveChanged(int32_t tab_id) {
  GetForwardingInterface()->TabActiveChanged(
    std::move(tab_id)
    );
}
void PageInterceptorForTesting::TabUpdated(TabPtr tab) {
  GetForwardingInterface()->TabUpdated(
    std::move(tab)
    );
}
void PageInterceptorForTesting::TabThumbnailUpdated(int32_t tab_id, const std::string& data_uri) {
  GetForwardingInterface()->TabThumbnailUpdated(
    std::move(tab_id)
    , 
    std::move(data_uri)
    );
}
void PageInterceptorForTesting::ShowContextMenu() {
  GetForwardingInterface()->ShowContextMenu();
}
void PageInterceptorForTesting::ThemeChanged() {
  GetForwardingInterface()->ThemeChanged();
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // tab_strip::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif