// chrome/browser/ui/webui/tab_strip/tab_strip.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom.h"


namespace tab_strip::mojom {


class  PageHandlerFactoryInterceptorForTesting : public PageHandlerFactory {
  virtual PageHandlerFactory* GetForwardingInterface() = 0;
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) override;
};
class  PageHandlerFactoryAsyncWaiter {
 public:
  explicit PageHandlerFactoryAsyncWaiter(PageHandlerFactory* proxy);

  PageHandlerFactoryAsyncWaiter(const PageHandlerFactoryAsyncWaiter&) = delete;
  PageHandlerFactoryAsyncWaiter& operator=(const PageHandlerFactoryAsyncWaiter&) = delete;

  ~PageHandlerFactoryAsyncWaiter();

 private:
  PageHandlerFactory* const proxy_;
};


class  PageHandlerInterceptorForTesting : public PageHandler {
  virtual PageHandler* GetForwardingInterface() = 0;
  void GetGroupVisualData(GetGroupVisualDataCallback callback) override;
  void GetTabs(GetTabsCallback callback) override;
  void CloseTab(int32_t tab_id, bool tab_was_swiped) override;
  void GroupTab(int32_t tab_id, const std::string& group_id) override;
  void MoveGroup(const std::string& group_id, int32_t to_index) override;
  void MoveTab(int32_t tab_id, int32_t to_index) override;
  void SetThumbnailTracked(int32_t tab_id, bool thumbnail_tracked) override;
  void UngroupTab(int32_t tab_id) override;
  void GetLayout(GetLayoutCallback callback) override;
  void ShowEditDialogForGroup(const std::string& group_id, int32_t location_x, int32_t location_y, int32_t width, int32_t height) override;
  void ShowTabContextMenu(int32_t tab_id, int32_t location_x, int32_t location_y) override;
  void ShowBackgroundContextMenu(int32_t location_x, int32_t location_y) override;
  void CloseContainer() override;
  void ReportTabActivationDuration(uint32_t duration_ms) override;
  void ReportTabDataReceivedDuration(uint32_t tab_count, uint32_t duration_ms) override;
  void ReportTabCreationDuration(uint32_t tab_count, uint32_t duration_ms) override;
  void ActivateTab(int32_t tab_id) override;
};
class  PageHandlerAsyncWaiter {
 public:
  explicit PageHandlerAsyncWaiter(PageHandler* proxy);

  PageHandlerAsyncWaiter(const PageHandlerAsyncWaiter&) = delete;
  PageHandlerAsyncWaiter& operator=(const PageHandlerAsyncWaiter&) = delete;

  ~PageHandlerAsyncWaiter();
  void GetGroupVisualData(
      base::flat_map<std::string, TabGroupVisualDataPtr>* out_data);
  base::flat_map<std::string, TabGroupVisualDataPtr> GetGroupVisualData();
  void GetTabs(
      std::vector<TabPtr>* out_tabs);
  std::vector<TabPtr> GetTabs();
  void GetLayout(
      base::flat_map<std::string, std::string>* out_layout);
  base::flat_map<std::string, std::string> GetLayout();

 private:
  PageHandler* const proxy_;
};


class  PageInterceptorForTesting : public Page {
  virtual Page* GetForwardingInterface() = 0;
  void LayoutChanged(const base::flat_map<std::string, std::string>& layout) override;
  void ReceivedKeyboardFocus() override;
  void ContextMenuClosed() override;
  void LongPress() override;
  void TabGroupVisualsChanged(const std::string& group_id, TabGroupVisualDataPtr tab_group) override;
  void TabGroupMoved(const std::string& group_id, int32_t index) override;
  void TabGroupClosed(const std::string& group_id) override;
  void TabGroupStateChanged(int32_t tab_id, int32_t index, const std::optional<std::string>& group_id) override;
  void TabCloseCancelled(int32_t tab_id) override;
  void TabCreated(TabPtr tab) override;
  void TabRemoved(int32_t tab_id) override;
  void TabMoved(int32_t tab_id, int32_t to_index, bool in_pinned) override;
  void TabReplaced(int32_t tab_id, int32_t new_tab_id) override;
  void TabActiveChanged(int32_t tab_id) override;
  void TabUpdated(TabPtr tab) override;
  void TabThumbnailUpdated(int32_t tab_id, const std::string& data_uri) override;
  void ShowContextMenu() override;
  void ThemeChanged() override;
};
class  PageAsyncWaiter {
 public:
  explicit PageAsyncWaiter(Page* proxy);

  PageAsyncWaiter(const PageAsyncWaiter&) = delete;
  PageAsyncWaiter& operator=(const PageAsyncWaiter&) = delete;

  ~PageAsyncWaiter();

 private:
  Page* const proxy_;
};




}  // tab_strip::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_TEST_UTILS_H_