// chrome/browser/ui/webui/tab_strip/tab_strip.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/ui/webui/tab_strip/tab_strip.mojom-shared-internal.h"
#include "chrome/browser/ui/webui/tabs/tabs.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace tab_strip::mojom {
class TabDataView;

class TabGroupVisualDataDataView;



}  // tab_strip::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::tab_strip::mojom::TabDataView> {
  using Data = ::tab_strip::mojom::internal::Tab_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::tab_strip::mojom::TabGroupVisualDataDataView> {
  using Data = ::tab_strip::mojom::internal::TabGroupVisualData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace tab_strip::mojom {
// Interface base classes. They are used for type safety check.
class PageHandlerFactoryInterfaceBase {};

using PageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerFactoryInterfaceBase>;
using PageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerFactoryInterfaceBase>;
class PageHandlerInterfaceBase {};

using PageHandlerPtrDataView =
    mojo::InterfacePtrDataView<PageHandlerInterfaceBase>;
using PageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageHandlerInterfaceBase>;
using PageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageHandlerInterfaceBase>;
class PageInterfaceBase {};

using PagePtrDataView =
    mojo::InterfacePtrDataView<PageInterfaceBase>;
using PageRequestDataView =
    mojo::InterfaceRequestDataView<PageInterfaceBase>;
using PageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageInterfaceBase>;
using PageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageInterfaceBase>;


class TabDataView {
 public:
  TabDataView() = default;

  TabDataView(
      internal::Tab_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool active() const {
    return data_->active;
  }
  inline void GetAlertStatesDataView(
      mojo::ArrayDataView<::tabs::mojom::TabAlertState>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAlertStates(UserType* output) {
    
    auto* pointer = data_->alert_states.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::tabs::mojom::TabAlertState>>(
        pointer, output, message_);
  }
  bool blocked() const {
    return data_->blocked;
  }
  bool crashed() const {
    return data_->crashed;
  }
  inline void GetFaviconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFaviconUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `favicon_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFaviconUrl` instead "
    "of `ReadFaviconUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->favicon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetActiveFaviconUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadActiveFaviconUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `active_favicon_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadActiveFaviconUrl` instead "
    "of `ReadActiveFaviconUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->active_favicon_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetGroupIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGroupId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `group_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadGroupId` instead "
    "of `ReadGroupId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->group_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t id() const {
    return data_->id;
  }
  int32_t index() const {
    return data_->index;
  }
  bool is_default_favicon() const {
    return data_->is_default_favicon;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadNetworkState(UserType* output) const {
    auto data_value = data_->network_state;
    return mojo::internal::Deserialize<::tabs::mojom::TabNetworkState>(
        data_value, output);
  }
  ::tabs::mojom::TabNetworkState network_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::tabs::mojom::TabNetworkState>(data_->network_state));
  }
  bool pinned() const {
    return data_->pinned;
  }
  bool should_hide_throbber() const {
    return data_->should_hide_throbber;
  }
  bool show_icon() const {
    return data_->show_icon;
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::Tab_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TabGroupVisualDataDataView {
 public:
  TabGroupVisualDataDataView() = default;

  TabGroupVisualDataDataView(
      internal::TabGroupVisualData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadColor(UserType* output) {
    
    auto* pointer = data_->color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTextColorDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTextColor(UserType* output) {
    
    auto* pointer = data_->text_color.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TabGroupVisualData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // tab_strip::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_TAB_STRIP_TAB_STRIP_MOJOM_DATA_VIEW_H_