// chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom-params-data.h"
#include "chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom-import-headers.h"
#include "chrome/browser/ui/webui/signin/signout_confirmation/signout_confirmation.mojom-test-utils.h"


namespace signout_confirmation::mojom {
ExtensionInfo::ExtensionInfo()
    : name(),
      icon_url() {}

ExtensionInfo::ExtensionInfo(
    const std::string& name_in,
    const std::string& icon_url_in)
    : name(std::move(name_in)),
      icon_url(std::move(icon_url_in)) {}

ExtensionInfo::~ExtensionInfo() = default;
size_t ExtensionInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->icon_url);
  return seed;
}

void ExtensionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon_url"), this->icon_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ExtensionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignoutConfirmationData::SignoutConfirmationData()
    : dialog_title(),
      dialog_subtitle(),
      accept_button_label(),
      cancel_button_label(),
      account_extensions(),
      has_unsynced_data() {}

SignoutConfirmationData::SignoutConfirmationData(
    const std::string& dialog_title_in,
    const std::string& dialog_subtitle_in,
    const std::string& accept_button_label_in,
    const std::string& cancel_button_label_in,
    std::vector<ExtensionInfoPtr> account_extensions_in,
    bool has_unsynced_data_in)
    : dialog_title(std::move(dialog_title_in)),
      dialog_subtitle(std::move(dialog_subtitle_in)),
      accept_button_label(std::move(accept_button_label_in)),
      cancel_button_label(std::move(cancel_button_label_in)),
      account_extensions(std::move(account_extensions_in)),
      has_unsynced_data(std::move(has_unsynced_data_in)) {}

SignoutConfirmationData::~SignoutConfirmationData() = default;

void SignoutConfirmationData::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dialog_title"), this->dialog_title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "dialog_subtitle"), this->dialog_subtitle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "accept_button_label"), this->accept_button_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cancel_button_label"), this->cancel_button_label,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "account_extensions"), this->account_extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ExtensionInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_unsynced_data"), this->has_unsynced_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SignoutConfirmationData::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PageHandlerFactory::IPCStableHashFunction PageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandlerFactory>(message.name())) {
    case messages::PageHandlerFactory::kCreateSignoutConfirmationHandler: {
      return &PageHandlerFactory::CreateSignoutConfirmationHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreateSignoutConfirmationHandler:
            return "Receive signout_confirmation::mojom::PageHandlerFactory::CreateSignoutConfirmationHandler";
    }
  } else {
    switch (static_cast<messages::PageHandlerFactory>(message.name())) {
      case messages::PageHandlerFactory::kCreateSignoutConfirmationHandler:
            return "Receive reply signout_confirmation::mojom::PageHandlerFactory::CreateSignoutConfirmationHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandlerFactory::CreateSignoutConfirmationHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7deeca97;  // IPCStableHash for signout_confirmation::mojom::PageHandlerFactory::CreateSignoutConfirmationHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerFactoryProxy::PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerFactoryProxy::CreateSignoutConfirmationHandler(
    ::mojo::PendingRemote<Page> in_page, ::mojo::PendingReceiver<PageHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send signout_confirmation::mojom::PageHandlerFactory::CreateSignoutConfirmationHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<Page>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<PageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandlerFactory::kCreateSignoutConfirmationHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::signout_confirmation::mojom::internal::PageHandlerFactory_CreateSignoutConfirmationHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::signout_confirmation::mojom::PageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in PageHandlerFactory.CreateSignoutConfirmationHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::signout_confirmation::mojom::PageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in PageHandlerFactory.CreateSignoutConfirmationHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandlerFactory::Name_);
  message.set_method_name("CreateSignoutConfirmationHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerFactoryStubDispatch::Accept(
    PageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreateSignoutConfirmationHandler: {
      DCHECK(message->is_serialized());
      internal::PageHandlerFactory_CreateSignoutConfirmationHandler_Params_Data* params =
          reinterpret_cast<internal::PageHandlerFactory_CreateSignoutConfirmationHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<Page> p_page{};
      ::mojo::PendingReceiver<PageHandler> p_handler{};
      PageHandlerFactory_CreateSignoutConfirmationHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateSignoutConfirmationHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerFactoryStubDispatch::AcceptWithResponder(
    PageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandlerFactory>(message->header()->name)) {
    case messages::PageHandlerFactory::kCreateSignoutConfirmationHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerFactoryValidationInfo[] = {
    { &internal::PageHandlerFactory_CreateSignoutConfirmationHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::signout_confirmation::mojom::PageHandlerFactory::Name_,
    kPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

PageHandler::IPCStableHashFunction PageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PageHandler>(message.name())) {
    case messages::PageHandler::kUpdateViewHeight: {
      return &PageHandler::UpdateViewHeight_Sym::IPCStableHash;
    }
    case messages::PageHandler::kAccept: {
      return &PageHandler::Accept_Sym::IPCStableHash;
    }
    case messages::PageHandler::kCancel: {
      return &PageHandler::Cancel_Sym::IPCStableHash;
    }
    case messages::PageHandler::kClose: {
      return &PageHandler::Close_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kUpdateViewHeight:
            return "Receive signout_confirmation::mojom::PageHandler::UpdateViewHeight";
      case messages::PageHandler::kAccept:
            return "Receive signout_confirmation::mojom::PageHandler::Accept";
      case messages::PageHandler::kCancel:
            return "Receive signout_confirmation::mojom::PageHandler::Cancel";
      case messages::PageHandler::kClose:
            return "Receive signout_confirmation::mojom::PageHandler::Close";
    }
  } else {
    switch (static_cast<messages::PageHandler>(message.name())) {
      case messages::PageHandler::kUpdateViewHeight:
            return "Receive reply signout_confirmation::mojom::PageHandler::UpdateViewHeight";
      case messages::PageHandler::kAccept:
            return "Receive reply signout_confirmation::mojom::PageHandler::Accept";
      case messages::PageHandler::kCancel:
            return "Receive reply signout_confirmation::mojom::PageHandler::Cancel";
      case messages::PageHandler::kClose:
            return "Receive reply signout_confirmation::mojom::PageHandler::Close";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PageHandler::UpdateViewHeight_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x51f3d60f;  // IPCStableHash for signout_confirmation::mojom::PageHandler::UpdateViewHeight
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Accept_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8667c690;  // IPCStableHash for signout_confirmation::mojom::PageHandler::Accept
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Cancel_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc2c97629;  // IPCStableHash for signout_confirmation::mojom::PageHandler::Cancel
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PageHandler::Close_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa986c94f;  // IPCStableHash for signout_confirmation::mojom::PageHandler::Close
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageHandlerProxy::PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageHandlerProxy::UpdateViewHeight(
    uint32_t in_height) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send signout_confirmation::mojom::PageHandler::UpdateViewHeight", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("height"), in_height,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kUpdateViewHeight), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::signout_confirmation::mojom::internal::PageHandler_UpdateViewHeight_Params_Data> params(
          message);
  params.Allocate();

  params->height = in_height;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("UpdateViewHeight");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Accept(
    bool in_uninstall_account_extensions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send signout_confirmation::mojom::PageHandler::Accept", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uninstall_account_extensions"), in_uninstall_account_extensions,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kAccept), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::signout_confirmation::mojom::internal::PageHandler_Accept_Params_Data> params(
          message);
  params.Allocate();

  params->uninstall_account_extensions = in_uninstall_account_extensions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Accept");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Cancel(
    bool in_uninstall_account_extensions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send signout_confirmation::mojom::PageHandler::Cancel", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("uninstall_account_extensions"), in_uninstall_account_extensions,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::signout_confirmation::mojom::internal::PageHandler_Cancel_Params_Data> params(
          message);
  params.Allocate();

  params->uninstall_account_extensions = in_uninstall_account_extensions;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void PageHandlerProxy::Close(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send signout_confirmation::mojom::PageHandler::Close");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PageHandler::kClose), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::signout_confirmation::mojom::internal::PageHandler_Close_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PageHandler::Name_);
  message.set_method_name("Close");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageHandlerStubDispatch::Accept(
    PageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kUpdateViewHeight: {
      DCHECK(message->is_serialized());
      internal::PageHandler_UpdateViewHeight_Params_Data* params =
          reinterpret_cast<internal::PageHandler_UpdateViewHeight_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.0
      bool success = true;
      uint32_t p_height{};
      PageHandler_UpdateViewHeight_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_height = input_data_view.height();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateViewHeight(        
        std::move(p_height));
      return true;
    }
    case messages::PageHandler::kAccept: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Accept_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Accept_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.1
      bool success = true;
      bool p_uninstall_account_extensions{};
      PageHandler_Accept_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_uninstall_account_extensions = input_data_view.uninstall_account_extensions();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Accept(        
        std::move(p_uninstall_account_extensions));
      return true;
    }
    case messages::PageHandler::kCancel: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Cancel_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Cancel_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.2
      bool success = true;
      bool p_uninstall_account_extensions{};
      PageHandler_Cancel_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_uninstall_account_extensions = input_data_view.uninstall_account_extensions();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        
        std::move(p_uninstall_account_extensions));
      return true;
    }
    case messages::PageHandler::kClose: {
      DCHECK(message->is_serialized());
      internal::PageHandler_Close_Params_Data* params =
          reinterpret_cast<internal::PageHandler_Close_Params_Data*>(
              message->mutable_payload());
      

      // Validation for PageHandler.3
      bool success = true;
      PageHandler_Close_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(        );
      return true;
    }
  }
  return false;
}

// static
bool PageHandlerStubDispatch::AcceptWithResponder(
    PageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PageHandler>(message->header()->name)) {
    case messages::PageHandler::kUpdateViewHeight: {
      break;
    }
    case messages::PageHandler::kAccept: {
      break;
    }
    case messages::PageHandler::kCancel: {
      break;
    }
    case messages::PageHandler::kClose: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageHandlerValidationInfo[] = {
    { &internal::PageHandler_UpdateViewHeight_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Accept_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Cancel_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::PageHandler_Close_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::signout_confirmation::mojom::PageHandler::Name_,
    kPageHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

Page::IPCStableHashFunction Page::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Page>(message.name())) {
    case messages::Page::kSendSignoutConfirmationData: {
      return &Page::SendSignoutConfirmationData_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Page::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSendSignoutConfirmationData:
            return "Receive signout_confirmation::mojom::Page::SendSignoutConfirmationData";
    }
  } else {
    switch (static_cast<messages::Page>(message.name())) {
      case messages::Page::kSendSignoutConfirmationData:
            return "Receive reply signout_confirmation::mojom::Page::SendSignoutConfirmationData";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Page::SendSignoutConfirmationData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3d09ec70;  // IPCStableHash for signout_confirmation::mojom::Page::SendSignoutConfirmationData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

PageProxy::PageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PageProxy::SendSignoutConfirmationData(
    SignoutConfirmationDataPtr in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send signout_confirmation::mojom::Page::SendSignoutConfirmationData", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("data"), in_data,
                        "<value of type SignoutConfirmationDataPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Page::kSendSignoutConfirmationData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::signout_confirmation::mojom::internal::Page_SendSignoutConfirmationData_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->data)::BaseType> data_fragment(
          params.message());
  
  mojo::internal::Serialize<::signout_confirmation::mojom::SignoutConfirmationDataDataView>(
    in_data,
    data_fragment);

  params->data.Set(
      data_fragment.is_null() ? nullptr : data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null data in Page.SendSignoutConfirmationData request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Page::Name_);
  message.set_method_name("SendSignoutConfirmationData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool PageStubDispatch::Accept(
    Page* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSendSignoutConfirmationData: {
      DCHECK(message->is_serialized());
      internal::Page_SendSignoutConfirmationData_Params_Data* params =
          reinterpret_cast<internal::Page_SendSignoutConfirmationData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for Page.0
      bool success = true;
      SignoutConfirmationDataPtr p_data{};
      Page_SendSignoutConfirmationData_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadData(&p_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Page::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendSignoutConfirmationData(        
        std::move(p_data));
      return true;
    }
  }
  return false;
}

// static
bool PageStubDispatch::AcceptWithResponder(
    Page* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Page>(message->header()->name)) {
    case messages::Page::kSendSignoutConfirmationData: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPageValidationInfo[] = {
    { &internal::Page_SendSignoutConfirmationData_Params_Data::Validate,
     nullptr /* no response */},
};

bool PageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::signout_confirmation::mojom::Page::Name_,
    kPageValidationInfo);
}



}  // signout_confirmation::mojom


namespace mojo {


// static
bool StructTraits<::signout_confirmation::mojom::ExtensionInfo::DataView, ::signout_confirmation::mojom::ExtensionInfoPtr>::Read(
    ::signout_confirmation::mojom::ExtensionInfo::DataView input,
    ::signout_confirmation::mojom::ExtensionInfoPtr* output) {
  bool success = true;
  ::signout_confirmation::mojom::ExtensionInfoPtr result(::signout_confirmation::mojom::ExtensionInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadIconUrl(&result->icon_url))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::signout_confirmation::mojom::SignoutConfirmationData::DataView, ::signout_confirmation::mojom::SignoutConfirmationDataPtr>::Read(
    ::signout_confirmation::mojom::SignoutConfirmationData::DataView input,
    ::signout_confirmation::mojom::SignoutConfirmationDataPtr* output) {
  bool success = true;
  ::signout_confirmation::mojom::SignoutConfirmationDataPtr result(::signout_confirmation::mojom::SignoutConfirmationData::New());
  
      if (success && !input.ReadDialogTitle(&result->dialog_title))
        success = false;
      if (success && !input.ReadDialogSubtitle(&result->dialog_subtitle))
        success = false;
      if (success && !input.ReadAcceptButtonLabel(&result->accept_button_label))
        success = false;
      if (success && !input.ReadCancelButtonLabel(&result->cancel_button_label))
        success = false;
      if (success && !input.ReadAccountExtensions(&result->account_extensions))
        success = false;
      if (success)
        result->has_unsynced_data = input.has_unsynced_data();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace signout_confirmation::mojom {


void PageHandlerFactoryInterceptorForTesting::CreateSignoutConfirmationHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) {
  GetForwardingInterface()->CreateSignoutConfirmationHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
PageHandlerFactoryAsyncWaiter::PageHandlerFactoryAsyncWaiter(
    PageHandlerFactory* proxy) : proxy_(proxy) {}

PageHandlerFactoryAsyncWaiter::~PageHandlerFactoryAsyncWaiter() = default;





void PageHandlerInterceptorForTesting::UpdateViewHeight(uint32_t height) {
  GetForwardingInterface()->UpdateViewHeight(
    std::move(height)
    );
}
void PageHandlerInterceptorForTesting::Accept(bool uninstall_account_extensions) {
  GetForwardingInterface()->Accept(
    std::move(uninstall_account_extensions)
    );
}
void PageHandlerInterceptorForTesting::Cancel(bool uninstall_account_extensions) {
  GetForwardingInterface()->Cancel(
    std::move(uninstall_account_extensions)
    );
}
void PageHandlerInterceptorForTesting::Close() {
  GetForwardingInterface()->Close();
}
PageHandlerAsyncWaiter::PageHandlerAsyncWaiter(
    PageHandler* proxy) : proxy_(proxy) {}

PageHandlerAsyncWaiter::~PageHandlerAsyncWaiter() = default;





void PageInterceptorForTesting::SendSignoutConfirmationData(SignoutConfirmationDataPtr data) {
  GetForwardingInterface()->SendSignoutConfirmationData(
    std::move(data)
    );
}
PageAsyncWaiter::PageAsyncWaiter(
    Page* proxy) : proxy_(proxy) {}

PageAsyncWaiter::~PageAsyncWaiter() = default;







}  // signout_confirmation::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif