// chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIGNIN_BATCH_UPLOAD_BATCH_UPLOAD_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_SIGNIN_BATCH_UPLOAD_BATCH_UPLOAD_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/signin/batch_upload/batch_upload.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace batch_upload::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "batch_upload.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateBatchUploadHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateBatchUploadHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreateBatchUploadHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "batch_upload.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateViewHeightMinVersion = 0,
    kSaveToAccountMinVersion = 0,
    kCloseMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateViewHeight_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveToAccount_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Close_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void UpdateViewHeight(uint32_t height) = 0;

  virtual void SaveToAccount(const std::vector<std::vector<int32_t>>& idsToMove) = 0;

  virtual void Close() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "batch_upload.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSendBatchUploadDataMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SendBatchUploadData_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void SendBatchUploadData(BatchUploadDataPtr data) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateBatchUploadHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateViewHeight(uint32_t height) final;
  
  void SaveToAccount(const std::vector<std::vector<int32_t>>& idsToMove) final;
  
  void Close() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendBatchUploadData(BatchUploadDataPtr data) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  DataItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataItem, T>::value>;
  using DataView = DataItemDataView;
  using Data_ = internal::DataItem_Data;

  template <typename... Args>
  static DataItemPtr New(Args&&... args) {
    return DataItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataItemPtr From(const U& u) {
    return mojo::TypeConverter<DataItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataItem>::Convert(*this);
  }


  DataItem();

  DataItem(
      int32_t id,
      const std::string& icon_url,
      const std::string& title,
      const std::string& subtitle);


  ~DataItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataItemPtr>
  DataItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataItem_UnserializedMessageContext<
            UserType, DataItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataItem_UnserializedMessageContext<
            UserType, DataItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t id;
  
  std::string icon_url;
  
  std::string title;
  
  std::string subtitle;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  BatchUploadAccountInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BatchUploadAccountInfo, T>::value>;
  using DataView = BatchUploadAccountInfoDataView;
  using Data_ = internal::BatchUploadAccountInfo_Data;

  template <typename... Args>
  static BatchUploadAccountInfoPtr New(Args&&... args) {
    return BatchUploadAccountInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BatchUploadAccountInfoPtr From(const U& u) {
    return mojo::TypeConverter<BatchUploadAccountInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BatchUploadAccountInfo>::Convert(*this);
  }


  BatchUploadAccountInfo();

  BatchUploadAccountInfo(
      const std::string& email,
      const std::string& data_picture_url);


  ~BatchUploadAccountInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BatchUploadAccountInfoPtr>
  BatchUploadAccountInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BatchUploadAccountInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BatchUploadAccountInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BatchUploadAccountInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BatchUploadAccountInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BatchUploadAccountInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BatchUploadAccountInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BatchUploadAccountInfo_UnserializedMessageContext<
            UserType, BatchUploadAccountInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BatchUploadAccountInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BatchUploadAccountInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BatchUploadAccountInfo_UnserializedMessageContext<
            UserType, BatchUploadAccountInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BatchUploadAccountInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string email;
  
  std::string data_picture_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BatchUploadAccountInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BatchUploadAccountInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BatchUploadAccountInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BatchUploadAccountInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  DataContainer {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DataContainer, T>::value>;
  using DataView = DataContainerDataView;
  using Data_ = internal::DataContainer_Data;

  template <typename... Args>
  static DataContainerPtr New(Args&&... args) {
    return DataContainerPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataContainerPtr From(const U& u) {
    return mojo::TypeConverter<DataContainerPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DataContainer>::Convert(*this);
  }


  DataContainer();

  DataContainer(
      const std::string& section_title,
      std::vector<DataItemPtr> data_items,
      bool is_theme);

DataContainer(const DataContainer&) = delete;
DataContainer& operator=(const DataContainer&) = delete;

  ~DataContainer();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataContainerPtr>
  DataContainerPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DataContainer::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DataContainer::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DataContainer::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataContainer::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DataContainer::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DataContainer::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DataContainer_UnserializedMessageContext<
            UserType, DataContainer::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DataContainer::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DataContainer::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DataContainer_UnserializedMessageContext<
            UserType, DataContainer::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DataContainer::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string section_title;
  
  std::vector<DataItemPtr> data_items;
  
  bool is_theme;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DataContainer::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DataContainer::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DataContainer::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DataContainer::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  BatchUploadData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BatchUploadData, T>::value>;
  using DataView = BatchUploadDataDataView;
  using Data_ = internal::BatchUploadData_Data;

  template <typename... Args>
  static BatchUploadDataPtr New(Args&&... args) {
    return BatchUploadDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BatchUploadDataPtr From(const U& u) {
    return mojo::TypeConverter<BatchUploadDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BatchUploadData>::Convert(*this);
  }


  BatchUploadData();

  BatchUploadData(
      BatchUploadAccountInfoPtr account_info,
      const std::string& dialog_subtitle,
      std::vector<DataContainerPtr> data_containers);

BatchUploadData(const BatchUploadData&) = delete;
BatchUploadData& operator=(const BatchUploadData&) = delete;

  ~BatchUploadData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BatchUploadDataPtr>
  BatchUploadDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BatchUploadData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BatchUploadData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BatchUploadData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BatchUploadData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BatchUploadData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BatchUploadData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BatchUploadData_UnserializedMessageContext<
            UserType, BatchUploadData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BatchUploadData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BatchUploadData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BatchUploadData_UnserializedMessageContext<
            UserType, BatchUploadData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BatchUploadData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  BatchUploadAccountInfoPtr account_info;
  
  std::string dialog_subtitle;
  
  std::vector<DataContainerPtr> data_containers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BatchUploadData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BatchUploadData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BatchUploadData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BatchUploadData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DataItemPtr DataItem::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(icon_url),
      mojo::Clone(title),
      mojo::Clone(subtitle)
  );
}

template <typename T, DataItem::EnableIfSame<T>*>
bool DataItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->icon_url, other_struct.icon_url))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->subtitle, other_struct.subtitle))
    return false;
  return true;
}

template <typename T, DataItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.icon_url < rhs.icon_url)
    return true;
  if (rhs.icon_url < lhs.icon_url)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.subtitle < rhs.subtitle)
    return true;
  if (rhs.subtitle < lhs.subtitle)
    return false;
  return false;
}
template <typename StructPtrType>
DataContainerPtr DataContainer::Clone() const {
  return New(
      mojo::Clone(section_title),
      mojo::Clone(data_items),
      mojo::Clone(is_theme)
  );
}

template <typename T, DataContainer::EnableIfSame<T>*>
bool DataContainer::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->section_title, other_struct.section_title))
    return false;
  if (!mojo::Equals(this->data_items, other_struct.data_items))
    return false;
  if (!mojo::Equals(this->is_theme, other_struct.is_theme))
    return false;
  return true;
}

template <typename T, DataContainer::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.section_title < rhs.section_title)
    return true;
  if (rhs.section_title < lhs.section_title)
    return false;
  if (lhs.data_items < rhs.data_items)
    return true;
  if (rhs.data_items < lhs.data_items)
    return false;
  if (lhs.is_theme < rhs.is_theme)
    return true;
  if (rhs.is_theme < lhs.is_theme)
    return false;
  return false;
}
template <typename StructPtrType>
BatchUploadAccountInfoPtr BatchUploadAccountInfo::Clone() const {
  return New(
      mojo::Clone(email),
      mojo::Clone(data_picture_url)
  );
}

template <typename T, BatchUploadAccountInfo::EnableIfSame<T>*>
bool BatchUploadAccountInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->email, other_struct.email))
    return false;
  if (!mojo::Equals(this->data_picture_url, other_struct.data_picture_url))
    return false;
  return true;
}

template <typename T, BatchUploadAccountInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.email < rhs.email)
    return true;
  if (rhs.email < lhs.email)
    return false;
  if (lhs.data_picture_url < rhs.data_picture_url)
    return true;
  if (rhs.data_picture_url < lhs.data_picture_url)
    return false;
  return false;
}
template <typename StructPtrType>
BatchUploadDataPtr BatchUploadData::Clone() const {
  return New(
      mojo::Clone(account_info),
      mojo::Clone(dialog_subtitle),
      mojo::Clone(data_containers)
  );
}

template <typename T, BatchUploadData::EnableIfSame<T>*>
bool BatchUploadData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->account_info, other_struct.account_info))
    return false;
  if (!mojo::Equals(this->dialog_subtitle, other_struct.dialog_subtitle))
    return false;
  if (!mojo::Equals(this->data_containers, other_struct.data_containers))
    return false;
  return true;
}

template <typename T, BatchUploadData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.account_info < rhs.account_info)
    return true;
  if (rhs.account_info < lhs.account_info)
    return false;
  if (lhs.dialog_subtitle < rhs.dialog_subtitle)
    return true;
  if (rhs.dialog_subtitle < lhs.dialog_subtitle)
    return false;
  if (lhs.data_containers < rhs.data_containers)
    return true;
  if (rhs.data_containers < lhs.data_containers)
    return false;
  return false;
}


}  // batch_upload::mojom

namespace mojo {


template <>
struct  StructTraits<::batch_upload::mojom::DataItem::DataView,
                                         ::batch_upload::mojom::DataItemPtr> {
  static bool IsNull(const ::batch_upload::mojom::DataItemPtr& input) { return !input; }
  static void SetToNull(::batch_upload::mojom::DataItemPtr* output) { output->reset(); }

  static decltype(::batch_upload::mojom::DataItem::id) id(
      const ::batch_upload::mojom::DataItemPtr& input) {
    return input->id;
  }

  static const decltype(::batch_upload::mojom::DataItem::icon_url)& icon_url(
      const ::batch_upload::mojom::DataItemPtr& input) {
    return input->icon_url;
  }

  static const decltype(::batch_upload::mojom::DataItem::title)& title(
      const ::batch_upload::mojom::DataItemPtr& input) {
    return input->title;
  }

  static const decltype(::batch_upload::mojom::DataItem::subtitle)& subtitle(
      const ::batch_upload::mojom::DataItemPtr& input) {
    return input->subtitle;
  }

  static bool Read(::batch_upload::mojom::DataItem::DataView input, ::batch_upload::mojom::DataItemPtr* output);
};


template <>
struct  StructTraits<::batch_upload::mojom::DataContainer::DataView,
                                         ::batch_upload::mojom::DataContainerPtr> {
  static bool IsNull(const ::batch_upload::mojom::DataContainerPtr& input) { return !input; }
  static void SetToNull(::batch_upload::mojom::DataContainerPtr* output) { output->reset(); }

  static const decltype(::batch_upload::mojom::DataContainer::section_title)& section_title(
      const ::batch_upload::mojom::DataContainerPtr& input) {
    return input->section_title;
  }

  static const decltype(::batch_upload::mojom::DataContainer::data_items)& data_items(
      const ::batch_upload::mojom::DataContainerPtr& input) {
    return input->data_items;
  }

  static decltype(::batch_upload::mojom::DataContainer::is_theme) is_theme(
      const ::batch_upload::mojom::DataContainerPtr& input) {
    return input->is_theme;
  }

  static bool Read(::batch_upload::mojom::DataContainer::DataView input, ::batch_upload::mojom::DataContainerPtr* output);
};


template <>
struct  StructTraits<::batch_upload::mojom::BatchUploadAccountInfo::DataView,
                                         ::batch_upload::mojom::BatchUploadAccountInfoPtr> {
  static bool IsNull(const ::batch_upload::mojom::BatchUploadAccountInfoPtr& input) { return !input; }
  static void SetToNull(::batch_upload::mojom::BatchUploadAccountInfoPtr* output) { output->reset(); }

  static const decltype(::batch_upload::mojom::BatchUploadAccountInfo::email)& email(
      const ::batch_upload::mojom::BatchUploadAccountInfoPtr& input) {
    return input->email;
  }

  static const decltype(::batch_upload::mojom::BatchUploadAccountInfo::data_picture_url)& data_picture_url(
      const ::batch_upload::mojom::BatchUploadAccountInfoPtr& input) {
    return input->data_picture_url;
  }

  static bool Read(::batch_upload::mojom::BatchUploadAccountInfo::DataView input, ::batch_upload::mojom::BatchUploadAccountInfoPtr* output);
};


template <>
struct  StructTraits<::batch_upload::mojom::BatchUploadData::DataView,
                                         ::batch_upload::mojom::BatchUploadDataPtr> {
  static bool IsNull(const ::batch_upload::mojom::BatchUploadDataPtr& input) { return !input; }
  static void SetToNull(::batch_upload::mojom::BatchUploadDataPtr* output) { output->reset(); }

  static const decltype(::batch_upload::mojom::BatchUploadData::account_info)& account_info(
      const ::batch_upload::mojom::BatchUploadDataPtr& input) {
    return input->account_info;
  }

  static const decltype(::batch_upload::mojom::BatchUploadData::dialog_subtitle)& dialog_subtitle(
      const ::batch_upload::mojom::BatchUploadDataPtr& input) {
    return input->dialog_subtitle;
  }

  static const decltype(::batch_upload::mojom::BatchUploadData::data_containers)& data_containers(
      const ::batch_upload::mojom::BatchUploadDataPtr& input) {
    return input->data_containers;
  }

  static bool Read(::batch_upload::mojom::BatchUploadData::DataView input, ::batch_upload::mojom::BatchUploadDataPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_SIGNIN_BATCH_UPLOAD_BATCH_UPLOAD_MOJOM_H_