// chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/side_panel/customize_chrome/customize_chrome.mojom-params-data.h"
namespace side_panel {
namespace mojom {

NOINLINE static const char* CustomizeChromeSectionToStringHelper(CustomizeChromeSection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CustomizeChromeSection::kAppearance:
      return "kAppearance";
    case CustomizeChromeSection::kShortcuts:
      return "kShortcuts";
    case CustomizeChromeSection::kModules:
      return "kModules";
    case CustomizeChromeSection::kWallpaperSearch:
      return "kWallpaperSearch";
    case CustomizeChromeSection::kToolbar:
      return "kToolbar";
    case CustomizeChromeSection::kFooter:
      return "kFooter";
    default:
      return nullptr;
  }
}

std::string CustomizeChromeSectionToString(CustomizeChromeSection value) {
  const char *str = CustomizeChromeSectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CustomizeChromeSection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CustomizeChromeSection value) {
  return os << CustomizeChromeSectionToString(value);
}

NOINLINE static const char* ChromeWebStoreCollectionToStringHelper(ChromeWebStoreCollection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ChromeWebStoreCollection::kWritingEssentials:
      return "kWritingEssentials";
    default:
      return nullptr;
  }
}

std::string ChromeWebStoreCollectionToString(ChromeWebStoreCollection value) {
  const char *str = ChromeWebStoreCollectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ChromeWebStoreCollection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ChromeWebStoreCollection value) {
  return os << ChromeWebStoreCollectionToString(value);
}

NOINLINE static const char* ChromeWebStoreCategoryToStringHelper(ChromeWebStoreCategory value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ChromeWebStoreCategory::kWorkflowPlanning:
      return "kWorkflowPlanning";
    case ChromeWebStoreCategory::kShopping:
      return "kShopping";
    default:
      return nullptr;
  }
}

std::string ChromeWebStoreCategoryToString(ChromeWebStoreCategory value) {
  const char *str = ChromeWebStoreCategoryToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ChromeWebStoreCategory value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ChromeWebStoreCategory value) {
  return os << ChromeWebStoreCategoryToString(value);
}

NOINLINE static const char* NewTabPageTypeToStringHelper(NewTabPageType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NewTabPageType::kFirstPartyWebUI:
      return "kFirstPartyWebUI";
    case NewTabPageType::kThirdPartyWebUI:
      return "kThirdPartyWebUI";
    case NewTabPageType::kThirdPartyRemote:
      return "kThirdPartyRemote";
    case NewTabPageType::kExtension:
      return "kExtension";
    case NewTabPageType::kIncognito:
      return "kIncognito";
    case NewTabPageType::kGuestMode:
      return "kGuestMode";
    case NewTabPageType::kNone:
      return "kNone";
    default:
      return nullptr;
  }
}

std::string NewTabPageTypeToString(NewTabPageType value) {
  const char *str = NewTabPageTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NewTabPageType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NewTabPageType value) {
  return os << NewTabPageTypeToString(value);
}

namespace internal {


// static
bool BackgroundImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundImage_Data* object =
      static_cast<const BackgroundImage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->snapshot_url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->snapshot_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->local_background_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->collection_id, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& collection_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->collection_id, validation_context,
                                         &collection_id_validate_params)) {
    return false;
  }

  return true;
}

BackgroundImage_Data::BackgroundImage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ThirdPartyThemeInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ThirdPartyThemeInfo_Data* object =
      static_cast<const ThirdPartyThemeInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  return true;
}

ThirdPartyThemeInfo_Data::ThirdPartyThemeInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Theme_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Theme_Data* object =
      static_cast<const Theme_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->background_image, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->third_party_theme_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->background_color, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->background_color, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->foreground_color, validation_context))
    return false;

  return true;
}

Theme_Data::Theme_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BackgroundCollection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BackgroundCollection_Data* object =
      static_cast<const BackgroundCollection_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->label, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->label, validation_context,
                                         &label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->preview_image_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->preview_image_url, validation_context))
    return false;

  return true;
}

BackgroundCollection_Data::BackgroundCollection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CollectionImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CollectionImage_Data* object =
      static_cast<const CollectionImage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution_1, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attribution_1_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attribution_1, validation_context,
                                         &attribution_1_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution_2, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attribution_2_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attribution_2, validation_context,
                                         &attribution_2_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->attribution_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->preview_image_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->preview_image_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->collection_id, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& collection_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->collection_id, validation_context,
                                         &collection_id_validate_params)) {
    return false;
  }

  return true;
}

CollectionImage_Data::CollectionImage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ModuleSettings_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ModuleSettings_Data* object =
      static_cast<const ModuleSettings_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  return true;
}

ModuleSettings_Data::ModuleSettings_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ManagementNoticeState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ManagementNoticeState_Data* object =
      static_cast<const ManagementNoticeState_Data*>(data);

  return true;
}

ManagementNoticeState_Data::ManagementNoticeState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandlerFactory_CreatePageHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandlerFactory_CreatePageHandler_Params_Data* object =
      static_cast<const CustomizeChromePageHandlerFactory_CreatePageHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CustomizeChromePageHandlerFactory_CreatePageHandler_Params_Data::CustomizeChromePageHandlerFactory_CreatePageHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_SetMostVisitedSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_SetMostVisitedSettings_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_SetMostVisitedSettings_Params_Data*>(data);


  if (!::ntp_tiles::mojom::internal::TileType_Data
        ::Validate(object->shortcuts_type, validation_context))
    return false;

  return true;
}

CustomizeChromePageHandler_SetMostVisitedSettings_Params_Data::CustomizeChromePageHandler_SetMostVisitedSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_UpdateMostVisitedSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_UpdateMostVisitedSettings_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_UpdateMostVisitedSettings_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_UpdateMostVisitedSettings_Params_Data::CustomizeChromePageHandler_UpdateMostVisitedSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_GetBackgroundCollections_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_GetBackgroundCollections_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_GetBackgroundCollections_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_GetBackgroundCollections_Params_Data::CustomizeChromePageHandler_GetBackgroundCollections_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams_Data* object =
      static_cast<const CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->collections, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& collections_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->collections, validation_context,
                                         &collections_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams_Data::CustomizeChromePageHandler_GetBackgroundCollections_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->collection_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& collection_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->collection_id, validation_context,
                                         &collection_id_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params_Data::CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams_Data* object =
      static_cast<const CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->preview_image_url, validation_context))
    return false;

  return true;
}

CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams_Data::CustomizeChromePageHandler_GetReplacementCollectionPreviewImage_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_GetBackgroundImages_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_GetBackgroundImages_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_GetBackgroundImages_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->collection_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& collection_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->collection_id, validation_context,
                                         &collection_id_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePageHandler_GetBackgroundImages_Params_Data::CustomizeChromePageHandler_GetBackgroundImages_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_GetBackgroundImages_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_GetBackgroundImages_ResponseParams_Data* object =
      static_cast<const CustomizeChromePageHandler_GetBackgroundImages_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->images, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& images_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->images, validation_context,
                                         &images_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePageHandler_GetBackgroundImages_ResponseParams_Data::CustomizeChromePageHandler_GetBackgroundImages_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_UpdateModulesSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_UpdateModulesSettings_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_UpdateModulesSettings_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_UpdateModulesSettings_Params_Data::CustomizeChromePageHandler_UpdateModulesSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_UpdateTheme_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_UpdateTheme_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_UpdateTheme_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_UpdateTheme_Params_Data::CustomizeChromePageHandler_UpdateTheme_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_UpdateThemeEditable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_UpdateThemeEditable_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_UpdateThemeEditable_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_UpdateThemeEditable_Params_Data::CustomizeChromePageHandler_UpdateThemeEditable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_SetDefaultColor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_SetDefaultColor_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_SetDefaultColor_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_SetDefaultColor_Params_Data::CustomizeChromePageHandler_SetDefaultColor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_SetFollowDeviceTheme_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_SetFollowDeviceTheme_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_SetFollowDeviceTheme_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_SetFollowDeviceTheme_Params_Data::CustomizeChromePageHandler_SetFollowDeviceTheme_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_RemoveBackgroundImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_RemoveBackgroundImage_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_RemoveBackgroundImage_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_RemoveBackgroundImage_Params_Data::CustomizeChromePageHandler_RemoveBackgroundImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_ChooseLocalCustomBackground_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_ChooseLocalCustomBackground_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_ChooseLocalCustomBackground_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_ChooseLocalCustomBackground_Params_Data::CustomizeChromePageHandler_ChooseLocalCustomBackground_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams_Data* object =
      static_cast<const CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams_Data*>(data);

  return true;
}

CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams_Data::CustomizeChromePageHandler_ChooseLocalCustomBackground_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_SetBackgroundImage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_SetBackgroundImage_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_SetBackgroundImage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution_1, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attribution_1_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attribution_1, validation_context,
                                         &attribution_1_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution_2, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& attribution_2_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->attribution_2, validation_context,
                                         &attribution_2_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->attribution_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->attribution_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->image_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->image_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->thumbnail_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->thumbnail_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->collection_id, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& collection_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->collection_id, validation_context,
                                         &collection_id_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePageHandler_SetBackgroundImage_Params_Data::CustomizeChromePageHandler_SetBackgroundImage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->collection_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& collection_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->collection_id, validation_context,
                                         &collection_id_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params_Data::CustomizeChromePageHandler_SetDailyRefreshCollectionId_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_OpenChromeWebStore_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_OpenChromeWebStore_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_OpenChromeWebStore_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_OpenChromeWebStore_Params_Data::CustomizeChromePageHandler_OpenChromeWebStore_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params_Data::CustomizeChromePageHandler_OpenChromeWebStoreHomePage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_OpenThirdPartyThemePage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_OpenThirdPartyThemePage_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_OpenThirdPartyThemePage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->theme_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& theme_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->theme_id, validation_context,
                                         &theme_id_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePageHandler_OpenThirdPartyThemePage_Params_Data::CustomizeChromePageHandler_OpenThirdPartyThemePage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params_Data*>(data);


  if (!::side_panel::mojom::internal::ChromeWebStoreCategory_Data
        ::Validate(object->category, validation_context))
    return false;

  return true;
}

CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params_Data::CustomizeChromePageHandler_OpenChromeWebStoreCategoryPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params_Data*>(data);


  if (!::side_panel::mojom::internal::ChromeWebStoreCollection_Data
        ::Validate(object->collection, validation_context))
    return false;

  return true;
}

CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params_Data::CustomizeChromePageHandler_OpenChromeWebStoreCollectionPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_OpenNtpManagedByPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_OpenNtpManagedByPage_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_OpenNtpManagedByPage_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_OpenNtpManagedByPage_Params_Data::CustomizeChromePageHandler_OpenNtpManagedByPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_SetModulesVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_SetModulesVisible_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_SetModulesVisible_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_SetModulesVisible_Params_Data::CustomizeChromePageHandler_SetModulesVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_SetModuleDisabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_SetModuleDisabled_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_SetModuleDisabled_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->module_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& module_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->module_id, validation_context,
                                         &module_id_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePageHandler_SetModuleDisabled_Params_Data::CustomizeChromePageHandler_SetModuleDisabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_UpdateScrollToSection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_UpdateScrollToSection_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_UpdateScrollToSection_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_UpdateScrollToSection_Params_Data::CustomizeChromePageHandler_UpdateScrollToSection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_UpdateAttachedTabState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_UpdateAttachedTabState_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_UpdateAttachedTabState_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_UpdateAttachedTabState_Params_Data::CustomizeChromePageHandler_UpdateAttachedTabState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_UpdateNtpManagedByName_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_UpdateNtpManagedByName_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_UpdateNtpManagedByName_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_UpdateNtpManagedByName_Params_Data::CustomizeChromePageHandler_UpdateNtpManagedByName_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_SetFooterVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_SetFooterVisible_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_SetFooterVisible_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_SetFooterVisible_Params_Data::CustomizeChromePageHandler_SetFooterVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePageHandler_UpdateFooterSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePageHandler_UpdateFooterSettings_Params_Data* object =
      static_cast<const CustomizeChromePageHandler_UpdateFooterSettings_Params_Data*>(data);

  return true;
}

CustomizeChromePageHandler_UpdateFooterSettings_Params_Data::CustomizeChromePageHandler_UpdateFooterSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePage_SetModulesSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePage_SetModulesSettings_Params_Data* object =
      static_cast<const CustomizeChromePage_SetModulesSettings_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->modules_settings, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& modules_settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->modules_settings, validation_context,
                                         &modules_settings_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePage_SetModulesSettings_Params_Data::CustomizeChromePage_SetModulesSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePage_SetMostVisitedSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePage_SetMostVisitedSettings_Params_Data* object =
      static_cast<const CustomizeChromePage_SetMostVisitedSettings_Params_Data*>(data);


  if (!::ntp_tiles::mojom::internal::TileType_Data
        ::Validate(object->shortcuts_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->disabled_shortcuts, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& disabled_shortcuts_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::ntp_tiles::mojom::internal::TileType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->disabled_shortcuts, validation_context,
                                         &disabled_shortcuts_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePage_SetMostVisitedSettings_Params_Data::CustomizeChromePage_SetMostVisitedSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePage_SetFooterSettings_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePage_SetFooterSettings_Params_Data* object =
      static_cast<const CustomizeChromePage_SetFooterSettings_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->management_notice_state, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->management_notice_state, validation_context))
    return false;

  return true;
}

CustomizeChromePage_SetFooterSettings_Params_Data::CustomizeChromePage_SetFooterSettings_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePage_SetTheme_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePage_SetTheme_Params_Data* object =
      static_cast<const CustomizeChromePage_SetTheme_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->theme, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->theme, validation_context))
    return false;

  return true;
}

CustomizeChromePage_SetTheme_Params_Data::CustomizeChromePage_SetTheme_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePage_SetThemeEditable_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePage_SetThemeEditable_Params_Data* object =
      static_cast<const CustomizeChromePage_SetThemeEditable_Params_Data*>(data);

  return true;
}

CustomizeChromePage_SetThemeEditable_Params_Data::CustomizeChromePage_SetThemeEditable_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePage_ScrollToSection_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePage_ScrollToSection_Params_Data* object =
      static_cast<const CustomizeChromePage_ScrollToSection_Params_Data*>(data);


  if (!::side_panel::mojom::internal::CustomizeChromeSection_Data
        ::Validate(object->section, validation_context))
    return false;

  return true;
}

CustomizeChromePage_ScrollToSection_Params_Data::CustomizeChromePage_ScrollToSection_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePage_AttachedTabStateUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePage_AttachedTabStateUpdated_Params_Data* object =
      static_cast<const CustomizeChromePage_AttachedTabStateUpdated_Params_Data*>(data);


  if (!::side_panel::mojom::internal::NewTabPageType_Data
        ::Validate(object->ntp_type, validation_context))
    return false;

  return true;
}

CustomizeChromePage_AttachedTabStateUpdated_Params_Data::CustomizeChromePage_AttachedTabStateUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeChromePage_NtpManagedByNameUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeChromePage_NtpManagedByNameUpdated_Params_Data* object =
      static_cast<const CustomizeChromePage_NtpManagedByNameUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }

  return true;
}

CustomizeChromePage_NtpManagedByNameUpdated_Params_Data::CustomizeChromePage_NtpManagedByNameUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace side_panel

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::mojom::CustomizeChromeSection>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::mojom::CustomizeChromeSection value) {
  return std::move(context).WriteString(::side_panel::mojom::CustomizeChromeSectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::mojom::ChromeWebStoreCollection>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::mojom::ChromeWebStoreCollection value) {
  return std::move(context).WriteString(::side_panel::mojom::ChromeWebStoreCollectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::mojom::ChromeWebStoreCategory>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::mojom::ChromeWebStoreCategory value) {
  return std::move(context).WriteString(::side_panel::mojom::ChromeWebStoreCategoryToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::side_panel::mojom::NewTabPageType>::WriteIntoTrace(
   perfetto::TracedValue context, ::side_panel::mojom::NewTabPageType value) {
  return std::move(context).WriteString(::side_panel::mojom::NewTabPageTypeToString(value));
}

} // namespace perfetto