// chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_TEST_UTILS_H_
#define CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_TEST_UTILS_H_

#include "chrome/browser/ui/webui/side_panel/bookmarks/bookmarks.mojom.h"


namespace side_panel::mojom {


class  BookmarksPageHandlerFactoryInterceptorForTesting : public BookmarksPageHandlerFactory {
  virtual BookmarksPageHandlerFactory* GetForwardingInterface() = 0;
  void CreateBookmarksPageHandler(::mojo::PendingRemote<BookmarksPage> page, ::mojo::PendingReceiver<BookmarksPageHandler> handler) override;
};
class  BookmarksPageHandlerFactoryAsyncWaiter {
 public:
  explicit BookmarksPageHandlerFactoryAsyncWaiter(BookmarksPageHandlerFactory* proxy);

  BookmarksPageHandlerFactoryAsyncWaiter(const BookmarksPageHandlerFactoryAsyncWaiter&) = delete;
  BookmarksPageHandlerFactoryAsyncWaiter& operator=(const BookmarksPageHandlerFactoryAsyncWaiter&) = delete;

  ~BookmarksPageHandlerFactoryAsyncWaiter();

 private:
  BookmarksPageHandlerFactory* const proxy_;
};


class  BookmarksPageHandlerInterceptorForTesting : public BookmarksPageHandler {
  virtual BookmarksPageHandler* GetForwardingInterface() = 0;
  void BookmarkCurrentTabInFolder(const std::string& folder_id) override;
  void CreateFolder(const std::string& folder_id, const std::string& title, CreateFolderCallback callback) override;
  void DropBookmarks(const std::string& folder_id, DropBookmarksCallback callback) override;
  void ExecuteEditCommand(const std::vector<int64_t>& node_ids, ActionSource source) override;
  void ExecuteMoveCommand(const std::vector<int64_t>& node_ids, ActionSource source) override;
  void ExecuteOpenInNewTabCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) override;
  void ExecuteOpenInNewWindowCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) override;
  void ExecuteOpenInIncognitoWindowCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) override;
  void ExecuteOpenInNewTabGroupCommand(const std::vector<std::string>& side_panel_ids, ActionSource source) override;
  void ExecuteOpenInSplitViewCommand(const std::vector<int64_t>& node_ids, ActionSource source) override;
  void ExecuteAddToBookmarksBarCommand(int64_t node_id, ActionSource source) override;
  void ExecuteRemoveFromBookmarksBarCommand(int64_t node_id, ActionSource source) override;
  void ExecuteDeleteCommand(const std::vector<int64_t>& node_ids, ActionSource source) override;
  void OpenBookmark(int64_t node_id, int32_t parent_folder_depth, ::ui::mojom::ClickModifiersPtr click_modifiers, ActionSource source) override;
  void Undo() override;
  void RenameBookmark(int64_t node_id, const std::string& new_title) override;
  void MoveBookmark(int64_t node_id, const std::string& folder_id) override;
  void RemoveBookmarks(const std::vector<int64_t>& node_ids, RemoveBookmarksCallback callback) override;
  void SetSortOrder(SortOrder sort_order) override;
  void SetViewType(ViewType view_type) override;
  void ShowContextMenu(const std::string& id, const ::gfx::Point& point, ActionSource source) override;
  void ShowUI() override;
  void GetAllBookmarks(GetAllBookmarksCallback callback) override;
};
class  BookmarksPageHandlerAsyncWaiter {
 public:
  explicit BookmarksPageHandlerAsyncWaiter(BookmarksPageHandler* proxy);

  BookmarksPageHandlerAsyncWaiter(const BookmarksPageHandlerAsyncWaiter&) = delete;
  BookmarksPageHandlerAsyncWaiter& operator=(const BookmarksPageHandlerAsyncWaiter&) = delete;

  ~BookmarksPageHandlerAsyncWaiter();
  void CreateFolder(
      const std::string& folder_id, const std::string& title, std::string* out_new_folder_id);
  std::string CreateFolder(const std::string& folder_id, const std::string& title);
  void DropBookmarks(
      const std::string& folder_id);
  
  void RemoveBookmarks(
      const std::vector<int64_t>& node_ids);
  
  void GetAllBookmarks(
      std::vector<BookmarksTreeNodePtr>* out_nodes);
  std::vector<BookmarksTreeNodePtr> GetAllBookmarks();

 private:
  BookmarksPageHandler* const proxy_;
};


class  BookmarksPageInterceptorForTesting : public BookmarksPage {
  virtual BookmarksPage* GetForwardingInterface() = 0;
  void OnBookmarkNodeAdded(BookmarksTreeNodePtr node) override;
  void OnBookmarkNodesRemoved(const std::vector<std::string>& node_ids) override;
  void OnBookmarkParentFolderChildrenReordered(const std::string& folder_id, const std::vector<std::string>& children_ordered_ids) override;
  void OnBookmarkNodeMoved(const std::string& old_parent_index, uint32_t old_node_index, const std::string& new_parent_index, uint32_t new_node_index) override;
  void OnBookmarkNodeChanged(const std::string& id, const std::string& new_title, const std::string& new_url) override;
};
class  BookmarksPageAsyncWaiter {
 public:
  explicit BookmarksPageAsyncWaiter(BookmarksPage* proxy);

  BookmarksPageAsyncWaiter(const BookmarksPageAsyncWaiter&) = delete;
  BookmarksPageAsyncWaiter& operator=(const BookmarksPageAsyncWaiter&) = delete;

  ~BookmarksPageAsyncWaiter();

 private:
  BookmarksPage* const proxy_;
};




}  // side_panel::mojom

#endif  // CHROME_BROWSER_UI_WEBUI_SIDE_PANEL_BOOKMARKS_BOOKMARKS_MOJOM_TEST_UTILS_H_