// chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_RELATED_WEBSITE_SETS_RELATED_WEBSITE_SETS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_RELATED_WEBSITE_SETS_RELATED_WEBSITE_SETS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace related_website_sets::mojom {

class RelatedWebsiteSetsPageHandlerProxy;

template <typename ImplRefTraits>
class RelatedWebsiteSetsPageHandlerStub;

class RelatedWebsiteSetsPageHandlerRequestValidator;
class RelatedWebsiteSetsPageHandlerResponseValidator;


class RelatedWebsiteSetsPageHandler
    : public RelatedWebsiteSetsPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "related_website_sets.mojom.RelatedWebsiteSetsPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RelatedWebsiteSetsPageHandlerInterfaceBase;
  using Proxy_ = RelatedWebsiteSetsPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = RelatedWebsiteSetsPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = RelatedWebsiteSetsPageHandlerRequestValidator;
  using ResponseValidator_ = RelatedWebsiteSetsPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetRelatedWebsiteSetsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetRelatedWebsiteSets_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RelatedWebsiteSetsPageHandler() = default;

  using GetRelatedWebsiteSetsCallback = base::OnceCallback<void(GetRelatedWebsiteSetsResponsePtr)>;
  using GetRelatedWebsiteSetsMojoCallback = base::OnceCallback<void(GetRelatedWebsiteSetsResponsePtr)>;

  virtual void GetRelatedWebsiteSets(GetRelatedWebsiteSetsCallback callback) = 0;
};



class  RelatedWebsiteSetsPageHandlerProxy
    : public RelatedWebsiteSetsPageHandler {
 public:
  using InterfaceType = RelatedWebsiteSetsPageHandler;

  explicit RelatedWebsiteSetsPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetRelatedWebsiteSets(GetRelatedWebsiteSetsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RelatedWebsiteSetsPageHandlerStubDispatch {
 public:
  static bool Accept(RelatedWebsiteSetsPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RelatedWebsiteSetsPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RelatedWebsiteSetsPageHandler>>
class RelatedWebsiteSetsPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RelatedWebsiteSetsPageHandlerStub() = default;
  ~RelatedWebsiteSetsPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RelatedWebsiteSetsPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RelatedWebsiteSetsPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RelatedWebsiteSetsPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RelatedWebsiteSetsPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  Member {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Member, T>::value>;
  using DataView = MemberDataView;
  using Data_ = internal::Member_Data;

  template <typename... Args>
  static MemberPtr New(Args&&... args) {
    return MemberPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MemberPtr From(const U& u) {
    return mojo::TypeConverter<MemberPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Member>::Convert(*this);
  }


  Member();

  Member(
      const std::string& site,
      SiteType type);


  ~Member();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MemberPtr>
  MemberPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Member::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Member::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Member::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Member::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Member::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Member::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Member_UnserializedMessageContext<
            UserType, Member::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Member::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Member::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Member_UnserializedMessageContext<
            UserType, Member::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Member::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string site;
  
  SiteType type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Member::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Member::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Member::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Member::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  GetRelatedWebsiteSetsResponse {
 public:
  using DataView = GetRelatedWebsiteSetsResponseDataView;
  using Data_ = internal::GetRelatedWebsiteSetsResponse_Data;
  using Tag = Data_::GetRelatedWebsiteSetsResponse_Tag;

  template <typename... Args>
  static GetRelatedWebsiteSetsResponsePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |related_website_sets|.
  static GetRelatedWebsiteSetsResponsePtr NewRelatedWebsiteSets(
      std::vector<RelatedWebsiteSetPtr> value);
  // Construct an instance holding |error_message|.
  static GetRelatedWebsiteSetsResponsePtr NewErrorMessage(
      const std::string& value);

  template <typename U>
  static GetRelatedWebsiteSetsResponsePtr From(const U& u) {
    return mojo::TypeConverter<GetRelatedWebsiteSetsResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GetRelatedWebsiteSetsResponse>::Convert(*this);
  }
  ~GetRelatedWebsiteSetsResponse();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  GetRelatedWebsiteSetsResponse(const GetRelatedWebsiteSetsResponse& other) = delete;
  GetRelatedWebsiteSetsResponse& operator=(const GetRelatedWebsiteSetsResponse& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = GetRelatedWebsiteSetsResponsePtr>
  GetRelatedWebsiteSetsResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetRelatedWebsiteSetsResponse>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, GetRelatedWebsiteSetsResponse>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_related_website_sets() const { return tag_ == Tag::kRelatedWebsiteSets; }
  const std::vector<RelatedWebsiteSetPtr>& get_related_website_sets() const {
    CHECK(tag_ == Tag::kRelatedWebsiteSets);
    return data_.related_website_sets;
  }
  std::vector<RelatedWebsiteSetPtr>& get_related_website_sets() {
    CHECK(tag_ == Tag::kRelatedWebsiteSets);
    return data_.related_website_sets;
  }
  void set_related_website_sets(std::vector<RelatedWebsiteSetPtr> related_website_sets);

  bool is_error_message() const { return tag_ == Tag::kErrorMessage; }
  const std::string& get_error_message() const {
    CHECK(tag_ == Tag::kErrorMessage);
    return data_.error_message;
  }
  std::string& get_error_message() {
    CHECK(tag_ == Tag::kErrorMessage);
    return data_.error_message;
  }
  void set_error_message(const std::string& error_message);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GetRelatedWebsiteSetsResponse::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<GetRelatedWebsiteSetsResponse::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kRelatedWebsiteSets)>,
        std::vector<RelatedWebsiteSetPtr> value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    std::vector<RelatedWebsiteSetPtr> related_website_sets;
    std::string error_message;
  };

  GetRelatedWebsiteSetsResponse(
      std::in_place_index_t<static_cast<size_t>(Tag::kRelatedWebsiteSets)>,
      std::vector<RelatedWebsiteSetPtr> value);
  GetRelatedWebsiteSetsResponse(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  RelatedWebsiteSet {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RelatedWebsiteSet, T>::value>;
  using DataView = RelatedWebsiteSetDataView;
  using Data_ = internal::RelatedWebsiteSet_Data;

  template <typename... Args>
  static RelatedWebsiteSetPtr New(Args&&... args) {
    return RelatedWebsiteSetPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RelatedWebsiteSetPtr From(const U& u) {
    return mojo::TypeConverter<RelatedWebsiteSetPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RelatedWebsiteSet>::Convert(*this);
  }


  RelatedWebsiteSet();

  RelatedWebsiteSet(
      const std::string& primary_site,
      std::vector<MemberPtr> member_sites,
      bool managed_by_enterprise);

RelatedWebsiteSet(const RelatedWebsiteSet&) = delete;
RelatedWebsiteSet& operator=(const RelatedWebsiteSet&) = delete;

  ~RelatedWebsiteSet();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RelatedWebsiteSetPtr>
  RelatedWebsiteSetPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RelatedWebsiteSet::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RelatedWebsiteSet::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RelatedWebsiteSet::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RelatedWebsiteSet::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RelatedWebsiteSet::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RelatedWebsiteSet::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RelatedWebsiteSet_UnserializedMessageContext<
            UserType, RelatedWebsiteSet::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RelatedWebsiteSet::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RelatedWebsiteSet::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RelatedWebsiteSet_UnserializedMessageContext<
            UserType, RelatedWebsiteSet::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RelatedWebsiteSet::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string primary_site;
  
  std::vector<MemberPtr> member_sites;
  
  bool managed_by_enterprise;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RelatedWebsiteSet::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RelatedWebsiteSet::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RelatedWebsiteSet::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RelatedWebsiteSet::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
GetRelatedWebsiteSetsResponsePtr GetRelatedWebsiteSetsResponse::Clone() const {
  switch (tag_) {
    case Tag::kRelatedWebsiteSets:
      return NewRelatedWebsiteSets(
          mojo::Clone(data_.related_website_sets));
    case Tag::kErrorMessage:
      return NewErrorMessage(
          mojo::Clone(data_.error_message));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, GetRelatedWebsiteSetsResponse>::value>::type*>
bool GetRelatedWebsiteSetsResponse::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kRelatedWebsiteSets:
      return mojo::Equals(data_.related_website_sets, other.data_.related_website_sets);
    case Tag::kErrorMessage:
      return mojo::Equals(data_.error_message, other.data_.error_message);
  }

  return false;
}
template <typename StructPtrType>
MemberPtr Member::Clone() const {
  return New(
      mojo::Clone(site),
      mojo::Clone(type)
  );
}

template <typename T, Member::EnableIfSame<T>*>
bool Member::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->site, other_struct.site))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, Member::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.site < rhs.site)
    return true;
  if (rhs.site < lhs.site)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}
template <typename StructPtrType>
RelatedWebsiteSetPtr RelatedWebsiteSet::Clone() const {
  return New(
      mojo::Clone(primary_site),
      mojo::Clone(member_sites),
      mojo::Clone(managed_by_enterprise)
  );
}

template <typename T, RelatedWebsiteSet::EnableIfSame<T>*>
bool RelatedWebsiteSet::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->primary_site, other_struct.primary_site))
    return false;
  if (!mojo::Equals(this->member_sites, other_struct.member_sites))
    return false;
  if (!mojo::Equals(this->managed_by_enterprise, other_struct.managed_by_enterprise))
    return false;
  return true;
}

template <typename T, RelatedWebsiteSet::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.primary_site < rhs.primary_site)
    return true;
  if (rhs.primary_site < lhs.primary_site)
    return false;
  if (lhs.member_sites < rhs.member_sites)
    return true;
  if (rhs.member_sites < lhs.member_sites)
    return false;
  if (lhs.managed_by_enterprise < rhs.managed_by_enterprise)
    return true;
  if (rhs.managed_by_enterprise < lhs.managed_by_enterprise)
    return false;
  return false;
}


}  // related_website_sets::mojom

namespace mojo {


template <>
struct  StructTraits<::related_website_sets::mojom::Member::DataView,
                                         ::related_website_sets::mojom::MemberPtr> {
  static bool IsNull(const ::related_website_sets::mojom::MemberPtr& input) { return !input; }
  static void SetToNull(::related_website_sets::mojom::MemberPtr* output) { output->reset(); }

  static const decltype(::related_website_sets::mojom::Member::site)& site(
      const ::related_website_sets::mojom::MemberPtr& input) {
    return input->site;
  }

  static decltype(::related_website_sets::mojom::Member::type) type(
      const ::related_website_sets::mojom::MemberPtr& input) {
    return input->type;
  }

  static bool Read(::related_website_sets::mojom::Member::DataView input, ::related_website_sets::mojom::MemberPtr* output);
};


template <>
struct  StructTraits<::related_website_sets::mojom::RelatedWebsiteSet::DataView,
                                         ::related_website_sets::mojom::RelatedWebsiteSetPtr> {
  static bool IsNull(const ::related_website_sets::mojom::RelatedWebsiteSetPtr& input) { return !input; }
  static void SetToNull(::related_website_sets::mojom::RelatedWebsiteSetPtr* output) { output->reset(); }

  static const decltype(::related_website_sets::mojom::RelatedWebsiteSet::primary_site)& primary_site(
      const ::related_website_sets::mojom::RelatedWebsiteSetPtr& input) {
    return input->primary_site;
  }

  static const decltype(::related_website_sets::mojom::RelatedWebsiteSet::member_sites)& member_sites(
      const ::related_website_sets::mojom::RelatedWebsiteSetPtr& input) {
    return input->member_sites;
  }

  static decltype(::related_website_sets::mojom::RelatedWebsiteSet::managed_by_enterprise) managed_by_enterprise(
      const ::related_website_sets::mojom::RelatedWebsiteSetPtr& input) {
    return input->managed_by_enterprise;
  }

  static bool Read(::related_website_sets::mojom::RelatedWebsiteSet::DataView input, ::related_website_sets::mojom::RelatedWebsiteSetPtr* output);
};


template <>
struct  UnionTraits<::related_website_sets::mojom::GetRelatedWebsiteSetsResponse::DataView,
                                        ::related_website_sets::mojom::GetRelatedWebsiteSetsResponsePtr> {
  static bool IsNull(const ::related_website_sets::mojom::GetRelatedWebsiteSetsResponsePtr& input) { return !input; }
  static void SetToNull(::related_website_sets::mojom::GetRelatedWebsiteSetsResponsePtr* output) { output->reset(); }

  static ::related_website_sets::mojom::GetRelatedWebsiteSetsResponse::Tag GetTag(const ::related_website_sets::mojom::GetRelatedWebsiteSetsResponsePtr& input) {
    return input->which();
  }

  static const std::vector<::related_website_sets::mojom::RelatedWebsiteSetPtr>& related_website_sets(const ::related_website_sets::mojom::GetRelatedWebsiteSetsResponsePtr& input) {
    return input->get_related_website_sets();
  }

  static const std::string& error_message(const ::related_website_sets::mojom::GetRelatedWebsiteSetsResponsePtr& input) {
    return input->get_error_message();
  }

  static bool Read(::related_website_sets::mojom::GetRelatedWebsiteSetsResponse::DataView input, ::related_website_sets::mojom::GetRelatedWebsiteSetsResponsePtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_PRIVACY_SANDBOX_RELATED_WEBSITE_SETS_RELATED_WEBSITE_SETS_MOJOM_H_