// chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-params-data.h"
#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-import-headers.h"
#include "chrome/browser/ui/webui/privacy_sandbox/related_website_sets/related_website_sets.mojom-test-utils.h"


namespace related_website_sets::mojom {
Member::Member()
    : site(),
      type() {}

Member::Member(
    const std::string& site_in,
    SiteType type_in)
    : site(std::move(site_in)),
      type(std::move(type_in)) {}

Member::~Member() = default;
size_t Member::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->site);
  seed = mojo::internal::Hash(seed, this->type);
  return seed;
}

void Member::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "site"), this->site,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SiteType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Member::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RelatedWebsiteSet::RelatedWebsiteSet()
    : primary_site(),
      member_sites(),
      managed_by_enterprise() {}

RelatedWebsiteSet::RelatedWebsiteSet(
    const std::string& primary_site_in,
    std::vector<MemberPtr> member_sites_in,
    bool managed_by_enterprise_in)
    : primary_site(std::move(primary_site_in)),
      member_sites(std::move(member_sites_in)),
      managed_by_enterprise(std::move(managed_by_enterprise_in)) {}

RelatedWebsiteSet::~RelatedWebsiteSet() = default;

void RelatedWebsiteSet::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "primary_site"), this->primary_site,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "member_sites"), this->member_sites,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<MemberPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "managed_by_enterprise"), this->managed_by_enterprise,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RelatedWebsiteSet::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetRelatedWebsiteSetsResponsePtr
GetRelatedWebsiteSetsResponse::NewRelatedWebsiteSets(
    std::vector<RelatedWebsiteSetPtr> value) {
  return GetRelatedWebsiteSetsResponsePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kRelatedWebsiteSets)>,
      std::move(value));
}

GetRelatedWebsiteSetsResponsePtr
GetRelatedWebsiteSetsResponse::NewErrorMessage(
    const std::string& value) {
  return GetRelatedWebsiteSetsResponsePtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kErrorMessage)>,
      std::move(value));
}

GetRelatedWebsiteSetsResponse::GetRelatedWebsiteSetsResponse(
    std::in_place_index_t<static_cast<size_t>(Tag::kRelatedWebsiteSets)>,
    std::vector<RelatedWebsiteSetPtr> value)
    : tag_(Tag::kRelatedWebsiteSets),
      data_(std::in_place_index<static_cast<size_t>(Tag::kRelatedWebsiteSets)>,
            std::move(value)) {}

GetRelatedWebsiteSetsResponse::GetRelatedWebsiteSetsResponse(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
    const std::string& value)
    : tag_(Tag::kErrorMessage),
      data_(std::in_place_index<static_cast<size_t>(Tag::kErrorMessage)>,
            std::move(value)) {}
GetRelatedWebsiteSetsResponse::~GetRelatedWebsiteSetsResponse() {
  DestroyActive();
}

void GetRelatedWebsiteSetsResponse::set_related_website_sets(std::vector<RelatedWebsiteSetPtr> related_website_sets) {
  if (tag_ == Tag::kRelatedWebsiteSets) {
    data_.related_website_sets = std::move(related_website_sets);
  } else {
    DestroyActive();
    tag_ = Tag::kRelatedWebsiteSets;
    new (&data_.related_website_sets) std::vector<RelatedWebsiteSetPtr>(
        std::move(related_website_sets));
  }
}

void GetRelatedWebsiteSetsResponse::set_error_message(const std::string& error_message) {
  if (tag_ == Tag::kErrorMessage) {
    data_.error_message = std::move(error_message);
  } else {
    DestroyActive();
    tag_ = Tag::kErrorMessage;
    new (&data_.error_message) std::string(
        std::move(error_message));
  }
}


GetRelatedWebsiteSetsResponse::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kRelatedWebsiteSets)>,
    std::vector<RelatedWebsiteSetPtr> value)
    : related_website_sets(std::move(value)) {}

GetRelatedWebsiteSetsResponse::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
    const std::string& value)
    : error_message(std::move(value)) {}

void GetRelatedWebsiteSetsResponse::DestroyActive() {
  switch (tag_) {

    case Tag::kRelatedWebsiteSets:
      std::destroy_at(&data_.related_website_sets);
      break;
    case Tag::kErrorMessage:
      std::destroy_at(&data_.error_message);
      break;
  }
}

bool GetRelatedWebsiteSetsResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

RelatedWebsiteSetsPageHandler::IPCStableHashFunction RelatedWebsiteSetsPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RelatedWebsiteSetsPageHandler>(message.name())) {
    case messages::RelatedWebsiteSetsPageHandler::kGetRelatedWebsiteSets: {
      return &RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSets_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RelatedWebsiteSetsPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RelatedWebsiteSetsPageHandler>(message.name())) {
      case messages::RelatedWebsiteSetsPageHandler::kGetRelatedWebsiteSets:
            return "Receive related_website_sets::mojom::RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSets";
    }
  } else {
    switch (static_cast<messages::RelatedWebsiteSetsPageHandler>(message.name())) {
      case messages::RelatedWebsiteSetsPageHandler::kGetRelatedWebsiteSets:
            return "Receive reply related_website_sets::mojom::RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSets";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSets_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6a167475;  // IPCStableHash for related_website_sets::mojom::RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSets
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ForwardToCallback(
      RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSetsCallback callback
      ) : callback_(std::move(callback)) {
  }

  RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ForwardToCallback(const RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ForwardToCallback&) = delete;
  RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ForwardToCallback& operator=(const RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSetsCallback callback_;
};

RelatedWebsiteSetsPageHandlerProxy::RelatedWebsiteSetsPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RelatedWebsiteSetsPageHandlerProxy::GetRelatedWebsiteSets(
    GetRelatedWebsiteSetsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send related_website_sets::mojom::RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSets");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RelatedWebsiteSetsPageHandler::kGetRelatedWebsiteSets), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::related_website_sets::mojom::internal::RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RelatedWebsiteSetsPageHandler::Name_);
  message.set_method_name("GetRelatedWebsiteSets");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSetsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ProxyToResponder> proxy(
        new RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSetsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      GetRelatedWebsiteSetsResponsePtr in_related_website_sets_info);
};

bool RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RelatedWebsiteSetsPageHandler.0
  bool success = true;
  GetRelatedWebsiteSetsResponsePtr p_related_website_sets_info{};
  RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadRelatedWebsiteSetsInfo(&p_related_website_sets_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RelatedWebsiteSetsPageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_related_website_sets_info));
  }
  return true;
}

void RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ProxyToResponder::Run(
    GetRelatedWebsiteSetsResponsePtr in_related_website_sets_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply related_website_sets::mojom::RelatedWebsiteSetsPageHandler::GetRelatedWebsiteSets", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("related_website_sets_info"), in_related_website_sets_info,
                        "<value of type GetRelatedWebsiteSetsResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RelatedWebsiteSetsPageHandler::kGetRelatedWebsiteSets), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::related_website_sets::mojom::internal::RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->related_website_sets_info)>
      related_website_sets_info_fragment(params.message());
  related_website_sets_info_fragment.Claim(&params->related_website_sets_info);
  
  mojo::internal::Serialize<::related_website_sets::mojom::GetRelatedWebsiteSetsResponseDataView>(
    in_related_website_sets_info,
    related_website_sets_info_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->related_website_sets_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null related_website_sets_info in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RelatedWebsiteSetsPageHandler::Name_);
  message.set_method_name("GetRelatedWebsiteSets");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RelatedWebsiteSetsPageHandlerStubDispatch::Accept(
    RelatedWebsiteSetsPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RelatedWebsiteSetsPageHandler>(message->header()->name)) {
    case messages::RelatedWebsiteSetsPageHandler::kGetRelatedWebsiteSets: {
      break;
    }
  }
  return false;
}

// static
bool RelatedWebsiteSetsPageHandlerStubDispatch::AcceptWithResponder(
    RelatedWebsiteSetsPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RelatedWebsiteSetsPageHandler>(message->header()->name)) {
    case messages::RelatedWebsiteSetsPageHandler::kGetRelatedWebsiteSets: {
      internal::RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_Params_Data* params =
          reinterpret_cast<
              internal::RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RelatedWebsiteSetsPageHandler.0
      bool success = true;
      RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RelatedWebsiteSetsPageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRelatedWebsiteSets(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRelatedWebsiteSetsPageHandlerValidationInfo[] = {
    { &internal::RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_Params_Data::Validate,
     &internal::RelatedWebsiteSetsPageHandler_GetRelatedWebsiteSets_ResponseParams_Data::Validate},
};

bool RelatedWebsiteSetsPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::related_website_sets::mojom::RelatedWebsiteSetsPageHandler::Name_,
    kRelatedWebsiteSetsPageHandlerValidationInfo);
}

bool RelatedWebsiteSetsPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::related_website_sets::mojom::RelatedWebsiteSetsPageHandler::Name_,
    kRelatedWebsiteSetsPageHandlerValidationInfo);
}


}  // related_website_sets::mojom


namespace mojo {


// static
bool StructTraits<::related_website_sets::mojom::Member::DataView, ::related_website_sets::mojom::MemberPtr>::Read(
    ::related_website_sets::mojom::Member::DataView input,
    ::related_website_sets::mojom::MemberPtr* output) {
  bool success = true;
  ::related_website_sets::mojom::MemberPtr result(::related_website_sets::mojom::Member::New());
  
      if (success && !input.ReadSite(&result->site))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::related_website_sets::mojom::RelatedWebsiteSet::DataView, ::related_website_sets::mojom::RelatedWebsiteSetPtr>::Read(
    ::related_website_sets::mojom::RelatedWebsiteSet::DataView input,
    ::related_website_sets::mojom::RelatedWebsiteSetPtr* output) {
  bool success = true;
  ::related_website_sets::mojom::RelatedWebsiteSetPtr result(::related_website_sets::mojom::RelatedWebsiteSet::New());
  
      if (success && !input.ReadPrimarySite(&result->primary_site))
        success = false;
      if (success && !input.ReadMemberSites(&result->member_sites))
        success = false;
      if (success)
        result->managed_by_enterprise = input.managed_by_enterprise();
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::related_website_sets::mojom::GetRelatedWebsiteSetsResponse::DataView, ::related_website_sets::mojom::GetRelatedWebsiteSetsResponsePtr>::Read(
    ::related_website_sets::mojom::GetRelatedWebsiteSetsResponse::DataView input,
    ::related_website_sets::mojom::GetRelatedWebsiteSetsResponsePtr* output) {
  using UnionType = ::related_website_sets::mojom::GetRelatedWebsiteSetsResponse;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kRelatedWebsiteSets: {
      std::vector<::related_website_sets::mojom::RelatedWebsiteSetPtr> result_related_website_sets{};
      if (!input.ReadRelatedWebsiteSets(&result_related_website_sets))
        return false;

      *output = UnionType::NewRelatedWebsiteSets(
          std::move(result_related_website_sets));
      break;
    }
    case Tag::kErrorMessage: {
      std::string result_error_message{};
      if (!input.ReadErrorMessage(&result_error_message))
        return false;

      *output = UnionType::NewErrorMessage(
          std::move(result_error_message));
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace related_website_sets::mojom {


void RelatedWebsiteSetsPageHandlerInterceptorForTesting::GetRelatedWebsiteSets(GetRelatedWebsiteSetsCallback callback) {
  GetForwardingInterface()->GetRelatedWebsiteSets(std::move(callback));
}
RelatedWebsiteSetsPageHandlerAsyncWaiter::RelatedWebsiteSetsPageHandlerAsyncWaiter(
    RelatedWebsiteSetsPageHandler* proxy) : proxy_(proxy) {}

RelatedWebsiteSetsPageHandlerAsyncWaiter::~RelatedWebsiteSetsPageHandlerAsyncWaiter() = default;


void RelatedWebsiteSetsPageHandlerAsyncWaiter::GetRelatedWebsiteSets(
    GetRelatedWebsiteSetsResponsePtr* out_related_website_sets_info) {
  base::RunLoop loop;
  proxy_->GetRelatedWebsiteSets(
      base::BindOnce(
          [](base::RunLoop* loop,
             GetRelatedWebsiteSetsResponsePtr* out_related_website_sets_info
,
             GetRelatedWebsiteSetsResponsePtr related_website_sets_info) {*out_related_website_sets_info = std::move(related_website_sets_info);
            loop->Quit();
          },
          &loop,
          out_related_website_sets_info));
  loop.Run();
}

GetRelatedWebsiteSetsResponsePtr RelatedWebsiteSetsPageHandlerAsyncWaiter::GetRelatedWebsiteSets(
    ) {
  GetRelatedWebsiteSetsResponsePtr async_wait_result;
  GetRelatedWebsiteSets(&async_wait_result);
  return async_wait_result;
}






}  // related_website_sets::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif