// chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom-params-data.h"
#include "chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom-import-headers.h"
#include "chrome/browser/ui/webui/privacy_sandbox/base_dialog.mojom-test-utils.h"


namespace privacy_sandbox::dialog::mojom {
// The declaration includes the definition on other builds.

BaseDialogPageHandlerFactory::IPCStableHashFunction BaseDialogPageHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BaseDialogPageHandlerFactory>(message.name())) {
    case messages::BaseDialogPageHandlerFactory::kCreatePageHandler: {
      return &BaseDialogPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BaseDialogPageHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BaseDialogPageHandlerFactory>(message.name())) {
      case messages::BaseDialogPageHandlerFactory::kCreatePageHandler:
            return "Receive privacy_sandbox::dialog::mojom::BaseDialogPageHandlerFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::BaseDialogPageHandlerFactory>(message.name())) {
      case messages::BaseDialogPageHandlerFactory::kCreatePageHandler:
            return "Receive reply privacy_sandbox::dialog::mojom::BaseDialogPageHandlerFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BaseDialogPageHandlerFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x59b8f99f;  // IPCStableHash for privacy_sandbox::dialog::mojom::BaseDialogPageHandlerFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BaseDialogPageHandlerFactoryProxy::BaseDialogPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BaseDialogPageHandlerFactoryProxy::CreatePageHandler(
    ::mojo::PendingRemote<BaseDialogPage> in_page, ::mojo::PendingReceiver<BaseDialogPageHandler> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send privacy_sandbox::dialog::mojom::BaseDialogPageHandlerFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<BaseDialogPage>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<BaseDialogPageHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BaseDialogPageHandlerFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox::dialog::mojom::internal::BaseDialogPageHandlerFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::privacy_sandbox::dialog::mojom::BaseDialogPageInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in BaseDialogPageHandlerFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::privacy_sandbox::dialog::mojom::BaseDialogPageHandlerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in BaseDialogPageHandlerFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BaseDialogPageHandlerFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BaseDialogPageHandlerFactoryStubDispatch::Accept(
    BaseDialogPageHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BaseDialogPageHandlerFactory>(message->header()->name)) {
    case messages::BaseDialogPageHandlerFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::BaseDialogPageHandlerFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::BaseDialogPageHandlerFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BaseDialogPageHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<BaseDialogPage> p_page{};
      ::mojo::PendingReceiver<BaseDialogPageHandler> p_receiver{};
      BaseDialogPageHandlerFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BaseDialogPageHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_page), 
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool BaseDialogPageHandlerFactoryStubDispatch::AcceptWithResponder(
    BaseDialogPageHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BaseDialogPageHandlerFactory>(message->header()->name)) {
    case messages::BaseDialogPageHandlerFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBaseDialogPageHandlerFactoryValidationInfo[] = {
    { &internal::BaseDialogPageHandlerFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool BaseDialogPageHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::privacy_sandbox::dialog::mojom::BaseDialogPageHandlerFactory::Name_,
    kBaseDialogPageHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

BaseDialogPageHandler::IPCStableHashFunction BaseDialogPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BaseDialogPageHandler>(message.name())) {
    case messages::BaseDialogPageHandler::kResizeDialog: {
      return &BaseDialogPageHandler::ResizeDialog_Sym::IPCStableHash;
    }
    case messages::BaseDialogPageHandler::kShowDialog: {
      return &BaseDialogPageHandler::ShowDialog_Sym::IPCStableHash;
    }
    case messages::BaseDialogPageHandler::kEventOccurred: {
      return &BaseDialogPageHandler::EventOccurred_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BaseDialogPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BaseDialogPageHandler>(message.name())) {
      case messages::BaseDialogPageHandler::kResizeDialog:
            return "Receive privacy_sandbox::dialog::mojom::BaseDialogPageHandler::ResizeDialog";
      case messages::BaseDialogPageHandler::kShowDialog:
            return "Receive privacy_sandbox::dialog::mojom::BaseDialogPageHandler::ShowDialog";
      case messages::BaseDialogPageHandler::kEventOccurred:
            return "Receive privacy_sandbox::dialog::mojom::BaseDialogPageHandler::EventOccurred";
    }
  } else {
    switch (static_cast<messages::BaseDialogPageHandler>(message.name())) {
      case messages::BaseDialogPageHandler::kResizeDialog:
            return "Receive reply privacy_sandbox::dialog::mojom::BaseDialogPageHandler::ResizeDialog";
      case messages::BaseDialogPageHandler::kShowDialog:
            return "Receive reply privacy_sandbox::dialog::mojom::BaseDialogPageHandler::ShowDialog";
      case messages::BaseDialogPageHandler::kEventOccurred:
            return "Receive reply privacy_sandbox::dialog::mojom::BaseDialogPageHandler::EventOccurred";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BaseDialogPageHandler::ResizeDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x061774fd;  // IPCStableHash for privacy_sandbox::dialog::mojom::BaseDialogPageHandler::ResizeDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BaseDialogPageHandler::ShowDialog_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4886484d;  // IPCStableHash for privacy_sandbox::dialog::mojom::BaseDialogPageHandler::ShowDialog
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t BaseDialogPageHandler::EventOccurred_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x22bf29f0;  // IPCStableHash for privacy_sandbox::dialog::mojom::BaseDialogPageHandler::EventOccurred
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BaseDialogPageHandlerProxy::BaseDialogPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BaseDialogPageHandlerProxy::ResizeDialog(
    uint32_t in_height) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send privacy_sandbox::dialog::mojom::BaseDialogPageHandler::ResizeDialog", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("height"), in_height,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BaseDialogPageHandler::kResizeDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox::dialog::mojom::internal::BaseDialogPageHandler_ResizeDialog_Params_Data> params(
          message);
  params.Allocate();

  params->height = in_height;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BaseDialogPageHandler::Name_);
  message.set_method_name("ResizeDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BaseDialogPageHandlerProxy::ShowDialog(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send privacy_sandbox::dialog::mojom::BaseDialogPageHandler::ShowDialog");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BaseDialogPageHandler::kShowDialog), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox::dialog::mojom::internal::BaseDialogPageHandler_ShowDialog_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BaseDialogPageHandler::Name_);
  message.set_method_name("ShowDialog");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void BaseDialogPageHandlerProxy::EventOccurred(
    ::privacy_sandbox::notice::mojom::PrivacySandboxNotice in_notice, ::privacy_sandbox::notice::mojom::PrivacySandboxNoticeEvent in_event) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send privacy_sandbox::dialog::mojom::BaseDialogPageHandler::EventOccurred", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("notice"), in_notice,
                        "<value of type ::privacy_sandbox::notice::mojom::PrivacySandboxNotice>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event"), in_event,
                        "<value of type ::privacy_sandbox::notice::mojom::PrivacySandboxNoticeEvent>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BaseDialogPageHandler::kEventOccurred), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox::dialog::mojom::internal::BaseDialogPageHandler_EventOccurred_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::privacy_sandbox::notice::mojom::PrivacySandboxNotice>(
    in_notice,
    &params->notice);

  
  mojo::internal::Serialize<::privacy_sandbox::notice::mojom::PrivacySandboxNoticeEvent>(
    in_event,
    &params->event);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BaseDialogPageHandler::Name_);
  message.set_method_name("EventOccurred");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BaseDialogPageHandlerStubDispatch::Accept(
    BaseDialogPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BaseDialogPageHandler>(message->header()->name)) {
    case messages::BaseDialogPageHandler::kResizeDialog: {
      DCHECK(message->is_serialized());
      internal::BaseDialogPageHandler_ResizeDialog_Params_Data* params =
          reinterpret_cast<internal::BaseDialogPageHandler_ResizeDialog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BaseDialogPageHandler.0
      bool success = true;
      uint32_t p_height{};
      BaseDialogPageHandler_ResizeDialog_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_height = input_data_view.height();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BaseDialogPageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResizeDialog(        
        std::move(p_height));
      return true;
    }
    case messages::BaseDialogPageHandler::kShowDialog: {
      DCHECK(message->is_serialized());
      internal::BaseDialogPageHandler_ShowDialog_Params_Data* params =
          reinterpret_cast<internal::BaseDialogPageHandler_ShowDialog_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BaseDialogPageHandler.1
      bool success = true;
      BaseDialogPageHandler_ShowDialog_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BaseDialogPageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowDialog(        );
      return true;
    }
    case messages::BaseDialogPageHandler::kEventOccurred: {
      DCHECK(message->is_serialized());
      internal::BaseDialogPageHandler_EventOccurred_Params_Data* params =
          reinterpret_cast<internal::BaseDialogPageHandler_EventOccurred_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BaseDialogPageHandler.2
      bool success = true;
      ::privacy_sandbox::notice::mojom::PrivacySandboxNotice p_notice{};
      ::privacy_sandbox::notice::mojom::PrivacySandboxNoticeEvent p_event{};
      BaseDialogPageHandler_EventOccurred_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNotice(&p_notice))
        success = false;
      if (success && !input_data_view.ReadEvent(&p_event))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BaseDialogPageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EventOccurred(        
        std::move(p_notice), 
        std::move(p_event));
      return true;
    }
  }
  return false;
}

// static
bool BaseDialogPageHandlerStubDispatch::AcceptWithResponder(
    BaseDialogPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BaseDialogPageHandler>(message->header()->name)) {
    case messages::BaseDialogPageHandler::kResizeDialog: {
      break;
    }
    case messages::BaseDialogPageHandler::kShowDialog: {
      break;
    }
    case messages::BaseDialogPageHandler::kEventOccurred: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBaseDialogPageHandlerValidationInfo[] = {
    { &internal::BaseDialogPageHandler_ResizeDialog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BaseDialogPageHandler_ShowDialog_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::BaseDialogPageHandler_EventOccurred_Params_Data::Validate,
     nullptr /* no response */},
};

bool BaseDialogPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::privacy_sandbox::dialog::mojom::BaseDialogPageHandler::Name_,
    kBaseDialogPageHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

BaseDialogPage::IPCStableHashFunction BaseDialogPage::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BaseDialogPage>(message.name())) {
    case messages::BaseDialogPage::kNavigateToNextStep: {
      return &BaseDialogPage::NavigateToNextStep_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BaseDialogPage::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BaseDialogPage>(message.name())) {
      case messages::BaseDialogPage::kNavigateToNextStep:
            return "Receive privacy_sandbox::dialog::mojom::BaseDialogPage::NavigateToNextStep";
    }
  } else {
    switch (static_cast<messages::BaseDialogPage>(message.name())) {
      case messages::BaseDialogPage::kNavigateToNextStep:
            return "Receive reply privacy_sandbox::dialog::mojom::BaseDialogPage::NavigateToNextStep";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BaseDialogPage::NavigateToNextStep_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf8889c8d;  // IPCStableHash for privacy_sandbox::dialog::mojom::BaseDialogPage::NavigateToNextStep
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

BaseDialogPageProxy::BaseDialogPageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BaseDialogPageProxy::NavigateToNextStep(
    ::privacy_sandbox::notice::mojom::PrivacySandboxNotice in_next_step) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send privacy_sandbox::dialog::mojom::BaseDialogPage::NavigateToNextStep", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("next_step"), in_next_step,
                        "<value of type ::privacy_sandbox::notice::mojom::PrivacySandboxNotice>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BaseDialogPage::kNavigateToNextStep), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::privacy_sandbox::dialog::mojom::internal::BaseDialogPage_NavigateToNextStep_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::privacy_sandbox::notice::mojom::PrivacySandboxNotice>(
    in_next_step,
    &params->next_step);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BaseDialogPage::Name_);
  message.set_method_name("NavigateToNextStep");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool BaseDialogPageStubDispatch::Accept(
    BaseDialogPage* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BaseDialogPage>(message->header()->name)) {
    case messages::BaseDialogPage::kNavigateToNextStep: {
      DCHECK(message->is_serialized());
      internal::BaseDialogPage_NavigateToNextStep_Params_Data* params =
          reinterpret_cast<internal::BaseDialogPage_NavigateToNextStep_Params_Data*>(
              message->mutable_payload());
      

      // Validation for BaseDialogPage.0
      bool success = true;
      ::privacy_sandbox::notice::mojom::PrivacySandboxNotice p_next_step{};
      BaseDialogPage_NavigateToNextStep_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadNextStep(&p_next_step))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BaseDialogPage::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NavigateToNextStep(        
        std::move(p_next_step));
      return true;
    }
  }
  return false;
}

// static
bool BaseDialogPageStubDispatch::AcceptWithResponder(
    BaseDialogPage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BaseDialogPage>(message->header()->name)) {
    case messages::BaseDialogPage::kNavigateToNextStep: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBaseDialogPageValidationInfo[] = {
    { &internal::BaseDialogPage_NavigateToNextStep_Params_Data::Validate,
     nullptr /* no response */},
};

bool BaseDialogPageRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::privacy_sandbox::dialog::mojom::BaseDialogPage::Name_,
    kBaseDialogPageValidationInfo);
}



}  // privacy_sandbox::dialog::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace privacy_sandbox::dialog::mojom {


void BaseDialogPageHandlerFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingRemote<BaseDialogPage> page, ::mojo::PendingReceiver<BaseDialogPageHandler> receiver) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(page)
    , 
    std::move(receiver)
    );
}
BaseDialogPageHandlerFactoryAsyncWaiter::BaseDialogPageHandlerFactoryAsyncWaiter(
    BaseDialogPageHandlerFactory* proxy) : proxy_(proxy) {}

BaseDialogPageHandlerFactoryAsyncWaiter::~BaseDialogPageHandlerFactoryAsyncWaiter() = default;





void BaseDialogPageHandlerInterceptorForTesting::ResizeDialog(uint32_t height) {
  GetForwardingInterface()->ResizeDialog(
    std::move(height)
    );
}
void BaseDialogPageHandlerInterceptorForTesting::ShowDialog() {
  GetForwardingInterface()->ShowDialog();
}
void BaseDialogPageHandlerInterceptorForTesting::EventOccurred(::privacy_sandbox::notice::mojom::PrivacySandboxNotice notice, ::privacy_sandbox::notice::mojom::PrivacySandboxNoticeEvent event) {
  GetForwardingInterface()->EventOccurred(
    std::move(notice)
    , 
    std::move(event)
    );
}
BaseDialogPageHandlerAsyncWaiter::BaseDialogPageHandlerAsyncWaiter(
    BaseDialogPageHandler* proxy) : proxy_(proxy) {}

BaseDialogPageHandlerAsyncWaiter::~BaseDialogPageHandlerAsyncWaiter() = default;





void BaseDialogPageInterceptorForTesting::NavigateToNextStep(::privacy_sandbox::notice::mojom::PrivacySandboxNotice next_step) {
  GetForwardingInterface()->NavigateToNextStep(
    std::move(next_step)
    );
}
BaseDialogPageAsyncWaiter::BaseDialogPageAsyncWaiter(
    BaseDialogPage* proxy) : proxy_(proxy) {}

BaseDialogPageAsyncWaiter::~BaseDialogPageAsyncWaiter() = default;







}  // privacy_sandbox::dialog::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif