// chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_OMNIBOX_OMNIBOX_INTERNALS_MOJOM_SHARED_H_
#define CHROME_BROWSER_UI_WEBUI_OMNIBOX_OMNIBOX_INTERNALS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-data-view.h"




namespace std {

template <>
struct hash<::mojom::AutocompleteControllerType>
    : public mojo::internal::EnumHashImpl<::mojom::AutocompleteControllerType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::AutocompleteControllerType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::mojom::AutocompleteControllerType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::mojom::AutocompleteControllerType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::ACMatchClassificationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::ACMatchClassificationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::ACMatchClassification_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->offset = Traits::offset(input);

    fragment->style = Traits::style(input);
  }

  static bool Deserialize(::mojom::internal::ACMatchClassification_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::ACMatchClassificationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::SignalsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::SignalsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::Signals_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->typed_count_$flag = Traits::typed_count(input).has_value();
    if (Traits::typed_count(input).has_value()) {
      fragment->typed_count_$value = Traits::typed_count(input).value();
    }
    fragment->visit_count_$flag = Traits::visit_count(input).has_value();
    if (Traits::visit_count(input).has_value()) {
      fragment->visit_count_$value = Traits::visit_count(input).value();
    }
    fragment->elapsed_time_last_visit_secs_$flag = Traits::elapsed_time_last_visit_secs(input).has_value();
    if (Traits::elapsed_time_last_visit_secs(input).has_value()) {
      fragment->elapsed_time_last_visit_secs_$value = Traits::elapsed_time_last_visit_secs(input).value();
    }
    fragment->shortcut_visit_count_$flag = Traits::shortcut_visit_count(input).has_value();
    if (Traits::shortcut_visit_count(input).has_value()) {
      fragment->shortcut_visit_count_$value = Traits::shortcut_visit_count(input).value();
    }
    fragment->shortest_shortcut_len_$flag = Traits::shortest_shortcut_len(input).has_value();
    if (Traits::shortest_shortcut_len(input).has_value()) {
      fragment->shortest_shortcut_len_$value = Traits::shortest_shortcut_len(input).value();
    }
    fragment->elapsed_time_last_shortcut_visit_sec_$flag = Traits::elapsed_time_last_shortcut_visit_sec(input).has_value();
    if (Traits::elapsed_time_last_shortcut_visit_sec(input).has_value()) {
      fragment->elapsed_time_last_shortcut_visit_sec_$value = Traits::elapsed_time_last_shortcut_visit_sec(input).value();
    }
    fragment->is_host_only_$flag = Traits::is_host_only(input).has_value();
    if (Traits::is_host_only(input).has_value()) {
      fragment->is_host_only_$value = Traits::is_host_only(input).value();
    }
    fragment->num_bookmarks_of_url_$flag = Traits::num_bookmarks_of_url(input).has_value();
    if (Traits::num_bookmarks_of_url(input).has_value()) {
      fragment->num_bookmarks_of_url_$value = Traits::num_bookmarks_of_url(input).value();
    }
    fragment->first_bookmark_title_match_position_$flag = Traits::first_bookmark_title_match_position(input).has_value();
    if (Traits::first_bookmark_title_match_position(input).has_value()) {
      fragment->first_bookmark_title_match_position_$value = Traits::first_bookmark_title_match_position(input).value();
    }
    fragment->total_bookmark_title_match_length_$flag = Traits::total_bookmark_title_match_length(input).has_value();
    if (Traits::total_bookmark_title_match_length(input).has_value()) {
      fragment->total_bookmark_title_match_length_$value = Traits::total_bookmark_title_match_length(input).value();
    }
    fragment->num_input_terms_matched_by_bookmark_title_$flag = Traits::num_input_terms_matched_by_bookmark_title(input).has_value();
    if (Traits::num_input_terms_matched_by_bookmark_title(input).has_value()) {
      fragment->num_input_terms_matched_by_bookmark_title_$value = Traits::num_input_terms_matched_by_bookmark_title(input).value();
    }
    fragment->first_url_match_position_$flag = Traits::first_url_match_position(input).has_value();
    if (Traits::first_url_match_position(input).has_value()) {
      fragment->first_url_match_position_$value = Traits::first_url_match_position(input).value();
    }
    fragment->total_url_match_length_$flag = Traits::total_url_match_length(input).has_value();
    if (Traits::total_url_match_length(input).has_value()) {
      fragment->total_url_match_length_$value = Traits::total_url_match_length(input).value();
    }
    fragment->host_match_at_word_boundary_$flag = Traits::host_match_at_word_boundary(input).has_value();
    if (Traits::host_match_at_word_boundary(input).has_value()) {
      fragment->host_match_at_word_boundary_$value = Traits::host_match_at_word_boundary(input).value();
    }
    fragment->total_host_match_length_$flag = Traits::total_host_match_length(input).has_value();
    if (Traits::total_host_match_length(input).has_value()) {
      fragment->total_host_match_length_$value = Traits::total_host_match_length(input).value();
    }
    fragment->total_path_match_length_$flag = Traits::total_path_match_length(input).has_value();
    if (Traits::total_path_match_length(input).has_value()) {
      fragment->total_path_match_length_$value = Traits::total_path_match_length(input).value();
    }
    fragment->total_query_or_ref_match_length_$flag = Traits::total_query_or_ref_match_length(input).has_value();
    if (Traits::total_query_or_ref_match_length(input).has_value()) {
      fragment->total_query_or_ref_match_length_$value = Traits::total_query_or_ref_match_length(input).value();
    }
    fragment->total_title_match_length_$flag = Traits::total_title_match_length(input).has_value();
    if (Traits::total_title_match_length(input).has_value()) {
      fragment->total_title_match_length_$value = Traits::total_title_match_length(input).value();
    }
    fragment->has_non_scheme_www_match_$flag = Traits::has_non_scheme_www_match(input).has_value();
    if (Traits::has_non_scheme_www_match(input).has_value()) {
      fragment->has_non_scheme_www_match_$value = Traits::has_non_scheme_www_match(input).value();
    }
    fragment->num_input_terms_matched_by_title_$flag = Traits::num_input_terms_matched_by_title(input).has_value();
    if (Traits::num_input_terms_matched_by_title(input).has_value()) {
      fragment->num_input_terms_matched_by_title_$value = Traits::num_input_terms_matched_by_title(input).value();
    }
    fragment->num_input_terms_matched_by_url_$flag = Traits::num_input_terms_matched_by_url(input).has_value();
    if (Traits::num_input_terms_matched_by_url(input).has_value()) {
      fragment->num_input_terms_matched_by_url_$value = Traits::num_input_terms_matched_by_url(input).value();
    }
    fragment->length_of_url_$flag = Traits::length_of_url(input).has_value();
    if (Traits::length_of_url(input).has_value()) {
      fragment->length_of_url_$value = Traits::length_of_url(input).value();
    }
    fragment->site_engagement_$flag = Traits::site_engagement(input).has_value();
    if (Traits::site_engagement(input).has_value()) {
      fragment->site_engagement_$value = Traits::site_engagement(input).value();
    }
    fragment->allowed_to_be_default_match_$flag = Traits::allowed_to_be_default_match(input).has_value();
    if (Traits::allowed_to_be_default_match(input).has_value()) {
      fragment->allowed_to_be_default_match_$value = Traits::allowed_to_be_default_match(input).value();
    }
    fragment->search_suggest_relevance_$flag = Traits::search_suggest_relevance(input).has_value();
    if (Traits::search_suggest_relevance(input).has_value()) {
      fragment->search_suggest_relevance_$value = Traits::search_suggest_relevance(input).value();
    }
    fragment->is_search_suggest_entity_$flag = Traits::is_search_suggest_entity(input).has_value();
    if (Traits::is_search_suggest_entity(input).has_value()) {
      fragment->is_search_suggest_entity_$value = Traits::is_search_suggest_entity(input).value();
    }
    fragment->is_verbatim_$flag = Traits::is_verbatim(input).has_value();
    if (Traits::is_verbatim(input).has_value()) {
      fragment->is_verbatim_$value = Traits::is_verbatim(input).value();
    }
    fragment->is_navsuggest_$flag = Traits::is_navsuggest(input).has_value();
    if (Traits::is_navsuggest(input).has_value()) {
      fragment->is_navsuggest_$value = Traits::is_navsuggest(input).value();
    }
    fragment->is_search_suggest_tail_$flag = Traits::is_search_suggest_tail(input).has_value();
    if (Traits::is_search_suggest_tail(input).has_value()) {
      fragment->is_search_suggest_tail_$value = Traits::is_search_suggest_tail(input).value();
    }
    fragment->is_answer_suggest_$flag = Traits::is_answer_suggest(input).has_value();
    if (Traits::is_answer_suggest(input).has_value()) {
      fragment->is_answer_suggest_$value = Traits::is_answer_suggest(input).value();
    }
    fragment->is_calculator_suggest_$flag = Traits::is_calculator_suggest(input).has_value();
    if (Traits::is_calculator_suggest(input).has_value()) {
      fragment->is_calculator_suggest_$value = Traits::is_calculator_suggest(input).value();
    }
  }

  static bool Deserialize(::mojom::internal::Signals_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::SignalsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::AutocompleteMatchDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::AutocompleteMatchDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::AutocompleteMatch_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::provider_name(input)) in_provider_name = Traits::provider_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->provider_name)::BaseType> provider_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_provider_name,
      provider_name_fragment);

    fragment->provider_name.Set(
        provider_name_fragment.is_null() ? nullptr : provider_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->provider_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null provider_name in AutocompleteMatch struct");

    fragment->provider_done = Traits::provider_done(input);

    fragment->relevance = Traits::relevance(input);

    fragment->deletable = Traits::deletable(input);

    decltype(Traits::fill_into_edit(input)) in_fill_into_edit = Traits::fill_into_edit(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->fill_into_edit)::BaseType> fill_into_edit_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_fill_into_edit,
      fill_into_edit_fragment);

    fragment->fill_into_edit.Set(
        fill_into_edit_fragment.is_null() ? nullptr : fill_into_edit_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->fill_into_edit.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fill_into_edit in AutocompleteMatch struct");

    decltype(Traits::inline_autocompletion(input)) in_inline_autocompletion = Traits::inline_autocompletion(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->inline_autocompletion)::BaseType> inline_autocompletion_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_inline_autocompletion,
      inline_autocompletion_fragment);

    fragment->inline_autocompletion.Set(
        inline_autocompletion_fragment.is_null() ? nullptr : inline_autocompletion_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->inline_autocompletion.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null inline_autocompletion in AutocompleteMatch struct");

    decltype(Traits::destination_url(input)) in_destination_url = Traits::destination_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->destination_url)::BaseType> destination_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_destination_url,
      destination_url_fragment);

    fragment->destination_url.Set(
        destination_url_fragment.is_null() ? nullptr : destination_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->destination_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null destination_url in AutocompleteMatch struct");

    decltype(Traits::stripped_destination_url(input)) in_stripped_destination_url = Traits::stripped_destination_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stripped_destination_url)::BaseType> stripped_destination_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_stripped_destination_url,
      stripped_destination_url_fragment);

    fragment->stripped_destination_url.Set(
        stripped_destination_url_fragment.is_null() ? nullptr : stripped_destination_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stripped_destination_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stripped_destination_url in AutocompleteMatch struct");

    decltype(Traits::icon(input)) in_icon = Traits::icon(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon)::BaseType> icon_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_icon,
      icon_fragment);

    fragment->icon.Set(
        icon_fragment.is_null() ? nullptr : icon_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->icon.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null icon in AutocompleteMatch struct");

    decltype(Traits::image(input)) in_image = Traits::image(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image)::BaseType> image_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_image,
      image_fragment);

    fragment->image.Set(
        image_fragment.is_null() ? nullptr : image_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->image.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null image in AutocompleteMatch struct");

    decltype(Traits::contents(input)) in_contents = Traits::contents(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->contents)::BaseType> contents_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_contents,
      contents_fragment);

    fragment->contents.Set(
        contents_fragment.is_null() ? nullptr : contents_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->contents.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contents in AutocompleteMatch struct");

    decltype(Traits::contents_class(input)) in_contents_class = Traits::contents_class(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->contents_class)::BaseType>
        contents_class_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& contents_class_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::ACMatchClassificationDataView>>(
      in_contents_class,
      contents_class_fragment,
      &contents_class_validate_params);

    fragment->contents_class.Set(
        contents_class_fragment.is_null() ? nullptr : contents_class_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->contents_class.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null contents_class in AutocompleteMatch struct");

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in AutocompleteMatch struct");

    decltype(Traits::description_class(input)) in_description_class = Traits::description_class(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description_class)::BaseType>
        description_class_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& description_class_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::ACMatchClassificationDataView>>(
      in_description_class,
      description_class_fragment,
      &description_class_validate_params);

    fragment->description_class.Set(
        description_class_fragment.is_null() ? nullptr : description_class_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description_class.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description_class in AutocompleteMatch struct");

    fragment->swap_contents_and_description = Traits::swap_contents_and_description(input);

    decltype(Traits::answer(input)) in_answer = Traits::answer(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->answer)::BaseType> answer_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_answer,
      answer_fragment);

    fragment->answer.Set(
        answer_fragment.is_null() ? nullptr : answer_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->answer.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null answer in AutocompleteMatch struct");

    decltype(Traits::transition(input)) in_transition = Traits::transition(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->transition)::BaseType> transition_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_transition,
      transition_fragment);

    fragment->transition.Set(
        transition_fragment.is_null() ? nullptr : transition_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->transition.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null transition in AutocompleteMatch struct");

    fragment->allowed_to_be_default_match = Traits::allowed_to_be_default_match(input);

    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_type,
      type_fragment);

    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null type in AutocompleteMatch struct");

    fragment->is_search_type = Traits::is_search_type(input);

    decltype(Traits::aqs_type_subtypes(input)) in_aqs_type_subtypes = Traits::aqs_type_subtypes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->aqs_type_subtypes)::BaseType> aqs_type_subtypes_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_aqs_type_subtypes,
      aqs_type_subtypes_fragment);

    fragment->aqs_type_subtypes.Set(
        aqs_type_subtypes_fragment.is_null() ? nullptr : aqs_type_subtypes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->aqs_type_subtypes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null aqs_type_subtypes in AutocompleteMatch struct");

    fragment->has_tab_match = Traits::has_tab_match(input);

    decltype(Traits::associated_keyword(input)) in_associated_keyword = Traits::associated_keyword(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->associated_keyword)::BaseType> associated_keyword_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_associated_keyword,
      associated_keyword_fragment);

    fragment->associated_keyword.Set(
        associated_keyword_fragment.is_null() ? nullptr : associated_keyword_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->associated_keyword.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null associated_keyword in AutocompleteMatch struct");

    decltype(Traits::keyword(input)) in_keyword = Traits::keyword(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->keyword)::BaseType> keyword_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_keyword,
      keyword_fragment);

    fragment->keyword.Set(
        keyword_fragment.is_null() ? nullptr : keyword_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->keyword.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keyword in AutocompleteMatch struct");

    fragment->starred = Traits::starred(input);

    fragment->duplicates = Traits::duplicates(input);

    fragment->from_previous = Traits::from_previous(input);

    fragment->pedal_id = Traits::pedal_id(input);

    decltype(Traits::scoring_signals(input)) in_scoring_signals = Traits::scoring_signals(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scoring_signals)::BaseType> scoring_signals_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojom::SignalsDataView>(
      in_scoring_signals,
      scoring_signals_fragment);

    fragment->scoring_signals.Set(
        scoring_signals_fragment.is_null() ? nullptr : scoring_signals_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scoring_signals.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scoring_signals in AutocompleteMatch struct");

    decltype(Traits::additional_info(input)) in_additional_info = Traits::additional_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->additional_info)::BaseType>
        additional_info_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& additional_info_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_additional_info,
      additional_info_fragment,
      &additional_info_validate_params);

    fragment->additional_info.Set(
        additional_info_fragment.is_null() ? nullptr : additional_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->additional_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null additional_info in AutocompleteMatch struct");
  }

  static bool Deserialize(::mojom::internal::AutocompleteMatch_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::AutocompleteMatchDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::AutocompleteResultsForProviderDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::AutocompleteResultsForProviderDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::AutocompleteResultsForProvider_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::provider_name(input)) in_provider_name = Traits::provider_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->provider_name)::BaseType> provider_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_provider_name,
      provider_name_fragment);

    fragment->provider_name.Set(
        provider_name_fragment.is_null() ? nullptr : provider_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->provider_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null provider_name in AutocompleteResultsForProvider struct");

    decltype(Traits::results(input)) in_results = Traits::results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->results)::BaseType>
        results_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::AutocompleteMatchDataView>>(
      in_results,
      results_fragment,
      &results_validate_params);

    fragment->results.Set(
        results_fragment.is_null() ? nullptr : results_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->results.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in AutocompleteResultsForProvider struct");
  }

  static bool Deserialize(::mojom::internal::AutocompleteResultsForProvider_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::AutocompleteResultsForProviderDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::mojom::OmniboxResponseDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::mojom::OmniboxResponseDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::mojom::internal::OmniboxResponse_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->cursor_position = Traits::cursor_position(input);

    fragment->time_since_omnibox_started_ms = Traits::time_since_omnibox_started_ms(input);

    fragment->done = Traits::done(input);

    decltype(Traits::type(input)) in_type = Traits::type(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->type)::BaseType> type_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_type,
      type_fragment);

    fragment->type.Set(
        type_fragment.is_null() ? nullptr : type_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->type.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null type in OmniboxResponse struct");

    decltype(Traits::host(input)) in_host = Traits::host(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host)::BaseType> host_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_host,
      host_fragment);

    fragment->host.Set(
        host_fragment.is_null() ? nullptr : host_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->host.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in OmniboxResponse struct");

    fragment->is_typed_host = Traits::is_typed_host(input);

    decltype(Traits::input_text(input)) in_input_text = Traits::input_text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->input_text)::BaseType> input_text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_input_text,
      input_text_fragment);

    fragment->input_text.Set(
        input_text_fragment.is_null() ? nullptr : input_text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->input_text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input_text in OmniboxResponse struct");

    decltype(Traits::combined_results(input)) in_combined_results = Traits::combined_results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->combined_results)::BaseType>
        combined_results_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& combined_results_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::AutocompleteMatchDataView>>(
      in_combined_results,
      combined_results_fragment,
      &combined_results_validate_params);

    fragment->combined_results.Set(
        combined_results_fragment.is_null() ? nullptr : combined_results_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->combined_results.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null combined_results in OmniboxResponse struct");

    decltype(Traits::results_by_provider(input)) in_results_by_provider = Traits::results_by_provider(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->results_by_provider)::BaseType>
        results_by_provider_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& results_by_provider_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::mojom::AutocompleteResultsForProviderDataView>>(
      in_results_by_provider,
      results_by_provider_fragment,
      &results_by_provider_validate_params);

    fragment->results_by_provider.Set(
        results_by_provider_fragment.is_null() ? nullptr : results_by_provider_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->results_by_provider.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results_by_provider in OmniboxResponse struct");
  }

  static bool Deserialize(::mojom::internal::OmniboxResponse_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::mojom::OmniboxResponseDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace mojom {





inline void AutocompleteMatchDataView::GetProviderNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->provider_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetFillIntoEditDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->fill_into_edit.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetInlineAutocompletionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->inline_autocompletion.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetDestinationUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->destination_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetStrippedDestinationUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->stripped_destination_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetIconDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->icon.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetImageDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->image.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetContentsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->contents.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetContentsClassDataView(
    mojo::ArrayDataView<ACMatchClassificationDataView>* output) {
  auto pointer = data_->contents_class.Get();
  *output = mojo::ArrayDataView<ACMatchClassificationDataView>(pointer, message_);
}
inline void AutocompleteMatchDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetDescriptionClassDataView(
    mojo::ArrayDataView<ACMatchClassificationDataView>* output) {
  auto pointer = data_->description_class.Get();
  *output = mojo::ArrayDataView<ACMatchClassificationDataView>(pointer, message_);
}
inline void AutocompleteMatchDataView::GetAnswerDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->answer.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetTransitionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->transition.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetAqsTypeSubtypesDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->aqs_type_subtypes.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetAssociatedKeywordDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->associated_keyword.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetKeywordDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->keyword.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetScoringSignalsDataView(
    SignalsDataView* output) {
  auto pointer = data_->scoring_signals.Get();
  *output = SignalsDataView(pointer, message_);
}
inline void AutocompleteMatchDataView::GetAdditionalInfoDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->additional_info.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}


inline void AutocompleteResultsForProviderDataView::GetProviderNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->provider_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void AutocompleteResultsForProviderDataView::GetResultsDataView(
    mojo::ArrayDataView<AutocompleteMatchDataView>* output) {
  auto pointer = data_->results.Get();
  *output = mojo::ArrayDataView<AutocompleteMatchDataView>(pointer, message_);
}


inline void OmniboxResponseDataView::GetTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->type.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void OmniboxResponseDataView::GetHostDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void OmniboxResponseDataView::GetInputTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->input_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void OmniboxResponseDataView::GetCombinedResultsDataView(
    mojo::ArrayDataView<AutocompleteMatchDataView>* output) {
  auto pointer = data_->combined_results.Get();
  *output = mojo::ArrayDataView<AutocompleteMatchDataView>(pointer, message_);
}
inline void OmniboxResponseDataView::GetResultsByProviderDataView(
    mojo::ArrayDataView<AutocompleteResultsForProviderDataView>* output) {
  auto pointer = data_->results_by_provider.Get();
  *output = mojo::ArrayDataView<AutocompleteResultsForProviderDataView>(pointer, message_);
}



}  // mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::mojom::AutocompleteControllerType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::mojom::AutocompleteControllerType value);
};

} // namespace perfetto

#endif  // CHROME_BROWSER_UI_WEBUI_OMNIBOX_OMNIBOX_INTERNALS_MOJOM_SHARED_H_