// chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_OMNIBOX_OMNIBOX_INTERNALS_MOJOM_DATA_VIEW_H_
#define CHROME_BROWSER_UI_WEBUI_OMNIBOX_OMNIBOX_INTERNALS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "chrome/browser/ui/webui/omnibox/omnibox_internals.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace mojom {
class ACMatchClassificationDataView;

class SignalsDataView;

class AutocompleteMatchDataView;

class AutocompleteResultsForProviderDataView;

class OmniboxResponseDataView;



}  // mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::mojom::ACMatchClassificationDataView> {
  using Data = ::mojom::internal::ACMatchClassification_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::SignalsDataView> {
  using Data = ::mojom::internal::Signals_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::AutocompleteMatchDataView> {
  using Data = ::mojom::internal::AutocompleteMatch_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::AutocompleteResultsForProviderDataView> {
  using Data = ::mojom::internal::AutocompleteResultsForProvider_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::mojom::OmniboxResponseDataView> {
  using Data = ::mojom::internal::OmniboxResponse_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace mojom {


enum class AutocompleteControllerType : int32_t {
  
  kBrowser = 0,
  
  kDebug = 1,
  
  kMlDisabledDebug = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, AutocompleteControllerType value);
inline bool IsKnownEnumValue(AutocompleteControllerType value) {
  return internal::AutocompleteControllerType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class OmniboxPageHandlerInterfaceBase {};

using OmniboxPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<OmniboxPageHandlerInterfaceBase>;
using OmniboxPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<OmniboxPageHandlerInterfaceBase>;
using OmniboxPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<OmniboxPageHandlerInterfaceBase>;
using OmniboxPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<OmniboxPageHandlerInterfaceBase>;
class OmniboxPageInterfaceBase {};

using OmniboxPagePtrDataView =
    mojo::InterfacePtrDataView<OmniboxPageInterfaceBase>;
using OmniboxPageRequestDataView =
    mojo::InterfaceRequestDataView<OmniboxPageInterfaceBase>;
using OmniboxPageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<OmniboxPageInterfaceBase>;
using OmniboxPageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<OmniboxPageInterfaceBase>;


class ACMatchClassificationDataView {
 public:
  ACMatchClassificationDataView() = default;

  ACMatchClassificationDataView(
      internal::ACMatchClassification_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t offset() const {
    return data_->offset;
  }
  int32_t style() const {
    return data_->style;
  }
 private:
  internal::ACMatchClassification_Data* data_ = nullptr;
};


class SignalsDataView {
 public:
  SignalsDataView() = default;

  SignalsDataView(
      internal::Signals_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  std::optional<int32_t> typed_count() const {

    return data_->typed_count_$flag
        ? std::make_optional(data_->typed_count_$value)
        : std::nullopt;
  }
  std::optional<int32_t> visit_count() const {

    return data_->visit_count_$flag
        ? std::make_optional(data_->visit_count_$value)
        : std::nullopt;
  }
  std::optional<int64_t> elapsed_time_last_visit_secs() const {

    return data_->elapsed_time_last_visit_secs_$flag
        ? std::make_optional(data_->elapsed_time_last_visit_secs_$value)
        : std::nullopt;
  }
  std::optional<int32_t> shortcut_visit_count() const {

    return data_->shortcut_visit_count_$flag
        ? std::make_optional(data_->shortcut_visit_count_$value)
        : std::nullopt;
  }
  std::optional<int32_t> shortest_shortcut_len() const {

    return data_->shortest_shortcut_len_$flag
        ? std::make_optional(data_->shortest_shortcut_len_$value)
        : std::nullopt;
  }
  std::optional<int64_t> elapsed_time_last_shortcut_visit_sec() const {

    return data_->elapsed_time_last_shortcut_visit_sec_$flag
        ? std::make_optional(data_->elapsed_time_last_shortcut_visit_sec_$value)
        : std::nullopt;
  }
  std::optional<bool> is_host_only() const {

    return data_->is_host_only_$flag
        ? std::make_optional(!!data_->is_host_only_$value)
        : std::nullopt;
  }
  std::optional<int32_t> num_bookmarks_of_url() const {

    return data_->num_bookmarks_of_url_$flag
        ? std::make_optional(data_->num_bookmarks_of_url_$value)
        : std::nullopt;
  }
  std::optional<int32_t> first_bookmark_title_match_position() const {

    return data_->first_bookmark_title_match_position_$flag
        ? std::make_optional(data_->first_bookmark_title_match_position_$value)
        : std::nullopt;
  }
  std::optional<int32_t> total_bookmark_title_match_length() const {

    return data_->total_bookmark_title_match_length_$flag
        ? std::make_optional(data_->total_bookmark_title_match_length_$value)
        : std::nullopt;
  }
  std::optional<int32_t> num_input_terms_matched_by_bookmark_title() const {

    return data_->num_input_terms_matched_by_bookmark_title_$flag
        ? std::make_optional(data_->num_input_terms_matched_by_bookmark_title_$value)
        : std::nullopt;
  }
  std::optional<int32_t> first_url_match_position() const {

    return data_->first_url_match_position_$flag
        ? std::make_optional(data_->first_url_match_position_$value)
        : std::nullopt;
  }
  std::optional<int32_t> total_url_match_length() const {

    return data_->total_url_match_length_$flag
        ? std::make_optional(data_->total_url_match_length_$value)
        : std::nullopt;
  }
  std::optional<bool> host_match_at_word_boundary() const {

    return data_->host_match_at_word_boundary_$flag
        ? std::make_optional(!!data_->host_match_at_word_boundary_$value)
        : std::nullopt;
  }
  std::optional<int32_t> total_host_match_length() const {

    return data_->total_host_match_length_$flag
        ? std::make_optional(data_->total_host_match_length_$value)
        : std::nullopt;
  }
  std::optional<int32_t> total_path_match_length() const {

    return data_->total_path_match_length_$flag
        ? std::make_optional(data_->total_path_match_length_$value)
        : std::nullopt;
  }
  std::optional<int32_t> total_query_or_ref_match_length() const {

    return data_->total_query_or_ref_match_length_$flag
        ? std::make_optional(data_->total_query_or_ref_match_length_$value)
        : std::nullopt;
  }
  std::optional<int32_t> total_title_match_length() const {

    return data_->total_title_match_length_$flag
        ? std::make_optional(data_->total_title_match_length_$value)
        : std::nullopt;
  }
  std::optional<bool> has_non_scheme_www_match() const {

    return data_->has_non_scheme_www_match_$flag
        ? std::make_optional(!!data_->has_non_scheme_www_match_$value)
        : std::nullopt;
  }
  std::optional<int32_t> num_input_terms_matched_by_title() const {

    return data_->num_input_terms_matched_by_title_$flag
        ? std::make_optional(data_->num_input_terms_matched_by_title_$value)
        : std::nullopt;
  }
  std::optional<int32_t> num_input_terms_matched_by_url() const {

    return data_->num_input_terms_matched_by_url_$flag
        ? std::make_optional(data_->num_input_terms_matched_by_url_$value)
        : std::nullopt;
  }
  std::optional<int32_t> length_of_url() const {

    return data_->length_of_url_$flag
        ? std::make_optional(data_->length_of_url_$value)
        : std::nullopt;
  }
  std::optional<float> site_engagement() const {

    return data_->site_engagement_$flag
        ? std::make_optional(data_->site_engagement_$value)
        : std::nullopt;
  }
  std::optional<bool> allowed_to_be_default_match() const {

    return data_->allowed_to_be_default_match_$flag
        ? std::make_optional(!!data_->allowed_to_be_default_match_$value)
        : std::nullopt;
  }
  std::optional<int32_t> search_suggest_relevance() const {

    return data_->search_suggest_relevance_$flag
        ? std::make_optional(data_->search_suggest_relevance_$value)
        : std::nullopt;
  }
  std::optional<bool> is_search_suggest_entity() const {

    return data_->is_search_suggest_entity_$flag
        ? std::make_optional(!!data_->is_search_suggest_entity_$value)
        : std::nullopt;
  }
  std::optional<bool> is_verbatim() const {

    return data_->is_verbatim_$flag
        ? std::make_optional(!!data_->is_verbatim_$value)
        : std::nullopt;
  }
  std::optional<bool> is_navsuggest() const {

    return data_->is_navsuggest_$flag
        ? std::make_optional(!!data_->is_navsuggest_$value)
        : std::nullopt;
  }
  std::optional<bool> is_search_suggest_tail() const {

    return data_->is_search_suggest_tail_$flag
        ? std::make_optional(!!data_->is_search_suggest_tail_$value)
        : std::nullopt;
  }
  std::optional<bool> is_answer_suggest() const {

    return data_->is_answer_suggest_$flag
        ? std::make_optional(!!data_->is_answer_suggest_$value)
        : std::nullopt;
  }
  std::optional<bool> is_calculator_suggest() const {

    return data_->is_calculator_suggest_$flag
        ? std::make_optional(!!data_->is_calculator_suggest_$value)
        : std::nullopt;
  }
 private:
  internal::Signals_Data* data_ = nullptr;
};


class AutocompleteMatchDataView {
 public:
  AutocompleteMatchDataView() = default;

  AutocompleteMatchDataView(
      internal::AutocompleteMatch_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProviderNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProviderName(UserType* output) {
    
    auto* pointer = data_->provider_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool provider_done() const {
    return data_->provider_done;
  }
  int32_t relevance() const {
    return data_->relevance;
  }
  bool deletable() const {
    return data_->deletable;
  }
  inline void GetFillIntoEditDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFillIntoEdit(UserType* output) {
    
    auto* pointer = data_->fill_into_edit.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetInlineAutocompletionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInlineAutocompletion(UserType* output) {
    
    auto* pointer = data_->inline_autocompletion.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDestinationUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDestinationUrl(UserType* output) {
    
    auto* pointer = data_->destination_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetStrippedDestinationUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStrippedDestinationUrl(UserType* output) {
    
    auto* pointer = data_->stripped_destination_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetIconDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) {
    
    auto* pointer = data_->icon.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetImageDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImage(UserType* output) {
    
    auto* pointer = data_->image.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetContentsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContents(UserType* output) {
    
    auto* pointer = data_->contents.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetContentsClassDataView(
      mojo::ArrayDataView<ACMatchClassificationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadContentsClass(UserType* output) {
    
    auto* pointer = data_->contents_class.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::ACMatchClassificationDataView>>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionClassDataView(
      mojo::ArrayDataView<ACMatchClassificationDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescriptionClass(UserType* output) {
    
    auto* pointer = data_->description_class.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::ACMatchClassificationDataView>>(
        pointer, output, message_);
  }
  bool swap_contents_and_description() const {
    return data_->swap_contents_and_description;
  }
  inline void GetAnswerDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnswer(UserType* output) {
    
    auto* pointer = data_->answer.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTransitionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTransition(UserType* output) {
    
    auto* pointer = data_->transition.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool allowed_to_be_default_match() const {
    return data_->allowed_to_be_default_match;
  }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_search_type() const {
    return data_->is_search_type;
  }
  inline void GetAqsTypeSubtypesDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAqsTypeSubtypes(UserType* output) {
    
    auto* pointer = data_->aqs_type_subtypes.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool has_tab_match() const {
    return data_->has_tab_match;
  }
  inline void GetAssociatedKeywordDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAssociatedKeyword(UserType* output) {
    
    auto* pointer = data_->associated_keyword.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetKeywordDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyword(UserType* output) {
    
    auto* pointer = data_->keyword.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool starred() const {
    return data_->starred;
  }
  int32_t duplicates() const {
    return data_->duplicates;
  }
  bool from_previous() const {
    return data_->from_previous;
  }
  int32_t pedal_id() const {
    return data_->pedal_id;
  }
  inline void GetScoringSignalsDataView(
      SignalsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadScoringSignals(UserType* output) {
    
    auto* pointer = data_->scoring_signals.Get();
    return mojo::internal::Deserialize<::mojom::SignalsDataView>(
        pointer, output, message_);
  }
  inline void GetAdditionalInfoDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAdditionalInfo(UserType* output) {
    
    auto* pointer = data_->additional_info.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AutocompleteMatch_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AutocompleteResultsForProviderDataView {
 public:
  AutocompleteResultsForProviderDataView() = default;

  AutocompleteResultsForProviderDataView(
      internal::AutocompleteResultsForProvider_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetProviderNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadProviderName(UserType* output) {
    
    auto* pointer = data_->provider_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetResultsDataView(
      mojo::ArrayDataView<AutocompleteMatchDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResults(UserType* output) {
    
    auto* pointer = data_->results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::AutocompleteMatchDataView>>(
        pointer, output, message_);
  }
 private:
  internal::AutocompleteResultsForProvider_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class OmniboxResponseDataView {
 public:
  OmniboxResponseDataView() = default;

  OmniboxResponseDataView(
      internal::OmniboxResponse_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t cursor_position() const {
    return data_->cursor_position;
  }
  int32_t time_since_omnibox_started_ms() const {
    return data_->time_since_omnibox_started_ms;
  }
  bool done() const {
    return data_->done;
  }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetHostDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHost(UserType* output) {
    
    auto* pointer = data_->host.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_typed_host() const {
    return data_->is_typed_host;
  }
  inline void GetInputTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInputText(UserType* output) {
    
    auto* pointer = data_->input_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCombinedResultsDataView(
      mojo::ArrayDataView<AutocompleteMatchDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCombinedResults(UserType* output) {
    
    auto* pointer = data_->combined_results.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::AutocompleteMatchDataView>>(
        pointer, output, message_);
  }
  inline void GetResultsByProviderDataView(
      mojo::ArrayDataView<AutocompleteResultsForProviderDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadResultsByProvider(UserType* output) {
    
    auto* pointer = data_->results_by_provider.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::mojom::AutocompleteResultsForProviderDataView>>(
        pointer, output, message_);
  }
 private:
  internal::OmniboxResponse_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // mojom

#endif  // CHROME_BROWSER_UI_WEBUI_OMNIBOX_OMNIBOX_INTERNALS_MOJOM_DATA_VIEW_H_