// chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_untrusted_ui.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_untrusted_ui.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_untrusted_ui.mojom-params-data.h"
#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_untrusted_ui.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_untrusted_ui.mojom-import-headers.h"
#include "chrome/browser/ui/webui/ntp_microsoft_auth/ntp_microsoft_auth_untrusted_ui.mojom-test-utils.h"


namespace new_tab_page::mojom {
AccessToken::AccessToken()
    : token(),
      expiration() {}

AccessToken::AccessToken(
    const std::string& token_in,
    ::base::Time expiration_in)
    : token(std::move(token_in)),
      expiration(std::move(expiration_in)) {}

AccessToken::~AccessToken() = default;

void AccessToken::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "token"), this->token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expiration"), this->expiration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AccessToken::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

MicrosoftAuthUntrustedDocumentInterfacesFactory::IPCStableHashFunction MicrosoftAuthUntrustedDocumentInterfacesFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MicrosoftAuthUntrustedDocumentInterfacesFactory>(message.name())) {
    case messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kConnectToParentDocument: {
      return &MicrosoftAuthUntrustedDocumentInterfacesFactory::ConnectToParentDocument_Sym::IPCStableHash;
    }
    case messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kCreatePageHandler: {
      return &MicrosoftAuthUntrustedDocumentInterfacesFactory::CreatePageHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MicrosoftAuthUntrustedDocumentInterfacesFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MicrosoftAuthUntrustedDocumentInterfacesFactory>(message.name())) {
      case messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kConnectToParentDocument:
            return "Receive new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfacesFactory::ConnectToParentDocument";
      case messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kCreatePageHandler:
            return "Receive new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfacesFactory::CreatePageHandler";
    }
  } else {
    switch (static_cast<messages::MicrosoftAuthUntrustedDocumentInterfacesFactory>(message.name())) {
      case messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kConnectToParentDocument:
            return "Receive reply new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfacesFactory::ConnectToParentDocument";
      case messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kCreatePageHandler:
            return "Receive reply new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfacesFactory::CreatePageHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MicrosoftAuthUntrustedDocumentInterfacesFactory::ConnectToParentDocument_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xb1e68e36;  // IPCStableHash for new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfacesFactory::ConnectToParentDocument
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MicrosoftAuthUntrustedDocumentInterfacesFactory::CreatePageHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcc502a50;  // IPCStableHash for new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfacesFactory::CreatePageHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MicrosoftAuthUntrustedDocumentInterfacesFactoryProxy::MicrosoftAuthUntrustedDocumentInterfacesFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MicrosoftAuthUntrustedDocumentInterfacesFactoryProxy::ConnectToParentDocument(
    ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> in_child_document) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfacesFactory::ConnectToParentDocument", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("child_document"), in_child_document,
                        "<value of type ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kConnectToParentDocument), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::MicrosoftAuthUntrustedDocumentInterfacesFactory_ConnectToParentDocument_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfaceBase>>(
    in_child_document,
    &params->child_document,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->child_document)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid child_document in MicrosoftAuthUntrustedDocumentInterfacesFactory.ConnectToParentDocument request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MicrosoftAuthUntrustedDocumentInterfacesFactory::Name_);
  message.set_method_name("ConnectToParentDocument");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MicrosoftAuthUntrustedDocumentInterfacesFactoryProxy::CreatePageHandler(
    ::mojo::PendingReceiver<MicrosoftAuthUntrustedPageHandler> in_handler, ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> in_document) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfacesFactory::CreatePageHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<MicrosoftAuthUntrustedPageHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("document"), in_document,
                        "<value of type ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kCreatePageHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::MicrosoftAuthUntrustedDocumentInterfacesFactory_CreatePageHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::new_tab_page::mojom::MicrosoftAuthUntrustedPageHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in MicrosoftAuthUntrustedDocumentInterfacesFactory.CreatePageHandler request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfaceBase>>(
    in_document,
    &params->document,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->document)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid document in MicrosoftAuthUntrustedDocumentInterfacesFactory.CreatePageHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MicrosoftAuthUntrustedDocumentInterfacesFactory::Name_);
  message.set_method_name("CreatePageHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MicrosoftAuthUntrustedDocumentInterfacesFactoryStubDispatch::Accept(
    MicrosoftAuthUntrustedDocumentInterfacesFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MicrosoftAuthUntrustedDocumentInterfacesFactory>(message->header()->name)) {
    case messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kConnectToParentDocument: {
      DCHECK(message->is_serialized());
      internal::MicrosoftAuthUntrustedDocumentInterfacesFactory_ConnectToParentDocument_Params_Data* params =
          reinterpret_cast<internal::MicrosoftAuthUntrustedDocumentInterfacesFactory_ConnectToParentDocument_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MicrosoftAuthUntrustedDocumentInterfacesFactory.0
      bool success = true;
      ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> p_child_document{};
      MicrosoftAuthUntrustedDocumentInterfacesFactory_ConnectToParentDocument_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_child_document =
            input_data_view.TakeChildDocument<decltype(p_child_document)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MicrosoftAuthUntrustedDocumentInterfacesFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ConnectToParentDocument(        
        std::move(p_child_document));
      return true;
    }
    case messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kCreatePageHandler: {
      DCHECK(message->is_serialized());
      internal::MicrosoftAuthUntrustedDocumentInterfacesFactory_CreatePageHandler_Params_Data* params =
          reinterpret_cast<internal::MicrosoftAuthUntrustedDocumentInterfacesFactory_CreatePageHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MicrosoftAuthUntrustedDocumentInterfacesFactory.1
      bool success = true;
      ::mojo::PendingReceiver<MicrosoftAuthUntrustedPageHandler> p_handler{};
      ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> p_document{};
      MicrosoftAuthUntrustedDocumentInterfacesFactory_CreatePageHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (success) {
        p_document =
            input_data_view.TakeDocument<decltype(p_document)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MicrosoftAuthUntrustedDocumentInterfacesFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreatePageHandler(        
        std::move(p_handler), 
        std::move(p_document));
      return true;
    }
  }
  return false;
}

// static
bool MicrosoftAuthUntrustedDocumentInterfacesFactoryStubDispatch::AcceptWithResponder(
    MicrosoftAuthUntrustedDocumentInterfacesFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MicrosoftAuthUntrustedDocumentInterfacesFactory>(message->header()->name)) {
    case messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kConnectToParentDocument: {
      break;
    }
    case messages::MicrosoftAuthUntrustedDocumentInterfacesFactory::kCreatePageHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMicrosoftAuthUntrustedDocumentInterfacesFactoryValidationInfo[] = {
    { &internal::MicrosoftAuthUntrustedDocumentInterfacesFactory_ConnectToParentDocument_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MicrosoftAuthUntrustedDocumentInterfacesFactory_CreatePageHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool MicrosoftAuthUntrustedDocumentInterfacesFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::new_tab_page::mojom::MicrosoftAuthUntrustedDocumentInterfacesFactory::Name_,
    kMicrosoftAuthUntrustedDocumentInterfacesFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

MicrosoftAuthUntrustedPageHandler::IPCStableHashFunction MicrosoftAuthUntrustedPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MicrosoftAuthUntrustedPageHandler>(message.name())) {
    case messages::MicrosoftAuthUntrustedPageHandler::kClearAuthData: {
      return &MicrosoftAuthUntrustedPageHandler::ClearAuthData_Sym::IPCStableHash;
    }
    case messages::MicrosoftAuthUntrustedPageHandler::kMaybeAcquireTokenSilent: {
      return &MicrosoftAuthUntrustedPageHandler::MaybeAcquireTokenSilent_Sym::IPCStableHash;
    }
    case messages::MicrosoftAuthUntrustedPageHandler::kSetAccessToken: {
      return &MicrosoftAuthUntrustedPageHandler::SetAccessToken_Sym::IPCStableHash;
    }
    case messages::MicrosoftAuthUntrustedPageHandler::kSetAuthStateError: {
      return &MicrosoftAuthUntrustedPageHandler::SetAuthStateError_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MicrosoftAuthUntrustedPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MicrosoftAuthUntrustedPageHandler>(message.name())) {
      case messages::MicrosoftAuthUntrustedPageHandler::kClearAuthData:
            return "Receive new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::ClearAuthData";
      case messages::MicrosoftAuthUntrustedPageHandler::kMaybeAcquireTokenSilent:
            return "Receive new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::MaybeAcquireTokenSilent";
      case messages::MicrosoftAuthUntrustedPageHandler::kSetAccessToken:
            return "Receive new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::SetAccessToken";
      case messages::MicrosoftAuthUntrustedPageHandler::kSetAuthStateError:
            return "Receive new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::SetAuthStateError";
    }
  } else {
    switch (static_cast<messages::MicrosoftAuthUntrustedPageHandler>(message.name())) {
      case messages::MicrosoftAuthUntrustedPageHandler::kClearAuthData:
            return "Receive reply new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::ClearAuthData";
      case messages::MicrosoftAuthUntrustedPageHandler::kMaybeAcquireTokenSilent:
            return "Receive reply new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::MaybeAcquireTokenSilent";
      case messages::MicrosoftAuthUntrustedPageHandler::kSetAccessToken:
            return "Receive reply new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::SetAccessToken";
      case messages::MicrosoftAuthUntrustedPageHandler::kSetAuthStateError:
            return "Receive reply new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::SetAuthStateError";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MicrosoftAuthUntrustedPageHandler::ClearAuthData_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd9384315;  // IPCStableHash for new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::ClearAuthData
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MicrosoftAuthUntrustedPageHandler::MaybeAcquireTokenSilent_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0ab808fe;  // IPCStableHash for new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::MaybeAcquireTokenSilent
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MicrosoftAuthUntrustedPageHandler::SetAccessToken_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc95bfd62;  // IPCStableHash for new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::SetAccessToken
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MicrosoftAuthUntrustedPageHandler::SetAuthStateError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc0f16496;  // IPCStableHash for new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::SetAuthStateError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MicrosoftAuthUntrustedPageHandlerProxy::MicrosoftAuthUntrustedPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MicrosoftAuthUntrustedPageHandlerProxy::ClearAuthData(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::ClearAuthData");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MicrosoftAuthUntrustedPageHandler::kClearAuthData), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::MicrosoftAuthUntrustedPageHandler_ClearAuthData_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MicrosoftAuthUntrustedPageHandler::Name_);
  message.set_method_name("ClearAuthData");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MicrosoftAuthUntrustedPageHandlerProxy::MaybeAcquireTokenSilent(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::MaybeAcquireTokenSilent");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MicrosoftAuthUntrustedPageHandler::kMaybeAcquireTokenSilent), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::MicrosoftAuthUntrustedPageHandler_MaybeAcquireTokenSilent_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MicrosoftAuthUntrustedPageHandler::Name_);
  message.set_method_name("MaybeAcquireTokenSilent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MicrosoftAuthUntrustedPageHandlerProxy::SetAccessToken(
    AccessTokenPtr in_access_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::SetAccessToken", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("access_token"), in_access_token,
                        "<value of type AccessTokenPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MicrosoftAuthUntrustedPageHandler::kSetAccessToken), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::MicrosoftAuthUntrustedPageHandler_SetAccessToken_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->access_token)::BaseType> access_token_fragment(
          params.message());
  
  mojo::internal::Serialize<::new_tab_page::mojom::AccessTokenDataView>(
    in_access_token,
    access_token_fragment);

  params->access_token.Set(
      access_token_fragment.is_null() ? nullptr : access_token_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->access_token.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null access_token in MicrosoftAuthUntrustedPageHandler.SetAccessToken request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MicrosoftAuthUntrustedPageHandler::Name_);
  message.set_method_name("SetAccessToken");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MicrosoftAuthUntrustedPageHandlerProxy::SetAuthStateError(
    const std::string& in_error_code, const std::string& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::SetAuthStateError", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_code"), in_error_code,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MicrosoftAuthUntrustedPageHandler::kSetAuthStateError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::new_tab_page::mojom::internal::MicrosoftAuthUntrustedPageHandler_SetAuthStateError_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->error_code)::BaseType> error_code_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_code,
    error_code_fragment);

  params->error_code.Set(
      error_code_fragment.is_null() ? nullptr : error_code_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_code.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_code in MicrosoftAuthUntrustedPageHandler.SetAuthStateError request");
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->error_message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null error_message in MicrosoftAuthUntrustedPageHandler.SetAuthStateError request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MicrosoftAuthUntrustedPageHandler::Name_);
  message.set_method_name("SetAuthStateError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MicrosoftAuthUntrustedPageHandlerStubDispatch::Accept(
    MicrosoftAuthUntrustedPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MicrosoftAuthUntrustedPageHandler>(message->header()->name)) {
    case messages::MicrosoftAuthUntrustedPageHandler::kClearAuthData: {
      DCHECK(message->is_serialized());
      internal::MicrosoftAuthUntrustedPageHandler_ClearAuthData_Params_Data* params =
          reinterpret_cast<internal::MicrosoftAuthUntrustedPageHandler_ClearAuthData_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MicrosoftAuthUntrustedPageHandler.0
      bool success = true;
      MicrosoftAuthUntrustedPageHandler_ClearAuthData_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MicrosoftAuthUntrustedPageHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearAuthData(        );
      return true;
    }
    case messages::MicrosoftAuthUntrustedPageHandler::kMaybeAcquireTokenSilent: {
      DCHECK(message->is_serialized());
      internal::MicrosoftAuthUntrustedPageHandler_MaybeAcquireTokenSilent_Params_Data* params =
          reinterpret_cast<internal::MicrosoftAuthUntrustedPageHandler_MaybeAcquireTokenSilent_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MicrosoftAuthUntrustedPageHandler.1
      bool success = true;
      MicrosoftAuthUntrustedPageHandler_MaybeAcquireTokenSilent_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MicrosoftAuthUntrustedPageHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MaybeAcquireTokenSilent(        );
      return true;
    }
    case messages::MicrosoftAuthUntrustedPageHandler::kSetAccessToken: {
      DCHECK(message->is_serialized());
      internal::MicrosoftAuthUntrustedPageHandler_SetAccessToken_Params_Data* params =
          reinterpret_cast<internal::MicrosoftAuthUntrustedPageHandler_SetAccessToken_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MicrosoftAuthUntrustedPageHandler.2
      bool success = true;
      AccessTokenPtr p_access_token{};
      MicrosoftAuthUntrustedPageHandler_SetAccessToken_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAccessToken(&p_access_token))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MicrosoftAuthUntrustedPageHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAccessToken(        
        std::move(p_access_token));
      return true;
    }
    case messages::MicrosoftAuthUntrustedPageHandler::kSetAuthStateError: {
      DCHECK(message->is_serialized());
      internal::MicrosoftAuthUntrustedPageHandler_SetAuthStateError_Params_Data* params =
          reinterpret_cast<internal::MicrosoftAuthUntrustedPageHandler_SetAuthStateError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MicrosoftAuthUntrustedPageHandler.3
      bool success = true;
      std::string p_error_code{};
      std::string p_error_message{};
      MicrosoftAuthUntrustedPageHandler_SetAuthStateError_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadErrorCode(&p_error_code))
        success = false;
      if (success && !input_data_view.ReadErrorMessage(&p_error_message))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MicrosoftAuthUntrustedPageHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAuthStateError(        
        std::move(p_error_code), 
        std::move(p_error_message));
      return true;
    }
  }
  return false;
}

// static
bool MicrosoftAuthUntrustedPageHandlerStubDispatch::AcceptWithResponder(
    MicrosoftAuthUntrustedPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MicrosoftAuthUntrustedPageHandler>(message->header()->name)) {
    case messages::MicrosoftAuthUntrustedPageHandler::kClearAuthData: {
      break;
    }
    case messages::MicrosoftAuthUntrustedPageHandler::kMaybeAcquireTokenSilent: {
      break;
    }
    case messages::MicrosoftAuthUntrustedPageHandler::kSetAccessToken: {
      break;
    }
    case messages::MicrosoftAuthUntrustedPageHandler::kSetAuthStateError: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMicrosoftAuthUntrustedPageHandlerValidationInfo[] = {
    { &internal::MicrosoftAuthUntrustedPageHandler_ClearAuthData_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MicrosoftAuthUntrustedPageHandler_MaybeAcquireTokenSilent_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MicrosoftAuthUntrustedPageHandler_SetAccessToken_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MicrosoftAuthUntrustedPageHandler_SetAuthStateError_Params_Data::Validate,
     nullptr /* no response */},
};

bool MicrosoftAuthUntrustedPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::new_tab_page::mojom::MicrosoftAuthUntrustedPageHandler::Name_,
    kMicrosoftAuthUntrustedPageHandlerValidationInfo);
}



}  // new_tab_page::mojom


namespace mojo {


// static
bool StructTraits<::new_tab_page::mojom::AccessToken::DataView, ::new_tab_page::mojom::AccessTokenPtr>::Read(
    ::new_tab_page::mojom::AccessToken::DataView input,
    ::new_tab_page::mojom::AccessTokenPtr* output) {
  bool success = true;
  ::new_tab_page::mojom::AccessTokenPtr result(::new_tab_page::mojom::AccessToken::New());
  
      if (success && !input.ReadToken(&result->token))
        success = false;
      if (success && !input.ReadExpiration(&result->expiration))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace new_tab_page::mojom {


void MicrosoftAuthUntrustedDocumentInterfacesFactoryInterceptorForTesting::ConnectToParentDocument(::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> child_document) {
  GetForwardingInterface()->ConnectToParentDocument(
    std::move(child_document)
    );
}
void MicrosoftAuthUntrustedDocumentInterfacesFactoryInterceptorForTesting::CreatePageHandler(::mojo::PendingReceiver<MicrosoftAuthUntrustedPageHandler> handler, ::mojo::PendingRemote<::new_tab_page::mojom::MicrosoftAuthUntrustedDocument> document) {
  GetForwardingInterface()->CreatePageHandler(
    std::move(handler)
    , 
    std::move(document)
    );
}
MicrosoftAuthUntrustedDocumentInterfacesFactoryAsyncWaiter::MicrosoftAuthUntrustedDocumentInterfacesFactoryAsyncWaiter(
    MicrosoftAuthUntrustedDocumentInterfacesFactory* proxy) : proxy_(proxy) {}

MicrosoftAuthUntrustedDocumentInterfacesFactoryAsyncWaiter::~MicrosoftAuthUntrustedDocumentInterfacesFactoryAsyncWaiter() = default;





void MicrosoftAuthUntrustedPageHandlerInterceptorForTesting::ClearAuthData() {
  GetForwardingInterface()->ClearAuthData();
}
void MicrosoftAuthUntrustedPageHandlerInterceptorForTesting::MaybeAcquireTokenSilent() {
  GetForwardingInterface()->MaybeAcquireTokenSilent();
}
void MicrosoftAuthUntrustedPageHandlerInterceptorForTesting::SetAccessToken(AccessTokenPtr access_token) {
  GetForwardingInterface()->SetAccessToken(
    std::move(access_token)
    );
}
void MicrosoftAuthUntrustedPageHandlerInterceptorForTesting::SetAuthStateError(const std::string& error_code, const std::string& error_message) {
  GetForwardingInterface()->SetAuthStateError(
    std::move(error_code)
    , 
    std::move(error_message)
    );
}
MicrosoftAuthUntrustedPageHandlerAsyncWaiter::MicrosoftAuthUntrustedPageHandlerAsyncWaiter(
    MicrosoftAuthUntrustedPageHandler* proxy) : proxy_(proxy) {}

MicrosoftAuthUntrustedPageHandlerAsyncWaiter::~MicrosoftAuthUntrustedPageHandlerAsyncWaiter() = default;







}  // new_tab_page::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif