// chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NTP_PROMO_NTP_PROMO_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NTP_PROMO_NTP_PROMO_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "chrome/browser/ui/webui/new_tab_page/ntp_promo/ntp_promo_mojom_traits.h"
#include "components/user_education/common/ntp_promo/ntp_promo_controller.h"




namespace ntp_promo::mojom {

class NtpPromoHandlerProxy;

template <typename ImplRefTraits>
class NtpPromoHandlerStub;

class NtpPromoHandlerRequestValidator;


class NtpPromoHandler
    : public NtpPromoHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ntp_promo.mojom.NtpPromoHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NtpPromoHandlerInterfaceBase;
  using Proxy_ = NtpPromoHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = NtpPromoHandlerStub<ImplRefTraits>;

  using RequestValidator_ = NtpPromoHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRequestPromosMinVersion = 0,
    kOnPromosShownMinVersion = 0,
    kOnPromoClickedMinVersion = 0,
    kSnoozeSetupListMinVersion = 0,
    kUnsnoozeSetupListMinVersion = 0,
    kDisableSetupListMinVersion = 0,
    kUndisableSetupListMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestPromos_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPromosShown_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPromoClicked_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SnoozeSetupList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnsnoozeSetupList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableSetupList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UndisableSetupList_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NtpPromoHandler() = default;

  virtual void RequestPromos() = 0;

  virtual void OnPromosShown(const std::vector<std::string>& eligible_shown, const std::vector<std::string>& completed_shown) = 0;

  virtual void OnPromoClicked(const std::string& promo_id) = 0;

  virtual void SnoozeSetupList() = 0;

  virtual void UnsnoozeSetupList() = 0;

  virtual void DisableSetupList() = 0;

  virtual void UndisableSetupList() = 0;
};

class NtpPromoClientProxy;

template <typename ImplRefTraits>
class NtpPromoClientStub;

class NtpPromoClientRequestValidator;


class NtpPromoClient
    : public NtpPromoClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ntp_promo.mojom.NtpPromoClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NtpPromoClientInterfaceBase;
  using Proxy_ = NtpPromoClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NtpPromoClientStub<ImplRefTraits>;

  using RequestValidator_ = NtpPromoClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetPromosMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetPromos_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NtpPromoClient() = default;

  virtual void SetPromos(const std::vector<::user_education::NtpShowablePromo>& eligible, const std::vector<::user_education::NtpShowablePromo>& completed) = 0;
};

class NtpPromoHandlerFactoryProxy;

template <typename ImplRefTraits>
class NtpPromoHandlerFactoryStub;

class NtpPromoHandlerFactoryRequestValidator;


class NtpPromoHandlerFactory
    : public NtpPromoHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ntp_promo.mojom.NtpPromoHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = NtpPromoHandlerFactoryInterfaceBase;
  using Proxy_ = NtpPromoHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = NtpPromoHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = NtpPromoHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateNtpPromoHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateNtpPromoHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~NtpPromoHandlerFactory() = default;

  virtual void CreateNtpPromoHandler(::mojo::PendingRemote<NtpPromoClient> client, ::mojo::PendingReceiver<NtpPromoHandler> handler) = 0;
};



class  NtpPromoHandlerProxy
    : public NtpPromoHandler {
 public:
  using InterfaceType = NtpPromoHandler;

  explicit NtpPromoHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestPromos() final;
  
  void OnPromosShown(const std::vector<std::string>& eligible_shown, const std::vector<std::string>& completed_shown) final;
  
  void OnPromoClicked(const std::string& promo_id) final;
  
  void SnoozeSetupList() final;
  
  void UnsnoozeSetupList() final;
  
  void DisableSetupList() final;
  
  void UndisableSetupList() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NtpPromoClientProxy
    : public NtpPromoClient {
 public:
  using InterfaceType = NtpPromoClient;

  explicit NtpPromoClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPromos(const std::vector<::user_education::NtpShowablePromo>& eligible, const std::vector<::user_education::NtpShowablePromo>& completed) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NtpPromoHandlerFactoryProxy
    : public NtpPromoHandlerFactory {
 public:
  using InterfaceType = NtpPromoHandlerFactory;

  explicit NtpPromoHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateNtpPromoHandler(::mojo::PendingRemote<NtpPromoClient> client, ::mojo::PendingReceiver<NtpPromoHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NtpPromoHandlerStubDispatch {
 public:
  static bool Accept(NtpPromoHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NtpPromoHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NtpPromoHandler>>
class NtpPromoHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NtpPromoHandlerStub() = default;
  ~NtpPromoHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NtpPromoHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NtpPromoHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NtpPromoClientStubDispatch {
 public:
  static bool Accept(NtpPromoClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NtpPromoClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NtpPromoClient>>
class NtpPromoClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NtpPromoClientStub() = default;
  ~NtpPromoClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NtpPromoClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NtpPromoClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NtpPromoHandlerFactoryStubDispatch {
 public:
  static bool Accept(NtpPromoHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NtpPromoHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NtpPromoHandlerFactory>>
class NtpPromoHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NtpPromoHandlerFactoryStub() = default;
  ~NtpPromoHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NtpPromoHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NtpPromoHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NtpPromoHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NtpPromoClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NtpPromoHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  Promo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Promo, T>::value>;
  using DataView = PromoDataView;
  using Data_ = internal::Promo_Data;

  template <typename... Args>
  static PromoPtr New(Args&&... args) {
    return PromoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PromoPtr From(const U& u) {
    return mojo::TypeConverter<PromoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Promo>::Convert(*this);
  }


  Promo();

  Promo(
      const std::string& id,
      const std::string& icon_name,
      const std::string& body_text,
      const std::string& button_text);


  ~Promo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PromoPtr>
  PromoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Promo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Promo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Promo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Promo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Promo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Promo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Promo_UnserializedMessageContext<
            UserType, Promo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Promo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Promo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Promo_UnserializedMessageContext<
            UserType, Promo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Promo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string icon_name;
  
  std::string body_text;
  
  std::string button_text;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Promo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Promo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Promo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Promo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  PromosShown {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PromosShown, T>::value>;
  using DataView = PromosShownDataView;
  using Data_ = internal::PromosShown_Data;

  template <typename... Args>
  static PromosShownPtr New(Args&&... args) {
    return PromosShownPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PromosShownPtr From(const U& u) {
    return mojo::TypeConverter<PromosShownPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PromosShown>::Convert(*this);
  }


  PromosShown();

  PromosShown(
      std::vector<std::string> eligible,
      std::vector<std::string> completed);


  ~PromosShown();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PromosShownPtr>
  PromosShownPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PromosShown::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, PromosShown::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, PromosShown::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PromosShown::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PromosShown::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PromosShown::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PromosShown_UnserializedMessageContext<
            UserType, PromosShown::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<PromosShown::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return PromosShown::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PromosShown_UnserializedMessageContext<
            UserType, PromosShown::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PromosShown::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> eligible;
  
  std::vector<std::string> completed;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PromosShown::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PromosShown::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PromosShown::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PromosShown::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
PromosShownPtr PromosShown::Clone() const {
  return New(
      mojo::Clone(eligible),
      mojo::Clone(completed)
  );
}

template <typename T, PromosShown::EnableIfSame<T>*>
bool PromosShown::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->eligible, other_struct.eligible))
    return false;
  if (!mojo::Equals(this->completed, other_struct.completed))
    return false;
  return true;
}

template <typename T, PromosShown::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.eligible < rhs.eligible)
    return true;
  if (rhs.eligible < lhs.eligible)
    return false;
  if (lhs.completed < rhs.completed)
    return true;
  if (rhs.completed < lhs.completed)
    return false;
  return false;
}
template <typename StructPtrType>
PromoPtr Promo::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(icon_name),
      mojo::Clone(body_text),
      mojo::Clone(button_text)
  );
}

template <typename T, Promo::EnableIfSame<T>*>
bool Promo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->icon_name, other_struct.icon_name))
    return false;
  if (!mojo::Equals(this->body_text, other_struct.body_text))
    return false;
  if (!mojo::Equals(this->button_text, other_struct.button_text))
    return false;
  return true;
}

template <typename T, Promo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.icon_name < rhs.icon_name)
    return true;
  if (rhs.icon_name < lhs.icon_name)
    return false;
  if (lhs.body_text < rhs.body_text)
    return true;
  if (rhs.body_text < lhs.body_text)
    return false;
  if (lhs.button_text < rhs.button_text)
    return true;
  if (rhs.button_text < lhs.button_text)
    return false;
  return false;
}


}  // ntp_promo::mojom

namespace mojo {


template <>
struct  StructTraits<::ntp_promo::mojom::PromosShown::DataView,
                                         ::ntp_promo::mojom::PromosShownPtr> {
  static bool IsNull(const ::ntp_promo::mojom::PromosShownPtr& input) { return !input; }
  static void SetToNull(::ntp_promo::mojom::PromosShownPtr* output) { output->reset(); }

  static const decltype(::ntp_promo::mojom::PromosShown::eligible)& eligible(
      const ::ntp_promo::mojom::PromosShownPtr& input) {
    return input->eligible;
  }

  static const decltype(::ntp_promo::mojom::PromosShown::completed)& completed(
      const ::ntp_promo::mojom::PromosShownPtr& input) {
    return input->completed;
  }

  static bool Read(::ntp_promo::mojom::PromosShown::DataView input, ::ntp_promo::mojom::PromosShownPtr* output);
};


template <>
struct  StructTraits<::ntp_promo::mojom::Promo::DataView,
                                         ::ntp_promo::mojom::PromoPtr> {
  static bool IsNull(const ::ntp_promo::mojom::PromoPtr& input) { return !input; }
  static void SetToNull(::ntp_promo::mojom::PromoPtr* output) { output->reset(); }

  static const decltype(::ntp_promo::mojom::Promo::id)& id(
      const ::ntp_promo::mojom::PromoPtr& input) {
    return input->id;
  }

  static const decltype(::ntp_promo::mojom::Promo::icon_name)& icon_name(
      const ::ntp_promo::mojom::PromoPtr& input) {
    return input->icon_name;
  }

  static const decltype(::ntp_promo::mojom::Promo::body_text)& body_text(
      const ::ntp_promo::mojom::PromoPtr& input) {
    return input->body_text;
  }

  static const decltype(::ntp_promo::mojom::Promo::button_text)& button_text(
      const ::ntp_promo::mojom::PromoPtr& input) {
    return input->button_text;
  }

  static bool Read(::ntp_promo::mojom::Promo::DataView input, ::ntp_promo::mojom::PromoPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_NEW_TAB_PAGE_NTP_PROMO_NTP_PROMO_MOJOM_H_