// chrome/browser/ui/webui/downloads/downloads.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/downloads/downloads.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/downloads/downloads.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/downloads/downloads.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace downloads::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "downloads.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "downloads.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDownloadsMinVersion = 0,
    kOpenFileRequiringGestureMinVersion = 0,
    kDragMinVersion = 0,
    kSaveSuspiciousRequiringGestureMinVersion = 0,
    kRecordOpenBypassWarningDialogMinVersion = 0,
    kSaveDangerousFromDialogRequiringGestureMinVersion = 0,
    kRecordCancelBypassWarningDialogMinVersion = 0,
    kDiscardDangerousMinVersion = 0,
    kRetryDownloadMinVersion = 0,
    kShowMinVersion = 0,
    kPauseMinVersion = 0,
    kResumeMinVersion = 0,
    kRemoveMinVersion = 0,
    kUndoMinVersion = 0,
    kCancelMinVersion = 0,
    kClearAllMinVersion = 0,
    kOpenDownloadsFolderRequiringGestureMinVersion = 0,
    kOpenEsbSettingsMinVersion = 0,
    kLogEsbPromotionRowViewedMinVersion = 0,
    kOpenDuringScanningRequiringGestureMinVersion = 0,
    kReviewDangerousRequiringGestureMinVersion = 0,
    kDeepScanMinVersion = 0,
    kBypassDeepScanRequiringGestureMinVersion = 0,
    kIsEligibleForEsbPromoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDownloads_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenFileRequiringGesture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Drag_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveSuspiciousRequiringGesture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordOpenBypassWarningDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SaveDangerousFromDialogRequiringGesture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordCancelBypassWarningDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DiscardDangerous_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RetryDownload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Show_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Pause_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Resume_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Remove_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Undo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Cancel_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenDownloadsFolderRequiringGesture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenEsbSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LogEsbPromotionRowViewed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenDuringScanningRequiringGesture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReviewDangerousRequiringGesture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeepScan_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BypassDeepScanRequiringGesture_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IsEligibleForEsbPromo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void GetDownloads(const std::vector<std::string>& search_terms) = 0;

  virtual void OpenFileRequiringGesture(const std::string& id) = 0;

  virtual void Drag(const std::string& id) = 0;

  virtual void SaveSuspiciousRequiringGesture(const std::string& id) = 0;

  virtual void RecordOpenBypassWarningDialog(const std::string& id) = 0;

  virtual void SaveDangerousFromDialogRequiringGesture(const std::string& id) = 0;

  virtual void RecordCancelBypassWarningDialog(const std::string& id) = 0;

  virtual void DiscardDangerous(const std::string& id) = 0;

  virtual void RetryDownload(const std::string& id) = 0;

  virtual void Show(const std::string& id) = 0;

  virtual void Pause(const std::string& id) = 0;

  virtual void Resume(const std::string& id) = 0;

  virtual void Remove(const std::string& id) = 0;

  virtual void Undo() = 0;

  virtual void Cancel(const std::string& id) = 0;

  virtual void ClearAll() = 0;

  virtual void OpenDownloadsFolderRequiringGesture() = 0;

  virtual void OpenEsbSettings() = 0;

  virtual void LogEsbPromotionRowViewed() = 0;

  virtual void OpenDuringScanningRequiringGesture(const std::string& id) = 0;

  virtual void ReviewDangerousRequiringGesture(const std::string& id) = 0;

  virtual void DeepScan(const std::string& id) = 0;

  virtual void BypassDeepScanRequiringGesture(const std::string& id) = 0;

  using IsEligibleForEsbPromoCallback = base::OnceCallback<void(bool)>;
  using IsEligibleForEsbPromoMojoCallback = base::OnceCallback<void(bool)>;

  virtual void IsEligibleForEsbPromo(IsEligibleForEsbPromoCallback callback) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "downloads.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kRemoveItemMinVersion = 0,
    kUpdateItemMinVersion = 0,
    kInsertItemsMinVersion = 0,
    kClearAllMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RemoveItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InsertItems_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ClearAll_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void RemoveItem(int32_t index) = 0;

  virtual void UpdateItem(int32_t index, DataPtr data) = 0;

  virtual void InsertItems(int32_t index, std::vector<DataPtr> items) = 0;

  virtual void ClearAll() = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDownloads(const std::vector<std::string>& search_terms) final;
  
  void OpenFileRequiringGesture(const std::string& id) final;
  
  void Drag(const std::string& id) final;
  
  void SaveSuspiciousRequiringGesture(const std::string& id) final;
  
  void RecordOpenBypassWarningDialog(const std::string& id) final;
  
  void SaveDangerousFromDialogRequiringGesture(const std::string& id) final;
  
  void RecordCancelBypassWarningDialog(const std::string& id) final;
  
  void DiscardDangerous(const std::string& id) final;
  
  void RetryDownload(const std::string& id) final;
  
  void Show(const std::string& id) final;
  
  void Pause(const std::string& id) final;
  
  void Resume(const std::string& id) final;
  
  void Remove(const std::string& id) final;
  
  void Undo() final;
  
  void Cancel(const std::string& id) final;
  
  void ClearAll() final;
  
  void OpenDownloadsFolderRequiringGesture() final;
  
  void OpenEsbSettings() final;
  
  void LogEsbPromotionRowViewed() final;
  
  void OpenDuringScanningRequiringGesture(const std::string& id) final;
  
  void ReviewDangerousRequiringGesture(const std::string& id) final;
  
  void DeepScan(const std::string& id) final;
  
  void BypassDeepScanRequiringGesture(const std::string& id) final;
  
  void IsEligibleForEsbPromo(IsEligibleForEsbPromoCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RemoveItem(int32_t index) final;
  
  void UpdateItem(int32_t index, DataPtr data) final;
  
  void InsertItems(int32_t index, std::vector<DataPtr> items) final;
  
  void ClearAll() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  Data {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Data, T>::value>;
  using DataView = DataDataView;
  using Data_ = internal::Data_Data;

  template <typename... Args>
  static DataPtr New(Args&&... args) {
    return DataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DataPtr From(const U& u) {
    return mojo::TypeConverter<DataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Data>::Convert(*this);
  }


  Data();

  Data(
      bool file_externally_removed,
      bool is_dangerous,
      bool is_insecure,
      bool is_reviewable,
      bool otr,
      bool resume,
      bool retry,
      int32_t percent,
      int32_t started,
      int64_t total,
      const std::string& by_ext_id,
      const std::string& by_ext_name,
      DangerType danger_type,
      TailoredWarningType tailored_warning_type,
      const std::string& date_string,
      const std::string& file_name,
      const std::string& file_path,
      const std::string& file_url,
      const std::string& id,
      const std::string& last_reason_text,
      const std::string& progress_status_text,
      const std::string& show_in_folder_text,
      const std::string& since_string,
      State state,
      const ::std::u16string& display_initiator_origin,
      const std::optional<::GURL>& url,
      const ::std::u16string& display_url,
      SafeBrowsingState safe_browsing_state,
      bool has_safe_browsing_verdict);


  ~Data();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DataPtr>
  DataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Data::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Data::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Data::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Data::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Data::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Data::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Data_UnserializedMessageContext<
            UserType, Data::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Data::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Data::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Data_UnserializedMessageContext<
            UserType, Data::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Data::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool file_externally_removed;
  
  bool is_dangerous;
  
  bool is_insecure;
  
  bool is_reviewable;
  
  bool otr;
  
  bool resume;
  
  bool retry;
  
  int32_t percent;
  
  int32_t started;
  
  int64_t total;
  
  std::string by_ext_id;
  
  std::string by_ext_name;
  
  DangerType danger_type;
  
  TailoredWarningType tailored_warning_type;
  
  std::string date_string;
  
  std::string file_name;
  
  std::string file_path;
  
  std::string file_url;
  
  std::string id;
  
  std::string last_reason_text;
  
  std::string progress_status_text;
  
  std::string show_in_folder_text;
  
  std::string since_string;
  
  State state;
  
  ::std::u16string display_initiator_origin;
  
  std::optional<::GURL> url;
  
  ::std::u16string display_url;
  
  SafeBrowsingState safe_browsing_state;
  
  bool has_safe_browsing_verdict;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Data::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Data::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Data::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Data::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DataPtr Data::Clone() const {
  return New(
      mojo::Clone(file_externally_removed),
      mojo::Clone(is_dangerous),
      mojo::Clone(is_insecure),
      mojo::Clone(is_reviewable),
      mojo::Clone(otr),
      mojo::Clone(resume),
      mojo::Clone(retry),
      mojo::Clone(percent),
      mojo::Clone(started),
      mojo::Clone(total),
      mojo::Clone(by_ext_id),
      mojo::Clone(by_ext_name),
      mojo::Clone(danger_type),
      mojo::Clone(tailored_warning_type),
      mojo::Clone(date_string),
      mojo::Clone(file_name),
      mojo::Clone(file_path),
      mojo::Clone(file_url),
      mojo::Clone(id),
      mojo::Clone(last_reason_text),
      mojo::Clone(progress_status_text),
      mojo::Clone(show_in_folder_text),
      mojo::Clone(since_string),
      mojo::Clone(state),
      mojo::Clone(display_initiator_origin),
      mojo::Clone(url),
      mojo::Clone(display_url),
      mojo::Clone(safe_browsing_state),
      mojo::Clone(has_safe_browsing_verdict)
  );
}

template <typename T, Data::EnableIfSame<T>*>
bool Data::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->file_externally_removed, other_struct.file_externally_removed))
    return false;
  if (!mojo::Equals(this->is_dangerous, other_struct.is_dangerous))
    return false;
  if (!mojo::Equals(this->is_insecure, other_struct.is_insecure))
    return false;
  if (!mojo::Equals(this->is_reviewable, other_struct.is_reviewable))
    return false;
  if (!mojo::Equals(this->otr, other_struct.otr))
    return false;
  if (!mojo::Equals(this->resume, other_struct.resume))
    return false;
  if (!mojo::Equals(this->retry, other_struct.retry))
    return false;
  if (!mojo::Equals(this->percent, other_struct.percent))
    return false;
  if (!mojo::Equals(this->started, other_struct.started))
    return false;
  if (!mojo::Equals(this->total, other_struct.total))
    return false;
  if (!mojo::Equals(this->by_ext_id, other_struct.by_ext_id))
    return false;
  if (!mojo::Equals(this->by_ext_name, other_struct.by_ext_name))
    return false;
  if (!mojo::Equals(this->danger_type, other_struct.danger_type))
    return false;
  if (!mojo::Equals(this->tailored_warning_type, other_struct.tailored_warning_type))
    return false;
  if (!mojo::Equals(this->date_string, other_struct.date_string))
    return false;
  if (!mojo::Equals(this->file_name, other_struct.file_name))
    return false;
  if (!mojo::Equals(this->file_path, other_struct.file_path))
    return false;
  if (!mojo::Equals(this->file_url, other_struct.file_url))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->last_reason_text, other_struct.last_reason_text))
    return false;
  if (!mojo::Equals(this->progress_status_text, other_struct.progress_status_text))
    return false;
  if (!mojo::Equals(this->show_in_folder_text, other_struct.show_in_folder_text))
    return false;
  if (!mojo::Equals(this->since_string, other_struct.since_string))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->display_initiator_origin, other_struct.display_initiator_origin))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->display_url, other_struct.display_url))
    return false;
  if (!mojo::Equals(this->safe_browsing_state, other_struct.safe_browsing_state))
    return false;
  if (!mojo::Equals(this->has_safe_browsing_verdict, other_struct.has_safe_browsing_verdict))
    return false;
  return true;
}

template <typename T, Data::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.file_externally_removed < rhs.file_externally_removed)
    return true;
  if (rhs.file_externally_removed < lhs.file_externally_removed)
    return false;
  if (lhs.is_dangerous < rhs.is_dangerous)
    return true;
  if (rhs.is_dangerous < lhs.is_dangerous)
    return false;
  if (lhs.is_insecure < rhs.is_insecure)
    return true;
  if (rhs.is_insecure < lhs.is_insecure)
    return false;
  if (lhs.is_reviewable < rhs.is_reviewable)
    return true;
  if (rhs.is_reviewable < lhs.is_reviewable)
    return false;
  if (lhs.otr < rhs.otr)
    return true;
  if (rhs.otr < lhs.otr)
    return false;
  if (lhs.resume < rhs.resume)
    return true;
  if (rhs.resume < lhs.resume)
    return false;
  if (lhs.retry < rhs.retry)
    return true;
  if (rhs.retry < lhs.retry)
    return false;
  if (lhs.percent < rhs.percent)
    return true;
  if (rhs.percent < lhs.percent)
    return false;
  if (lhs.started < rhs.started)
    return true;
  if (rhs.started < lhs.started)
    return false;
  if (lhs.total < rhs.total)
    return true;
  if (rhs.total < lhs.total)
    return false;
  if (lhs.by_ext_id < rhs.by_ext_id)
    return true;
  if (rhs.by_ext_id < lhs.by_ext_id)
    return false;
  if (lhs.by_ext_name < rhs.by_ext_name)
    return true;
  if (rhs.by_ext_name < lhs.by_ext_name)
    return false;
  if (lhs.danger_type < rhs.danger_type)
    return true;
  if (rhs.danger_type < lhs.danger_type)
    return false;
  if (lhs.tailored_warning_type < rhs.tailored_warning_type)
    return true;
  if (rhs.tailored_warning_type < lhs.tailored_warning_type)
    return false;
  if (lhs.date_string < rhs.date_string)
    return true;
  if (rhs.date_string < lhs.date_string)
    return false;
  if (lhs.file_name < rhs.file_name)
    return true;
  if (rhs.file_name < lhs.file_name)
    return false;
  if (lhs.file_path < rhs.file_path)
    return true;
  if (rhs.file_path < lhs.file_path)
    return false;
  if (lhs.file_url < rhs.file_url)
    return true;
  if (rhs.file_url < lhs.file_url)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.last_reason_text < rhs.last_reason_text)
    return true;
  if (rhs.last_reason_text < lhs.last_reason_text)
    return false;
  if (lhs.progress_status_text < rhs.progress_status_text)
    return true;
  if (rhs.progress_status_text < lhs.progress_status_text)
    return false;
  if (lhs.show_in_folder_text < rhs.show_in_folder_text)
    return true;
  if (rhs.show_in_folder_text < lhs.show_in_folder_text)
    return false;
  if (lhs.since_string < rhs.since_string)
    return true;
  if (rhs.since_string < lhs.since_string)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  if (lhs.display_initiator_origin < rhs.display_initiator_origin)
    return true;
  if (rhs.display_initiator_origin < lhs.display_initiator_origin)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.display_url < rhs.display_url)
    return true;
  if (rhs.display_url < lhs.display_url)
    return false;
  if (lhs.safe_browsing_state < rhs.safe_browsing_state)
    return true;
  if (rhs.safe_browsing_state < lhs.safe_browsing_state)
    return false;
  if (lhs.has_safe_browsing_verdict < rhs.has_safe_browsing_verdict)
    return true;
  if (rhs.has_safe_browsing_verdict < lhs.has_safe_browsing_verdict)
    return false;
  return false;
}


}  // downloads::mojom

namespace mojo {


template <>
struct  StructTraits<::downloads::mojom::Data::DataView,
                                         ::downloads::mojom::DataPtr> {
  static bool IsNull(const ::downloads::mojom::DataPtr& input) { return !input; }
  static void SetToNull(::downloads::mojom::DataPtr* output) { output->reset(); }

  static decltype(::downloads::mojom::Data::file_externally_removed) file_externally_removed(
      const ::downloads::mojom::DataPtr& input) {
    return input->file_externally_removed;
  }

  static decltype(::downloads::mojom::Data::is_dangerous) is_dangerous(
      const ::downloads::mojom::DataPtr& input) {
    return input->is_dangerous;
  }

  static decltype(::downloads::mojom::Data::is_insecure) is_insecure(
      const ::downloads::mojom::DataPtr& input) {
    return input->is_insecure;
  }

  static decltype(::downloads::mojom::Data::is_reviewable) is_reviewable(
      const ::downloads::mojom::DataPtr& input) {
    return input->is_reviewable;
  }

  static decltype(::downloads::mojom::Data::otr) otr(
      const ::downloads::mojom::DataPtr& input) {
    return input->otr;
  }

  static decltype(::downloads::mojom::Data::resume) resume(
      const ::downloads::mojom::DataPtr& input) {
    return input->resume;
  }

  static decltype(::downloads::mojom::Data::retry) retry(
      const ::downloads::mojom::DataPtr& input) {
    return input->retry;
  }

  static decltype(::downloads::mojom::Data::percent) percent(
      const ::downloads::mojom::DataPtr& input) {
    return input->percent;
  }

  static decltype(::downloads::mojom::Data::started) started(
      const ::downloads::mojom::DataPtr& input) {
    return input->started;
  }

  static decltype(::downloads::mojom::Data::total) total(
      const ::downloads::mojom::DataPtr& input) {
    return input->total;
  }

  static const decltype(::downloads::mojom::Data::by_ext_id)& by_ext_id(
      const ::downloads::mojom::DataPtr& input) {
    return input->by_ext_id;
  }

  static const decltype(::downloads::mojom::Data::by_ext_name)& by_ext_name(
      const ::downloads::mojom::DataPtr& input) {
    return input->by_ext_name;
  }

  static decltype(::downloads::mojom::Data::danger_type) danger_type(
      const ::downloads::mojom::DataPtr& input) {
    return input->danger_type;
  }

  static decltype(::downloads::mojom::Data::tailored_warning_type) tailored_warning_type(
      const ::downloads::mojom::DataPtr& input) {
    return input->tailored_warning_type;
  }

  static const decltype(::downloads::mojom::Data::date_string)& date_string(
      const ::downloads::mojom::DataPtr& input) {
    return input->date_string;
  }

  static const decltype(::downloads::mojom::Data::file_name)& file_name(
      const ::downloads::mojom::DataPtr& input) {
    return input->file_name;
  }

  static const decltype(::downloads::mojom::Data::file_path)& file_path(
      const ::downloads::mojom::DataPtr& input) {
    return input->file_path;
  }

  static const decltype(::downloads::mojom::Data::file_url)& file_url(
      const ::downloads::mojom::DataPtr& input) {
    return input->file_url;
  }

  static const decltype(::downloads::mojom::Data::id)& id(
      const ::downloads::mojom::DataPtr& input) {
    return input->id;
  }

  static const decltype(::downloads::mojom::Data::last_reason_text)& last_reason_text(
      const ::downloads::mojom::DataPtr& input) {
    return input->last_reason_text;
  }

  static const decltype(::downloads::mojom::Data::progress_status_text)& progress_status_text(
      const ::downloads::mojom::DataPtr& input) {
    return input->progress_status_text;
  }

  static const decltype(::downloads::mojom::Data::show_in_folder_text)& show_in_folder_text(
      const ::downloads::mojom::DataPtr& input) {
    return input->show_in_folder_text;
  }

  static const decltype(::downloads::mojom::Data::since_string)& since_string(
      const ::downloads::mojom::DataPtr& input) {
    return input->since_string;
  }

  static decltype(::downloads::mojom::Data::state) state(
      const ::downloads::mojom::DataPtr& input) {
    return input->state;
  }

  static const decltype(::downloads::mojom::Data::display_initiator_origin)& display_initiator_origin(
      const ::downloads::mojom::DataPtr& input) {
    return input->display_initiator_origin;
  }

  static const decltype(::downloads::mojom::Data::url)& url(
      const ::downloads::mojom::DataPtr& input) {
    return input->url;
  }

  static const decltype(::downloads::mojom::Data::display_url)& display_url(
      const ::downloads::mojom::DataPtr& input) {
    return input->display_url;
  }

  static decltype(::downloads::mojom::Data::safe_browsing_state) safe_browsing_state(
      const ::downloads::mojom::DataPtr& input) {
    return input->safe_browsing_state;
  }

  static decltype(::downloads::mojom::Data::has_safe_browsing_verdict) has_safe_browsing_verdict(
      const ::downloads::mojom::DataPtr& input) {
    return input->has_safe_browsing_verdict;
  }

  static bool Read(::downloads::mojom::Data::DataView input, ::downloads::mojom::DataPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_DOWNLOADS_DOWNLOADS_MOJOM_H_