// chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom-params-data.h"
#include "chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom-import-headers.h"
#include "chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom-test-utils.h"


namespace customize_buttons::mojom {
// The declaration includes the definition on other builds.

CustomizeButtonsHandlerFactory::IPCStableHashFunction CustomizeButtonsHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomizeButtonsHandlerFactory>(message.name())) {
    case messages::CustomizeButtonsHandlerFactory::kCreateCustomizeButtonsHandler: {
      return &CustomizeButtonsHandlerFactory::CreateCustomizeButtonsHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomizeButtonsHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomizeButtonsHandlerFactory>(message.name())) {
      case messages::CustomizeButtonsHandlerFactory::kCreateCustomizeButtonsHandler:
            return "Receive customize_buttons::mojom::CustomizeButtonsHandlerFactory::CreateCustomizeButtonsHandler";
    }
  } else {
    switch (static_cast<messages::CustomizeButtonsHandlerFactory>(message.name())) {
      case messages::CustomizeButtonsHandlerFactory::kCreateCustomizeButtonsHandler:
            return "Receive reply customize_buttons::mojom::CustomizeButtonsHandlerFactory::CreateCustomizeButtonsHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomizeButtonsHandlerFactory::CreateCustomizeButtonsHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x06fc5368;  // IPCStableHash for customize_buttons::mojom::CustomizeButtonsHandlerFactory::CreateCustomizeButtonsHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CustomizeButtonsHandlerFactoryProxy::CustomizeButtonsHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomizeButtonsHandlerFactoryProxy::CreateCustomizeButtonsHandler(
    ::mojo::PendingRemote<CustomizeButtonsDocument> in_page, ::mojo::PendingReceiver<CustomizeButtonsHandler> in_handler) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send customize_buttons::mojom::CustomizeButtonsHandlerFactory::CreateCustomizeButtonsHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("page"), in_page,
                        "<value of type ::mojo::PendingRemote<CustomizeButtonsDocument>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<CustomizeButtonsHandler>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeButtonsHandlerFactory::kCreateCustomizeButtonsHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::customize_buttons::mojom::internal::CustomizeButtonsHandlerFactory_CreateCustomizeButtonsHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::customize_buttons::mojom::CustomizeButtonsDocumentInterfaceBase>>(
    in_page,
    &params->page,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->page)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid page in CustomizeButtonsHandlerFactory.CreateCustomizeButtonsHandler request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::customize_buttons::mojom::CustomizeButtonsHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in CustomizeButtonsHandlerFactory.CreateCustomizeButtonsHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeButtonsHandlerFactory::Name_);
  message.set_method_name("CreateCustomizeButtonsHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CustomizeButtonsHandlerFactoryStubDispatch::Accept(
    CustomizeButtonsHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomizeButtonsHandlerFactory>(message->header()->name)) {
    case messages::CustomizeButtonsHandlerFactory::kCreateCustomizeButtonsHandler: {
      DCHECK(message->is_serialized());
      internal::CustomizeButtonsHandlerFactory_CreateCustomizeButtonsHandler_Params_Data* params =
          reinterpret_cast<internal::CustomizeButtonsHandlerFactory_CreateCustomizeButtonsHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeButtonsHandlerFactory.0
      bool success = true;
      ::mojo::PendingRemote<CustomizeButtonsDocument> p_page{};
      ::mojo::PendingReceiver<CustomizeButtonsHandler> p_handler{};
      CustomizeButtonsHandlerFactory_CreateCustomizeButtonsHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_page =
            input_data_view.TakePage<decltype(p_page)>();
      }
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeButtonsHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCustomizeButtonsHandler(        
        std::move(p_page), 
        std::move(p_handler));
      return true;
    }
  }
  return false;
}

// static
bool CustomizeButtonsHandlerFactoryStubDispatch::AcceptWithResponder(
    CustomizeButtonsHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomizeButtonsHandlerFactory>(message->header()->name)) {
    case messages::CustomizeButtonsHandlerFactory::kCreateCustomizeButtonsHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCustomizeButtonsHandlerFactoryValidationInfo[] = {
    { &internal::CustomizeButtonsHandlerFactory_CreateCustomizeButtonsHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool CustomizeButtonsHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::customize_buttons::mojom::CustomizeButtonsHandlerFactory::Name_,
    kCustomizeButtonsHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

CustomizeButtonsHandler::IPCStableHashFunction CustomizeButtonsHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomizeButtonsHandler>(message.name())) {
    case messages::CustomizeButtonsHandler::kIncrementCustomizeChromeButtonOpenCount: {
      return &CustomizeButtonsHandler::IncrementCustomizeChromeButtonOpenCount_Sym::IPCStableHash;
    }
    case messages::CustomizeButtonsHandler::kIncrementWallpaperSearchButtonShownCount: {
      return &CustomizeButtonsHandler::IncrementWallpaperSearchButtonShownCount_Sym::IPCStableHash;
    }
    case messages::CustomizeButtonsHandler::kSetCustomizeChromeSidePanelVisible: {
      return &CustomizeButtonsHandler::SetCustomizeChromeSidePanelVisible_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomizeButtonsHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomizeButtonsHandler>(message.name())) {
      case messages::CustomizeButtonsHandler::kIncrementCustomizeChromeButtonOpenCount:
            return "Receive customize_buttons::mojom::CustomizeButtonsHandler::IncrementCustomizeChromeButtonOpenCount";
      case messages::CustomizeButtonsHandler::kIncrementWallpaperSearchButtonShownCount:
            return "Receive customize_buttons::mojom::CustomizeButtonsHandler::IncrementWallpaperSearchButtonShownCount";
      case messages::CustomizeButtonsHandler::kSetCustomizeChromeSidePanelVisible:
            return "Receive customize_buttons::mojom::CustomizeButtonsHandler::SetCustomizeChromeSidePanelVisible";
    }
  } else {
    switch (static_cast<messages::CustomizeButtonsHandler>(message.name())) {
      case messages::CustomizeButtonsHandler::kIncrementCustomizeChromeButtonOpenCount:
            return "Receive reply customize_buttons::mojom::CustomizeButtonsHandler::IncrementCustomizeChromeButtonOpenCount";
      case messages::CustomizeButtonsHandler::kIncrementWallpaperSearchButtonShownCount:
            return "Receive reply customize_buttons::mojom::CustomizeButtonsHandler::IncrementWallpaperSearchButtonShownCount";
      case messages::CustomizeButtonsHandler::kSetCustomizeChromeSidePanelVisible:
            return "Receive reply customize_buttons::mojom::CustomizeButtonsHandler::SetCustomizeChromeSidePanelVisible";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomizeButtonsHandler::IncrementCustomizeChromeButtonOpenCount_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2398105a;  // IPCStableHash for customize_buttons::mojom::CustomizeButtonsHandler::IncrementCustomizeChromeButtonOpenCount
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeButtonsHandler::IncrementWallpaperSearchButtonShownCount_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd90d114;  // IPCStableHash for customize_buttons::mojom::CustomizeButtonsHandler::IncrementWallpaperSearchButtonShownCount
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t CustomizeButtonsHandler::SetCustomizeChromeSidePanelVisible_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x79342ced;  // IPCStableHash for customize_buttons::mojom::CustomizeButtonsHandler::SetCustomizeChromeSidePanelVisible
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CustomizeButtonsHandlerProxy::CustomizeButtonsHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomizeButtonsHandlerProxy::IncrementCustomizeChromeButtonOpenCount(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send customize_buttons::mojom::CustomizeButtonsHandler::IncrementCustomizeChromeButtonOpenCount");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeButtonsHandler::kIncrementCustomizeChromeButtonOpenCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::customize_buttons::mojom::internal::CustomizeButtonsHandler_IncrementCustomizeChromeButtonOpenCount_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeButtonsHandler::Name_);
  message.set_method_name("IncrementCustomizeChromeButtonOpenCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeButtonsHandlerProxy::IncrementWallpaperSearchButtonShownCount(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send customize_buttons::mojom::CustomizeButtonsHandler::IncrementWallpaperSearchButtonShownCount");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeButtonsHandler::kIncrementWallpaperSearchButtonShownCount), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::customize_buttons::mojom::internal::CustomizeButtonsHandler_IncrementWallpaperSearchButtonShownCount_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeButtonsHandler::Name_);
  message.set_method_name("IncrementWallpaperSearchButtonShownCount");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void CustomizeButtonsHandlerProxy::SetCustomizeChromeSidePanelVisible(
    bool in_visible, CustomizeChromeSection in_section, SidePanelOpenTrigger in_trigger) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send customize_buttons::mojom::CustomizeButtonsHandler::SetCustomizeChromeSidePanelVisible", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("section"), in_section,
                        "<value of type CustomizeChromeSection>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("trigger"), in_trigger,
                        "<value of type SidePanelOpenTrigger>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeButtonsHandler::kSetCustomizeChromeSidePanelVisible), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::customize_buttons::mojom::internal::CustomizeButtonsHandler_SetCustomizeChromeSidePanelVisible_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

  
  mojo::internal::Serialize<::customize_buttons::mojom::CustomizeChromeSection>(
    in_section,
    &params->section);

  
  mojo::internal::Serialize<::customize_buttons::mojom::SidePanelOpenTrigger>(
    in_trigger,
    &params->trigger);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeButtonsHandler::Name_);
  message.set_method_name("SetCustomizeChromeSidePanelVisible");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CustomizeButtonsHandlerStubDispatch::Accept(
    CustomizeButtonsHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomizeButtonsHandler>(message->header()->name)) {
    case messages::CustomizeButtonsHandler::kIncrementCustomizeChromeButtonOpenCount: {
      DCHECK(message->is_serialized());
      internal::CustomizeButtonsHandler_IncrementCustomizeChromeButtonOpenCount_Params_Data* params =
          reinterpret_cast<internal::CustomizeButtonsHandler_IncrementCustomizeChromeButtonOpenCount_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeButtonsHandler.0
      bool success = true;
      CustomizeButtonsHandler_IncrementCustomizeChromeButtonOpenCount_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeButtonsHandler::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IncrementCustomizeChromeButtonOpenCount(        );
      return true;
    }
    case messages::CustomizeButtonsHandler::kIncrementWallpaperSearchButtonShownCount: {
      DCHECK(message->is_serialized());
      internal::CustomizeButtonsHandler_IncrementWallpaperSearchButtonShownCount_Params_Data* params =
          reinterpret_cast<internal::CustomizeButtonsHandler_IncrementWallpaperSearchButtonShownCount_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeButtonsHandler.1
      bool success = true;
      CustomizeButtonsHandler_IncrementWallpaperSearchButtonShownCount_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeButtonsHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IncrementWallpaperSearchButtonShownCount(        );
      return true;
    }
    case messages::CustomizeButtonsHandler::kSetCustomizeChromeSidePanelVisible: {
      DCHECK(message->is_serialized());
      internal::CustomizeButtonsHandler_SetCustomizeChromeSidePanelVisible_Params_Data* params =
          reinterpret_cast<internal::CustomizeButtonsHandler_SetCustomizeChromeSidePanelVisible_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeButtonsHandler.2
      bool success = true;
      bool p_visible{};
      CustomizeChromeSection p_section{};
      SidePanelOpenTrigger p_trigger{};
      CustomizeButtonsHandler_SetCustomizeChromeSidePanelVisible_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (success && !input_data_view.ReadSection(&p_section))
        success = false;
      if (success && !input_data_view.ReadTrigger(&p_trigger))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeButtonsHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCustomizeChromeSidePanelVisible(        
        std::move(p_visible), 
        std::move(p_section), 
        std::move(p_trigger));
      return true;
    }
  }
  return false;
}

// static
bool CustomizeButtonsHandlerStubDispatch::AcceptWithResponder(
    CustomizeButtonsHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomizeButtonsHandler>(message->header()->name)) {
    case messages::CustomizeButtonsHandler::kIncrementCustomizeChromeButtonOpenCount: {
      break;
    }
    case messages::CustomizeButtonsHandler::kIncrementWallpaperSearchButtonShownCount: {
      break;
    }
    case messages::CustomizeButtonsHandler::kSetCustomizeChromeSidePanelVisible: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCustomizeButtonsHandlerValidationInfo[] = {
    { &internal::CustomizeButtonsHandler_IncrementCustomizeChromeButtonOpenCount_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeButtonsHandler_IncrementWallpaperSearchButtonShownCount_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::CustomizeButtonsHandler_SetCustomizeChromeSidePanelVisible_Params_Data::Validate,
     nullptr /* no response */},
};

bool CustomizeButtonsHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::customize_buttons::mojom::CustomizeButtonsHandler::Name_,
    kCustomizeButtonsHandlerValidationInfo);
}

// The declaration includes the definition on other builds.

CustomizeButtonsDocument::IPCStableHashFunction CustomizeButtonsDocument::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::CustomizeButtonsDocument>(message.name())) {
    case messages::CustomizeButtonsDocument::kSetCustomizeChromeSidePanelVisibility: {
      return &CustomizeButtonsDocument::SetCustomizeChromeSidePanelVisibility_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* CustomizeButtonsDocument::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::CustomizeButtonsDocument>(message.name())) {
      case messages::CustomizeButtonsDocument::kSetCustomizeChromeSidePanelVisibility:
            return "Receive customize_buttons::mojom::CustomizeButtonsDocument::SetCustomizeChromeSidePanelVisibility";
    }
  } else {
    switch (static_cast<messages::CustomizeButtonsDocument>(message.name())) {
      case messages::CustomizeButtonsDocument::kSetCustomizeChromeSidePanelVisibility:
            return "Receive reply customize_buttons::mojom::CustomizeButtonsDocument::SetCustomizeChromeSidePanelVisibility";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t CustomizeButtonsDocument::SetCustomizeChromeSidePanelVisibility_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x356ecf68;  // IPCStableHash for customize_buttons::mojom::CustomizeButtonsDocument::SetCustomizeChromeSidePanelVisibility
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

CustomizeButtonsDocumentProxy::CustomizeButtonsDocumentProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomizeButtonsDocumentProxy::SetCustomizeChromeSidePanelVisibility(
    bool in_visible) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send customize_buttons::mojom::CustomizeButtonsDocument::SetCustomizeChromeSidePanelVisibility", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("visible"), in_visible,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::CustomizeButtonsDocument::kSetCustomizeChromeSidePanelVisibility), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::customize_buttons::mojom::internal::CustomizeButtonsDocument_SetCustomizeChromeSidePanelVisibility_Params_Data> params(
          message);
  params.Allocate();

  params->visible = in_visible;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomizeButtonsDocument::Name_);
  message.set_method_name("SetCustomizeChromeSidePanelVisibility");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool CustomizeButtonsDocumentStubDispatch::Accept(
    CustomizeButtonsDocument* impl,
    mojo::Message* message) {
  switch (static_cast<messages::CustomizeButtonsDocument>(message->header()->name)) {
    case messages::CustomizeButtonsDocument::kSetCustomizeChromeSidePanelVisibility: {
      DCHECK(message->is_serialized());
      internal::CustomizeButtonsDocument_SetCustomizeChromeSidePanelVisibility_Params_Data* params =
          reinterpret_cast<internal::CustomizeButtonsDocument_SetCustomizeChromeSidePanelVisibility_Params_Data*>(
              message->mutable_payload());
      

      // Validation for CustomizeButtonsDocument.0
      bool success = true;
      bool p_visible{};
      CustomizeButtonsDocument_SetCustomizeChromeSidePanelVisibility_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_visible = input_data_view.visible();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomizeButtonsDocument::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCustomizeChromeSidePanelVisibility(        
        std::move(p_visible));
      return true;
    }
  }
  return false;
}

// static
bool CustomizeButtonsDocumentStubDispatch::AcceptWithResponder(
    CustomizeButtonsDocument* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::CustomizeButtonsDocument>(message->header()->name)) {
    case messages::CustomizeButtonsDocument::kSetCustomizeChromeSidePanelVisibility: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kCustomizeButtonsDocumentValidationInfo[] = {
    { &internal::CustomizeButtonsDocument_SetCustomizeChromeSidePanelVisibility_Params_Data::Validate,
     nullptr /* no response */},
};

bool CustomizeButtonsDocumentRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::customize_buttons::mojom::CustomizeButtonsDocument::Name_,
    kCustomizeButtonsDocumentValidationInfo);
}



}  // customize_buttons::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace customize_buttons::mojom {


void CustomizeButtonsHandlerFactoryInterceptorForTesting::CreateCustomizeButtonsHandler(::mojo::PendingRemote<CustomizeButtonsDocument> page, ::mojo::PendingReceiver<CustomizeButtonsHandler> handler) {
  GetForwardingInterface()->CreateCustomizeButtonsHandler(
    std::move(page)
    , 
    std::move(handler)
    );
}
CustomizeButtonsHandlerFactoryAsyncWaiter::CustomizeButtonsHandlerFactoryAsyncWaiter(
    CustomizeButtonsHandlerFactory* proxy) : proxy_(proxy) {}

CustomizeButtonsHandlerFactoryAsyncWaiter::~CustomizeButtonsHandlerFactoryAsyncWaiter() = default;





void CustomizeButtonsHandlerInterceptorForTesting::IncrementCustomizeChromeButtonOpenCount() {
  GetForwardingInterface()->IncrementCustomizeChromeButtonOpenCount();
}
void CustomizeButtonsHandlerInterceptorForTesting::IncrementWallpaperSearchButtonShownCount() {
  GetForwardingInterface()->IncrementWallpaperSearchButtonShownCount();
}
void CustomizeButtonsHandlerInterceptorForTesting::SetCustomizeChromeSidePanelVisible(bool visible, CustomizeChromeSection section, SidePanelOpenTrigger trigger) {
  GetForwardingInterface()->SetCustomizeChromeSidePanelVisible(
    std::move(visible)
    , 
    std::move(section)
    , 
    std::move(trigger)
    );
}
CustomizeButtonsHandlerAsyncWaiter::CustomizeButtonsHandlerAsyncWaiter(
    CustomizeButtonsHandler* proxy) : proxy_(proxy) {}

CustomizeButtonsHandlerAsyncWaiter::~CustomizeButtonsHandlerAsyncWaiter() = default;





void CustomizeButtonsDocumentInterceptorForTesting::SetCustomizeChromeSidePanelVisibility(bool visible) {
  GetForwardingInterface()->SetCustomizeChromeSidePanelVisibility(
    std::move(visible)
    );
}
CustomizeButtonsDocumentAsyncWaiter::CustomizeButtonsDocumentAsyncWaiter(
    CustomizeButtonsDocument* proxy) : proxy_(proxy) {}

CustomizeButtonsDocumentAsyncWaiter::~CustomizeButtonsDocumentAsyncWaiter() = default;







}  // customize_buttons::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif