// chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/customize_buttons/customize_buttons.mojom-params-data.h"
namespace customize_buttons {
namespace mojom {

NOINLINE static const char* CustomizeChromeSectionToStringHelper(CustomizeChromeSection value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case CustomizeChromeSection::kUnspecified:
      return "kUnspecified";
    case CustomizeChromeSection::kAppearance:
      return "kAppearance";
    case CustomizeChromeSection::kShortcuts:
      return "kShortcuts";
    case CustomizeChromeSection::kModules:
      return "kModules";
    case CustomizeChromeSection::kWallpaperSearch:
      return "kWallpaperSearch";
    case CustomizeChromeSection::kToolbar:
      return "kToolbar";
    case CustomizeChromeSection::kFooter:
      return "kFooter";
    default:
      return nullptr;
  }
}

std::string CustomizeChromeSectionToString(CustomizeChromeSection value) {
  const char *str = CustomizeChromeSectionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown CustomizeChromeSection value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, CustomizeChromeSection value) {
  return os << CustomizeChromeSectionToString(value);
}

NOINLINE static const char* SidePanelOpenTriggerToStringHelper(SidePanelOpenTrigger value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SidePanelOpenTrigger::kNewTabPage:
      return "kNewTabPage";
    case SidePanelOpenTrigger::kNewTabFooter:
      return "kNewTabFooter";
    default:
      return nullptr;
  }
}

std::string SidePanelOpenTriggerToString(SidePanelOpenTrigger value) {
  const char *str = SidePanelOpenTriggerToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SidePanelOpenTrigger value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SidePanelOpenTrigger value) {
  return os << SidePanelOpenTriggerToString(value);
}

namespace internal {


// static
bool CustomizeButtonsHandlerFactory_CreateCustomizeButtonsHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeButtonsHandlerFactory_CreateCustomizeButtonsHandler_Params_Data* object =
      static_cast<const CustomizeButtonsHandlerFactory_CreateCustomizeButtonsHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

CustomizeButtonsHandlerFactory_CreateCustomizeButtonsHandler_Params_Data::CustomizeButtonsHandlerFactory_CreateCustomizeButtonsHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeButtonsHandler_IncrementCustomizeChromeButtonOpenCount_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeButtonsHandler_IncrementCustomizeChromeButtonOpenCount_Params_Data* object =
      static_cast<const CustomizeButtonsHandler_IncrementCustomizeChromeButtonOpenCount_Params_Data*>(data);

  return true;
}

CustomizeButtonsHandler_IncrementCustomizeChromeButtonOpenCount_Params_Data::CustomizeButtonsHandler_IncrementCustomizeChromeButtonOpenCount_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeButtonsHandler_IncrementWallpaperSearchButtonShownCount_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeButtonsHandler_IncrementWallpaperSearchButtonShownCount_Params_Data* object =
      static_cast<const CustomizeButtonsHandler_IncrementWallpaperSearchButtonShownCount_Params_Data*>(data);

  return true;
}

CustomizeButtonsHandler_IncrementWallpaperSearchButtonShownCount_Params_Data::CustomizeButtonsHandler_IncrementWallpaperSearchButtonShownCount_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeButtonsHandler_SetCustomizeChromeSidePanelVisible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeButtonsHandler_SetCustomizeChromeSidePanelVisible_Params_Data* object =
      static_cast<const CustomizeButtonsHandler_SetCustomizeChromeSidePanelVisible_Params_Data*>(data);


  if (!::customize_buttons::mojom::internal::CustomizeChromeSection_Data
        ::Validate(object->section, validation_context))
    return false;


  if (!::customize_buttons::mojom::internal::SidePanelOpenTrigger_Data
        ::Validate(object->trigger, validation_context))
    return false;

  return true;
}

CustomizeButtonsHandler_SetCustomizeChromeSidePanelVisible_Params_Data::CustomizeButtonsHandler_SetCustomizeChromeSidePanelVisible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CustomizeButtonsDocument_SetCustomizeChromeSidePanelVisibility_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CustomizeButtonsDocument_SetCustomizeChromeSidePanelVisibility_Params_Data* object =
      static_cast<const CustomizeButtonsDocument_SetCustomizeChromeSidePanelVisibility_Params_Data*>(data);

  return true;
}

CustomizeButtonsDocument_SetCustomizeChromeSidePanelVisibility_Params_Data::CustomizeButtonsDocument_SetCustomizeChromeSidePanelVisibility_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace customize_buttons

namespace perfetto {

// static
void TraceFormatTraits<::customize_buttons::mojom::CustomizeChromeSection>::WriteIntoTrace(
   perfetto::TracedValue context, ::customize_buttons::mojom::CustomizeChromeSection value) {
  return std::move(context).WriteString(::customize_buttons::mojom::CustomizeChromeSectionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::customize_buttons::mojom::SidePanelOpenTrigger>::WriteIntoTrace(
   perfetto::TracedValue context, ::customize_buttons::mojom::SidePanelOpenTrigger value) {
  return std::move(context).WriteString(::customize_buttons::mojom::SidePanelOpenTriggerToString(value));
}

} // namespace perfetto