// chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom-params-data.h"
#include "chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom-shared-message-ids.h"

#include "chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom-import-headers.h"
#include "chrome/browser/ui/webui/app_service_internals/app_service_internals.mojom-test-utils.h"


namespace mojom::app_service_internals {
AppInfo::AppInfo()
    : id(),
      name(),
      debug_info() {}

AppInfo::AppInfo(
    const std::string& id_in,
    const std::string& name_in,
    const std::string& debug_info_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      debug_info(std::move(debug_info_in)) {}

AppInfo::~AppInfo() = default;
size_t AppInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->debug_info);
  return seed;
}

void AppInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_info"), this->debug_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AppInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PreferredAppInfo::PreferredAppInfo()
    : id(),
      name(),
      preferred_filters() {}

PreferredAppInfo::PreferredAppInfo(
    const std::string& id_in,
    const std::string& name_in,
    const std::string& preferred_filters_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      preferred_filters(std::move(preferred_filters_in)) {}

PreferredAppInfo::~PreferredAppInfo() = default;
size_t PreferredAppInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->id);
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->preferred_filters);
  return seed;
}

void PreferredAppInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preferred_filters"), this->preferred_filters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PreferredAppInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PromiseAppInfo::PromiseAppInfo()
    : package_id(),
      debug_info() {}

PromiseAppInfo::PromiseAppInfo(
    const std::string& package_id_in,
    const std::string& debug_info_in)
    : package_id(std::move(package_id_in)),
      debug_info(std::move(debug_info_in)) {}

PromiseAppInfo::~PromiseAppInfo() = default;
size_t PromiseAppInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->package_id);
  seed = mojo::internal::Hash(seed, this->debug_info);
  return seed;
}

void PromiseAppInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "package_id"), this->package_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_info"), this->debug_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PromiseAppInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AppCapabilityInfo::AppCapabilityInfo()
    : name(),
      debug_info() {}

AppCapabilityInfo::AppCapabilityInfo(
    const std::string& name_in,
    const std::string& debug_info_in)
    : name(std::move(name_in)),
      debug_info(std::move(debug_info_in)) {}

AppCapabilityInfo::~AppCapabilityInfo() = default;
size_t AppCapabilityInfo::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->name);
  seed = mojo::internal::Hash(seed, this->debug_info);
  return seed;
}

void AppCapabilityInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "debug_info"), this->debug_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AppCapabilityInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
DebugInfo::DebugInfo()
    : app_list(),
      preferred_app_list(),
      promise_app_list(),
      app_capability_list() {}

DebugInfo::DebugInfo(
    std::vector<AppInfoPtr> app_list_in,
    std::vector<PreferredAppInfoPtr> preferred_app_list_in,
    std::vector<PromiseAppInfoPtr> promise_app_list_in,
    std::vector<AppCapabilityInfoPtr> app_capability_list_in)
    : app_list(std::move(app_list_in)),
      preferred_app_list(std::move(preferred_app_list_in)),
      promise_app_list(std::move(promise_app_list_in)),
      app_capability_list(std::move(app_capability_list_in)) {}

DebugInfo::~DebugInfo() = default;

void DebugInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_list"), this->app_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AppInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "preferred_app_list"), this->preferred_app_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PreferredAppInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "promise_app_list"), this->promise_app_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<PromiseAppInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_capability_list"), this->app_capability_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<AppCapabilityInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool DebugInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

AppServiceInternalsPageHandler::IPCStableHashFunction AppServiceInternalsPageHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::AppServiceInternalsPageHandler>(message.name())) {
    case messages::AppServiceInternalsPageHandler::kGetDebugInfo: {
      return &AppServiceInternalsPageHandler::GetDebugInfo_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* AppServiceInternalsPageHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::AppServiceInternalsPageHandler>(message.name())) {
      case messages::AppServiceInternalsPageHandler::kGetDebugInfo:
            return "Receive mojom::app_service_internals::AppServiceInternalsPageHandler::GetDebugInfo";
    }
  } else {
    switch (static_cast<messages::AppServiceInternalsPageHandler>(message.name())) {
      case messages::AppServiceInternalsPageHandler::kGetDebugInfo:
            return "Receive reply mojom::app_service_internals::AppServiceInternalsPageHandler::GetDebugInfo";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t AppServiceInternalsPageHandler::GetDebugInfo_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd436d135;  // IPCStableHash for mojom::app_service_internals::AppServiceInternalsPageHandler::GetDebugInfo
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class AppServiceInternalsPageHandler_GetDebugInfo_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  AppServiceInternalsPageHandler_GetDebugInfo_ForwardToCallback(
      AppServiceInternalsPageHandler::GetDebugInfoCallback callback
      ) : callback_(std::move(callback)) {
  }

  AppServiceInternalsPageHandler_GetDebugInfo_ForwardToCallback(const AppServiceInternalsPageHandler_GetDebugInfo_ForwardToCallback&) = delete;
  AppServiceInternalsPageHandler_GetDebugInfo_ForwardToCallback& operator=(const AppServiceInternalsPageHandler_GetDebugInfo_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  AppServiceInternalsPageHandler::GetDebugInfoCallback callback_;
};

AppServiceInternalsPageHandlerProxy::AppServiceInternalsPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AppServiceInternalsPageHandlerProxy::GetDebugInfo(
    GetDebugInfoCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send mojom::app_service_internals::AppServiceInternalsPageHandler::GetDebugInfo");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppServiceInternalsPageHandler::kGetDebugInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::app_service_internals::internal::AppServiceInternalsPageHandler_GetDebugInfo_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppServiceInternalsPageHandler::Name_);
  message.set_method_name("GetDebugInfo");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new AppServiceInternalsPageHandler_GetDebugInfo_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class AppServiceInternalsPageHandler_GetDebugInfo_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static AppServiceInternalsPageHandler::GetDebugInfoCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<AppServiceInternalsPageHandler_GetDebugInfo_ProxyToResponder> proxy(
        new AppServiceInternalsPageHandler_GetDebugInfo_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&AppServiceInternalsPageHandler_GetDebugInfo_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~AppServiceInternalsPageHandler_GetDebugInfo_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  AppServiceInternalsPageHandler_GetDebugInfo_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "AppServiceInternalsPageHandler::GetDebugInfoCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      DebugInfoPtr in_debug_info);
};

bool AppServiceInternalsPageHandler_GetDebugInfo_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::AppServiceInternalsPageHandler_GetDebugInfo_ResponseParams_Data* params =
      reinterpret_cast<
          internal::AppServiceInternalsPageHandler_GetDebugInfo_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for AppServiceInternalsPageHandler.0
  bool success = true;
  DebugInfoPtr p_debug_info{};
  AppServiceInternalsPageHandler_GetDebugInfo_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDebugInfo(&p_debug_info))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        AppServiceInternalsPageHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_debug_info));
  }
  return true;
}

void AppServiceInternalsPageHandler_GetDebugInfo_ProxyToResponder::Run(
    DebugInfoPtr in_debug_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply mojom::app_service_internals::AppServiceInternalsPageHandler::GetDebugInfo", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("debug_info"), in_debug_info,
                        "<value of type DebugInfoPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::AppServiceInternalsPageHandler::kGetDebugInfo), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::mojom::app_service_internals::internal::AppServiceInternalsPageHandler_GetDebugInfo_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->debug_info)::BaseType> debug_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojom::app_service_internals::DebugInfoDataView>(
    in_debug_info,
    debug_info_fragment);

  params->debug_info.Set(
      debug_info_fragment.is_null() ? nullptr : debug_info_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AppServiceInternalsPageHandler::Name_);
  message.set_method_name("GetDebugInfo");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AppServiceInternalsPageHandlerStubDispatch::Accept(
    AppServiceInternalsPageHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::AppServiceInternalsPageHandler>(message->header()->name)) {
    case messages::AppServiceInternalsPageHandler::kGetDebugInfo: {
      break;
    }
  }
  return false;
}

// static
bool AppServiceInternalsPageHandlerStubDispatch::AcceptWithResponder(
    AppServiceInternalsPageHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::AppServiceInternalsPageHandler>(message->header()->name)) {
    case messages::AppServiceInternalsPageHandler::kGetDebugInfo: {
      internal::AppServiceInternalsPageHandler_GetDebugInfo_Params_Data* params =
          reinterpret_cast<
              internal::AppServiceInternalsPageHandler_GetDebugInfo_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for AppServiceInternalsPageHandler.0
      bool success = true;
      AppServiceInternalsPageHandler_GetDebugInfo_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AppServiceInternalsPageHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          AppServiceInternalsPageHandler_GetDebugInfo_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDebugInfo(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAppServiceInternalsPageHandlerValidationInfo[] = {
    { &internal::AppServiceInternalsPageHandler_GetDebugInfo_Params_Data::Validate,
     &internal::AppServiceInternalsPageHandler_GetDebugInfo_ResponseParams_Data::Validate},
};

bool AppServiceInternalsPageHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::mojom::app_service_internals::AppServiceInternalsPageHandler::Name_,
    kAppServiceInternalsPageHandlerValidationInfo);
}

bool AppServiceInternalsPageHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::mojom::app_service_internals::AppServiceInternalsPageHandler::Name_,
    kAppServiceInternalsPageHandlerValidationInfo);
}


}  // mojom::app_service_internals


namespace mojo {


// static
bool StructTraits<::mojom::app_service_internals::AppInfo::DataView, ::mojom::app_service_internals::AppInfoPtr>::Read(
    ::mojom::app_service_internals::AppInfo::DataView input,
    ::mojom::app_service_internals::AppInfoPtr* output) {
  bool success = true;
  ::mojom::app_service_internals::AppInfoPtr result(::mojom::app_service_internals::AppInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadDebugInfo(&result->debug_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::app_service_internals::PreferredAppInfo::DataView, ::mojom::app_service_internals::PreferredAppInfoPtr>::Read(
    ::mojom::app_service_internals::PreferredAppInfo::DataView input,
    ::mojom::app_service_internals::PreferredAppInfoPtr* output) {
  bool success = true;
  ::mojom::app_service_internals::PreferredAppInfoPtr result(::mojom::app_service_internals::PreferredAppInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadPreferredFilters(&result->preferred_filters))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::app_service_internals::PromiseAppInfo::DataView, ::mojom::app_service_internals::PromiseAppInfoPtr>::Read(
    ::mojom::app_service_internals::PromiseAppInfo::DataView input,
    ::mojom::app_service_internals::PromiseAppInfoPtr* output) {
  bool success = true;
  ::mojom::app_service_internals::PromiseAppInfoPtr result(::mojom::app_service_internals::PromiseAppInfo::New());
  
      if (success && !input.ReadPackageId(&result->package_id))
        success = false;
      if (success && !input.ReadDebugInfo(&result->debug_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::app_service_internals::AppCapabilityInfo::DataView, ::mojom::app_service_internals::AppCapabilityInfoPtr>::Read(
    ::mojom::app_service_internals::AppCapabilityInfo::DataView input,
    ::mojom::app_service_internals::AppCapabilityInfoPtr* output) {
  bool success = true;
  ::mojom::app_service_internals::AppCapabilityInfoPtr result(::mojom::app_service_internals::AppCapabilityInfo::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadDebugInfo(&result->debug_info))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::mojom::app_service_internals::DebugInfo::DataView, ::mojom::app_service_internals::DebugInfoPtr>::Read(
    ::mojom::app_service_internals::DebugInfo::DataView input,
    ::mojom::app_service_internals::DebugInfoPtr* output) {
  bool success = true;
  ::mojom::app_service_internals::DebugInfoPtr result(::mojom::app_service_internals::DebugInfo::New());
  
      if (success && !input.ReadAppList(&result->app_list))
        success = false;
      if (success && !input.ReadPreferredAppList(&result->preferred_app_list))
        success = false;
      if (success && !input.ReadPromiseAppList(&result->promise_app_list))
        success = false;
      if (success && !input.ReadAppCapabilityList(&result->app_capability_list))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace mojom::app_service_internals {


void AppServiceInternalsPageHandlerInterceptorForTesting::GetDebugInfo(GetDebugInfoCallback callback) {
  GetForwardingInterface()->GetDebugInfo(std::move(callback));
}
AppServiceInternalsPageHandlerAsyncWaiter::AppServiceInternalsPageHandlerAsyncWaiter(
    AppServiceInternalsPageHandler* proxy) : proxy_(proxy) {}

AppServiceInternalsPageHandlerAsyncWaiter::~AppServiceInternalsPageHandlerAsyncWaiter() = default;


void AppServiceInternalsPageHandlerAsyncWaiter::GetDebugInfo(
    DebugInfoPtr* out_debug_info) {
  base::RunLoop loop;
  proxy_->GetDebugInfo(
      base::BindOnce(
          [](base::RunLoop* loop,
             DebugInfoPtr* out_debug_info
,
             DebugInfoPtr debug_info) {*out_debug_info = std::move(debug_info);
            loop->Quit();
          },
          &loop,
          out_debug_info));
  loop.Run();
}

DebugInfoPtr AppServiceInternalsPageHandlerAsyncWaiter::GetDebugInfo(
    ) {
  DebugInfoPtr async_wait_result;
  GetDebugInfo(&async_wait_result);
  return async_wait_result;
}






}  // mojom::app_service_internals


#if defined(__clang__)
#pragma clang diagnostic pop
#endif