// chrome/browser/ui/webui/app_home/app_home.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_APP_HOME_APP_HOME_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_APP_HOME_APP_HOME_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/app_home/app_home.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/app_home/app_home.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/app_home/app_home.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom.h"
#include "chrome/browser/web_applications/mojom/user_display_mode.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "chrome/browser/ui/webui/app_home/app_home_mojom_traits.h"
#include "chrome/browser/web_applications/web_app_constants.h"




namespace app_home::mojom {

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "app_home.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "app_home.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAppsMinVersion = 0,
    kGetDeprecationLinkStringMinVersion = 0,
    kUninstallAppMinVersion = 0,
    kShowAppSettingsMinVersion = 0,
    kCreateAppShortcutMinVersion = 0,
    kLaunchAppMinVersion = 0,
    kSetRunOnOsLoginModeMinVersion = 0,
    kLaunchDeprecatedAppDialogMinVersion = 0,
    kInstallAppLocallyMinVersion = 0,
    kSetUserDisplayModeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetApps_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDeprecationLinkString_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UninstallApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowAppSettings_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CreateAppShortcut_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LaunchApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetRunOnOsLoginMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LaunchDeprecatedAppDialog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InstallAppLocally_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserDisplayMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  using GetAppsCallback = base::OnceCallback<void(std::vector<AppInfoPtr>)>;
  using GetAppsMojoCallback = base::OnceCallback<void(std::vector<AppInfoPtr>)>;

  virtual void GetApps(GetAppsCallback callback) = 0;

  using GetDeprecationLinkStringCallback = base::OnceCallback<void(const std::string&)>;
  using GetDeprecationLinkStringMojoCallback = base::OnceCallback<void(const std::string&)>;

  virtual void GetDeprecationLinkString(GetDeprecationLinkStringCallback callback) = 0;

  virtual void UninstallApp(const std::string& app_id) = 0;

  virtual void ShowAppSettings(const std::string& app_id) = 0;

  using CreateAppShortcutCallback = base::OnceCallback<void()>;
  using CreateAppShortcutMojoCallback = base::OnceCallback<void()>;

  virtual void CreateAppShortcut(const std::string& app_id, CreateAppShortcutCallback callback) = 0;

  virtual void LaunchApp(const std::string& app_id, ClickEventPtr click_event) = 0;

  virtual void SetRunOnOsLoginMode(const std::string& app_id, ::web_app::RunOnOsLoginMode run_on_os_login_mode) = 0;

  virtual void LaunchDeprecatedAppDialog() = 0;

  virtual void InstallAppLocally(const std::string& app_id) = 0;

  virtual void SetUserDisplayMode(const std::string& app_id, ::web_app::mojom::UserDisplayMode display_mode) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "app_home.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAddAppMinVersion = 0,
    kRemoveAppMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveApp_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void AddApp(AppInfoPtr app_info) = 0;

  virtual void RemoveApp(AppInfoPtr app_info) = 0;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetApps(GetAppsCallback callback) final;
  
  void GetDeprecationLinkString(GetDeprecationLinkStringCallback callback) final;
  
  void UninstallApp(const std::string& app_id) final;
  
  void ShowAppSettings(const std::string& app_id) final;
  
  void CreateAppShortcut(const std::string& app_id, CreateAppShortcutCallback callback) final;
  
  void LaunchApp(const std::string& app_id, ClickEventPtr click_event) final;
  
  void SetRunOnOsLoginMode(const std::string& app_id, ::web_app::RunOnOsLoginMode run_on_os_login_mode) final;
  
  void LaunchDeprecatedAppDialog() final;
  
  void InstallAppLocally(const std::string& app_id) final;
  
  void SetUserDisplayMode(const std::string& app_id, ::web_app::mojom::UserDisplayMode display_mode) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddApp(AppInfoPtr app_info) final;
  
  void RemoveApp(AppInfoPtr app_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  AppInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AppInfo, T>::value>;
  using DataView = AppInfoDataView;
  using Data_ = internal::AppInfo_Data;

  template <typename... Args>
  static AppInfoPtr New(Args&&... args) {
    return AppInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AppInfoPtr From(const U& u) {
    return mojo::TypeConverter<AppInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AppInfo>::Convert(*this);
  }


  AppInfo();

  AppInfo(
      AppType app_type,
      const std::string& id,
      const ::GURL& start_url,
      const std::string& name,
      const ::GURL& icon_url,
      bool may_show_run_on_os_login_mode,
      bool may_toggle_run_on_os_login_mode,
      ::web_app::RunOnOsLoginMode run_on_os_login_mode,
      bool is_locally_installed,
      bool open_in_window,
      bool may_uninstall,
      const std::optional<::GURL>& store_page_url);


  ~AppInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AppInfoPtr>
  AppInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AppInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AppInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AppInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AppInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AppInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AppInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AppInfo_UnserializedMessageContext<
            UserType, AppInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AppInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AppInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AppInfo_UnserializedMessageContext<
            UserType, AppInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AppInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AppType app_type;
  
  std::string id;
  
  ::GURL start_url;
  
  std::string name;
  
  ::GURL icon_url;
  
  bool may_show_run_on_os_login_mode;
  
  bool may_toggle_run_on_os_login_mode;
  
  ::web_app::RunOnOsLoginMode run_on_os_login_mode;
  
  bool is_locally_installed;
  
  bool open_in_window;
  
  bool may_uninstall;
  
  std::optional<::GURL> store_page_url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AppInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AppInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AppInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AppInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ClickEvent {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClickEvent, T>::value>;
  using DataView = ClickEventDataView;
  using Data_ = internal::ClickEvent_Data;

  template <typename... Args>
  static ClickEventPtr New(Args&&... args) {
    return ClickEventPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClickEventPtr From(const U& u) {
    return mojo::TypeConverter<ClickEventPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClickEvent>::Convert(*this);
  }


  ClickEvent();

  ClickEvent(
      double button,
      bool alt_key,
      bool ctrl_key,
      bool meta_key,
      bool shift_key);


  ~ClickEvent();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClickEventPtr>
  ClickEventPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClickEvent::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClickEvent::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClickEvent::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClickEvent::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClickEvent::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClickEvent::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClickEvent_UnserializedMessageContext<
            UserType, ClickEvent::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClickEvent::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClickEvent::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClickEvent_UnserializedMessageContext<
            UserType, ClickEvent::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClickEvent::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  double button;
  
  bool alt_key;
  
  bool ctrl_key;
  
  bool meta_key;
  
  bool shift_key;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClickEvent::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClickEvent::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClickEvent::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClickEvent::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AppInfoPtr AppInfo::Clone() const {
  return New(
      mojo::Clone(app_type),
      mojo::Clone(id),
      mojo::Clone(start_url),
      mojo::Clone(name),
      mojo::Clone(icon_url),
      mojo::Clone(may_show_run_on_os_login_mode),
      mojo::Clone(may_toggle_run_on_os_login_mode),
      mojo::Clone(run_on_os_login_mode),
      mojo::Clone(is_locally_installed),
      mojo::Clone(open_in_window),
      mojo::Clone(may_uninstall),
      mojo::Clone(store_page_url)
  );
}

template <typename T, AppInfo::EnableIfSame<T>*>
bool AppInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->app_type, other_struct.app_type))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->start_url, other_struct.start_url))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->icon_url, other_struct.icon_url))
    return false;
  if (!mojo::Equals(this->may_show_run_on_os_login_mode, other_struct.may_show_run_on_os_login_mode))
    return false;
  if (!mojo::Equals(this->may_toggle_run_on_os_login_mode, other_struct.may_toggle_run_on_os_login_mode))
    return false;
  if (!mojo::Equals(this->run_on_os_login_mode, other_struct.run_on_os_login_mode))
    return false;
  if (!mojo::Equals(this->is_locally_installed, other_struct.is_locally_installed))
    return false;
  if (!mojo::Equals(this->open_in_window, other_struct.open_in_window))
    return false;
  if (!mojo::Equals(this->may_uninstall, other_struct.may_uninstall))
    return false;
  if (!mojo::Equals(this->store_page_url, other_struct.store_page_url))
    return false;
  return true;
}

template <typename T, AppInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.app_type < rhs.app_type)
    return true;
  if (rhs.app_type < lhs.app_type)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.start_url < rhs.start_url)
    return true;
  if (rhs.start_url < lhs.start_url)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.icon_url < rhs.icon_url)
    return true;
  if (rhs.icon_url < lhs.icon_url)
    return false;
  if (lhs.may_show_run_on_os_login_mode < rhs.may_show_run_on_os_login_mode)
    return true;
  if (rhs.may_show_run_on_os_login_mode < lhs.may_show_run_on_os_login_mode)
    return false;
  if (lhs.may_toggle_run_on_os_login_mode < rhs.may_toggle_run_on_os_login_mode)
    return true;
  if (rhs.may_toggle_run_on_os_login_mode < lhs.may_toggle_run_on_os_login_mode)
    return false;
  if (lhs.run_on_os_login_mode < rhs.run_on_os_login_mode)
    return true;
  if (rhs.run_on_os_login_mode < lhs.run_on_os_login_mode)
    return false;
  if (lhs.is_locally_installed < rhs.is_locally_installed)
    return true;
  if (rhs.is_locally_installed < lhs.is_locally_installed)
    return false;
  if (lhs.open_in_window < rhs.open_in_window)
    return true;
  if (rhs.open_in_window < lhs.open_in_window)
    return false;
  if (lhs.may_uninstall < rhs.may_uninstall)
    return true;
  if (rhs.may_uninstall < lhs.may_uninstall)
    return false;
  if (lhs.store_page_url < rhs.store_page_url)
    return true;
  if (rhs.store_page_url < lhs.store_page_url)
    return false;
  return false;
}
template <typename StructPtrType>
ClickEventPtr ClickEvent::Clone() const {
  return New(
      mojo::Clone(button),
      mojo::Clone(alt_key),
      mojo::Clone(ctrl_key),
      mojo::Clone(meta_key),
      mojo::Clone(shift_key)
  );
}

template <typename T, ClickEvent::EnableIfSame<T>*>
bool ClickEvent::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->button, other_struct.button))
    return false;
  if (!mojo::Equals(this->alt_key, other_struct.alt_key))
    return false;
  if (!mojo::Equals(this->ctrl_key, other_struct.ctrl_key))
    return false;
  if (!mojo::Equals(this->meta_key, other_struct.meta_key))
    return false;
  if (!mojo::Equals(this->shift_key, other_struct.shift_key))
    return false;
  return true;
}

template <typename T, ClickEvent::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.button < rhs.button)
    return true;
  if (rhs.button < lhs.button)
    return false;
  if (lhs.alt_key < rhs.alt_key)
    return true;
  if (rhs.alt_key < lhs.alt_key)
    return false;
  if (lhs.ctrl_key < rhs.ctrl_key)
    return true;
  if (rhs.ctrl_key < lhs.ctrl_key)
    return false;
  if (lhs.meta_key < rhs.meta_key)
    return true;
  if (rhs.meta_key < lhs.meta_key)
    return false;
  if (lhs.shift_key < rhs.shift_key)
    return true;
  if (rhs.shift_key < lhs.shift_key)
    return false;
  return false;
}


}  // app_home::mojom

namespace mojo {


template <>
struct  StructTraits<::app_home::mojom::AppInfo::DataView,
                                         ::app_home::mojom::AppInfoPtr> {
  static bool IsNull(const ::app_home::mojom::AppInfoPtr& input) { return !input; }
  static void SetToNull(::app_home::mojom::AppInfoPtr* output) { output->reset(); }

  static decltype(::app_home::mojom::AppInfo::app_type) app_type(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->app_type;
  }

  static const decltype(::app_home::mojom::AppInfo::id)& id(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->id;
  }

  static const decltype(::app_home::mojom::AppInfo::start_url)& start_url(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->start_url;
  }

  static const decltype(::app_home::mojom::AppInfo::name)& name(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->name;
  }

  static const decltype(::app_home::mojom::AppInfo::icon_url)& icon_url(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->icon_url;
  }

  static decltype(::app_home::mojom::AppInfo::may_show_run_on_os_login_mode) may_show_run_on_os_login_mode(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->may_show_run_on_os_login_mode;
  }

  static decltype(::app_home::mojom::AppInfo::may_toggle_run_on_os_login_mode) may_toggle_run_on_os_login_mode(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->may_toggle_run_on_os_login_mode;
  }

  static decltype(::app_home::mojom::AppInfo::run_on_os_login_mode) run_on_os_login_mode(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->run_on_os_login_mode;
  }

  static decltype(::app_home::mojom::AppInfo::is_locally_installed) is_locally_installed(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->is_locally_installed;
  }

  static decltype(::app_home::mojom::AppInfo::open_in_window) open_in_window(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->open_in_window;
  }

  static decltype(::app_home::mojom::AppInfo::may_uninstall) may_uninstall(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->may_uninstall;
  }

  static const decltype(::app_home::mojom::AppInfo::store_page_url)& store_page_url(
      const ::app_home::mojom::AppInfoPtr& input) {
    return input->store_page_url;
  }

  static bool Read(::app_home::mojom::AppInfo::DataView input, ::app_home::mojom::AppInfoPtr* output);
};


template <>
struct  StructTraits<::app_home::mojom::ClickEvent::DataView,
                                         ::app_home::mojom::ClickEventPtr> {
  static bool IsNull(const ::app_home::mojom::ClickEventPtr& input) { return !input; }
  static void SetToNull(::app_home::mojom::ClickEventPtr* output) { output->reset(); }

  static decltype(::app_home::mojom::ClickEvent::button) button(
      const ::app_home::mojom::ClickEventPtr& input) {
    return input->button;
  }

  static decltype(::app_home::mojom::ClickEvent::alt_key) alt_key(
      const ::app_home::mojom::ClickEventPtr& input) {
    return input->alt_key;
  }

  static decltype(::app_home::mojom::ClickEvent::ctrl_key) ctrl_key(
      const ::app_home::mojom::ClickEventPtr& input) {
    return input->ctrl_key;
  }

  static decltype(::app_home::mojom::ClickEvent::meta_key) meta_key(
      const ::app_home::mojom::ClickEventPtr& input) {
    return input->meta_key;
  }

  static decltype(::app_home::mojom::ClickEvent::shift_key) shift_key(
      const ::app_home::mojom::ClickEventPtr& input) {
    return input->shift_key;
  }

  static bool Read(::app_home::mojom::ClickEvent::DataView input, ::app_home::mojom::ClickEventPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_APP_HOME_APP_HOME_MOJOM_H_