// chrome/browser/ui/webui/actor_internals/actor_internals.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_WEBUI_ACTOR_INTERNALS_ACTOR_INTERNALS_MOJOM_H_
#define CHROME_BROWSER_UI_WEBUI_ACTOR_INTERNALS_ACTOR_INTERNALS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "chrome/browser/ui/webui/actor_internals/actor_internals.mojom-features.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/actor_internals/actor_internals.mojom-shared.h"  // IWYU pragma: export
#include "chrome/browser/ui/webui/actor_internals/actor_internals.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace actor_internals::mojom {

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor_internals.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kJournalEntryAddedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct JournalEntryAdded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void JournalEntryAdded(JournalEntryPtr entry) = 0;
};

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor_internals.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartLoggingMinVersion = 0,
    kStopLoggingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartLogging_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopLogging_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void StartLogging() = 0;

  virtual void StopLogging() = 0;
};

class PageHandlerFactoryProxy;

template <typename ImplRefTraits>
class PageHandlerFactoryStub;

class PageHandlerFactoryRequestValidator;


class PageHandlerFactory
    : public PageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "actor_internals.mojom.PageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerFactoryInterfaceBase;
  using Proxy_ = PageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) = 0;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void JournalEntryAdded(JournalEntryPtr entry) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartLogging() final;
  
  void StopLogging() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageHandlerFactoryProxy
    : public PageHandlerFactory {
 public:
  using InterfaceType = PageHandlerFactory;

  explicit PageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<Page> page, ::mojo::PendingReceiver<PageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerFactoryStubDispatch {
 public:
  static bool Accept(PageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandlerFactory>>
class PageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerFactoryStub() = default;
  ~PageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  JournalEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<JournalEntry, T>::value>;
  using DataView = JournalEntryDataView;
  using Data_ = internal::JournalEntry_Data;

  template <typename... Args>
  static JournalEntryPtr New(Args&&... args) {
    return JournalEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static JournalEntryPtr From(const U& u) {
    return mojo::TypeConverter<JournalEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, JournalEntry>::Convert(*this);
  }


  JournalEntry();

  JournalEntry(
      const std::string& url,
      const std::string& event,
      const std::string& type,
      const std::string& details,
      ::base::Time timestamp,
      int32_t task_id,
      const std::string& track,
      std::optional<std::vector<uint8_t>> screenshot);


  ~JournalEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = JournalEntryPtr>
  JournalEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JournalEntry::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        JournalEntry::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        JournalEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::JournalEntry_UnserializedMessageContext<
            UserType, JournalEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<JournalEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return JournalEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::JournalEntry_UnserializedMessageContext<
            UserType, JournalEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<JournalEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string url;
  
  std::string event;
  
  std::string type;
  
  std::string details;
  
  ::base::Time timestamp;
  
  int32_t task_id;
  
  std::string track;
  
  std::optional<std::vector<uint8_t>> screenshot;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, JournalEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
JournalEntryPtr JournalEntry::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(event),
      mojo::Clone(type),
      mojo::Clone(details),
      mojo::Clone(timestamp),
      mojo::Clone(task_id),
      mojo::Clone(track),
      mojo::Clone(screenshot)
  );
}

template <typename T, JournalEntry::EnableIfSame<T>*>
bool JournalEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->event, other_struct.event))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->task_id, other_struct.task_id))
    return false;
  if (!mojo::Equals(this->track, other_struct.track))
    return false;
  if (!mojo::Equals(this->screenshot, other_struct.screenshot))
    return false;
  return true;
}

template <typename T, JournalEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.event < rhs.event)
    return true;
  if (rhs.event < lhs.event)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.details < rhs.details)
    return true;
  if (rhs.details < lhs.details)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.task_id < rhs.task_id)
    return true;
  if (rhs.task_id < lhs.task_id)
    return false;
  if (lhs.track < rhs.track)
    return true;
  if (rhs.track < lhs.track)
    return false;
  if (lhs.screenshot < rhs.screenshot)
    return true;
  if (rhs.screenshot < lhs.screenshot)
    return false;
  return false;
}


}  // actor_internals::mojom

namespace mojo {


template <>
struct  StructTraits<::actor_internals::mojom::JournalEntry::DataView,
                                         ::actor_internals::mojom::JournalEntryPtr> {
  static bool IsNull(const ::actor_internals::mojom::JournalEntryPtr& input) { return !input; }
  static void SetToNull(::actor_internals::mojom::JournalEntryPtr* output) { output->reset(); }

  static const decltype(::actor_internals::mojom::JournalEntry::url)& url(
      const ::actor_internals::mojom::JournalEntryPtr& input) {
    return input->url;
  }

  static const decltype(::actor_internals::mojom::JournalEntry::event)& event(
      const ::actor_internals::mojom::JournalEntryPtr& input) {
    return input->event;
  }

  static const decltype(::actor_internals::mojom::JournalEntry::type)& type(
      const ::actor_internals::mojom::JournalEntryPtr& input) {
    return input->type;
  }

  static const decltype(::actor_internals::mojom::JournalEntry::details)& details(
      const ::actor_internals::mojom::JournalEntryPtr& input) {
    return input->details;
  }

  static const decltype(::actor_internals::mojom::JournalEntry::timestamp)& timestamp(
      const ::actor_internals::mojom::JournalEntryPtr& input) {
    return input->timestamp;
  }

  static decltype(::actor_internals::mojom::JournalEntry::task_id) task_id(
      const ::actor_internals::mojom::JournalEntryPtr& input) {
    return input->task_id;
  }

  static const decltype(::actor_internals::mojom::JournalEntry::track)& track(
      const ::actor_internals::mojom::JournalEntryPtr& input) {
    return input->track;
  }

  static const decltype(::actor_internals::mojom::JournalEntry::screenshot)& screenshot(
      const ::actor_internals::mojom::JournalEntryPtr& input) {
    return input->screenshot;
  }

  static bool Read(::actor_internals::mojom::JournalEntry::DataView input, ::actor_internals::mojom::JournalEntryPtr* output);
};

}  // namespace mojo

#endif  // CHROME_BROWSER_UI_WEBUI_ACTOR_INTERNALS_ACTOR_INTERNALS_MOJOM_H_